/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceFileManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.database.SqlDataSource;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ*\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0003J\u001e\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J&\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J&\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/actions/DumpToDdlDataSourceFileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "addFiles", "", "sqlDs", "Lcom/intellij/sql/database/SqlDataSource;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectAllFiles", "", "createSession", "Lcom/intellij/database/actions/DumpToDdlDataSourceFileManager$Session;", "fileListMsg", "", "extra", "output", "limit", "", "removeFiles", "suggestAddingPaths", "suggestDeletingFiles", "Companion", "Session", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDumpToDdlDataSourceFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpToDdlDataSourceFileManager.kt\ncom/intellij/database/actions/DumpToDdlDataSourceFileManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1#2:155\n1549#3:156\n1620#3,3:157\n1549#3:160\n1620#3,3:161\n*S KotlinDebug\n*F\n+ 1 DumpToDdlDataSourceFileManager.kt\ncom/intellij/database/actions/DumpToDdlDataSourceFileManager\n*L\n60#1:156\n60#1:157,3\n79#1:160\n79#1:161,3\n*E\n"})
public class DumpToDdlDataSourceFileManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger log;

    public DumpToDdlDataSourceFileManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Session createSession(@NotNull SqlDataSource sqlDs2) {
        Intrinsics.checkNotNullParameter((Object)sqlDs2, (String)"sqlDs");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return new Session(sqlDs2);
    }

    private final Set<VirtualFile> collectAllFiles(SqlDataSource sqlDs2) {
        LinkedHashSet all2 = new LinkedHashSet();
        sqlDs2.processFiles(all2::add);
        return all2;
    }

    public void addFiles(@NotNull SqlDataSource sqlDs2, @NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter((Object)sqlDs2, (String)"sqlDs");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        ApplicationManager.getApplication().invokeLater(() -> DumpToDdlDataSourceFileManager.addFiles$lambda$0(this, sqlDs2, files2));
    }

    public void removeFiles(@NotNull SqlDataSource sqlDs2, @NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter((Object)sqlDs2, (String)"sqlDs");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        ApplicationManager.getApplication().invokeLater(() -> DumpToDdlDataSourceFileManager.removeFiles$lambda$1(this, sqlDs2, files2));
    }

    /*
     * WARNING - void declaration
     */
    private final void suggestAddingPaths(Project project, SqlDataSource sqlDs2, List<? extends VirtualFile> extra) {
        VirtualFile virtualFile;
        String string = sqlDs2.getOutputPath();
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(it2);
        } else {
            virtualFile = null;
        }
        VirtualFile output = virtualFile;
        String string2 = DatabaseBundle.message("dialog.message.add.new.files.to.sql.data.source", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message2 = string2;
        String fileList = this.fileListMsg(extra, output, Integer.MAX_VALUE);
        String[] stringArray = new String[]{Messages.getYesButton(), DatabaseBundle.message("add.output.folder", new Object[0]), Messages.getNoButton()};
        int res2 = MessagesService.Companion.getInstance().showMoreInfoMessageDialog(project, message2, DatabaseBundle.message("dialog.title.new.files.produced", new Object[0]), fileList, stringArray, 0, -1, null);
        switch (res2) {
            case 0: {
                Collection<String> collection2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list = sqlDs2.getUrls();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUrls(...)");
                Iterable iterable = extra;
                Collection collection3 = list;
                SqlDataSource sqlDataSource = sqlDs2;
                boolean $i$f$map = false;
                void var11_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it3.getUrl());
                }
                collection2 = (List)destination$iv$iv;
                sqlDataSource.setUrls(CollectionsKt.plus((Collection)collection3, (Iterable)collection2));
                break;
            }
            case 1: {
                VirtualFile virtualFile3 = output;
                if (virtualFile3 == null) {
                    return;
                }
                VirtualFile file = virtualFile3;
                List list = sqlDs2.getUrls();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUrls(...)");
                sqlDs2.setUrls(CollectionsKt.plus((Collection)list, (Object)file.getUrl()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void suggestDeletingFiles(Project project, SqlDataSource sqlDs2, List<? extends VirtualFile> extra) {
        VirtualFile virtualFile;
        Object[] it2;
        Object[] objectArray = sqlDs2.getOutputPath();
        if (objectArray != null) {
            it2 = objectArray;
            boolean bl = false;
            virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath((String)it2);
        } else {
            virtualFile = null;
        }
        VirtualFile output = virtualFile;
        it2 = new Object[]{""};
        String string = DatabaseBundle.message("dialog.message.existing.files.haven.t.been.mentioned.during.code.generation.delete.them", it2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message2 = string;
        String fileList = this.fileListMsg(extra, output, Integer.MAX_VALUE);
        String[] stringArray = new String[]{Messages.getYesButton(), Messages.getNoButton()};
        int res2 = MessagesService.Companion.getInstance().showMoreInfoMessageDialog(project, message2, DatabaseBundle.message("dialog.title.outdated.files", new Object[0]), fileList, stringArray, 0, -1, null);
        if (res2 == 0) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list = sqlDs2.getUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUrls(...)");
            Iterable iterable = extra;
            Iterable iterable2 = list;
            SqlDataSource sqlDataSource = sqlDs2;
            boolean $i$f$map = false;
            void var11_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it3.getUrl());
            }
            collection2 = (List)destination$iv$iv;
            sqlDataSource.setUrls(CollectionsKt.minus((Iterable)iterable2, (Iterable)collection2));
            WriteAction.run(() -> DumpToDdlDataSourceFileManager.suggestDeletingFiles$lambda$6(extra, sqlDs2));
        }
    }

    @Nls
    private final String fileListMsg(List<? extends VirtualFile> extra, VirtualFile output, int limit) {
        Object object;
        List<? extends VirtualFile> list = extra.size() <= limit ? extra : extra.subList(0, limit);
        String files2 = SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<VirtualFile, String>(output){
            final /* synthetic */ VirtualFile $output;
            {
                this.$output = $output;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull VirtualFile it2) {
                Object object;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        object = this.$output;
                        if (object == null) break block2;
                        VirtualFile p2 = object;
                        boolean bl = false;
                        String string = VfsUtil.findRelativePath((VirtualFile)p2, (VirtualFile)it2, (char)File.separatorChar);
                        object = string;
                        if (string != null) break block3;
                    }
                    object = it2.getPath();
                }
                return object;
            }
        })), (Function1)fileListMsg.files.2.INSTANCE), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (extra.size() <= limit) {
            object = "";
        } else {
            Object[] objectArray = new Object[]{extra.size() - limit};
            object = "\n" + DatabaseBundle.message("and.0.files.more", objectArray);
        }
        String more = object;
        return files2 + more;
    }

    static /* synthetic */ String fileListMsg$default(DumpToDdlDataSourceFileManager dumpToDdlDataSourceFileManager, List list, VirtualFile virtualFile, int n, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fileListMsg");
        }
        if ((n3 & 4) != 0) {
            n = 3;
        }
        return dumpToDdlDataSourceFileManager.fileListMsg(list, virtualFile, n);
    }

    private static final void addFiles$lambda$0(DumpToDdlDataSourceFileManager this$0, SqlDataSource $sqlDs, List $files) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sqlDs, (String)"$sqlDs");
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        this$0.suggestAddingPaths(this$0.project, $sqlDs, $files);
    }

    private static final void removeFiles$lambda$1(DumpToDdlDataSourceFileManager this$0, SqlDataSource $sqlDs, List $files) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sqlDs, (String)"$sqlDs");
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        this$0.suggestDeletingFiles(this$0.project, $sqlDs, $files);
    }

    private static final void suggestDeletingFiles$lambda$6(List $extra, SqlDataSource $sqlDs) {
        Intrinsics.checkNotNullParameter((Object)$extra, (String)"$extra");
        Intrinsics.checkNotNullParameter((Object)$sqlDs, (String)"$sqlDs");
        for (VirtualFile file : $extra) {
            file.delete((Object)$sqlDs);
        }
    }

    static {
        Logger logger2 = Logger.getInstance(DumpToDdlDataSourceFileManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/actions/DumpToDdlDataSourceFileManager$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u0011\u001a\u00020\u0012J0\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00150\u00142\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/actions/DumpToDdlDataSourceFileManager$Session;", "", "sqlDs", "Lcom/intellij/sql/database/SqlDataSource;", "(Lcom/intellij/database/actions/DumpToDdlDataSourceFileManager;Lcom/intellij/sql/database/SqlDataSource;)V", "generated", "Ljava/util/LinkedHashSet;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/collections/LinkedHashSet;", "add", "", "file", "Ljava/nio/file/Path;", "text", "", "complete", "", "dropExtraFile", "", "computeFileListChanges", "Lcom/intellij/openapi/util/Couple;", "", "allFiles", "findOrCreateFile", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDumpToDdlDataSourceFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpToDdlDataSourceFileManager.kt\ncom/intellij/database/actions/DumpToDdlDataSourceFileManager$Session\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,154:1\n1247#2,2:155\n*S KotlinDebug\n*F\n+ 1 DumpToDdlDataSourceFileManager.kt\ncom/intellij/database/actions/DumpToDdlDataSourceFileManager$Session\n*L\n148#1:155,2\n*E\n"})
    public final class Session {
        @NotNull
        private final SqlDataSource sqlDs;
        @NotNull
        private final LinkedHashSet<VirtualFile> generated;

        public Session(SqlDataSource sqlDs2) {
            Intrinsics.checkNotNullParameter((Object)sqlDs2, (String)"sqlDs");
            this.sqlDs = sqlDs2;
            this.generated = new LinkedHashSet();
        }

        public final void add(@NotNull Path file, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            WriteAction.runAndWait(() -> Session.add$lambda$0(this, file, text2));
        }

        @NotNull
        public final Set<VirtualFile> complete(boolean dropExtraFile) {
            WriteAction.runAndWait(Session::complete$lambda$1);
            Set all2 = DumpToDdlDataSourceFileManager.this.collectAllFiles(this.sqlDs);
            Couple<List<VirtualFile>> changes = this.computeFileListChanges((Set<? extends VirtualFile>)this.generated, all2);
            Object object = changes.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
            if (!((Collection)object).isEmpty()) {
                Object object2 = changes.first;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
                DumpToDdlDataSourceFileManager.this.addFiles(this.sqlDs, (List)object2);
            }
            Object object3 = changes.second;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"second");
            if (!((Collection)object3).isEmpty() && dropExtraFile) {
                Object object4 = changes.second;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"second");
                DumpToDdlDataSourceFileManager.this.removeFiles(this.sqlDs, (List)object4);
            }
            return this.generated;
        }

        private final VirtualFile findOrCreateFile(Path file) {
            VirtualFile parent2;
            VirtualFile virtualFile = VfsUtil.findFile((Path)file, (boolean)true);
            if (virtualFile != null) {
                return virtualFile;
            }
            VirtualFile virtualFile2 = parent2 = VfsUtil.createDirectoryIfMissing((String)((Object)file.getParent()).toString());
            return virtualFile2 != null ? virtualFile2.createChildData((Object)DumpToDdlDataSourceFileManager.this, ((Object)file.getFileName()).toString()) : null;
        }

        private final Couple<List<VirtualFile>> computeFileListChanges(Set<? extends VirtualFile> generated, Set<? extends VirtualFile> allFiles) {
            ArrayList extra = new ArrayList();
            ArrayList deleted = new ArrayList();
            for (VirtualFile virtualFile : allFiles) {
                if (virtualFile.isDirectory() || generated.contains(virtualFile)) continue;
                ((Collection)deleted).add(virtualFile);
            }
            for (VirtualFile virtualFile : generated) {
                boolean inDs2;
                boolean bl;
                block3: {
                    Sequence $this$any$iv = SequencesKt.generateSequence((Object)virtualFile, (Function1)computeFileListChanges.inDs.1.INSTANCE);
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        VirtualFile it2 = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        if (!allFiles.contains(it2)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (inDs2 = bl) continue;
                ((Collection)extra).add(virtualFile);
            }
            Couple couple = Couple.of(extra, deleted);
            Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"of(...)");
            return couple;
        }

        private static final void add$lambda$0(Session this$0, Path $file, String $text) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
            VirtualFile virtualFile = this$0.findOrCreateFile($file);
            if (virtualFile == null) {
                log.error("Unable to create: " + $file);
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document != null) {
                document.setText((CharSequence)$text);
            } else {
                VfsUtil.saveText((VirtualFile)virtualFile, (String)$text);
            }
            this$0.generated.add(virtualFile);
        }

        private static final void complete$lambda$1() {
            FileDocumentManager.getInstance().saveAllDocuments();
        }
    }
}

