/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.psi.DbGoToTableContributor;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.scopes.DbDataSourceScope;
import com.intellij.database.util.SqlDialects;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFiltersStatisticsCollector;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameFilterConfiguration;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.ide.util.gotoByName.LanguageRef;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DbSETablesContributor
extends AbstractGotoSEContributor {
    private final SearchEverywhereCommandInfo DB_COMMAND;
    private final PersistentSearchEverywhereContributorFilter<LanguageRef> myFilter;

    protected DbSETablesContributor(@NotNull AnActionEvent event) {
        if (event == null) {
            DbSETablesContributor.$$$reportNull$$$0(0);
        }
        super(event);
        this.DB_COMMAND = new SearchEverywhereCommandInfo("db", DatabaseBundle.message("go.to.database.object", new Object[0]), (SearchEverywhereContributor)this);
        this.myFilter = DbSETablesContributor.createLanguageFilter((Project)event.getRequiredData(CommonDataKeys.PROJECT));
    }

    private static PersistentSearchEverywhereContributorFilter<LanguageRef> createLanguageFilter(Project project) {
        List items2 = ContainerUtil.map(SqlDialects.getTopLevelSqlDialects(), l -> new LanguageRef(l.getID(), l.getDisplayName(), l.getIcon()));
        GotoClassSymbolConfiguration persistentConfig = GotoClassSymbolConfiguration.getInstance((Project)project);
        return new PersistentSearchEverywhereContributorFilter(items2, (ChooseByNameFilterConfiguration)persistentConfig, LanguageRef::getDisplayName, LanguageRef::getIcon);
    }

    @Nls
    @NotNull
    public String getGroupName() {
        String string = DatabaseBundle.message("go.to.table.title", new Object[0]);
        if (string == null) {
            DbSETablesContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getSortWeight() {
        return 450;
    }

    public boolean isShownInSeparateTab() {
        return DbSETablesContributor.hasDatabaseTab(this.myProject);
    }

    static boolean hasDatabaseTab(Project project) {
        return !PlatformUtils.isDataGrip() && AdvancedSettings.getBoolean((String)"database.show.search.tab") && !DbPsiFacade.getInstance(project).getDataSources().isEmpty();
    }

    @NotNull
    public List<AnAction> getActions(@NotNull Runnable onChanged) {
        if (onChanged == null) {
            DbSETablesContributor.$$$reportNull$$$0(2);
        }
        List list = this.doGetActions(this.myFilter, (ElementsChooser.StatisticsCollector)new SearchEverywhereFiltersStatisticsCollector.LangFilterCollector(), onChanged);
        if (list == null) {
            DbSETablesContributor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        List<SearchEverywhereCommandInfo> list = Collections.singletonList(this.DB_COMMAND);
        if (list == null) {
            DbSETablesContributor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    protected FilteringGotoByModel<?> createModel(@NotNull Project project) {
        if (project == null) {
            DbSETablesContributor.$$$reportNull$$$0(5);
        }
        GotoClassModel2 model2 = new GotoClassModel2(project){

            protected List<ChooseByNameContributor> getContributorList() {
                return List.of(new DbGoToTableContributor());
            }
        };
        if (this.myFilter != null) {
            model2.setFilterItems((Collection)this.myFilter.getSelectedElements());
        }
        GotoClassModel2 gotoClassModel2 = model2;
        if (gotoClassModel2 == null) {
            DbSETablesContributor.$$$reportNull$$$0(6);
        }
        return gotoClassModel2;
    }

    protected List<ScopeDescriptor> createScopes() {
        int s2;
        int e2;
        List scopes = super.createScopes();
        for (e2 = scopes.size(); e2 > 0 && !(((ScopeDescriptor)scopes.get(e2 - 1)).getScope() instanceof DbDataSourceScope); --e2) {
        }
        for (s2 = e2; s2 > 0; --s2) {
            SearchScope scope = ((ScopeDescriptor)scopes.get(s2 - 1)).getScope();
            if (scope instanceof DbDataSourceScope) continue;
            if (scope != null) break;
            --s2;
            break;
        }
        return s2 == e2 ? scopes : scopes.subList(s2, e2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DbSETablesContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DbSETablesContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedCommands";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 6 -> new IllegalStateException(string);
        };
    }

    public static final class Factory
    implements SearchEverywhereContributorFactory<Object> {
        @NotNull
        public SearchEverywhereContributor<Object> createContributor(@NotNull AnActionEvent initEvent) {
            if (initEvent == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return new DbSETablesContributor(initEvent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initEvent", "com/intellij/database/actions/DbSETablesContributor$Factory", "createContributor"));
        }
    }
}

