/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.actions.ActionAvailability;
import com.intellij.database.actions.AddDataSourceFromPath;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.BasicElementActionFun;
import com.intellij.database.actions.DatabaseViewEyeGroup;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewPanel;
import com.intellij.database.view.structure.DvMutableViewOptions;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeNodeRankFun;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseViewActions {
    private DatabaseViewActions() {
    }

    @NotNull
    public static <T> ToggleAction toggle(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name2, @NotNull @NotNull KMutableProperty1<@NotNull T, Boolean> prop, @NotNull @NotNull Function<@NotNull AnActionEvent, @Nullable T> supplier2) {
        if (name2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(0);
        }
        if (prop == null) {
            DatabaseViewActions.$$$reportNull$$$0(1);
        }
        if (supplier2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(2);
        }
        return DatabaseViewActions.toggle(name2, prop, supplier2, null, null);
    }

    @NotNull
    public static <T> ToggleAction toggle(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name2, @NotNull @NotNull KMutableProperty1<@NotNull T, Boolean> prop, @NotNull @NotNull Function<@NotNull AnActionEvent, @Nullable T> supplier2, @Nullable java.util.function.Consumer<AnActionEvent> performer) {
        if (name2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(3);
        }
        if (prop == null) {
            DatabaseViewActions.$$$reportNull$$$0(4);
        }
        if (supplier2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(5);
        }
        return DatabaseViewActions.toggle(name2, prop, supplier2, performer, null);
    }

    @NotNull
    public static <T> ToggleAction toggle(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name2, final @NotNull @NotNull KMutableProperty1<@NotNull T, Boolean> prop, final @NotNull @NotNull Function<@NotNull AnActionEvent, @Nullable T> supplier2, final @Nullable java.util.function.Consumer<AnActionEvent> performer, final @Nullable java.util.function.Consumer<AnActionEvent> updater) {
        if (name2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(6);
        }
        if (prop == null) {
            DatabaseViewActions.$$$reportNull$$$0(7);
        }
        if (supplier2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(8);
        }
        return new ToggleAction(name2){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public boolean isSelected(@NotNull AnActionEvent e2) {
                Object obj2;
                if (e2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (obj2 = supplier2.apply(e2)) != null && (Boolean)prop.get(obj2) != false;
            }

            public void setSelected(@NotNull AnActionEvent e2, boolean state) {
                Object obj2;
                if (e2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((obj2 = supplier2.apply(e2)) != null && (Boolean)prop.get(obj2) != state) {
                    prop.set(obj2, (Object)state);
                    if (performer != null) {
                        performer.accept(e2);
                    }
                }
            }

            public void update(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                super.update(e2);
                if (updater != null) {
                    updater.accept(e2);
                }
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @Nullable
    public static String getDbGroupName(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(9);
        }
        PsiElement selection2 = (PsiElement)e2.getData(CommonDataKeys.PSI_ELEMENT);
        return null;
    }

    @Nullable
    public static AnAction getCreateDataSourceAction(@NotNull DataSourceManager<?> manager, @NotNull Project project, @Nullable String groupName, boolean standalone, @Nullable Consumer<DbDataSource> consumer2) {
        if (manager == null) {
            DatabaseViewActions.$$$reportNull$$$0(10);
        }
        if (project == null) {
            DatabaseViewActions.$$$reportNull$$$0(11);
        }
        AnAction action = manager.getCreateDataSourceAction(d2 -> {
            ((AbstractDataSource)d2).setGroupName(groupName);
            DatabaseViewActions.onDataSourceCreated(DbPsiFacade.getInstance(project), manager, d2, consumer2);
        });
        if (standalone && action instanceof ActionGroup) {
            ActionGroup actionGroup = (ActionGroup)action;
            actionGroup.setPopup(false);
            return new DefaultActionGroup(new AnAction[]{actionGroup, Separator.getInstance()});
        }
        return action;
    }

    private static void onDataSourceCreated(@NotNull DbPsiFacade facade, @NotNull DataSourceManager<?> manager, @NotNull RawDataSource dataSource2) {
        if (facade == null) {
            DatabaseViewActions.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            DatabaseViewActions.$$$reportNull$$$0(13);
        }
        if (dataSource2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(14);
        }
        DatabaseViewActions.onDataSourceCreated(facade, manager, dataSource2, null);
    }

    private static void onDataSourceCreated(@NotNull DbPsiFacade facade, @NotNull DataSourceManager<?> manager, @NotNull RawDataSource dataSource2, @Nullable Consumer<DbDataSource> consumer2) {
        if (facade == null) {
            DatabaseViewActions.$$$reportNull$$$0(15);
        }
        if (manager == null) {
            DatabaseViewActions.$$$reportNull$$$0(16);
        }
        if (dataSource2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(17);
        }
        DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dataSource2, manager);
        DataSourceManagerDialog.showDialog(facade, newElement, null, null, consumer2 != null ? () -> consumer2.consume((Object)newElement) : null);
    }

    public static void addToLRUNames(@NotNull Project project, int lruItems, @NotNull String key2, @NotNull String name2) {
        if (project == null) {
            DatabaseViewActions.$$$reportNull$$$0(18);
        }
        if (key2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(19);
        }
        if (name2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(20);
        }
        DatabaseViewActions.addToLRUNames(project, lruItems, key2, Collections.singletonList(name2));
    }

    public static void addToLRUNames(@NotNull Project project, int lruItems, @NotNull String key2, @NotNull List<String> names2) {
        if (project == null) {
            DatabaseViewActions.$$$reportNull$$$0(21);
        }
        if (key2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(22);
        }
        if (names2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(23);
        }
        PropertiesComponent props = PropertiesComponent.getInstance((Project)project);
        ArrayList<String> list = new ArrayList<String>((Collection)ObjectUtils.notNull((Object)props.getList(key2), Collections.emptyList()));
        list.removeAll(names2);
        list.addAll(names2);
        List lru = list.subList(Math.max(0, list.size() - lruItems), list.size());
        props.setList(key2, lru);
    }

    @NotNull
    public static List<String> getLRUNames(@NotNull Project project, @NotNull String key2) {
        if (project == null) {
            DatabaseViewActions.$$$reportNull$$$0(24);
        }
        if (key2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(25);
        }
        List<String> list = Objects.requireNonNullElse(PropertiesComponent.getInstance((Project)project).getList(key2), Collections.emptyList());
        if (list == null) {
            DatabaseViewActions.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private static JComponent createKindChooser(@NotNull DatabaseView databaseView) {
        if (databaseView == null) {
            DatabaseViewActions.$$$reportNull$$$0(27);
        }
        DvMutableViewOptions options2 = databaseView.getMutableViewOptions();
        List<DbDataSource> dataSources2 = DbPsiFacade.getInstance(databaseView.getProject()).getDataSources();
        ArrayList<ObjectKind> kinds = new ArrayList<ObjectKind>();
        if (dataSources2.isEmpty()) {
            ObjectKind.getDatabaseKinds().addAllTo(kinds);
        } else {
            JBIterable.from(dataSources2).transform(ds -> DbImplUtilCore.getMetaModel(ds)).unique().flatten(mm -> mm.getKinds()).unique().addAllTo(kinds);
        }
        kinds.removeAll(Arrays.asList(ObjectKind.NONE, ObjectKind.UNKNOWN_OBJECT, ObjectKind.ROOT, ObjectKind.DATABASE, ObjectKind.SCHEMA));
        kinds.sort(Comparator.comparing(ObjectKind::name));
        ElementsChooser<ObjectKind> chooser = new ElementsChooser<ObjectKind>(kinds, true){

            protected String getItemText(@NotNull ObjectKind value2) {
                if (value2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return StringUtil.capitalizeWords((String)DbPresentationCore.getPresentableName(value2, Dbms.UNKNOWN), (boolean)true);
            }

            protected Icon getItemIcon(@NotNull ObjectKind value2) {
                if (value2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return (Icon)ObjectUtils.notNull((Object)DbPresentationCore.getIcon(value2), (Object)EmptyIcon.ICON_16);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getItemText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getItemIcon";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (ObjectKind kind : kinds) {
            chooser.setElementMarked((Object)kind, !options2.getHiddenKinds().contains(kind.code()));
        }
        chooser.addElementsMarkListener((element2, isMarked) -> {
            if (isMarked) {
                options2.getHiddenKinds().remove(element2.code());
            } else {
                options2.getHiddenKinds().add(element2.code());
            }
            options2.fireChanged();
        });
        chooser.setFocusable(false);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add((Component)chooser);
        JPanel buttons = new JPanel();
        JButton all2 = new JButton(DatabaseBundle.message("kinds.filter.all", new Object[0]));
        all2.addActionListener(new ActionListener((ElementsChooser)chooser){
            final /* synthetic */ ElementsChooser val$chooser;
            {
                this.val$chooser = elementsChooser;
            }

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.val$chooser.setAllElementsMarked(true);
            }
        });
        buttons.add(all2);
        JButton none = new JButton(DatabaseBundle.message("kinds.filter.none", new Object[0]));
        none.addActionListener(new ActionListener((ElementsChooser)chooser){
            final /* synthetic */ ElementsChooser val$chooser;
            {
                this.val$chooser = elementsChooser;
            }

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.val$chooser.setAllElementsMarked(false);
            }
        });
        buttons.add(none);
        JButton invert = new JButton(DatabaseBundle.message("kinds.filter.invert", new Object[0]));
        invert.addActionListener(new ActionListener((ElementsChooser)chooser){
            final /* synthetic */ ElementsChooser val$chooser;
            {
                this.val$chooser = elementsChooser;
            }

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.val$chooser.invertSelection();
            }
        });
        buttons.add(invert);
        panel2.add(buttons);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            DatabaseViewActions.$$$reportNull$$$0(28);
        }
        return jPanel;
    }

    public static boolean isDataSourceActionsEnabled(AnActionEvent e2) {
        return e2.getData(DatabaseView.DATABASE_VIEW_KEY) != null || ActionPlaces.isMainMenuOrActionSearch((String)e2.getPlace()) || !ActionPlaces.isPopupPlace((String)e2.getPlace()) || StringUtil.containsIgnoreCase((String)e2.getPlace(), (String)"database");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 26, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLRUNames";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createKindChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toggle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDbGroupName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceAction";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onDataSourceCreated";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addToLRUNames";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLRUNames";
                break;
            }
            case 26: 
            case 28: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createKindChooser";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 26, 28 -> new IllegalStateException(string);
        };
    }

    static class FilterAction
    extends DumbAwareAction {
        FilterAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                FilterAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            DatabaseView databaseView;
            if (e2 == null) {
                FilterAction.$$$reportNull$$$0(1);
            }
            boolean active = (databaseView = (DatabaseView)e2.getData(DatabaseView.DATABASE_VIEW_KEY)) != null && !databaseView.getViewOptions().getHiddenKinds().isEmpty();
            e2.getPresentation().setEnabledAndVisible(databaseView != null);
            Icon icon = this.getTemplatePresentation().getIcon();
            e2.getPresentation().setIcon(active ? ExecutionUtil.getLiveIndicator((Icon)icon) : icon);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DatabaseView databaseView;
            if (e2 == null) {
                FilterAction.$$$reportNull$$$0(2);
            }
            if ((databaseView = (DatabaseView)e2.getData(DatabaseView.DATABASE_VIEW_KEY)) == null) {
                return;
            }
            Project project = databaseView.getProject();
            JComponent chooser = DatabaseViewActions.createKindChooser(databaseView);
            JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(chooser, null).setFocusable(false).setRequestFocus(false).setResizable(true).setMinSize(new Dimension(200, 200)).setDimensionServiceKey(project, "DatabaseViewActions_Filter", false).createPopup();
            Point screenPoint = null;
            DatabaseViewPanel databaseViewPanel = databaseView.getPanelIfAny();
            if (databaseViewPanel != null) {
                InputEvent inputEvent;
                ActionToolbarImpl actionToolbar;
                DatabaseViewEyeGroup.EyeButton theButton;
                ActionToolbar toolbar2 = databaseViewPanel.myToolbar;
                if (toolbar2 instanceof ActionToolbarImpl && (theButton = (DatabaseViewEyeGroup.EyeButton)((Object)UIUtil.uiTraverser((Component)(actionToolbar = (ActionToolbarImpl)toolbar2).getComponent()).traverse().filter(DatabaseViewEyeGroup.EyeButton.class).first())) != null) {
                    screenPoint = theButton.getGroupPopupLocation();
                }
                if (screenPoint == null && (inputEvent = e2.getInputEvent()) instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)inputEvent;
                    screenPoint = mouseEvent.getLocationOnScreen();
                }
            }
            if (screenPoint != null) {
                popup2.showInScreenCoordinates((Component)((Object)databaseViewPanel), screenPoint);
            } else {
                popup2.showCenteredInCurrentWindow(project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions$FilterAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$FilterAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class MoveToGroup
    extends DataSourceActionBase {
        @Override
        public void update(@NotNull AnActionEvent e2) {
            boolean disable;
            if (e2 == null) {
                MoveToGroup.$$$reportNull$$$0(0);
            }
            if (disable = JBIterable.of((Object[])((PsiElement[])e2.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY))).filter(DbDataSource.class).isEmpty()) {
                e2.getPresentation().setEnabledAndVisible(false);
            } else {
                super.update(e2);
            }
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource source) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(1);
            }
            if (source == null) {
                MoveToGroup.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        protected void performActionImpl(final @NotNull Project project, @NotNull List<DbDataSource> dataSources2, @NotNull AnActionEvent e2) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(3);
            }
            if (dataSources2 == null) {
                MoveToGroup.$$$reportNull$$$0(4);
            }
            if (e2 == null) {
                MoveToGroup.$$$reportNull$$$0(5);
            }
            JBIterable allDataSources = JBIterable.from(DbPsiFacade.getInstance(project).getDataSources()).map(DbDataSource::getDelegate).filter(RawDataSource.class).collect();
            List groups2 = (List)allDataSources.filterMap(o2 -> o2.getGroupName()).flatMap(o2 -> JBIterable.generate((Object)o2, o1 -> {
                int idx = o1.lastIndexOf("/");
                return idx < 0 ? null : o1.substring(0, idx);
            })).collect(new TreeSet(NaturalComparator.INSTANCE)).addAllTo(new ArrayList());
            String newGroup = new String(DatabaseBundle.message("new.group", new Object[0]));
            String topGroup = new String(DatabaseBundle.message("root.group", new Object[0]));
            final Consumer action = o2 -> {
                if (Objects.equals(o2, topGroup)) {
                    MoveToGroup.assignGroup(project, null, dataSources2);
                } else if (!Objects.equals(o2, newGroup)) {
                    MoveToGroup.assignGroup(project, o2, dataSources2);
                } else {
                    String initial = (String)JBIterable.from((Iterable)dataSources2).filterMap(d2 -> StringUtil.nullize((String)d2.getDelegate().getGroupName())).first();
                    MoveToGroup.askForGroupName(project, initial, (Consumer<String>)((Consumer)groupName -> {
                        if (groupName != null) {
                            MoveToGroup.assignGroup(project, groupName, dataSources2);
                        }
                    }));
                }
            };
            if (groups2.isEmpty()) {
                action.consume((Object)newGroup);
                return;
            }
            groups2.add(0, newGroup);
            groups2.add(1, topGroup);
            BaseListPopupStep<String> step2 = new BaseListPopupStep<String>(DatabaseBundle.message("move.to.group", new Object[0]), groups2){

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(@NlsSafe String o2) {
                    String string = o2;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public Icon getIconFor(String value2) {
                    return DatabaseIcons.ObjectGroup;
                }

                public ListSeparator getSeparatorAbove(String value2) {
                    List values2 = this.getValues();
                    int index2 = values2.indexOf(value2);
                    return index2 == 2 ? new ListSeparator() : null;
                }

                public PopupStep onChosen(String o2, boolean finalChoice) {
                    ApplicationManager.getApplication().invokeLater(() -> action.consume((Object)o2), ModalityState.current(), project.getDisposed());
                    return PopupStep.FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions$MoveToGroup$1", "getTextFor"));
                }
            };
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2, 20);
            DbUIUtil.showPopup((JBPopup)popup2, null, e2);
        }

        public static void askForGroupName(@NotNull Project project, @Nullable String initial, @NotNull Consumer<String> consumer2) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(6);
            }
            if (consumer2 == null) {
                MoveToGroup.$$$reportNull$$$0(7);
            }
            String string = initial = StringUtil.isEmptyOrSpaces((String)(initial = StringUtil.notNullize((String)initial))) || StringUtil.endsWithChar((CharSequence)initial, (char)'/') ? initial : initial + "/";
            if (Experiments.getInstance().isFeatureEnabled("show.create.new.element.in.popup")) {
                MoveToGroup.createLightWeightPopup(initial, consumer2).showCenteredInCurrentWindow(project);
            } else {
                String name2 = Messages.showInputDialog((Project)project, null, (String)DatabaseBundle.message("group.name.title", new Object[0]), null, (String)initial, null, null, (String)DatabaseBundle.message("group.name.message", new Object[0]));
                consumer2.consume((Object)name2);
            }
        }

        private static JBPopup createLightWeightPopup(@NotNull String initial, @NotNull Consumer<String> consumer2) {
            if (initial == null) {
                MoveToGroup.$$$reportNull$$$0(8);
            }
            if (consumer2 == null) {
                MoveToGroup.$$$reportNull$$$0(9);
            }
            NewItemSimplePopupPanel contentPanel = new NewItemSimplePopupPanel();
            JTextField nameField = contentPanel.getTextField();
            nameField.setText(initial);
            nameField.selectAll();
            JBPopup popup2 = NewItemPopupUtil.createNewItemPopup((String)DatabaseBundle.message("group.name.title.2", new Object[0]), (JComponent)contentPanel, (JComponent)nameField);
            popup2.setAdText(DatabaseBundle.message("group.name.message", new Object[0]), 2);
            contentPanel.setApplyAction(event -> {
                consumer2.consume((Object)nameField.getText());
                popup2.closeOk(event);
            });
            return popup2;
        }

        public static void assignGroup(@NotNull Project project, @Nullable String groupName, @NotNull List<DbDataSource> dataSources2) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(10);
            }
            if (dataSources2 == null) {
                MoveToGroup.$$$reportNull$$$0(11);
            }
            DvTreeStructureService treeStructureService = (DvTreeStructureService)project.getService(DvTreeStructureService.class);
            for (DbDataSource dataSource2 : dataSources2) {
                AbstractDataSource ds = (AbstractDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), AbstractDataSource.class);
                if (ds == null) continue;
                ((DbDataSourceImpl)dataSource2).getDbManager().setGroupName(ds, groupName);
            }
            DatabaseView.refreshViewAndSelect(project, dataSources2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initial";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$MoveToGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performActionImpl";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "askForGroupName";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLightWeightPopup";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "assignGroup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CopyAction
    extends DumbAwareAction {
        CopyAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            JBIterable elements2;
            if (e2 == null) {
                CopyAction.$$$reportNull$$$0(1);
            }
            boolean enabled = (elements2 = JBIterable.of((Object[])((PsiElement[])e2.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY)))).size() == 1 && elements2.first() instanceof DbDataSource;
            e2.getPresentation().setEnabled(enabled);
            e2.getPresentation().setVisible(enabled || !ActionPlaces.isPopupPlace((String)e2.getPlace()));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Project project;
            if (e2 == null) {
                CopyAction.$$$reportNull$$$0(2);
            }
            if ((project = e2.getProject()) == null) {
                return;
            }
            JBIterable elements2 = JBIterable.of((Object[])((PsiElement[])e2.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY)));
            PsiElement first2 = (PsiElement)elements2.first();
            if (elements2.size() != 1 || !(first2 instanceof DbDataSource)) {
                return;
            }
            DbDataSource element2 = (DbDataSource)first2;
            DatabaseView view2 = (DatabaseView)e2.getData(DatabaseView.DATABASE_VIEW_KEY);
            if (view2 == null) {
                return;
            }
            DbPsiFacade facade = DbPsiFacade.getInstance(project);
            String newName = DbUtil.generateUniqueDataSourceName(project, element2.getName());
            DataSourceManager<RawDataSource> dbManager = facade.getDataSourceManager(element2);
            RawDataSource dsCopy = dbManager.copyDataSource(newName, element2.getDelegate());
            DatabaseCredentials credentials = DatabaseCredentialsUi.newUIInstance();
            if (dsCopy instanceof LocalDataSource) {
                DatabaseAuthProvider.copyAllCredentials((LocalDataSource)element2.getDelegate(), DatabaseCredentials.getInstance(), (LocalDataSource)dsCopy, credentials);
            }
            DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dsCopy, dbManager);
            DataSourceManagerDialog.showDialog(facade, (Object)newElement, credentials);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions$CopyAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$CopyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static class DeactivateAction
    extends DataSourceActionBase {
        DeactivateAction() {
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource dataSource2) {
            RawDataSource delegate;
            if (project == null) {
                DeactivateAction.$$$reportNull$$$0(0);
            }
            if (dataSource2 == null) {
                DeactivateAction.$$$reportNull$$$0(1);
            }
            if ((delegate = dataSource2.getDelegate()) instanceof SqlDataSource) {
                return DeactivateAction.isEnabledFor((SqlDataSource)delegate);
            }
            if (delegate instanceof LocalDataSource) {
                return DeactivateAction.isEnabledFor(project, (LocalDataSource)delegate);
            }
            return false;
        }

        private static boolean isEnabledFor(@NotNull Project project, LocalDataSource local) {
            JdbcDriverManager manager;
            if (project == null) {
                DeactivateAction.$$$reportNull$$$0(2);
            }
            return !(manager = JdbcDriverManager.getDriverManager(project)).getActiveConfigurations(local).isEmpty();
        }

        private static boolean isEnabledFor(SqlDataSource sqlDs2) {
            return DataSourceSyncManager.getInstance().isActive((DasDataSource)sqlDs2);
        }

        @Override
        protected void performActionImpl(@NotNull Project project, @NotNull List<DbDataSource> dataSources2, @NotNull AnActionEvent e2) {
            if (project == null) {
                DeactivateAction.$$$reportNull$$$0(3);
            }
            if (dataSources2 == null) {
                DeactivateAction.$$$reportNull$$$0(4);
            }
            if (e2 == null) {
                DeactivateAction.$$$reportNull$$$0(5);
            }
            for (DbDataSource dataSource2 : dataSources2) {
                RawDataSource delegate = dataSource2.getDelegate();
                if (delegate instanceof SqlDataSource) {
                    DeactivateAction.deactivate((SqlDataSource)delegate);
                    continue;
                }
                if (!(delegate instanceof LocalDataSource)) continue;
                DeactivateAction.deactivate(project, (LocalDataSource)delegate);
            }
        }

        private static void deactivate(SqlDataSource delegate) {
            DataSourceSyncManager.getInstance().stopSynchronization((DasDataSource)delegate);
        }

        private static void deactivate(@NotNull Project project, LocalDataSource localDataSource) {
            if (project == null) {
                DeactivateAction.$$$reportNull$$$0(6);
            }
            DataSourceUtil.deactivate(project, localDataSource);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$DeactivateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performActionImpl";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deactivate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class DataSourceActionBase
    extends DumbAwareAction {
        DataSourceActionBase() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DataSourceActionBase.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        protected abstract boolean isEnabledFor(@NotNull Project var1, @NotNull DbDataSource var2);

        protected abstract void performActionImpl(@NotNull Project var1, @NotNull List<DbDataSource> var2, @NotNull AnActionEvent var3);

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                DataSourceActionBase.$$$reportNull$$$0(1);
            }
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e2);
            JBIterable elements2 = JBIterable.of((Object[])((PsiElement[])e2.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            boolean enabled = false;
            boolean strict = false;
            if (project != null && !elements2.isEmpty()) {
                HashSet<String> visited = new HashSet<String>();
                for (DbElement element2 : elements2) {
                    DbDataSource dataSource2 = element2.getDataSource();
                    if (!visited.add(dataSource2.getUniqueId())) continue;
                    strict |= element2 == dataSource2;
                    if (enabled || !this.isEnabledFor(project, dataSource2)) continue;
                    enabled = true;
                }
            }
            boolean inPopup = ActionPlaces.isPopupPlace((String)e2.getPlace());
            e2.getPresentation().setEnabled(enabled);
            e2.getPresentation().setVisible(!inPopup || strict);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                DataSourceActionBase.$$$reportNull$$$0(2);
            }
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e2);
            JBIterable elements2 = JBIterable.of((Object[])((PsiElement[])e2.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            if (project == null || elements2.isEmpty()) {
                return;
            }
            ArrayList<DbDataSource> dataSources2 = new ArrayList<DbDataSource>();
            HashSet<String> visited = new HashSet<String>();
            for (DbElement element2 : elements2) {
                DbDataSource dataSource2 = element2.getDataSource();
                if (!visited.add(dataSource2.getUniqueId()) || !this.isEnabledFor(project, dataSource2)) continue;
                dataSources2.add(dataSource2);
            }
            this.performActionImpl(project, dataSources2, e2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions$DataSourceActionBase";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$DataSourceActionBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class DiagnosticsGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                DiagnosticsGroup.$$$reportNull$$$0(0);
            }
            ActionAvailability availability = DiagnosticsGroup.checkAvailability(e2);
            BasicElementActionFun.setAvailability(e2, availability);
            e2.getPresentation().setPopupGroup(true);
        }

        private static ActionAvailability checkAvailability(@NotNull AnActionEvent e2) {
            DatabaseView databaseView;
            if (e2 == null) {
                DiagnosticsGroup.$$$reportNull$$$0(1);
            }
            if ((databaseView = (DatabaseView)e2.getData(DatabaseView.DATABASE_VIEW_KEY)) == null) {
                return ActionAvailability.ACTION_HIDDEN;
            }
            String place = e2.getPlace();
            if (!place.equals("DatabaseViewPopup") && !ActionPlaces.isMainMenuOrActionSearch((String)place)) {
                return ActionAvailability.ACTION_HIDDEN;
            }
            try {
                JBIterable<BasicNode> nodes = BasicElementActionFun.iterateActionNodes(e2, true);
                if (nodes.isEmpty()) {
                    return ActionAvailability.ACTION_HIDDEN;
                }
                return ActionAvailability.ACTION_ENABLED;
            }
            catch (ProcessCanceledException pce) {
                return ActionAvailability.ACTION_HIDDEN;
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                DiagnosticsGroup.$$$reportNull$$$0(2);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(DatabaseBundle.message("group.DatabaseView.Diagnostics.text", new Object[0]), (ActionGroup)this, e2.getDataContext(), JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, false, null, 20, null, "DatabaseViewPopup");
            popup2.showInBestPositionFor(e2.getDataContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$DiagnosticsGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkAvailability";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ImportExportPopupGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        private static final Set<DvTreeNodeRank> APPLICABLE_TREE_NODE_RANKS = EnumSet.of(DvTreeNodeRank.TL_ROOT, DvTreeNodeRank.TL_NAMESPACE, DvTreeNodeRank.TL_FAMILY, DvTreeNodeRank.TL_ELEMENT);

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                ImportExportPopupGroup.$$$reportNull$$$0(0);
            }
            Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(e2.getDataContext());
            boolean applicable = CollectionFun.intersects(ranks, APPLICABLE_TREE_NODE_RANKS);
            e2.getPresentation().setVisible(applicable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DatabaseViewActions$ImportExportPopupGroup", "update"));
        }
    }

    public static class FindUsagesActionGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        private static final Set<DvTreeNodeRank> APPLICABLE_TREE_NODE_RANKS = EnumSet.of(DvTreeNodeRank.TL_NAMESPACE, DvTreeNodeRank.TL_ELEMENT);

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                FindUsagesActionGroup.$$$reportNull$$$0(0);
            }
            boolean applicable = false;
            DataContext dc = e2.getDataContext();
            BasicNode singleNode = DatabaseContextFun.getSelectedSingleNode(dc);
            if (singleNode != null) {
                DvTreeNodeRank rank = DvTreeNodeRankFun.getTreeNodeRank(singleNode);
                applicable = APPLICABLE_TREE_NODE_RANKS.contains(rank);
            }
            e2.getPresentation().setVisible(applicable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DatabaseViewActions$FindUsagesActionGroup", "update"));
        }
    }

    public static class DiagramsPopupGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        private static final Set<DvTreeNodeRank> APPLICABLE_TREE_NODE_RANKS = EnumSet.of(DvTreeNodeRank.TL_ROOT, DvTreeNodeRank.TL_NAMESPACE, DvTreeNodeRank.TL_FAMILY, DvTreeNodeRank.TL_ELEMENT);

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                DiagramsPopupGroup.$$$reportNull$$$0(0);
            }
            Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(e2.getDataContext());
            boolean applicable = CollectionFun.intersects(ranks, APPLICABLE_TREE_NODE_RANKS);
            e2.getPresentation().setVisible(applicable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DatabaseViewActions$DiagramsPopupGroup", "update"));
        }
    }

    public static class ToolsPopupGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        private static final Set<DvTreeNodeRank> APPLICABLE_TREE_NODE_RANKS = EnumSet.of(DvTreeNodeRank.TL_ROOT, DvTreeNodeRank.TL_NAMESPACE, DvTreeNodeRank.TL_FAMILY, DvTreeNodeRank.TL_ELEMENT);

        public void update(@NotNull AnActionEvent e2) {
            Set<DvTreeNodeRank> ranks;
            boolean applicable;
            if (e2 == null) {
                ToolsPopupGroup.$$$reportNull$$$0(0);
            }
            boolean enabled = (applicable = CollectionFun.intersects(ranks = DatabaseContextFun.getSelectedTreeNodeRanks(e2.getDataContext()), APPLICABLE_TREE_NODE_RANKS)) && e2.getData(DatabaseView.DATABASE_VIEW_KEY) != null;
            boolean visible = enabled && ("DatabaseViewPopup".equals(e2.getPlace()) || ActionPlaces.isMainMenuOrActionSearch((String)e2.getPlace()));
            e2.getPresentation().setEnabled(enabled);
            e2.getPresentation().setVisible(visible);
            e2.getPresentation().setPerformGroup(applicable);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                ToolsPopupGroup.$$$reportNull$$$0(1);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(DatabaseBundle.message("group.DatabaseView.Tools.text", new Object[0]), (ActionGroup)this, e2.getDataContext(), JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, false, null, 20, null, "DatabaseViewPopup");
            popup2.showInBestPositionFor(e2.getDataContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$ToolsPopupGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AddDriver
    extends DumbAwareAction {
        AddDriver() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AddDriver.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddDriver.$$$reportNull$$$0(1);
            }
            e2.getPresentation().setEnabledAndVisible(e2.getProject() != null && DatabaseViewActions.isDataSourceActionsEnabled(e2));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Project project;
            if (e2 == null) {
                AddDriver.$$$reportNull$$$0(2);
            }
            if ((project = e2.getProject()) == null) {
                return;
            }
            Collection<? extends DatabaseDriver> existing = DatabaseDriverManager.getInstance().getDrivers();
            DatabaseDriver driver2 = DataSourceUiUtil.createDefaultDatabaseDriver(existing);
            DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance(project), (Object)driver2, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions$AddDriver";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$AddDriver";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static class AddDataSourceFromThatAction
    extends AddDataSourceFromPath.FromThat {
        AddDataSourceFromThatAction() {
            super(DatabaseViewActions::onDataSourceCreated);
        }
    }

    static class AddDataSourceHereAction
    extends AddDataSourceFromPath.Here {
        AddDataSourceHereAction() {
            super(DatabaseViewActions::onDataSourceCreated);
        }
    }

    static class AddDataSourceFromPathAction
    extends AddDataSourceFromPath.FromDialog {
        AddDataSourceFromPathAction() {
            super(DatabaseViewActions::onDataSourceCreated);
        }
    }

    static class AddDataSourceFromUrlAction
    extends AddDataSourceFromUrl {
        AddDataSourceFromUrlAction() {
            super(DatabaseViewActions::onDataSourceCreated);
        }
    }

    public static interface DataSourceFactory {
        public void create(@NotNull DbPsiFacade var1, @NotNull DataSourceManager<LocalDataSource> var2, @NotNull LocalDataSource var3);
    }

    public static class AddDataSourcesGroup
    extends DefaultActionGroup
    implements DumbAware,
    AlwaysVisibleActionGroup {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(1);
            }
            e2.getPresentation().setEnabledAndVisible(e2.getProject() != null);
            e2.getPresentation().setPerformGroup(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Project project;
            if (e2 == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(2);
            }
            if ((project = e2.getProject()) == null) {
                return;
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(this.getTemplateText(), (ActionGroup)new DefaultActionGroup(this.getActions(project, DatabaseViewActions.getDbGroupName(e2), true)), e2.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 20, null, ActionPlaces.getPopupPlace((String)e2.getPlace()));
            popup2.showInBestPositionFor(e2.getDataContext());
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
            Project project;
            Project project2 = project = e2 == null ? null : e2.getProject();
            if (project == null) {
                AnAction[] anActionArray = super.getChildren(e2);
                if (anActionArray == null) {
                    AddDataSourcesGroup.$$$reportNull$$$0(3);
                }
                return anActionArray;
            }
            AnAction[] anActionArray = this.getActions(project, DatabaseViewActions.getDbGroupName(e2), false).toArray(EMPTY_ARRAY);
            if (anActionArray == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        @NotNull
        protected List<AnAction> getActions(@NotNull Project project, @Nullable String groupName, boolean standalone) {
            if (project == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(5);
            }
            List list = JBIterable.from(DataSourceManager.getManagers(project)).filterMap(manager -> DatabaseViewActions.getCreateDataSourceAction(manager, project, groupName, standalone, null)).append((Object[])super.getChildren(null)).toList();
            if (list == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions$AddDataSourcesGroup";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$AddDataSourcesGroup";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getActions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class NewGroup
    extends DefaultActionGroup
    implements DumbAware {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                NewGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                NewGroup.$$$reportNull$$$0(1);
            }
            e2.getPresentation().setVisible(e2.getProject() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions$NewGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$NewGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class AddActionGroupPopup
    extends DefaultActionGroup
    implements DumbAware {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AddActionGroupPopup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddActionGroupPopup.$$$reportNull$$$0(1);
            }
            e2.getPresentation().setIcon(e2.isFromActionToolbar() ? IconUtil.getAddIcon() : AllIcons.General.Add);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions$AddActionGroupPopup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$AddActionGroupPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class DropAction
    extends DeleteAction {
        private static final Set<DvTreeNodeRank> MODEL_STUFF_RANKS = Set.of(DvTreeNodeRank.TL_NAMESPACE, DvTreeNodeRank.TL_FAMILY, DvTreeNodeRank.TL_ELEMENT, DvTreeNodeRank.TL_UNKNOWN);

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                DropAction.$$$reportNull$$$0(0);
            }
            DataContext context = e2.getDataContext();
            Presentation presentation = e2.getPresentation();
            DeleteProvider deleteProvider = (DeleteProvider)context.getData(DatabaseView.DROP_ELEMENT_PROVIDER);
            if (deleteProvider != null) {
                boolean enabled;
                Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(context);
                boolean hasDS = ranks.contains(DvTreeNodeRank.TL_ROOT);
                boolean hasModelStuff = ContainerUtil.intersects(ranks, MODEL_STUFF_RANKS);
                boolean bl = enabled = (!hasDS || !hasModelStuff) && deleteProvider.canDeleteElement(context);
                if (enabled) {
                    presentation.setEnabledAndVisible(true);
                    if (deleteProvider instanceof TitledHandler) {
                        presentation.setText(((TitledHandler)deleteProvider).getActionTitle());
                    } else if (hasDS) {
                        int numberOfDataSources = DatabaseContextFun.getSelectionRelatedDataSources(context).size();
                        presentation.setText(DatabaseBundle.message("action.DatabaseView.DropAction.forDataSource.text", numberOfDataSources));
                        presentation.setDescription(DatabaseBundle.message("action.DatabaseView.DropAction.forDataSource.description", numberOfDataSources));
                    }
                } else {
                    presentation.setEnabled(false);
                    if (hasDS && ranks.size() > 1) {
                        presentation.setVisible(false);
                    }
                }
            } else if (e2.getPlace().equals("DatabaseViewPopup")) {
                presentation.setEnabledAndVisible(false);
            } else {
                super.update(e2);
            }
        }

        @Nullable
        protected DeleteProvider getDeleteProvider(DataContext dataContext) {
            return (DeleteProvider)DatabaseView.DROP_ELEMENT_PROVIDER.getData(dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DatabaseViewActions$DropAction", "update"));
        }
    }
}

