/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.lang.Language;
import com.intellij.model.Pointer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseObjectRefactoring
extends BaseRefactoringAction
implements DumbAware {
    public static final DataKey<Consumer<AbstractDbRefactoringDialog<?>>> INTERCEPTOR = DataKey.create((String)"DatabaseObjectRefactoring.INTERCEPTOR");

    public static boolean isOldModifyEnabled() {
        return ApplicationManager.getApplication().isUnitTestMode() || Registry.is((String)"database.show.old.modify", (boolean)false);
    }

    @Nullable
    public static DasObject getDasObject(@Nullable PsiElement element2) {
        if (element2 instanceof DasObject) {
            return (DasObject)element2;
        }
        JBIterable<DasObject> elements2 = DbNavigationUtils.unwrapElements(element2);
        if (elements2 != null) {
            return (DasObject)elements2.first();
        }
        DasObject res2 = DatabaseObjectRefactoring.getDasObject(element2 == null ? null : element2.getReference());
        if (res2 == null) {
            res2 = (DasObject)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiObject.class, (boolean)false);
        }
        return res2;
    }

    @Nullable
    public static DasObject getDasObject(@Nullable PsiReference ref2) {
        return ref2 == null ? null : (DasObject)ObjectUtils.tryCast((Object)ref2.resolve(), DasObject.class);
    }

    @Nullable
    public static DasObject getDasObject(@Nullable Editor editor2, @Nullable PsiFile file) {
        DasObject res2 = null;
        if (file != null && editor2 != null) {
            int offset = editor2.getCaretModel().getOffset();
            res2 = DatabaseObjectRefactoring.getDasObject(file.findReferenceAt(offset));
            if (res2 == null) {
                res2 = DatabaseObjectRefactoring.getDasObject(file.findElementAt(offset));
            }
            --offset;
            if (res2 == null) {
                res2 = DatabaseObjectRefactoring.getDasObject(file.findReferenceAt(offset));
            }
            if (res2 == null) {
                res2 = DatabaseObjectRefactoring.getDasObject(file.findElementAt(offset));
            }
        }
        return res2;
    }

    @Nullable
    public static BasicElement getBasicElement(@Nullable DasObject object, @NotNull DatabaseEditorContext context) {
        BasicElement res2;
        if (context == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(0);
        }
        if ((res2 = DatabaseObjectRefactoring.extractBasicElement(object)) != null || object == null) {
            return res2;
        }
        Map<? extends DasObject, Pointer<DasObject>> mapping = context.getMapping();
        if (mapping != null) {
            PsiElement psi = (PsiElement)ObjectUtils.tryCast((Object)object, PsiElement.class);
            for (Map.Entry<? extends DasObject, Pointer<DasObject>> entry : mapping.entrySet()) {
                DasObject das = (DasObject)entry.getValue().dereference();
                if (!object.equals(das) && (psi == null || !psi.isEquivalentTo((PsiElement)ObjectUtils.tryCast((Object)das, PsiElement.class)))) continue;
                return (BasicElement)entry.getKey();
            }
        }
        return null;
    }

    @Nullable
    public static BasicElement extractBasicElement(@Nullable DasObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BasicElement) {
            return (BasicElement)object;
        }
        if (object instanceof DbElement) {
            Object delegate = ((DbElement)object).getDelegate();
            return delegate instanceof BasicElement ? (BasicElement)delegate : null;
        }
        return null;
    }

    @Nullable
    public static @Nullable Pair<@Nullable BasicElement, DatabaseEditorContext> prepareForEditing(@Nullable PsiElement place, @Nullable DasObject object) {
        DatabaseEditorContext context = null;
        if (object == null) {
            SqlFile file;
            SqlFile sqlFile = file = place == null ? null : (SqlFile)ObjectUtils.tryCast((Object)place.getContainingFile(), SqlFile.class);
            if (file != null) {
                context = DatabaseEditorContext.forFile(file, false);
            }
        }
        if (context == null && object != null) {
            context = DbRefactoringHelper.createContext(object, place, false);
        }
        if (context == null) {
            return null;
        }
        BasicElement element2 = DatabaseObjectRefactoring.getBasicElement(object, context);
        return Pair.create((Object)element2, (Object)context);
    }

    @Nullable
    public static PsiElement getPlace(@Nullable Editor editor2, @Nullable PsiFile file) {
        return file != null && editor2 != null ? file.findElementAt(editor2.getCaretModel().getOffset()) : null;
    }

    @Nullable
    public static DasObject getDasObject(@NotNull DataContext context) {
        if (context == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(1);
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        DasObject res2 = DatabaseObjectRefactoring.getDasObject(editor2, file);
        if (res2 == null && element2 != null) {
            res2 = DatabaseObjectRefactoring.getDasObject(element2);
        }
        return res2;
    }

    @NotNull
    public static JBIterable<DasObject> getDasObjects(@NotNull DataContext context) {
        if (context == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(2);
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        JBIterable res2 = JBIterable.empty();
        if (editor2 != null && file != null) {
            res2 = JBIterable.from((Iterable)editor2.getCaretModel().getAllCarets()).filterMap(caret -> DatabaseObjectRefactoring.getDasObject(file.findReferenceAt(caret.getOffset())));
        }
        JBIterable jBIterable = res2.isEmpty() ? JBIterable.of((Object)DatabaseObjectRefactoring.getDasObject(context)) : res2;
        if (jBIterable == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    public boolean isAvailableInEditorOnly() {
        return false;
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element2, @NotNull Editor editor2, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element2 == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(6);
        }
        if (context == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(7);
        }
        return this.isEnabledOnElement(element2);
    }

    public boolean isEnabledOnElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(8);
        }
        if (!DatabaseObjectRefactoring.isOldModifyEnabled()) {
            return false;
        }
        DasObject object = DatabaseObjectRefactoring.getDasObject(element2);
        if (object instanceof DbElement && !ImportUtil.canModify((DbElement)object)) {
            return false;
        }
        DatabaseEditorContext context = object == null ? null : DbRefactoringHelper.createContext(object, element2, true);
        return context != null && DbRefactoringHelper.isTableOrEditableTableChild(object, context) && !DataImporter.isBusy(object);
    }

    protected boolean isAvailableForLanguage(Language language) {
        return language instanceof SqlLanguage || language instanceof SqlLanguageDialect;
    }

    public boolean isEnabledOnElements(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(9);
        }
        if (elements2.length != 1) {
            return false;
        }
        return this.isEnabledOnElement(elements2[0]);
    }

    private static void showDialog(@Nullable PsiElement place, @Nullable BasicElement object, @Nullable DatabaseEditorContext context, @Nullable Consumer<AbstractDbRefactoringDialog<?>> interceptor) {
        boolean userSelectedAbort;
        if (object == null || context == null || !DbRefactoringHelper.isTableOrEditableTableChild(object, context)) {
            return;
        }
        DbDataSource dbDataSource = context.getDataSource();
        if (dbDataSource == null) {
            DbModelRegistry registry = (DbModelRegistry)context.getProject().getService(DbModelRegistry.class);
            dbDataSource = registry.findDbDataSource(object);
        }
        if (dbDataSource != null && (userSelectedAbort = DetailsSyncHelper.askUserForSyncOrAbort(dbDataSource, object, OptionsBundle.message((String)"exportable.BaseRefactoringSettings.presentable.name", (Object[])new Object[0])))) {
            return;
        }
        DbTableDialog dialog = new DbTableDialog(context);
        AbstractDbRefactoringDialog.ResultProcessor proc = DbRefactoringHelper.getResultProcessor(object, dialog, place);
        dialog.setResultProcessor(proc);
        dialog.configureForModification(object, DbRefactoringHelper.isForceCreate(object, context));
        DbRefactoringDialogHelper.bootstrap(dialog, (Computable<? extends DeObject>)((Computable)() -> dialog.export(object, true)));
        if (interceptor != null) {
            interceptor.consume((Object)dialog);
        } else {
            dialog.finishAndShow();
        }
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(10);
        }
        return new RefactoringActionHandler(){

            public void invoke(@NotNull Project project, Editor editor2, PsiFile file, DataContext dataContext) {
                Pair<BasicElement, DatabaseEditorContext> info2;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((info2 = DatabaseObjectRefactoring.prepareForEditing(DatabaseObjectRefactoring.getPlace(editor2, file), DatabaseObjectRefactoring.getDasObject(editor2, file))) == null) {
                    return;
                }
                DatabaseObjectRefactoring.showDialog(DatabaseObjectRefactoring.getPlace(editor2, file), (BasicElement)info2.first, (DatabaseEditorContext)info2.second, (Consumer)INTERCEPTOR.getData(dataContext));
            }

            public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, DataContext dataContext) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (elements2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (elements2.length != 1) {
                    return;
                }
                Pair<BasicElement, DatabaseEditorContext> info2 = DatabaseObjectRefactoring.prepareForEditing(elements2[0], DatabaseObjectRefactoring.getDasObject(elements2[0]));
                if (info2 == null) {
                    return;
                }
                DatabaseObjectRefactoring.showDialog(elements2[0], (BasicElement)info2.first, (DatabaseEditorContext)info2.second, (Consumer)INTERCEPTOR.getData(dataContext));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "elements";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/actions/DatabaseObjectRefactoring$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NlsActions.ActionText
    @NotNull
    private static String getDesc(@NotNull ObjectKind kind) {
        if (kind == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(11);
        }
        String string = DatabaseBundle.message("action.DatabaseObjectRefactoring.desc", DatabaseObjectRefactoring.getKindTitle(kind));
        if (string == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NlsContexts.DialogTitle
    @NotNull
    public static String getKindTitle(@NotNull ObjectKind kind) {
        if (kind == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(13);
        }
        String string = StringUtil.capitalizeWords((String)kind.getPresentableName(), (boolean)true);
        if (string == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(15);
        }
        super.update(e2);
        Presentation presentation = e2.getPresentation();
        if (presentation.isEnabled()) {
            DasObject object = DatabaseObjectRefactoring.getDasObject(e2.getDataContext());
            if (object != null) {
                presentation.setText(DatabaseObjectRefactoring.getDesc(object.getKind()));
            }
        } else {
            presentation.setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseObjectRefactoring";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseObjectRefactoring";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasObjects";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesc";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBasicElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDasObject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDasObjects";
                break;
            }
            case 3: 
            case 12: 
            case 14: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDesc";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getKindTitle";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 12, 14 -> new IllegalStateException(string);
        };
    }
}

