/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.DataSourceModelStorageImpl;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageService;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/actions/DataSourceFromModelInternalAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceFromModelInternalAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceFromModelInternalAction.kt\ncom/intellij/database/actions/DataSourceFromModelInternalAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,49:1\n1549#2:50\n1620#2,3:51\n9#3:54\n*S KotlinDebug\n*F\n+ 1 DataSourceFromModelInternalAction.kt\ncom/intellij/database/actions/DataSourceFromModelInternalAction\n*L\n35#1:50\n35#1:51,3\n46#1:54\n*E\n"})
public final class DataSourceFromModelInternalAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        e2.getPresentation().setEnabledAndVisible(e2.getProject() != null);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Project project = e2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        try {
            void $this$mapTo$iv$iv;
            VirtualFile[] virtualFileArray = new VirtualFile[]{null};
            VirtualFile[] virtualFileArray2 = FileChooserFactory.getInstance().createFileChooser(FileChooserDescriptorFactory.createSingleFileDescriptor((String)"xml"), project2, null).choose(project2, virtualFileArray);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"choose(...)");
            VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray2);
            if (virtualFile == null) {
                return;
            }
            VirtualFile modelFile = virtualFile;
            LocalDataSource dataSource2 = new LocalDataSource();
            List<DbDataSource> list = DbPsiFacade.getInstance(project2).getDataSources();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                DbDataSource dbDataSource = (DbDataSource)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(p0.getName());
            }
            List names2 = (List)destination$iv$iv;
            dataSource2.setName(UniqueNameGenerator.generateUniqueName((String)modelFile.getNameWithoutExtension(), (Collection)names2));
            ModelFactory modelFactory = DbSrcModelStorageService.getInstance().createFactory(project2, dataSource2);
            Intrinsics.checkNotNullExpressionValue((Object)modelFactory, (String)"createFactory(...)");
            ModelFactory modelFactory2 = modelFactory;
            File file = modelFile.toNioPath().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            Object object = DataSourceModelStorageImpl.Companion.readModel(modelFactory2, file, dataSource2.getName());
            if (object == null || (object = (DasModel)object.getFirst()) == null) {
                DasModel dasModel = DasUtil.emptyModel();
                object = dasModel;
                Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"emptyModel(...)");
            }
            dataSource2.setModel((DasModel)object);
            DasModel dasModel = dataSource2.getModel();
            Intrinsics.checkNotNull((Object)dasModel, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModel");
            BasicModel model2 = (BasicModel)dasModel;
            dataSource2.setDatabaseDriver(DbImplUtil.guessDatabaseDriver(model2.getDbms()));
            DatabaseDriver databaseDriver = dataSource2.getDatabaseDriver();
            Intrinsics.checkNotNull((Object)databaseDriver);
            dataSource2.setUrl(databaseDriver.getSampleUrl());
            dataSource2.setIntrospectionScope(TreePatternUtils.patternFromPattern(model2.getDbms(), "*"));
            DataSourceManagerDialog.showDialog(project2, (Object)dataSource2, null);
        }
        catch (Throwable th) {
            DataSourceFromModelInternalAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(DataSourceFromModelInternalAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error(th);
        }
    }
}

