/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.HSet;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.DbTestUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.Attribute;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Unit;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Dbms
implements Comparable<Dbms> {
    private static final Logger LOG = Logger.getInstance(Dbms.class);
    private static final ConcurrentMap<String, Dbms> ourValues = new ConcurrentHashMap<String, Dbms>();
    private static final List<Pair<Pattern, Dbms>> ourDetectors = new CopyOnWriteArrayList<Pair<Pattern, Dbms>>();
    public static final Dbms SYNAPSE = Dbms.create("SYNAPSE", "Azure Synapse Analytics", () -> AllIcons.Providers.Azure, Dbms.defaultPattern("azure sql data warehouse"));
    public static final Dbms UNKNOWN = Dbms.create("UNKNOWN", () -> DatabaseIcons.Dbms);
    public static final Dbms ORACLE = Dbms.create("Oracle", () -> AllIcons.Providers.Oracle);
    public static final Dbms MEMSQL = Dbms.create("MEMSQL", "SingleStore", () -> AllIcons.Providers.Singlestore, Dbms.defaultPattern("singlestore|memsql"));
    public static final Dbms MARIA = Dbms.create("MariaDB", () -> AllIcons.Providers.Mariadb);
    public static final Dbms MYSQL_AURORA = Dbms.create("MYSQL_AURORA", "Amazon Aurora MySQL", () -> AllIcons.Providers.Mysql, Dbms.defaultPattern("mysql_aurora") + "|software\\.aws\\.rds\\.jdbc\\.Driver");
    public static final Dbms MYSQL = Dbms.create("MySQL", () -> AllIcons.Providers.Mysql);
    public static final Dbms POSTGRES = Dbms.create("POSTGRES", "PostgreSQL", () -> AllIcons.Providers.Postgresql);
    public static final Dbms REDSHIFT = Dbms.create("REDSHIFT", "Amazon Redshift", () -> AllIcons.Providers.Redshift);
    public static final Dbms GREENPLUM = Dbms.create("GREENPLUM", "Greenplum", () -> AllIcons.Providers.Greenplum);
    public static final Dbms SYBASE = Dbms.create("SYBASE", "Sybase ASE", () -> AllIcons.Providers.Sybase, Dbms.defaultPattern("sybase|adaptive server") + "|ase.*");
    public static final Dbms AZURE = Dbms.create("AZURE", "Azure SQL Database", () -> AllIcons.Providers.Azure);
    public static final Dbms MSSQL_LOCALDB = Dbms.create("MSSQL_LOCALDB", "Microsoft SQL Server LocalDB", () -> AllIcons.Providers.SqlServer, Dbms.defaultPattern("(mssql|sqlserver).localdb"));
    public static final Dbms MSSQL = Dbms.create("MSSQL", "Microsoft SQL Server", () -> AllIcons.Providers.SqlServer, Dbms.defaultPattern("microsoft|sqlserver|jtds"));
    public static final Dbms DB2_LUW = Dbms.create("DB2_LUW", "IBM Db2 LUW", () -> AllIcons.Providers.DB2);
    public static final Dbms DB2_IS = Dbms.create("DB2_IS", "IBM Db2 iSeries", () -> AllIcons.Providers.DB2);
    public static final Dbms DB2_ZOS = Dbms.create("DB2_ZOS", "IBM Db2 z/OS", () -> AllIcons.Providers.DB2);
    public static final Dbms DB2 = Dbms.create("DB2", "IBM Db2", () -> AllIcons.Providers.DB2, "(?i).*(?:\\bDB2|[:.]as400[:.]).*");
    public static final Dbms SQLITE = Dbms.create("SQLite", () -> AllIcons.Providers.Sqlite);
    public static final Dbms HSQL = Dbms.create("HSQLDB", "HSQLDB", () -> AllIcons.Providers.Hsqldb, Dbms.defaultPattern("hsql"));
    public static final Dbms H2 = Dbms.create("H2", () -> AllIcons.Providers.H2);
    public static final Dbms DERBY = Dbms.create("DERBY", "Apache Derby", () -> AllIcons.Providers.ApacheDerby);
    public static final Dbms EXASOL = Dbms.create("EXASOL", "Exasol", () -> AllIcons.Providers.Exasol, Dbms.defaultPattern("exasol|exa"));
    public static final Dbms CLICKHOUSE = Dbms.create("ClickHouse", () -> AllIcons.Providers.ClickHouse);
    public static final Dbms CASSANDRA = Dbms.create("CASSANDRA", "Apache Cassandra", () -> AllIcons.Providers.Cassandra);
    public static final Dbms VERTICA = Dbms.create("Vertica", () -> AllIcons.Providers.Vertica);
    public static final Dbms HIVE = Dbms.create("HIVE", "Apache Hive", () -> AllIcons.Providers.Hive);
    public static final Dbms SPARK = Dbms.create("SPARK", "Apache Spark", () -> AllIcons.Providers.Spark, Dbms.defaultPattern("spark|databricks"));
    public static final Dbms SNOWFLAKE = Dbms.create("Snowflake", () -> AllIcons.Providers.Snowflake);
    public static final Dbms MONGO = Dbms.create("MONGO", "MongoDB", () -> AllIcons.Providers.MongoDB, Dbms.defaultPattern("mongo|documentdb"));
    public static final Dbms COCKROACH = Dbms.create("COCKROACH", "CockroachDB", () -> AllIcons.Providers.CockroachDB);
    public static final Dbms BIGQUERY = Dbms.create("BIGQUERY", "BigQuery", () -> AllIcons.Providers.BigQuery);
    public static final Dbms COUCHBASE_QUERY = Dbms.create("COUCHBASE", "Couchbase Query", () -> AllIcons.Providers.Couchbase);
    public static final Dbms REDIS = Dbms.create("REDIS", "Redis", () -> AllIcons.Providers.Redis);
    public static final Dbms DYNAMO = Dbms.create("DYNAMO", "DynamoDB", () -> AllIcons.Providers.DynamoDB);
    public static final HSet POSTGRES_LIKE = HSet.create("POSTGRES_LIKE");
    public static final HSet MYSQL_LIKE = HSet.create("MYSQL_LIKE");
    public static final HSet DB2_LIKE = HSet.create("DB2_LIKE");
    public static final HSet AZURE_LIKE = HSet.create("AZURE_LIKE");
    public static final HSet MSSQL_LIKE = HSet.create("MSSQL_LIKE");
    public static final HSet PRESTO_LIKE = HSet.create("PRESTO_LIKE");
    public static final HSet TRANSACT_SQL = HSet.create("TRANSACT_SQL");
    public static final HSet DOCUMENT_ORIENTED = HSet.create("DOCUMENT_ORIENTED");
    public static final HSet PSEUDO_SUPPORTED = HSet.create("PSEUDO_SUPPORTED");
    private final String myName;
    private final String myDisplayName;
    private final NotNullLazyValue<Icon> myIcon;
    private final HSet mySet;
    private static final ExtensionPointName<DbmsBean> DBMS_EP = ExtensionPointName.create((String)"com.intellij.database.dbms");

    @NotNull
    public static Dbms create(@NotNull String displayName, @NotNull Supplier<Icon> icon) {
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(1);
        }
        return Dbms.create(displayName, displayName, icon);
    }

    @NotNull
    public static Dbms create(@NotNull String name2, @NotNull String displayName, @NotNull Supplier<Icon> icon) {
        if (name2 == null) {
            Dbms.$$$reportNull$$$0(2);
        }
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(3);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(4);
        }
        return Dbms.create(name2, displayName, icon, null);
    }

    @NotNull
    public static Dbms create(@NotNull String name2, @NotNull String displayName, @NotNull Supplier<Icon> icon, @RegExp @Nullable String detectPattern) {
        Dbms existing;
        if (name2 == null) {
            Dbms.$$$reportNull$$$0(5);
        }
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(6);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(7);
        }
        if ((existing = (Dbms)ourValues.get(name2 = Strings.toUpperCase((String)name2))) != null) {
            Dbms dbms = existing;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(8);
            }
            return dbms;
        }
        Dbms proposed = new Dbms(name2, displayName, icon);
        Dbms result2 = (Dbms)ConcurrencyUtil.cacheOrGet(ourValues, (Object)name2, (Object)proposed);
        if (proposed == result2) {
            String pattern2 = detectPattern == null ? Dbms.defaultPattern(name2) : detectPattern;
            ourDetectors.add((Pair<Pattern, Dbms>)Pair.create((Object)Pattern.compile(pattern2), (Object)result2));
        }
        Dbms dbms = result2;
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(9);
        }
        return dbms;
    }

    public static String defaultPattern(@NotNull String name2) {
        if (name2 == null) {
            Dbms.$$$reportNull$$$0(10);
        }
        return String.format("(?i).*\\b(?:%s).*", name2.replace("_", ".*"));
    }

    private Dbms(@NotNull String name2, @NotNull String displayName, @NotNull Supplier<Icon> icon) {
        if (name2 == null) {
            Dbms.$$$reportNull$$$0(11);
        }
        if (displayName == null) {
            Dbms.$$$reportNull$$$0(12);
        }
        if (icon == null) {
            Dbms.$$$reportNull$$$0(13);
        }
        this.myName = name2;
        this.myDisplayName = displayName;
        this.myIcon = NotNullLazyValue.lazy(icon);
        this.mySet = HSet.create(name2);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            Dbms.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            Dbms.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = (Icon)this.myIcon.getValue();
        if (icon == null) {
            Dbms.$$$reportNull$$$0(16);
        }
        return icon;
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    public HSet getHSet() {
        HSet hSet = this.mySet;
        if (hSet == null) {
            Dbms.$$$reportNull$$$0(17);
        }
        return hSet;
    }

    public boolean isOracle() {
        return this.is(ORACLE);
    }

    public boolean isMysql() {
        return this.in(MYSQL_LIKE);
    }

    public boolean isPostgres() {
        return this.in(POSTGRES_LIKE);
    }

    public boolean isBigQuery() {
        return this.is(BIGQUERY);
    }

    public boolean isRedshift() {
        return this.is(REDSHIFT);
    }

    public boolean isGreenplum() {
        return this.is(GREENPLUM);
    }

    public boolean isVertica() {
        return this.is(VERTICA);
    }

    public boolean isMicrosoft() {
        return this.in(MSSQL_LIKE);
    }

    public boolean isSybase() {
        return this.is(SYBASE);
    }

    public boolean isDb2() {
        return this.in(DB2_LIKE);
    }

    public boolean isHsqldb() {
        return this.is(HSQL);
    }

    public boolean isH2() {
        return this.is(H2);
    }

    public boolean isDerby() {
        return this.is(DERBY);
    }

    public boolean isSqlite() {
        return this.is(SQLITE);
    }

    public boolean isExasol() {
        return this.is(EXASOL);
    }

    public boolean isClickHouse() {
        return this.is(CLICKHOUSE);
    }

    public boolean isCassandra() {
        return this.is(CASSANDRA);
    }

    public boolean isHive() {
        return this.is(HIVE);
    }

    public boolean isSpark() {
        return this.is(SPARK);
    }

    public boolean isSnowflake() {
        return this.is(SNOWFLAKE);
    }

    public boolean isMongo() {
        return this.is(MONGO);
    }

    public boolean isCouchbase() {
        return this.is(COUCHBASE_QUERY);
    }

    public boolean isCockroach() {
        return this.is(COCKROACH);
    }

    public boolean isRedis() {
        return this.is(REDIS);
    }

    public boolean isDynamo() {
        return this.is(DYNAMO);
    }

    public boolean isTransactSql() {
        return this.in(TRANSACT_SQL);
    }

    public boolean isDocumentOriented() {
        return this.in(DOCUMENT_ORIENTED);
    }

    public boolean eq(@Nullable Dbms dbms) {
        return this == dbms;
    }

    public boolean is(@Nullable Dbms dbms) {
        return this.eq(dbms);
    }

    public boolean in(@NotNull Dbms dbms) {
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(18);
        }
        return this.in(dbms.getHSet());
    }

    public boolean in(@NotNull HSet set) {
        if (set == null) {
            Dbms.$$$reportNull$$$0(19);
        }
        return set.contains(this.mySet);
    }

    @NotNull
    public static Dbms forConnection(@Nullable RawConnectionConfig o2) {
        if (o2 == null) {
            Dbms dbms = UNKNOWN;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(20);
            }
            return dbms;
        }
        Dbms result2 = Dbms.fromString(o2.getUrl());
        if (result2 != UNKNOWN) {
            Dbms dbms = result2;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(21);
            }
            return dbms;
        }
        return Dbms.fromString(o2.getDriverClass());
    }

    @NotNull
    public static Dbms fromString(@Nullable String text2) {
        if (text2 == null) {
            Dbms dbms = UNKNOWN;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(22);
            }
            return dbms;
        }
        for (Pair<Pattern, Dbms> detector : ourDetectors) {
            if (!((Pattern)detector.first).matcher(text2).matches()) continue;
            Dbms dbms = (Dbms)detector.second;
            if (dbms == null) {
                Dbms.$$$reportNull$$$0(23);
            }
            return dbms;
        }
        String pattern2 = "(?i).*\\b(?:%s).*";
        for (Dbms dbms : Dbms.allValues()) {
            if (!text2.matches(String.format(pattern2, dbms.getName()))) continue;
            Dbms dbms2 = dbms;
            if (dbms2 == null) {
                Dbms.$$$reportNull$$$0(24);
            }
            return dbms2;
        }
        Dbms dbms = UNKNOWN;
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(25);
        }
        return dbms;
    }

    @Nullable
    public static Dbms byName(@Nullable String name2) {
        return name2 == null ? null : LazyData.allDbms().get(name2);
    }

    @NotNull
    public static Collection<Dbms> allValues() {
        Collection<Dbms> collection2 = LazyData.allDbms().values();
        if (collection2 == null) {
            Dbms.$$$reportNull$$$0(26);
        }
        return collection2;
    }

    @NotNull
    public static HSet asSet(Dbms ... dbms) {
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(27);
        }
        HSet[] sets = new HSet[dbms.length];
        for (int i2 = 0; i2 < dbms.length; ++i2) {
            sets[i2] = dbms[i2].getHSet();
        }
        HSet hSet = HSet.create(sets);
        if (hSet == null) {
            Dbms.$$$reportNull$$$0(28);
        }
        return hSet;
    }

    @NotNull
    public static Iterable<Dbms> allValues(@NotNull HSet set) {
        if (set == null) {
            Dbms.$$$reportNull$$$0(29);
        }
        JBIterable jBIterable = JBIterable.from(Dbms.allValues()).filter(d2 -> d2.in(set));
        if (jBIterable == null) {
            Dbms.$$$reportNull$$$0(30);
        }
        return jBIterable;
    }

    @Override
    public int compareTo(@NotNull Dbms o2) {
        if (o2 == null) {
            Dbms.$$$reportNull$$$0(31);
        }
        return Comparing.compare((Comparable)((Object)this.getName()), (Comparable)((Object)o2.getName()));
    }

    @NotNull
    public static Collection<PluginDescriptor> getPluginDescriptors(@NotNull Dbms dbms) {
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(32);
        }
        Collection collection2 = LazyData.ourDescriptors.get((Object)dbms);
        if (collection2 == null) {
            Dbms.$$$reportNull$$$0(33);
        }
        return collection2;
    }

    public static boolean isPredefined(@NotNull Dbms dbms) {
        if (dbms == null) {
            Dbms.$$$reportNull$$$0(34);
        }
        return LazyData.ourPredefined.contains(dbms);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 14, 15, 16, 17, 20, 21, 22, 23, 24, 25, 26, 28, 30, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/Dbms";
                break;
            }
            case 18: 
            case 27: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/Dbms";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getHSet";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "forConnection";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 26: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "allValues";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "asSet";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 33: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "defaultPattern";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "in";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "asSet";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "allValues";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptors";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isPredefined";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 14, 15, 16, 17, 20, 21, 22, 23, 24, 25, 26, 28, 30, 33 -> new IllegalStateException(string);
        };
    }

    private static class LazyData {
        private static final MultiMap<Dbms, PluginDescriptor> ourDescriptors = MultiMap.create();
        private static final Set<Dbms> ourPredefined = new HashSet<Dbms>();

        private LazyData() {
        }

        private static JBIterable<Dbms> getPredefinedDbms() {
            return JBIterable.of((Object[])Dbms.class.getDeclaredFields()).filter(f -> {
                int req2;
                if (!ReflectionUtil.isAssignable(Dbms.class, f.getType())) {
                    return false;
                }
                int modifiers = f.getModifiers();
                return (modifiers & (req2 = 25)) == req2;
            }).filterMap(f -> {
                try {
                    return (Dbms)f.get(null);
                }
                catch (IllegalAccessException e2) {
                    LOG.warn((Throwable)e2);
                    return null;
                }
            });
        }

        private static void addDbms(DbmsBean bean, PluginDescriptor pluginDescriptor) {
            Dbms dbms = LazyData.getDbms(bean, pluginDescriptor);
            if (dbms == null) {
                return;
            }
            String id = bean.id;
            String name2 = dbms.getName();
            if (id == null) {
                LOG.error(name2 + " should define `id=\"" + name2 + "\"` in xml");
            } else if (!id.equals(name2)) {
                LOG.error(name2 + " has defined id=" + id + ", but they should match");
            } else {
                ourDescriptors.putValue((Object)dbms, (Object)pluginDescriptor);
                if (ourValues.get(name2) != dbms) {
                    LOG.error(bean.instance + " does not match existing dbms");
                }
            }
        }

        private static Dbms getDbms(DbmsBean bean, PluginDescriptor pluginDescriptor) {
            int dotIdx = bean.instance.lastIndexOf(46);
            if (dotIdx < 0) {
                LOG.error("Class field reference should contain `.` in: " + bean.instance + "[" + pluginDescriptor.getPluginId() + "]");
                return null;
            }
            try {
                Class<?> holder = Class.forName(bean.instance.substring(0, dotIdx), true, pluginDescriptor.getPluginClassLoader());
                Dbms dbms = (Dbms)ReflectionUtil.getStaticFieldValue(holder, Dbms.class, (String)bean.instance.substring(dotIdx + 1));
                if (dbms == null) {
                    LOG.error("Static field not found: " + bean.instance + "[" + pluginDescriptor.getPluginId() + "]");
                }
                return dbms;
            }
            catch (Exception e2) {
                LOG.error("Unable to find dbms: " + bean.instance + "[" + pluginDescriptor.getPluginId() + "]", (Throwable)e2);
                return null;
            }
        }

        private static Map<String, Dbms> allDbms() {
            return ourValues;
        }

        static {
            Application app = ApplicationManager.getApplication();
            if (app != null && app.getExtensionArea().hasExtensionPoint(DBMS_EP)) {
                DBMS_EP.processWithPluginDescriptor((bean, pluginDescriptor) -> {
                    try {
                        LazyData.addDbms(bean, pluginDescriptor);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return Unit.INSTANCE;
                });
            } else if (app == null || app.isUnitTestMode()) {
                for (DbmsBean bean2 : DbTestUtils.loadBeans(DBMS_EP.getName(), DbmsBean.class, false)) {
                    LazyData.addDbms(bean2, DbTestUtils.ourDescriptor);
                }
            }
            LazyData.getPredefinedDbms().addAllTo(ourPredefined);
        }
    }

    public static final class DbmsBean {
        @Attribute(value="id")
        public String id;
        @Attribute(value="instance")
        public String instance;
    }
}

