/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.DatabaseTopics;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.messages.MessageBusOwner;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class DataBus {
    private static final ExtensionPointName<DataConsumer> CONSUMER_EP = new ExtensionPointName("com.intellij.database.dataConsumer");
    private static final ExtensionPointName<DataProducer> PRODUCER_EP = new ExtensionPointName("com.intellij.database.dataProducer");
    private static final ExtensionPointName<DataAuditor> AUDITOR_EP = new ExtensionPointName("com.intellij.database.dataAuditor");
    private final MessageBus myMessageBus;
    private final AtomicInteger myUseCount;

    DataBus(final @NotNull Project project) {
        if (project == null) {
            DataBus.$$$reportNull$$$0(0);
        }
        this.myUseCount = new AtomicInteger();
        this.myMessageBus = MessageBusFactory.newMessageBus((MessageBusOwner)new MessageBusOwner(){

            @NotNull
            public Object createListener(@NotNull ListenerDescriptor descriptor2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException();
            }

            public boolean isDisposed() {
                return project.isDisposed();
            }

            public String toString() {
                return DataBus.this.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/DataBus$1", "createListener"));
            }
        });
        Disposer.register((Disposable)project, (Disposable)this.newUseCountDisposable());
        this.myMessageBus.connect().subscribe(DatabaseTopics.RESPONSE_TOPIC, (Object)((DataConsumer)EventDispatcher.createMulticaster(DataConsumer.class, () -> CONSUMER_EP.getExtensionList())));
        this.myMessageBus.connect().subscribe(DatabaseTopics.REQUEST_TOPIC, (Object)((DataProducer)EventDispatcher.createMulticaster(DataProducer.class, () -> PRODUCER_EP.getExtensionList())));
        this.myMessageBus.connect().subscribe(DatabaseTopics.AUDIT_TOPIC, (Object)((DataAuditor)EventDispatcher.createMulticaster(DataAuditor.class, () -> AUDITOR_EP.getExtensionList())));
    }

    private static MessageBus getDataBusInner(@NotNull Project project) {
        if (project == null) {
            DataBus.$$$reportNull$$$0(1);
        }
        return ((DataBus)project.getService(DataBus.class)).myMessageBus;
    }

    @NotNull
    public static MessageBus newDataBusChild(final @NotNull Project project, final @NotNull String title, @NotNull Disposable parentDisposable) {
        if (project == null) {
            DataBus.$$$reportNull$$$0(2);
        }
        if (title == null) {
            DataBus.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            DataBus.$$$reportNull$$$0(4);
        }
        MessageBus messageBus = MessageBusFactory.getInstance().createMessageBus(new MessageBusOwner(){

            @NotNull
            public Object createListener(@NotNull ListenerDescriptor descriptor2) {
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException();
            }

            public boolean isDisposed() {
                return project.isDisposed();
            }

            public String toString() {
                return title;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/DataBus$2", "createListener"));
            }
        }, DataBus.getDataBusInner(project));
        Disposable useCountDisposer = ((DataBus)project.getService(DataBus.class)).newUseCountDisposable();
        Disposer.register((Disposable)parentDisposable, (Disposable)useCountDisposer);
        Disposer.register((Disposable)parentDisposable, (Disposable)messageBus);
        Disposer.register((Disposable)project, (Disposable)parentDisposable);
        MessageBus messageBus2 = messageBus;
        if (messageBus2 == null) {
            DataBus.$$$reportNull$$$0(5);
        }
        return messageBus2;
    }

    @NotNull
    private Disposable newUseCountDisposable() {
        this.myUseCount.incrementAndGet();
        return new Disposable(){

            public void dispose() {
                if (DataBus.this.myUseCount.decrementAndGet() == 0) {
                    Disposer.dispose((Disposable)DataBus.this.myMessageBus);
                }
            }
        };
    }

    @NotNull
    public static Producing shortCircuit(@NotNull Consuming messageBus) {
        if (messageBus == null) {
            DataBus.$$$reportNull$$$0(6);
        }
        Producing producing = (Producing)((Object)messageBus);
        if (producing == null) {
            DataBus.$$$reportNull$$$0(7);
        }
        return producing;
    }

    public static void addRootAuditor(@NotNull Project project, DataAuditor auditor, Disposable disposable) {
        if (project == null) {
            DataBus.$$$reportNull$$$0(8);
        }
        DataBus.getDataBusInner(project).connect(disposable).subscribe(DatabaseTopics.AUDIT_TOPIC, (Object)auditor);
    }

    @TestOnly
    @NotNull
    public static MessageBus getDataBus(@NotNull Project project) {
        if (project == null) {
            DataBus.$$$reportNull$$$0(9);
        }
        MessageBus messageBus = DataBus.getDataBusInner(project);
        if (messageBus == null) {
            DataBus.$$$reportNull$$$0(10);
        }
        return messageBus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/DataBus";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/DataBus";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newDataBusChild";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "shortCircuit";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataBus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataBusInner";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newDataBusChild";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shortCircuit";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRootAuditor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDataBus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 10 -> new IllegalStateException(string);
        };
    }

    public static interface Producing {
        public DataConsumer getDataConsumer();

        public DataAuditor getDataAuditor();

        public void addProducer(@NotNull DataProducer var1);

        public void beforeProducerRemove(@NotNull DataProducer var1);

        public void afterProducerRemove(@NotNull DataProducer var1);
    }

    public static interface Consuming {
        public Consuming filterFor(@NotNull DataRequest.Owner var1);

        public DataProducer getDataProducer();

        public void addConsumer(@NotNull DataConsumer var1);

        public void addAuditor(@NotNull DataAuditor var1);
    }
}

