/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.package;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.PackageType;
import org.jetbrains.security.package.version.SingleVersion;
import org.jetbrains.security.utils.StringUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BO\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\r\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\rH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JW\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\r2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\u000e\u0010/\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0000J\t\u00100\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0007\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00061"}, d2={"Lorg/jetbrains/security/package/Package;", "", "type", "Lorg/jetbrains/security/package/PackageType;", "namespace", "", "name", "version", "qualifiers", "subpath", "releaseDate", "Ljava/util/Date;", "(Lorg/jetbrains/security/package/PackageType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Date;)V", "Lorg/jetbrains/security/package/version/SingleVersion;", "(Lorg/jetbrains/security/package/PackageType;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/security/package/version/SingleVersion;Ljava/lang/String;Ljava/lang/String;Ljava/util/Date;)V", "coordinates", "getCoordinates", "()Ljava/lang/String;", "humanReadableCoordinates", "getHumanReadableCoordinates", "getName", "getNamespace", "getQualifiers", "getReleaseDate", "()Ljava/util/Date;", "searchCoordinates", "getSearchCoordinates", "searchKey", "getSearchKey", "getSubpath", "getType", "()Lorg/jetbrains/security/package/PackageType;", "getVersion", "()Lorg/jetbrains/security/package/version/SingleVersion;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "matches", "toString", "model"})
public final class Package {
    @NotNull
    private final PackageType type;
    @Nullable
    private final String namespace;
    @NotNull
    private final String name;
    @NotNull
    private final SingleVersion version;
    @Nullable
    private final String qualifiers;
    @Nullable
    private final String subpath;
    @Nullable
    private final Date releaseDate;
    @NotNull
    private final String coordinates;
    @NotNull
    private final String humanReadableCoordinates;
    @NotNull
    private final String searchCoordinates;
    @NotNull
    private final String searchKey;

    public Package(@NotNull PackageType type, @Nullable String namespace, @NotNull String name, @NotNull SingleVersion version, @Nullable String qualifiers, @Nullable String subpath, @Nullable Date releaseDate) {
        String string;
        String string2;
        String string3;
        String string4;
        Object[] it;
        Package package_;
        StringBuilder stringBuilder;
        boolean bl;
        boolean bl2;
        Object[] objectArray;
        String string5;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.type = type;
        this.namespace = namespace;
        this.name = name;
        this.version = version;
        this.qualifiers = qualifiers;
        this.subpath = subpath;
        this.releaseDate = releaseDate;
        this.coordinates = (Object)((Object)this.type) + ':' + this.namespace + ':' + this.name + ':' + this.version + ':' + this.qualifiers + ':' + this.subpath;
        Package package_2 = this;
        StringBuilder stringBuilder2 = new StringBuilder().append((Object)this.type);
        Object[] objectArray2 = this.namespace;
        if (objectArray2 == null) {
            string5 = "";
        } else {
            objectArray = objectArray2;
            bl2 = false;
            bl = false;
            Object[] objectArray3 = objectArray;
            stringBuilder = stringBuilder2;
            package_ = package_2;
            boolean bl3 = false;
            string4 = Intrinsics.stringPlus((String)":", (Object)it);
            package_2 = package_;
            stringBuilder2 = stringBuilder;
            string3 = string4;
            string5 = string3 == null ? "" : string3;
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string5).append(':').append(this.name).append(':').append(this.version);
        objectArray2 = this.qualifiers;
        if (objectArray2 == null) {
            string2 = "";
        } else {
            objectArray = objectArray2;
            bl2 = false;
            bl = false;
            it = objectArray;
            stringBuilder = stringBuilder3;
            package_ = package_2;
            boolean bl4 = false;
            string4 = Intrinsics.stringPlus((String)":", (Object)it);
            package_2 = package_;
            stringBuilder3 = stringBuilder;
            string3 = string4;
            string2 = string3 == null ? "" : string3;
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string2);
        objectArray2 = this.subpath;
        if (objectArray2 == null) {
            string = "";
        } else {
            objectArray = objectArray2;
            bl2 = false;
            bl = false;
            it = objectArray;
            stringBuilder = stringBuilder4;
            package_ = package_2;
            boolean bl5 = false;
            string4 = Intrinsics.stringPlus((String)":", (Object)it);
            package_2 = package_;
            stringBuilder4 = stringBuilder;
            string3 = string4;
            string = string3 == null ? "" : string3;
        }
        package_2.humanReadableCoordinates = stringBuilder4.append(string).toString();
        this.searchCoordinates = this.namespace + ':' + this.name + ':' + this.version;
        objectArray2 = new Object[]{this.type.name() + ':' + this.searchCoordinates};
        this.searchKey = StringUtils.INSTANCE.calculateContentsHashSha256(objectArray2);
    }

    public /* synthetic */ Package(PackageType packageType, String string, String string2, SingleVersion singleVersion, String string3, String string4, Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            string4 = null;
        }
        if ((n & 0x40) != 0) {
            date = null;
        }
        this(packageType, string, string2, singleVersion, string3, string4, date);
    }

    @NotNull
    public final PackageType getType() {
        return this.type;
    }

    @Nullable
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final SingleVersion getVersion() {
        return this.version;
    }

    @Nullable
    public final String getQualifiers() {
        return this.qualifiers;
    }

    @Nullable
    public final String getSubpath() {
        return this.subpath;
    }

    @Nullable
    public final Date getReleaseDate() {
        return this.releaseDate;
    }

    public Package(@NotNull PackageType type, @Nullable String namespace, @NotNull String name, @NotNull String version, @Nullable String qualifiers, @Nullable String subpath, @Nullable Date releaseDate) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this(type, namespace, name, new SingleVersion(version), qualifiers, subpath, releaseDate);
    }

    public /* synthetic */ Package(PackageType packageType, String string, String string2, String string3, String string4, String string5, Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        if ((n & 0x20) != 0) {
            string5 = null;
        }
        if ((n & 0x40) != 0) {
            date = null;
        }
        this(packageType, string, string2, string3, string4, string5, date);
    }

    @NotNull
    public final String getCoordinates() {
        return this.coordinates;
    }

    @NotNull
    public final String getHumanReadableCoordinates() {
        return this.humanReadableCoordinates;
    }

    @NotNull
    public final String getSearchCoordinates() {
        return this.searchCoordinates;
    }

    @NotNull
    public final String getSearchKey() {
        return this.searchKey;
    }

    public final boolean matches(@NotNull Package other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return !Intrinsics.areEqual((Object)this.name, (Object)other.name) ? false : (this.type != other.type ? false : (!this.version.checkIfAnyVersion() && !other.version.checkIfAnyVersion() && !Intrinsics.areEqual((Object)this.version, (Object)other.version) ? false : Intrinsics.areEqual((Object)this.namespace, (Object)other.namespace)));
    }

    @NotNull
    public final PackageType component1() {
        return this.type;
    }

    @Nullable
    public final String component2() {
        return this.namespace;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final SingleVersion component4() {
        return this.version;
    }

    @Nullable
    public final String component5() {
        return this.qualifiers;
    }

    @Nullable
    public final String component6() {
        return this.subpath;
    }

    @Nullable
    public final Date component7() {
        return this.releaseDate;
    }

    @NotNull
    public final Package copy(@NotNull PackageType type, @Nullable String namespace, @NotNull String name, @NotNull SingleVersion version, @Nullable String qualifiers, @Nullable String subpath, @Nullable Date releaseDate) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new Package(type, namespace, name, version, qualifiers, subpath, releaseDate);
    }

    public static /* synthetic */ Package copy$default(Package package_, PackageType packageType, String string, String string2, SingleVersion singleVersion, String string3, String string4, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            packageType = package_.type;
        }
        if ((n & 2) != 0) {
            string = package_.namespace;
        }
        if ((n & 4) != 0) {
            string2 = package_.name;
        }
        if ((n & 8) != 0) {
            singleVersion = package_.version;
        }
        if ((n & 0x10) != 0) {
            string3 = package_.qualifiers;
        }
        if ((n & 0x20) != 0) {
            string4 = package_.subpath;
        }
        if ((n & 0x40) != 0) {
            date = package_.releaseDate;
        }
        return package_.copy(packageType, string, string2, singleVersion, string3, string4, date);
    }

    @NotNull
    public String toString() {
        return "Package(type=" + (Object)((Object)this.type) + ", namespace=" + this.namespace + ", name=" + this.name + ", version=" + this.version + ", qualifiers=" + this.qualifiers + ", subpath=" + this.subpath + ", releaseDate=" + this.releaseDate + ')';
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.version.hashCode();
        result = result * 31 + (this.qualifiers == null ? 0 : this.qualifiers.hashCode());
        result = result * 31 + (this.subpath == null ? 0 : this.subpath.hashCode());
        result = result * 31 + (this.releaseDate == null ? 0 : this.releaseDate.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Package)) {
            return false;
        }
        Package package_ = (Package)other;
        if (this.type != package_.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.namespace, (Object)package_.namespace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)package_.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)package_.version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.qualifiers, (Object)package_.qualifiers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subpath, (Object)package_.subpath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.releaseDate, (Object)package_.releaseDate);
    }
}

