/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.java.BuildFileProviderBase;
import com.intellij.packageChecker.java.IntellijModuleProjectDependenciesModel;
import com.intellij.packageChecker.java.JavaPackageUtilKt;
import com.intellij.packageChecker.java.JpsBuildFileProviderKt;
import com.intellij.packageChecker.model.ProjectDependenciesModel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00182\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00182\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\"\u001a\u00020 H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006#"}, d2={"Lcom/intellij/packageChecker/java/JpsBuildFileProvider;", "Lcom/intellij/packageChecker/java/BuildFileProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "id", "", "getId", "()Ljava/lang/String;", "collectPackages", "", "Lorg/jetbrains/security/package/Package;", "module", "Lcom/intellij/openapi/module/Module;", "declaredPackages", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "file", "Lcom/intellij/psi/PsiFile;", "findModuleForFile", "getJpsPackageDeclaration", "imlFile", "packages", "getModule", "getRoots", "", "pkgs", "importedPackages", "moduleScript", "parseDependencyName", "Lkotlin/Pair;", "str", "isJar", "", "supports", "supportsFixes", "intellij.packageChecker.java"})
@SourceDebugExtension(value={"SMAP\nJpsBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsBuildFileProvider.kt\ncom/intellij/packageChecker/java/JpsBuildFileProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1#2:151\n766#3:152\n857#3,2:153\n766#3:155\n857#3,2:156\n1271#3,2:158\n1285#3,4:160\n*S KotlinDebug\n*F\n+ 1 JpsBuildFileProvider.kt\ncom/intellij/packageChecker/java/JpsBuildFileProvider\n*L\n69#1:152\n69#1:153,2\n73#1:155\n73#1:156,2\n129#1:158,2\n129#1:160,4\n*E\n"})
public final class JpsBuildFileProvider
extends BuildFileProviderBase {
    @NotNull
    private final String id;

    public JpsBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.id = "jps";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Module getModule(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module = this.findModuleForFile(file2);
        if (module == null) {
            JpsBuildFileProviderKt.access$getLogger$p().warn("Not a Jps module by file: " + file2.getName());
        }
        return module;
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = module.getModuleFile();
        if (virtualFile != null) {
            VirtualFile moduleFile = virtualFile;
            boolean bl = false;
            if (this.getProject().isDisposed() || !moduleFile.isValid()) {
                return null;
            }
            psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(moduleFile);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredPackages(@Nullable PsiFile file2, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (file2 == null) {
            return CollectionsKt.emptyList();
        }
        List<Package> jpsPackages = this.collectPackages(module);
        List<PackageDeclaration> jpsPackageDeclarations = this.getJpsPackageDeclaration(file2, jpsPackages);
        if (JpsBuildFileProviderKt.access$getLogger$p().isDebugEnabled()) {
            JpsBuildFileProviderKt.access$getLogger$p().debug("found " + jpsPackages.size() + " jpsPackages and " + jpsPackageDeclarations.size() + " jpsPackageDeclarations");
        }
        return jpsPackageDeclarations;
    }

    private final List<PackageDeclaration> getJpsPackageDeclaration(PsiFile imlFile, List<Package> packages) {
        if (packages.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PsiFile file2 = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("file.iml", (Language)XMLLanguage.INSTANCE, (CharSequence)imlFile.getText());
        PsiElement[] psiElementArray = file2.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        List elements = ArraysKt.toMutableList((Object[])psiElementArray);
        List libraries = new ArrayList();
        while (!((Collection)elements).isEmpty()) {
            Object object = CollectionsKt.removeFirst((List)elements);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"removeFirst(...)");
            PsiElement element = (PsiElement)object;
            boolean isJar = element.textMatches((CharSequence)"type=\"module-library\"");
            if (element.textMatches((CharSequence)"type=\"library\"") || isJar) {
                Package pkg;
                Package package_;
                Object object2;
                Object[] objectArray;
                String version;
                String artifactId;
                PsiElement jpsDependencyNameElement;
                block12: {
                    Pair<String, String> pair;
                    Object object3;
                    block11: {
                        PsiElement[] psiElementArray2 = element.getParent().getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
                        for (Object object4 : (Object[])psiElementArray2) {
                            Object it = (PsiElement)object4;
                            boolean bl = false;
                            String string = it.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"name", (boolean)false, (int)2, null)) continue;
                            object3 = object4;
                            break block11;
                        }
                        object3 = null;
                    }
                    if ((PsiElement)object3 == null || this.parseDependencyName(jpsDependencyNameElement.getText(), isJar) == null) continue;
                    artifactId = (String)pair.component1();
                    version = (String)pair.component2();
                    objectArray = (Object[])packages;
                    for (Object it : objectArray) {
                        Package it2 = (Package)it;
                        boolean bl = false;
                        boolean isVersionMatch = version != null ? Intrinsics.areEqual((Object)it2.getVersion().getValue(), (Object)version) : true;
                        if (!(StringsKt.contains$default((CharSequence)artifactId, (CharSequence)(it2.getNamespace() + ":" + it2.getName()), (boolean)false, (int)2, null) && isVersionMatch)) continue;
                        object2 = it;
                        break block12;
                    }
                    object2 = null;
                }
                Package foundByNamespaceNameAndVersion = (Package)object2;
                if (foundByNamespaceNameAndVersion == null) {
                    boolean bl;
                    Package it;
                    Iterable $this$filterTo$iv$iv;
                    Iterable iterable = packages;
                    boolean $i$f$filter = false;
                    Iterable it2 = iterable;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Package)element$iv$iv;
                        bl = false;
                        if (!StringsKt.contains$default((CharSequence)artifactId, (CharSequence)it.getName(), (boolean)false, (int)2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Package foundByName = (Package)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                    package_ = foundByName;
                    if (package_ == null) {
                        Iterable iterable2 = packages;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = iterable2;
                        destination$iv$iv = new ArrayList();
                        $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            it = (Package)element$iv$iv;
                            bl = false;
                            String namespace = it.getNamespace();
                            if (!(namespace != null && StringsKt.contains$default((CharSequence)artifactId, (CharSequence)namespace, (boolean)false, (int)2, null))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        package_ = (Package)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                    }
                } else {
                    package_ = foundByNamespaceNameAndVersion;
                }
                if ((pkg = package_) == null) {
                    objectArray = new Object[]{artifactId, version};
                    JpsBuildFileProviderKt.access$getLogger$p().debug("cannot find corresponding package by provided artifactId and version: ", objectArray);
                    continue;
                }
                libraries.add(new PackageDeclaration(pkg, jpsDependencyNameElement, jpsDependencyNameElement.getTextRange()));
                continue;
            }
            PsiElement[] psiElementArray3 = element.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"getChildren(...)");
            elements.addAll(0, ArraysKt.toList((Object[])psiElementArray3));
        }
        return libraries;
    }

    private final Pair<String, String> parseDependencyName(String str, boolean isJar) {
        Pair pair;
        if (str == null) {
            return null;
        }
        String text = StringsKt.substringAfter$default((String)str, (String)"name=", null, (int)2, null);
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)"Maven:", (boolean)false, (int)2, null)) {
            String artifactId = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)text, (String)"Maven:", null, (int)2, null), (String)":", null, (int)2, null), (String)":", null, (int)2, null);
            String version = StringsKt.substringAfterLast$default((String)text, (String)":", null, (int)2, null);
            pair = new Pair((Object)StringsKt.replace$default((String)artifactId, (String)"\"", (String)"", (boolean)false, (int)4, null), (Object)StringsKt.replace$default((String)version, (String)"\"", (String)"", (boolean)false, (int)4, null));
        } else {
            String dependencyName = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)text, (String)"\"", null, (int)2, null), (String)"\"", null, (int)2, null);
            String artifactId = isJar ? StringsKt.substringBefore$default((String)dependencyName, (String)":", null, (int)2, null) : dependencyName;
            String version = isJar ? StringsKt.substringAfter$default((String)dependencyName, (String)":", null, (int)2, null) : null;
            pair = new Pair((Object)artifactId, (Object)version);
        }
        return pair;
    }

    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module = this.findModuleForFile(file2);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        return this.collectPackages(module2);
    }

    @Override
    public boolean supports(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return Intrinsics.areEqual((Object)file2.getFileType(), (Object)ModuleFileType.INSTANCE);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ((IntellijModuleProjectDependenciesModel)ProjectDependenciesModel.Companion.getEP_NAME().findExtensionOrFail(IntellijModuleProjectDependenciesModel.class, (AreaInstance)this.getProject())).shouldProcess(module);
    }

    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull PsiFile file2, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        Module module = ModuleUtil.findModuleForFile((PsiFile)file2);
        if (module == null) {
            return MapsKt.emptyMap();
        }
        Module module2 = module;
        return this.getRoots(module2);
    }

    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable $this$associateWith$iv = this.collectPackages(module);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Package package_ = (Package)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            map2.put(t, list);
        }
        return result$iv;
    }

    @Override
    public boolean supportsFixes() {
        return false;
    }

    private final Module findModuleForFile(PsiFile file2) {
        return ModuleUtil.findModuleForFile((PsiFile)file2);
    }

    private final List<Package> collectPackages(Module module) {
        List packages = new ArrayList();
        if (module.isDisposed()) {
            return packages;
        }
        ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary(arg_0 -> JpsBuildFileProvider.collectPackages$lambda$6((Function1)new Function1<Library, Boolean>((List<Package>)packages){
            final /* synthetic */ List<Package> $packages;
            {
                this.$packages = $packages;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Library it) {
                Intrinsics.checkNotNull((Object)it);
                Package pkg = JavaPackageUtilKt.createPackage(it);
                if (pkg != null) {
                    this.$packages.add(pkg);
                }
                return true;
            }
        }, arg_0));
        return packages;
    }

    private static final boolean collectPackages$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

