/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.protobuf.lang.annotation.OptionOccurrenceTracker;
import com.intellij.protobuf.lang.psi.PbExtensionName;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbOptionName;
import com.intellij.protobuf.lang.psi.PbOptionOwner;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.ProtoSymbolPath;
import com.intellij.protobuf.lang.psi.ProtoSymbolPathDelegate;
import com.intellij.protobuf.lang.psi.impl.PbQualifiedReferenceBase;
import com.intellij.protobuf.lang.psi.util.PbPsiImplUtil;
import com.intellij.protobuf.lang.resolve.PbSymbolLookupElement;
import com.intellij.protobuf.lang.resolve.PbSymbolResolver;
import com.intellij.protobuf.lang.resolve.ProtoSymbolPathReference;
import com.intellij.protobuf.lang.resolve.ResolveFilters;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PbExtensionNameMixin
extends PbQualifiedReferenceBase
implements PbExtensionName {
    PbExtensionNameMixin(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public ProtoSymbolPathDelegate getDefaultPathDelegate() {
        return new ProtoSymbolPathDelegate(){

            @Override
            public PsiReference getReference(ProtoSymbolPath path) {
                PbOptionOwner optionOwner;
                QualifiedName scope = !PbExtensionNameMixin.this.isFullyQualified() ? ((optionOwner = PbPsiImplUtil.getOptionOwner(path)) != null ? optionOwner.getExtensionOptionScope() : null) : null;
                return new ProtoSymbolPathReference(path, PbSymbolResolver.forFile(PbExtensionNameMixin.this.getPbFile()), scope, ResolveFilters.anySymbol(), ResolveFilters.withUnsuggestableFilter(PbExtensionNameMixin.this.getExtensionFilter()), symbol -> PbSymbolLookupElement.withUnmergeableFieldHighlight(symbol, PbExtensionNameMixin.this.getOccurrence()));
            }
        };
    }

    @Override
    @Nullable
    public PsiReference getEffectiveReference() {
        return this.getSymbolPath().getReference();
    }

    @Nullable
    private Condition<PbSymbol> getExtensionFilter() {
        PbOptionName optionName = (PbOptionName)PsiTreeUtil.getParentOfType((PsiElement)this, PbOptionName.class);
        if (optionName == null) {
            return null;
        }
        PbMessageType qualifierType = optionName.getQualifierType();
        if (qualifierType == null) {
            return null;
        }
        QualifiedName qualifierTypeName = qualifierType.getQualifiedName();
        if (qualifierTypeName == null) {
            return null;
        }
        Condition condition = Conditions.or(ResolveFilters.packageOrMessageWithExtension(), ResolveFilters.extendedFromTypeOrMember(qualifierType));
        condition = Conditions.or((Condition)condition, symbol -> qualifierTypeName.equals((Object)symbol.getQualifiedName()));
        return condition;
    }

    private OptionOccurrenceTracker.Occurrence getOccurrence() {
        PbOptionName name = (PbOptionName)PsiTreeUtil.getParentOfType((PsiElement)this, PbOptionName.class);
        if (name == null) {
            return null;
        }
        PbOptionOwner owner = PbPsiImplUtil.getOptionOwner(name);
        if (owner == null) {
            return null;
        }
        OptionOccurrenceTracker tracker = OptionOccurrenceTracker.forOptionOwner(owner);
        PbOptionName qualifier = name.getQualifier();
        if (qualifier != null) {
            return tracker.getOccurrence(qualifier);
        }
        return tracker.getRootOccurrence();
    }
}

