/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.go;

import com.goide.GoLanguage;
import com.goide.GoTypes;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSpec;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.shared.gencode.ProtoFromSourceComments;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class PbGolangGotoDeclarationHandler
implements GotoDeclarationHandler {
    public PsiElement @Nullable [] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        return Optional.ofNullable(sourceElement).filter(e -> e.getLanguage().is(GoLanguage.INSTANCE)).filter(LeafPsiElement.class::isInstance).map(LeafPsiElement.class::cast).filter(e -> e.getElementType().equals(GoTypes.IDENTIFIER)).map(e -> (GoReferenceExpressionBase)PsiTreeUtil.getParentOfType((PsiElement)e, GoReferenceExpressionBase.class)).map(GoReferenceExpressionBase::getReference).map(PsiReference::resolve).map(PbGolangGotoDeclarationHandler::convertToProtoSymbols).filter(symbols -> !symbols.isEmpty()).map(symbols -> symbols.toArray(new PbSymbol[0])).orElse(null);
    }

    private static Collection<PbSymbol> convertToProtoSymbols(PsiElement element) {
        PbFile pbFile = PbGolangGotoDeclarationHandler.getPbFile(element);
        if (pbFile == null) {
            return ImmutableList.of();
        }
        QualifiedName convertedName = null;
        if (element instanceof GoTypeSpec) {
            convertedName = PbGolangGotoDeclarationHandler.convertTypeSpec((GoTypeSpec)element);
        } else if (element instanceof GoMethodDeclaration) {
            convertedName = PbGolangGotoDeclarationHandler.convertToProtoFieldOrMethodName((GoMethodDeclaration)element);
        } else if (element instanceof GoMethodSpec) {
            convertedName = PbGolangGotoDeclarationHandler.convertToProtoServiceMethodName((GoMethodSpec)element);
        } else if (element instanceof GoFieldDefinition) {
            convertedName = PbGolangGotoDeclarationHandler.convertToProtoFieldName((GoFieldDefinition)element);
        } else if (element instanceof GoConstDefinition) {
            convertedName = PbGolangGotoDeclarationHandler.convertToProtoEnumValueName((GoConstDefinition)element);
        } else if (element instanceof GoFunctionDeclaration) {
            convertedName = PbGolangGotoDeclarationHandler.convertToProtoServiceName((GoFunctionDeclaration)element);
        }
        if (convertedName == null) {
            return ImmutableList.of();
        }
        QualifiedName protoPackage = pbFile.getPackageQualifiedName();
        return pbFile.getLocalQualifiedSymbolMap().get(protoPackage.append(convertedName));
    }

    private static QualifiedName convertTypeSpec(GoTypeSpec type) {
        String methodName;
        List methods = type.getAllMethods();
        if (methods.size() == 1 && (methodName = ((GoNamedSignatureOwner)methods.get(0)).getName()) != null && methodName.startsWith("is")) {
            QualifiedName qualifiedFieldName = PbGolangGotoDeclarationHandler.underscoreToQualifiedName(type.getName());
            if (qualifiedFieldName == null || qualifiedFieldName.getLastComponent() == null) {
                return null;
            }
            String fieldName = qualifiedFieldName.getLastComponent();
            fieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fieldName);
            return qualifiedFieldName.removeLastComponent().append(fieldName);
        }
        return PbGolangGotoDeclarationHandler.convertToProtoMessageOrServiceName(type);
    }

    @Nullable
    private static QualifiedName convertToProtoMessageOrServiceName(GoTypeSpec type) {
        QualifiedName messageOrServiceName = PbGolangGotoDeclarationHandler.underscoreToQualifiedName(type.getName());
        if (messageOrServiceName == null) {
            return null;
        }
        QualifiedName serviceName = PbGolangGotoDeclarationHandler.convertToServiceName(messageOrServiceName);
        return serviceName != null ? serviceName : messageOrServiceName;
    }

    @Nullable
    private static QualifiedName underscoreToQualifiedName(@Nullable String name) {
        return Optional.ofNullable(name).map(n -> n.replace('_', '.')).map(QualifiedName::fromDottedString).orElse(null);
    }

    @Nullable
    private static QualifiedName convertToServiceName(QualifiedName serviceQualifiedName) {
        String serviceName = Optional.of(serviceQualifiedName).filter(qn -> qn.getComponentCount() == 1).map(QualifiedName::getLastComponent).orElse(null);
        if (serviceName == null) {
            return null;
        }
        for (String suffix : ImmutableList.of((Object)"Client", (Object)"Server", (Object)"ClientInterface")) {
            if (!serviceName.endsWith(suffix)) continue;
            serviceName = serviceName.substring(0, serviceName.lastIndexOf(suffix));
            return QualifiedName.fromComponents((String[])new String[]{serviceName});
        }
        return null;
    }

    @Nullable
    private static QualifiedName convertToProtoFieldOrMethodName(GoMethodDeclaration method) {
        QualifiedName messageOrServiceName = Optional.of(method).map(GoMethodDeclaration::getReceiverType).filter(GoPointerType.class::isInstance).map(GoPointerType.class::cast).map(GoPointerType::getType).map(GoType::contextlessResolve).filter(GoTypeSpec.class::isInstance).map(GoTypeSpec.class::cast).map(PbGolangGotoDeclarationHandler::convertToProtoMessageOrServiceName).orElse(null);
        String methodName = method.getName();
        if (messageOrServiceName == null || methodName == null) {
            return null;
        }
        String fieldPrefix = "Get";
        if (methodName.startsWith(fieldPrefix)) {
            String goFieldName = methodName.substring(fieldPrefix.length());
            String pbFieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, goFieldName);
            return messageOrServiceName.append(pbFieldName);
        }
        return messageOrServiceName.append(methodName);
    }

    @Nullable
    private static QualifiedName convertToProtoServiceMethodName(GoMethodSpec method) {
        QualifiedName serviceName = Optional.ofNullable((GoTypeSpec)PsiTreeUtil.getParentOfType((PsiElement)method, GoTypeSpec.class)).map(PbGolangGotoDeclarationHandler::convertToProtoMessageOrServiceName).orElse(null);
        String methodName = method.getName();
        if (methodName == null || serviceName == null) {
            return null;
        }
        return serviceName.append(methodName);
    }

    @Nullable
    private static QualifiedName convertToProtoFieldName(GoFieldDefinition field) {
        QualifiedName messageName = Optional.ofNullable((GoTypeSpec)PsiTreeUtil.getParentOfType((PsiElement)field, GoTypeSpec.class)).map(PbGolangGotoDeclarationHandler::convertToProtoMessageOrServiceName).orElse(null);
        String goFieldName = field.getName();
        if (messageName == null || goFieldName == null) {
            return null;
        }
        String pbFieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, goFieldName);
        return messageName.append(pbFieldName);
    }

    @Nullable
    private static QualifiedName convertToProtoEnumValueName(GoConstDefinition definition) {
        String prefix;
        QualifiedName enumTypeName = Optional.ofNullable((GoConstSpec)PsiTreeUtil.getParentOfType((PsiElement)definition, GoConstSpec.class)).map(GoConstSpec::getType).map(GoType::contextlessResolve).filter(GoTypeSpec.class::isInstance).map(GoTypeSpec.class::cast).map(PbGolangGotoDeclarationHandler::convertToProtoMessageOrServiceName).orElse(null);
        String valueName = definition.getName();
        if (enumTypeName == null || valueName == null) {
            return null;
        }
        if (enumTypeName.getComponentCount() == 1) {
            prefix = enumTypeName.getLastComponent() + "_";
            enumTypeName = enumTypeName.removeLastComponent();
        } else if (enumTypeName.getComponentCount() > 1) {
            enumTypeName = enumTypeName.removeLastComponent();
            prefix = enumTypeName.join("_") + "_";
        } else {
            return null;
        }
        if (valueName.startsWith(prefix)) {
            return enumTypeName.append(valueName.substring(prefix.length()));
        }
        return null;
    }

    @Nullable
    private static QualifiedName convertToProtoServiceName(GoFunctionDeclaration function) {
        String functionName = function.getName();
        if (functionName == null) {
            return null;
        }
        String prefix = "New";
        String suffix = "Client";
        if (functionName.startsWith(prefix) && functionName.endsWith(suffix)) {
            String serviceName = functionName.substring(prefix.length(), functionName.lastIndexOf(suffix));
            return QualifiedName.fromComponents((String[])new String[]{serviceName});
        }
        return null;
    }

    @Nullable
    private static PbFile getPbFile(PsiElement element) {
        return Optional.of(element).map(PsiElement::getContainingFile).filter(GoFile.class::isInstance).map(GoFile.class::cast).map(PbGolangGotoDeclarationHandler::getPbFile).orElse(null);
    }

    @Nullable
    private static PbFile getPbFile(GoFile goFile) {
        VirtualFile resolvedFile = goFile.getVirtualFile();
        if (resolvedFile == null || !resolvedFile.getName().endsWith(".pb.go")) {
            return null;
        }
        PsiFile resolvedPsiFile = goFile.getManager().findFile(resolvedFile);
        if (resolvedPsiFile == null) {
            return null;
        }
        return ProtoFromSourceComments.findProtoOfGeneratedCode("//", resolvedPsiFile);
    }
}

