/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VFileCreateEvent
extends VFileEvent {
    private final VirtualFile myParent;
    private final boolean myDirectory;
    private final FileAttributes myAttributes;
    private final String mySymlinkTarget;
    private final ChildInfo[] myChildren;
    private final int myChildNameId;
    private VirtualFile myCreatedFile;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public VFileCreateEvent(Object requestor, @NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, @Nullable FileAttributes attributes, @Nullable String symlinkTarget, boolean isFromRefresh, ChildInfo @Nullable [] children2) {
        if (parent == null) {
            VFileCreateEvent.$$$reportNull$$$0(0);
        }
        if (childName == null) {
            VFileCreateEvent.$$$reportNull$$$0(1);
        }
        super(requestor);
        this.myParent = parent;
        this.myDirectory = isDirectory;
        this.myAttributes = attributes;
        this.mySymlinkTarget = symlinkTarget;
        this.myChildren = children2;
        this.myChildNameId = VirtualFileManager.getInstance().storeName(childName);
    }

    @ApiStatus.Internal
    public VFileCreateEvent(Object requestor, @NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, @Nullable(value="null means should read from the created file") @Nullable(value="null means should read from the created file") FileAttributes attributes, @Nullable String symlinkTarget, ChildInfo @Nullable(value="null means children not available (e.g. the created file is not a directory) or unknown") [] children2) {
        if (parent == null) {
            VFileCreateEvent.$$$reportNull$$$0(2);
        }
        if (childName == null) {
            VFileCreateEvent.$$$reportNull$$$0(3);
        }
        super(requestor);
        this.myParent = parent;
        this.myDirectory = isDirectory;
        this.myAttributes = attributes;
        this.mySymlinkTarget = symlinkTarget;
        this.myChildren = children2;
        this.myChildNameId = VirtualFileManager.getInstance().storeName(childName);
    }

    @NotNull
    public String getChildName() {
        String string2 = VirtualFileManager.getInstance().getVFileName(this.myChildNameId).toString();
        if (string2 == null) {
            VFileCreateEvent.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    @NotNull
    public VirtualFile getParent() {
        VirtualFile virtualFile = this.myParent;
        if (virtualFile == null) {
            VFileCreateEvent.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @Nullable
    public FileAttributes getAttributes() {
        return this.myAttributes;
    }

    @Nullable
    public String getSymlinkTarget() {
        return this.mySymlinkTarget;
    }

    public boolean isEmptyDirectory() {
        return this.isDirectory() && this.myChildren != null && this.myChildren.length == 0;
    }

    @Override
    @NotNull
    protected String computePath() {
        String parentPath = this.myParent.getPath();
        String string2 = StringUtil.endsWithChar(parentPath, '/') ? parentPath + this.getChildName() : parentPath + "/" + this.getChildName();
        if (string2 == null) {
            VFileCreateEvent.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    public VirtualFile getFile() {
        VirtualFile createdFile = this.myCreatedFile;
        if (createdFile == null && this.myParent.isValid()) {
            this.myCreatedFile = createdFile = this.myParent.findChild(this.getChildName());
        }
        return createdFile;
    }

    public ChildInfo @Nullable(value="null means children not available (e.g. the created file is not a directory) or unknown") [] getChildren() {
        return this.myChildren;
    }

    public void resetCache() {
        this.myCreatedFile = null;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myParent.getFileSystem();
        if (virtualFileSystem == null) {
            VFileCreateEvent.$$$reportNull$$$0(7);
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myParent.isValid() && this.myParent.findChild(this.getChildName()) == null;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o2;
        return this.myDirectory == event.myDirectory && this.getChildName().equals(event.getChildName()) && this.myParent.equals(event.myParent);
    }

    @Override
    public int hashCode() {
        int result2 = this.myParent.hashCode();
        result2 = 31 * result2 + (this.myDirectory ? 1 : 0);
        result2 = 31 * result2 + this.getChildName().hashCode();
        return result2;
    }

    public String toString() {
        String kind = this.myDirectory ? (this.isEmptyDirectory() ? "(empty) " : "") + "dir " : "file ";
        return "VfsEvent[create " + kind + "'" + this.myParent.getUrl() + "/" + this.getChildName() + "']" + (this.myChildren == null ? "" : " with " + this.myChildren.length + " children");
    }

    public int getChildNameId() {
        return this.myChildNameId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

