/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;

public final class TrigramBuilder {
    private TrigramBuilder() {
    }

    public static boolean processTrigrams(@NotNull CharSequence text, @NotNull TrigramProcessor consumer2) {
        IntSet trigrams;
        if (text == null) {
            TrigramBuilder.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            TrigramBuilder.$$$reportNull$$$0(1);
        }
        if (!consumer2.consumeTrigramsCount((trigrams = TrigramBuilder.getTrigrams(text)).size())) {
            return false;
        }
        IntIterator iterator2 = trigrams.iterator();
        while (iterator2.hasNext()) {
            int trigram = iterator2.nextInt();
            if (consumer2.test(trigram)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Map<Integer, Void> getTrigramsAsMap(final @NotNull CharSequence text) {
        if (text == null) {
            TrigramBuilder.$$$reportNull$$$0(2);
        }
        return new AbstractInt2ObjectMap<Void>(){
            final IntSet trigrams;
            {
                this.trigrams = TrigramBuilder.getTrigrams(text);
            }

            @Override
            public int size() {
                return this.trigrams.size();
            }

            @Override
            public boolean containsKey(int k2) {
                return this.trigrams.contains(k2);
            }

            @Override
            public boolean containsValue(Object v2) {
                return v2 == null && !this.isEmpty();
            }

            @Override
            public void forEach(BiConsumer<? super Integer, ? super Void> consumer2) {
                this.trigrams.forEach(integer -> consumer2.accept(integer, null));
            }

            @Override
            public ObjectSet<Int2ObjectMap.Entry<Void>> int2ObjectEntrySet() {
                return new AbstractObjectSet<Int2ObjectMap.Entry<Void>>(){

                    @Override
                    public ObjectIterator<Int2ObjectMap.Entry<Void>> iterator() {
                        final IntIterator iterator2 = trigrams.iterator();
                        return new AbstractObjectIterator<Int2ObjectMap.Entry<Void>>(){

                            @Override
                            public boolean hasNext() {
                                return iterator2.hasNext();
                            }

                            @Override
                            public Int2ObjectMap.Entry<Void> next() {
                                final int key = iterator2.nextInt();
                                return new Int2ObjectMap.Entry<Void>(){

                                    @Override
                                    public int getIntKey() {
                                        return key;
                                    }

                                    @Override
                                    public Void getValue() {
                                        return null;
                                    }

                                    @Override
                                    public Void setValue(Void value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return trigrams.size();
                    }
                };
            }

            @Override
            public Void get(int key) {
                return null;
            }
        };
    }

    @NotNull
    public static IntSet getTrigrams(@NotNull CharSequence text) {
        if (text == null) {
            TrigramBuilder.$$$reportNull$$$0(3);
        }
        AddonlyIntSet set = new AddonlyIntSet();
        int index = 0;
        char[] fileTextArray = CharArrayUtil.fromSequenceWithoutCopying(text);
        while (index != text.length()) {
            char c2;
            char c3 = c2 = fileTextArray != null ? fileTextArray[index] : text.charAt(index);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || Character.isJavaIdentifierPart(c2))) {
                ++index;
                continue;
            }
            int identifierStart = index;
            while (++index != text.length()) {
                char c4;
                char c5 = c4 = fileTextArray != null ? fileTextArray[index] : text.charAt(index);
                if (c4 >= 'a' && c4 <= 'z' || c4 >= 'A' && c4 <= 'Z' || c4 >= '0' && c4 <= '9' || Character.isJavaIdentifierPart(c4)) continue;
                break;
            }
            int tc1 = 0;
            int tc2 = 0;
            int i2 = identifierStart;
            int iters = 0;
            while (i2 < index) {
                char c6 = StringUtil.toLowerCase(fileTextArray != null ? fileTextArray[i2] : text.charAt(i2));
                int tc3 = (tc2 << 8) + c6;
                tc2 = (tc1 << 8) + c6;
                tc1 = c6;
                if (iters >= 2) {
                    set.add(tc3);
                }
                ++i2;
                ++iters;
            }
        }
        AddonlyIntSet addonlyIntSet = set;
        if (addonlyIntSet == null) {
            TrigramBuilder.$$$reportNull$$$0(4);
        }
        return addonlyIntSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/TrigramBuilder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/TrigramBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrigrams";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processTrigrams";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTrigramsAsMap";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTrigrams";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class TrigramProcessor
    implements IntPredicate {
        public boolean consumeTrigramsCount(int count2) {
            return true;
        }
    }

    private static final class AddonlyIntSet
    extends AbstractIntSet {
        private int size;
        private int[] data;
        private int mask;
        private boolean hasZeroKey;

        AddonlyIntSet() {
            this(21);
        }

        @Override
        public IntIterator iterator() {
            return new AbstractIntIterator(){
                private int pos = -1;

                @Override
                public int nextInt() {
                    if (this.pos == -1 && hasZeroKey) {
                        this.pos = 0;
                        return 0;
                    }
                    for (int i2 = Math.max(0, this.pos); i2 < data.length; ++i2) {
                        if (data[i2] == 0) continue;
                        this.pos = i2 + 1;
                        return data[i2];
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasNext() {
                    if (this.pos == -1 && hasZeroKey) {
                        return true;
                    }
                    for (int i2 = Math.max(0, this.pos); i2 < data.length; ++i2) {
                        if (data[i2] == 0) continue;
                        this.pos = i2;
                        return true;
                    }
                    return false;
                }
            };
        }

        AddonlyIntSet(int expectedSize) {
            int powerOfTwo = Integer.highestOneBit(3 * expectedSize / 2) << 1;
            this.mask = powerOfTwo - 1;
            this.data = new int[powerOfTwo];
        }

        @Override
        public int size() {
            return this.size;
        }

        private int hash(int h2) {
            h2 ^= h2 >>> 20 ^ h2 >>> 12;
            return (h2 ^ h2 >>> 7 ^ h2 >>> 4) & this.mask;
        }

        @Override
        public boolean add(int key) {
            boolean updated;
            if (key == 0) {
                if (!this.hasZeroKey) {
                    this.hasZeroKey = true;
                    ++this.size;
                    return true;
                }
                return false;
            }
            if (this.size >= 2 * this.data.length / 3) {
                this.rehash();
            }
            if (updated = this.doPut(this.data, key)) {
                ++this.size;
            }
            return updated;
        }

        private boolean doPut(int[] a2, int o2) {
            int obj;
            int index = this.hash(o2);
            while ((obj = a2[index]) != 0 && obj != o2) {
                if (index == 0) {
                    index = a2.length;
                }
                --index;
            }
            a2[index] = o2;
            return obj == 0;
        }

        private void rehash() {
            int[] b2 = new int[this.data.length << 1];
            this.mask = b2.length - 1;
            int i2 = this.data.length;
            while (--i2 >= 0) {
                int ns = this.data[i2];
                if (ns == 0) continue;
                this.doPut(b2, ns);
            }
            this.data = b2;
        }

        @Override
        public boolean contains(int key) {
            int v2;
            if (key == 0) {
                return this.hasZeroKey;
            }
            int index = this.hash(key);
            while ((v2 = this.data[index]) != 0) {
                if (v2 == key) {
                    return true;
                }
                if (index == 0) {
                    index = this.data.length;
                }
                --index;
            }
            return false;
        }

        public boolean forEach(@NotNull IntPredicate consumer2) {
            if (consumer2 == null) {
                AddonlyIntSet.$$$reportNull$$$0(0);
            }
            if (this.hasZeroKey && !consumer2.test(0)) {
                return false;
            }
            for (int o2 : this.data) {
                if (o2 == 0 || consumer2.test(o2)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/util/text/TrigramBuilder$AddonlyIntSet", "forEach"));
        }
    }
}

