/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.EarlyAccessRegistryManager;
import com.intellij.openapi.util.registry.EarlyAccessRegistryManagerKt;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u001a;\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0016H\u0082\b\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\" \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\"\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "configFile", "Ljava/nio/file/Path;", "getConfigFile", "()Ljava/nio/file/Path;", "configFile$delegate", "Lkotlin/Lazy;", "lazyMap", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Ljava/util/concurrent/ConcurrentHashMap;", "", "map", "getMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "getOrFromSystemProperty", "key", "saveConfigFile", "", "provider", "Lkotlin/Function1;", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nEarlyAccessRegistryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManagerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,188:1\n11#2:189\n*S KotlinDebug\n*F\n+ 1 EarlyAccessRegistryManager.kt\ncom/intellij/openapi/util/registry/EarlyAccessRegistryManagerKt\n*L\n24#1:189\n*E\n"})
public final class EarlyAccessRegistryManagerKt {
    @NotNull
    private static final Lazy configFile$delegate = LazyKt.lazy(configFile.2.INSTANCE);
    @NotNull
    private static final SynchronizedClearableLazy<ConcurrentHashMap<String, String>> lazyMap = new SynchronizedClearableLazy(lazyMap.1.INSTANCE);

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EarlyAccessRegistryManager.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        return logger;
    }

    private static final Path getConfigFile() {
        Lazy lazy = configFile$delegate;
        Object t2 = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t2, "getValue(...)");
        return (Path)t2;
    }

    private static final ConcurrentHashMap<String, String> getMap() {
        if (lazyMap.isInitialized()) {
            ConcurrentHashMap<String, String> map2 = lazyMap.getValue();
            return map2.isEmpty() ? null : map2;
        }
        return null;
    }

    private static final String getOrFromSystemProperty(ConcurrentHashMap<String, String> map2, String key) {
        String string2 = map2.get(key);
        if (string2 == null) {
            string2 = System.getProperty(key);
        }
        return string2;
    }

    private static final void saveConfigFile(ConcurrentHashMap<String, String> map2, Path configFile2, Function1<? super String, String> provider) {
        boolean $i$f$saveConfigFile = false;
        if (Intrinsics.areEqual(System.getProperty("early.access.registry.disable.saving"), "true")) {
            return;
        }
        List lines = new ArrayList();
        Set set = map2.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        for (String key : CollectionsKt.sorted(set)) {
            String value;
            Intrinsics.checkNotNull(key);
            if (provider.invoke(key) == null) continue;
            lines.add(key);
            lines.add(value);
        }
        if (lines.isEmpty()) {
            Files.deleteIfExists(configFile2);
        } else {
            Files.createDirectories(configFile2.getParent(), new FileAttribute[0]);
            Files.write(configFile2, (Iterable<? extends CharSequence>)lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return EarlyAccessRegistryManagerKt.getLOG();
    }

    public static final /* synthetic */ SynchronizedClearableLazy access$getLazyMap$p() {
        return lazyMap;
    }

    public static final /* synthetic */ String access$getOrFromSystemProperty(ConcurrentHashMap map2, String key) {
        return EarlyAccessRegistryManagerKt.getOrFromSystemProperty(map2, key);
    }

    public static final /* synthetic */ Path access$getConfigFile() {
        return EarlyAccessRegistryManagerKt.getConfigFile();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getMap() {
        return EarlyAccessRegistryManagerKt.getMap();
    }
}

