/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointListener;
import org.jetbrains.debugger.BreakpointManagerBase;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipBreakpointManagerKt;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.debugger.BreakpointResolvedEventData;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.Instrumentation;
import org.jetbrains.wip.protocol.debugger.LocationValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J.\u0010\u0011\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0013\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0002H\u0002J\u0006\u0010\u0018\u001a\u00020\u000eJ:\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0007H\u0014J\u0014\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J(\u0010$\u001a\b\u0012\u0004\u0012\u00020%0#2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J\u0014\u0010(\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0014\u0010)\u001a\u00020\u00072\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+H\u0016J\b\u0010,\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006-"}, d2={"Lorg/jetbrains/wip/WipBreakpointManager;", "Lorg/jetbrains/debugger/BreakpointManagerBase;", "Lorg/jetbrains/wip/WipBreakpoint;", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "breakpointsActive", "", "regExpBreakpointSupported", "getRegExpBreakpointSupported", "()Z", "getVm", "()Lorg/jetbrains/wip/WipVm;", "breakpointReportedResolved", "", "eventData", "Lorg/jetbrains/wip/protocol/debugger/BreakpointResolvedEventData;", "breakpointResolvedHandler", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/Pair;", "", "", "Lorg/jetbrains/wip/protocol/debugger/LocationValue;", "breakpoint", "clearNonProvisionalBreakpoints", "createBreakpoint", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "ignoreCount", "enabled", "doClearBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "doSetBreakpoint", "Lorg/jetbrains/debugger/Breakpoint;", "url", "Lcom/intellij/util/Url;", "enableBreakpoints", "isBreakOnFirstStatement", "context", "Lorg/jetbrains/debugger/SuspendContext;", "setBreakOnFirstStatement", "intellij.javascript.wip.backend"})
@SourceDebugExtension(value={"SMAP\nWipBreakpointManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipBreakpointManager.kt\norg/jetbrains/wip/WipBreakpointManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public class WipBreakpointManager
extends BreakpointManagerBase<WipBreakpoint> {
    @NotNull
    private final WipVm vm;
    private boolean breakpointsActive;
    private final boolean regExpBreakpointSupported;

    public WipBreakpointManager(@NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.breakpointsActive = true;
        this.regExpBreakpointSupported = true;
    }

    @NotNull
    public final WipVm getVm() {
        return this.vm;
    }

    public boolean getRegExpBreakpointSupported() {
        return this.regExpBreakpointSupported;
    }

    @NotNull
    protected WipBreakpoint createBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new WipBreakpoint(target, line, column, condition, enabled);
    }

    @NotNull
    protected Promise<Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget target, @Nullable Url url, @NotNull WipBreakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)breakpoint), (String)"breakpoint");
        Function1<Pair<String, List<? extends LocationValue>>, WipBreakpoint> breakpointResolvedHandler2 = this.breakpointResolvedHandler(breakpoint);
        Promise promise2 = WipBreakpointManagerKt.sendSetBreakpointRequest(target, breakpoint.getLine(), breakpoint.getColumn(), breakpoint.getCondition(), this.vm.getCommandProcessor()).then(arg_0 -> WipBreakpointManager.doSetBreakpoint$lambda$0(breakpointResolvedHandler2, arg_0)).then(arg_0 -> WipBreakpointManager.doSetBreakpoint$lambda$1((Function1)new Function1<WipBreakpoint, Breakpoint>(breakpoint){
            final /* synthetic */ WipBreakpoint $breakpoint;
            {
                this.$breakpoint = $breakpoint;
                super(1);
            }

            public final Breakpoint invoke(WipBreakpoint it) {
                return (Breakpoint)this.$breakpoint;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @NotNull
    protected Promise<?> doClearBreakpoint(@NotNull WipBreakpoint breakpoint) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)((Object)breakpoint), (String)"breakpoint");
                string = breakpoint.getVmIdImmediately();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                Promise promise2 = this.vm.getCommandProcessor().send((Request)DebuggerKt.RemoveBreakpoint(it));
                string = promise2;
                if (promise2 != null) break block3;
            }
            string = Promises.resolvedPromise((Object)Unit.INSTANCE);
        }
        return string;
    }

    public final void clearNonProvisionalBreakpoints() {
        SmartList deleteList = new SmartList();
        for (WipBreakpoint breakpoint : this.getBreakpoints()) {
            if (breakpoint.getTarget() instanceof BreakpointTarget.ScriptId) {
                deleteList.add((Object)breakpoint);
                continue;
            }
            breakpoint.clearActualLocations();
        }
        for (WipBreakpoint breakpoint : deleteList) {
            try {
                this.getBreakpoints().remove((Object)breakpoint);
                this.getBreakpointDuplicationByTarget().remove((Object)breakpoint);
                BreakpointListener breakpointListener = (BreakpointListener)this.getDispatcher().getMulticaster();
                Intrinsics.checkNotNull((Object)((Object)breakpoint));
                breakpointListener.nonProvisionalBreakpointRemoved((Breakpoint)breakpoint);
            }
            catch (Throwable e) {
                CommandProcessorKt.getLOG().error(e);
            }
        }
    }

    public final void breakpointReportedResolved(@NotNull BreakpointResolvedEventData eventData) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)eventData, (String)"eventData");
            String vmId = eventData.breakpointId();
            Iterable iterable = this.getBreakpoints();
            for (Object t : iterable) {
                WipBreakpoint it = (WipBreakpoint)((Object)t);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)vmId, (Object)it.getVmIdImmediately())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        WipBreakpoint wipBreakpoint = v0;
        if (wipBreakpoint == null) {
            return;
        }
        WipBreakpoint breakpoint = wipBreakpoint;
        breakpoint.addResolvedLocation(eventData.location());
        this.notifyBreakpointResolvedListener(breakpoint);
    }

    @NotNull
    public Promise<?> enableBreakpoints(boolean enabled) {
        this.breakpointsActive = enabled;
        return this.vm.getCommandProcessor().send((Request)DebuggerKt.SetBreakpointsActive(enabled));
    }

    public void setBreakOnFirstStatement() {
        this.vm.getCommandProcessor().send((Request)DebuggerKt.SetInstrumentationBreakpoint(Instrumentation.BEFORE_SCRIPT_WITH_SOURCE_MAP_EXECUTION));
    }

    public boolean isBreakOnFirstStatement(@NotNull SuspendContext<?> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        return context instanceof WipSuspendContext && ((WipSuspendContext)context).isBreakOnFirstStatement();
    }

    private final Function1<Pair<String, List<? extends LocationValue>>, WipBreakpoint> breakpointResolvedHandler(WipBreakpoint breakpoint) {
        return (Function1)new Function1<Pair<String, List<? extends LocationValue>>, WipBreakpoint>(breakpoint, this){
            final /* synthetic */ WipBreakpoint $breakpoint;
            final /* synthetic */ WipBreakpointManager this$0;
            {
                this.$breakpoint = $breakpoint;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final WipBreakpoint invoke(@NotNull Pair<String, List<LocationValue>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Object object = it.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                this.$breakpoint.updateVmRegistered$intellij_javascript_wip_backend((String)object);
                this.$breakpoint.addResolvedLocations((List)it.second);
                WipBreakpointManager.access$notifyBreakpointResolvedListener(this.this$0, this.$breakpoint);
                return this.$breakpoint;
            }
        };
    }

    private static final WipBreakpoint doSetBreakpoint$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (WipBreakpoint)((Object)$tmp0.invoke(p0));
    }

    private static final Breakpoint doSetBreakpoint$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Breakpoint)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$notifyBreakpointResolvedListener(WipBreakpointManager $this, WipBreakpoint breakpoint) {
        $this.notifyBreakpointResolvedListener(breakpoint);
    }
}

