/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8.value;

import com.intellij.util.Function;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.protocol.GetObjectsResult;
import org.jetbrains.v8.protocol.Handle;
import org.jetbrains.v8.protocol.LookupMessage;
import org.jetbrains.v8.protocol.ObjectDescriptor;
import org.jetbrains.v8.protocol.PropertyDescriptor;
import org.jetbrains.v8.protocol.Protocol_exKt;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.protocol.SomeRef;
import org.jetbrains.v8.protocol.ValueHandle;
import org.jetbrains.v8.value.ArrayReference;
import org.jetbrains.v8.value.DataWithRef;
import org.jetbrains.v8.value.FunctionReference;
import org.jetbrains.v8.value.LoadableString;
import org.jetbrains.v8.value.ObjectReference;
import org.jetbrains.v8.value.PropertyItem;
import org.jetbrains.v8.value.V8Function;
import org.jetbrains.v8.value.V8Object;
import org.jetbrains.v8.value.V8PrimitiveValue;
import org.jetbrains.v8.value.V8ValueManagerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001f0\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J\u0010\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001f0\u001b2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\u00020\u000e2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010!R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006)"}, d2={"Lorg/jetbrains/v8/value/V8ValueManager;", "Lorg/jetbrains/debugger/values/ValueManager;", "vm", "Lorg/jetbrains/v8/V8Vm;", "(Lorg/jetbrains/v8/V8Vm;)V", "refToValue", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lorg/jetbrains/debugger/values/Value;", "getVm", "()Lorg/jetbrains/v8/V8Vm;", "addHandleFromRefs", "handle", "Lorg/jetbrains/v8/protocol/Handle;", "clearCaches", "", "createValue", "objectDescriptor", "Lorg/jetbrains/v8/protocol/ObjectDescriptor;", "propertyDescriptor", "Lorg/jetbrains/v8/protocol/PropertyDescriptor;", "valueHandle", "Lorg/jetbrains/v8/protocol/ValueHandle;", "createValueIfSure", "refWithDisplayData", "Lorg/jetbrains/v8/protocol/SomeRef;", "doCreateValue", "getOrLoadValue", "Lorg/jetbrains/concurrency/Promise;", "id", "", "getOrLoadValueFromRefs", "", "propertyRefs", "", "Lorg/jetbrains/v8/value/PropertyItem;", "getValue", "loadValuesFromRemote", "propertyRefIds", "", "store", "objects", "intellij.javascript.v8.backend"})
@SourceDebugExtension(value={"SMAP\nV8ValueManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 V8ValueManager.kt\norg/jetbrains/v8/value/V8ValueManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,325:1\n1#2:326\n102#3,5:327\n*S KotlinDebug\n*F\n+ 1 V8ValueManager.kt\norg/jetbrains/v8/value/V8ValueManager\n*L\n150#1:327,5\n*E\n"})
public final class V8ValueManager
extends ValueManager {
    @NotNull
    private final V8Vm vm;
    @NotNull
    private final Int2ObjectOpenHashMap<Value> refToValue;

    public V8ValueManager(@NotNull V8Vm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.refToValue = new Int2ObjectOpenHashMap();
    }

    @NotNull
    public final V8Vm getVm() {
        return this.vm;
    }

    private final Value createValueIfSure(SomeRef refWithDisplayData) {
        String value;
        ValueType type;
        String className = refWithDisplayData.getClassName();
        String typeString = refWithDisplayData.getType();
        if (typeString == null && className == null) {
            v0 = null;
        } else {
            String string = typeString;
            Intrinsics.checkNotNull((Object)string);
            v0 = type = V8ValueManagerKt.access$calculateType(string, className, false);
        }
        if (type == ValueType.STRING) {
            String string = refWithDisplayData.getValue();
            Intrinsics.checkNotNull((Object)string);
            String possiblyTruncatedValue = string;
            if (possiblyTruncatedValue.length() > 100) {
                String pattern = "... (length: ";
                if (StringsKt.regionMatches$default((String)possiblyTruncatedValue, (int)100, (String)pattern, (int)0, (int)pattern.length(), (boolean)false, (int)16, null)) {
                    int beginIndex = 100 + pattern.length();
                    String string2 = possiblyTruncatedValue.substring(beginIndex, StringsKt.indexOf$default((CharSequence)possiblyTruncatedValue, (char)')', (int)beginIndex, (boolean)false, (int)4, null));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    int actualLength = Integer.parseInt(string2);
                    return (Value)new LoadableString(this, refWithDisplayData.getRef(), possiblyTruncatedValue, actualLength);
                }
                return null;
            }
        } else if (!V8ValueManagerKt.access$getTYPES_WITH_ACCURATE_DISPLAY$p().contains(type)) {
            return null;
        }
        if ((value = refWithDisplayData.getValue()) == null) {
            value = typeString;
        }
        int n = refWithDisplayData.getRef();
        ValueType valueType = type;
        Intrinsics.checkNotNull((Object)valueType);
        String string = value;
        Intrinsics.checkNotNull((Object)string);
        return (Value)new V8PrimitiveValue(n, valueType, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        super.clearCaches();
        Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
        synchronized (int2ObjectOpenHashMap) {
            boolean bl = false;
            this.refToValue.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final Value addHandleFromRefs(@NotNull Handle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        String type = handle.type();
        if (!Intrinsics.areEqual((Object)"script", (Object)type) && !Intrinsics.areEqual((Object)"context", (Object)type)) {
            return this.createValue(handle instanceof ValueHandle ? (ValueHandle)handle : ((SomeHandle)handle).asValueHandle());
        }
        return null;
    }

    private final Value doCreateValue(ValueHandle valueHandle) {
        String string = valueHandle.type();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type(...)");
        ValueType type = V8ValueManagerKt.access$calculateType(string, valueHandle.className(), true);
        if (V8ValueManagerKt.access$getTYPES_WITH_ACCURATE_DISPLAY$p().contains(type)) {
            String string2 = valueHandle.value() == null ? valueHandle.type() : valueHandle.value();
            Intrinsics.checkNotNull((Object)string2);
            return (Value)new PrimitiveValue(type, string2);
        }
        if (type == ValueType.STRING) {
            int length = valueHandle.length();
            int toIndex = valueHandle.toIndex();
            if (length != -1 && toIndex != -1 && length != toIndex) {
                return (Value)new LoadableString(this, valueHandle.handle(), valueHandle.value(), length);
            }
            int n = valueHandle.handle();
            String string3 = valueHandle.value();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"value(...)");
            return (Value)new V8PrimitiveValue(n, type, string3);
        }
        return type == ValueType.FUNCTION ? (Value)new V8Function(valueHandle, this) : (Value)new V8Object(type, valueHandle, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Value createValue(@NotNull ValueHandle valueHandle) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)valueHandle, (String)"valueHandle");
        Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
        synchronized (int2ObjectOpenHashMap) {
            boolean bl = false;
            Value mirror = (Value)this.refToValue.get(valueHandle.handle());
            if (mirror == null) {
                mirror = this.doCreateValue(valueHandle);
                this.refToValue.put(valueHandle.handle(), (Object)mirror);
            }
            Value value2 = mirror;
            Intrinsics.checkNotNull((Object)value2);
            value = value2;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Value createValue(@NotNull PropertyDescriptor propertyDescriptor) {
        Intrinsics.checkNotNullParameter((Object)propertyDescriptor, (String)"propertyDescriptor");
        if (propertyDescriptor.getObjectId() != -1) {
            Value value;
            Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
            synchronized (int2ObjectOpenHashMap) {
                boolean bl = false;
                value = (Value)this.refToValue.get(propertyDescriptor.getObjectId());
            }
            return value;
        }
        ValueType valueType = ValueType.Companion.fromIndex(propertyDescriptor.getType());
        switch (WhenMappings.$EnumSwitchMapping$0[valueType.ordinal()]) {
            case 1: {
                return (Value)PrimitiveValue.NULL;
            }
            case 2: {
                return (Value)PrimitiveValue.UNDEFINED;
            }
            case 3: {
                String string = propertyDescriptor.getValue();
                Intrinsics.checkNotNull((Object)string);
                return (Value)PrimitiveValue.Companion.bool(string);
            }
            case 4: 
            case 5: {
                String string = propertyDescriptor.getValue();
                Intrinsics.checkNotNull((Object)string);
                return (Value)new PrimitiveValue(valueType, string);
            }
        }
        throw new IllegalArgumentException(valueType.name());
    }

    private final Value createValue(ObjectDescriptor objectDescriptor) {
        ValueType valueType = ValueType.Companion.fromIndex(objectDescriptor.getType());
        switch (WhenMappings.$EnumSwitchMapping$0[valueType.ordinal()]) {
            case 5: {
                int length = objectDescriptor.getLength();
                String string = objectDescriptor.getDescription();
                Intrinsics.checkNotNull((Object)string);
                String value = string;
                if (length != -1 && length > value.length()) {
                    return (Value)new LoadableString(this, objectDescriptor.getId(), value, length);
                }
                return (Value)new V8PrimitiveValue(objectDescriptor.getId(), valueType, value);
            }
            case 6: {
                return (Value)new ObjectReference(valueType, objectDescriptor, this);
            }
            case 7: {
                return (Value)new FunctionReference(objectDescriptor, this);
            }
            case 8: {
                return (Value)new ArrayReference(objectDescriptor, this);
            }
        }
        throw new IllegalArgumentException(valueType.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Value getValue(int id) {
        Value value;
        Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
        synchronized (int2ObjectOpenHashMap) {
            boolean bl = false;
            value = (Value)this.refToValue.get(id);
        }
        return value;
    }

    @NotNull
    public final Promise<Value> getOrLoadValue(int id) {
        Value value = this.getValue(id);
        if (value == null) {
            Promise $this$then$iv = this.vm.getCommandProcessor().send((Request)Protocol_exKt.GetObjects$default(id, 0, false, 6, null));
            boolean $i$f$then = false;
            Promise promise2 = $this$then$iv.then((Function)new ObsolescentFunction<GetObjectsResult, Value>((Obsolescent)this, this, id){
                final /* synthetic */ Obsolescent $obsolescent;
                final /* synthetic */ V8ValueManager this$0;
                final /* synthetic */ int $id$inlined;
                {
                    this.$obsolescent = $obsolescent;
                    this.this$0 = v8ValueManager;
                    this.$id$inlined = n;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public Object fun(Object param) {
                    GetObjectsResult it = (GetObjectsResult)param;
                    boolean bl = false;
                    this.this$0.store(it.objects());
                    return this.this$0.getValue(this.$id$inlined);
                }

                public boolean isObsolete() {
                    return this.$obsolescent.isObsolete();
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
            return promise2;
        }
        return Promises.resolvedPromise((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Promise<Value[]> getOrLoadValueFromRefs(@NotNull List<? extends PropertyItem> propertyRefs) {
        Intrinsics.checkNotNullParameter(propertyRefs, (String)"propertyRefs");
        Value[] result = new Value[propertyRefs.size()];
        if (propertyRefs.isEmpty()) {
            return Promises.resolvedPromise((Object)result);
        }
        Int2IntOpenHashMap refToRequestIndex = new Int2IntOpenHashMap();
        refToRequestIndex.defaultReturnValue(-1);
        IntArrayList needsLoading = null;
        int n = propertyRefs.size();
        for (int i = 0; i < n; ++i) {
            SomeRef dataWithDisplayData;
            Value value;
            PropertyItem property = propertyRefs.get(i);
            DataWithRef dataWithRef = property.getValueObject();
            int ref = dataWithRef.ref();
            Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
            synchronized (int2ObjectOpenHashMap) {
                boolean bl = false;
                value = (Value)this.refToValue.get(ref);
            }
            Value mirror = value;
            if (mirror == null && (dataWithDisplayData = dataWithRef.getWithDisplayData()) != null) {
                mirror = this.createValueIfSure(dataWithDisplayData);
            }
            if (mirror == null) {
                int requestPos = refToRequestIndex.get(ref);
                if (requestPos != -1) continue;
                if (needsLoading == null) {
                    needsLoading = new IntArrayList();
                }
                refToRequestIndex.put(ref, needsLoading.size());
                needsLoading.add(property.getRef());
                continue;
            }
            result[i] = mirror;
        }
        if (needsLoading == null) {
            return Promises.resolvedPromise((Object)result);
        }
        int[] nArray = needsLoading.toIntArray();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"toIntArray(...)");
        Promise promise2 = this.loadValuesFromRemote(nArray).then(arg_0 -> V8ValueManager.getOrLoadValueFromRefs$lambda$6((Function1)new Function1<Value[], Value[]>(propertyRefs, result, refToRequestIndex){
            final /* synthetic */ List<PropertyItem> $propertyRefs;
            final /* synthetic */ Value[] $result;
            final /* synthetic */ Int2IntOpenHashMap $refToRequestIndex;
            {
                this.$propertyRefs = $propertyRefs;
                this.$result = $result;
                this.$refToRequestIndex = $refToRequestIndex;
                super(1);
            }

            public final Value[] invoke(Value[] it) {
                int n = this.$propertyRefs.size();
                for (int i = 0; i < n; ++i) {
                    if (this.$result[i] != null) continue;
                    this.$result[i] = it[this.$refToRequestIndex.get(this.$propertyRefs.get(i).getValueObject().ref())];
                }
                return this.$result;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    private final Promise<Value[]> loadValuesFromRemote(int[] propertyRefIds) {
        Promise promise2 = this.vm.getCommandProcessor().send((Request)new LookupMessage(propertyRefIds, false, 0, 4, null)).then(arg_0 -> V8ValueManager.loadValuesFromRemote$lambda$7((Function1)new Function1<Int2ObjectMap<ValueHandle>, Value[]>(propertyRefIds, this){
            final /* synthetic */ int[] $propertyRefIds;
            final /* synthetic */ V8ValueManager this$0;
            {
                this.$propertyRefIds = $propertyRefIds;
                this.this$0 = $receiver;
                super(1);
            }

            public final Value[] invoke(Int2ObjectMap<ValueHandle> objects) {
                int n = 0;
                int n2 = this.$propertyRefIds.length;
                Value[] valueArray = new Value[n2];
                while (n < n2) {
                    ValueHandle valueHandle;
                    int n3;
                    int ref;
                    if ((ValueHandle)objects.get(ref = this.$propertyRefIds[n3 = n++]) == null) {
                        throw new IllegalStateException("Failed to find value for ref=" + ref);
                    }
                    if (valueHandle.handle() != ref) {
                        throw new IllegalStateException("Inconsistent ref in response, ref=" + ref);
                    }
                    valueArray[n3] = this.this$0.createValue(valueHandle);
                }
                Value[] result = valueArray;
                return result;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void store(@Nullable List<? extends ObjectDescriptor> objects) {
        Collection collection = objects;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
        synchronized (int2ObjectOpenHashMap) {
            boolean bl = false;
            for (ObjectDescriptor objectDescriptor : objects) {
                this.refToValue.put(objectDescriptor.getId(), (Object)this.createValue(objectDescriptor));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Value[] getOrLoadValueFromRefs$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Value[])$tmp0.invoke(p0);
    }

    private static final Value[] loadValuesFromRemote$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Value[])$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.NULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.UNDEFINED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.BOOLEAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NUMBER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.OBJECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.FUNCTION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.ARRAY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

