/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.VmBase;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.v8.BreakEventHandlerKt;
import org.jetbrains.v8.EventMap;
import org.jetbrains.v8.V8BreakpointManager;
import org.jetbrains.v8.V8CommandProcessor;
import org.jetbrains.v8.V8EvaluateContext;
import org.jetbrains.v8.V8ScriptManager;
import org.jetbrains.v8.V8SuspendContextManager;
import org.jetbrains.v8.V8VersionFeatures;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.V8VmKt;
import org.jetbrains.v8.protocol.FrameInfo;
import org.jetbrains.v8.protocol.GetFramesResult;
import org.jetbrains.v8.protocol.GetScriptsResult;
import org.jetbrains.v8.protocol.IncomingMessage;
import org.jetbrains.v8.protocol.OriginalProtocolKt;
import org.jetbrains.v8.protocol.ProtocolKt;
import org.jetbrains.v8.protocol.ScriptDescriptor;
import org.jetbrains.v8.protocol.ScriptHandle;
import org.jetbrains.v8.protocol.ScriptsMessageKt;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.value.V8ValueManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020<J\b\u0010>\u001a\u00020?H\u0004J\b\u0010@\u001a\u00020\u0019H\u0002J\b\u0010A\u001a\u00020\u0007H\u0002J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CH\u0002J\u0012\u0010E\u001a\u0006\u0012\u0002\b\u00030C2\u0006\u0010F\u001a\u00020GJ\u0018\u0010H\u001a\u00020D2\u000e\u0010I\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00000'H\u0014J\u0010\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020LH$R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\nR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\nR\u0016\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001b\"\u0004\b+\u0010\u001dR\u001a\u0010,\u001a\u00020-X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b.\u0010\u0010\u001a\u0004\b/\u00100R\u0017\u00101\u001a\u000202\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u0010\u0010\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u00108\u001a\u0004\u0018\u00010\u00192\b\u00107\u001a\u0004\u0018\u00010\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u001b\"\u0004\b:\u0010\u001d\u00a8\u0006M"}, d2={"Lorg/jetbrains/v8/V8Vm;", "Lorg/jetbrains/debugger/VmBase;", "Lorg/jetbrains/debugger/Vm;", "debugEventListener", "Lorg/jetbrains/debugger/DebugEventListener;", "(Lorg/jetbrains/debugger/DebugEventListener;)V", "<set-?>", "", "bootstrapped", "getBootstrapped", "()Z", "setBootstrapped$intellij_javascript_v8_backend", "(Z)V", "breakpointManager", "Lorg/jetbrains/v8/V8BreakpointManager;", "getBreakpointManager$annotations", "()V", "getBreakpointManager", "()Lorg/jetbrains/v8/V8BreakpointManager;", "commandProcessor", "Lorg/jetbrains/v8/V8CommandProcessor;", "getCommandProcessor$annotations", "getCommandProcessor", "()Lorg/jetbrains/v8/V8CommandProcessor;", "embeddingHost", "", "getEmbeddingHost", "()Ljava/lang/String;", "setEmbeddingHost", "(Ljava/lang/String;)V", "hasJbDebuggerSupport", "getHasJbDebuggerSupport", "initialBreakEvent", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/v8/protocol/IncomingMessage;", "getInitialBreakEvent$intellij_javascript_v8_backend", "()Ljava/util/concurrent/atomic/AtomicReference;", "isAbleToReportSourceMapUrl", "jbDebuggerSupportInstalled", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "presentableName", "getPresentableName", "setPresentableName", "scriptManager", "Lorg/jetbrains/v8/V8ScriptManager;", "getScriptManager$annotations", "getScriptManager", "()Lorg/jetbrains/v8/V8ScriptManager;", "suspendContextManager", "Lorg/jetbrains/v8/V8SuspendContextManager;", "getSuspendContextManager$annotations", "getSuspendContextManager", "()Lorg/jetbrains/v8/V8SuspendContextManager;", "valueModificationSupported", "value", "vmVersion", "getVmVersion", "setVmVersion", "checkValueModifier", "Lorg/jetbrains/debugger/ValueModifier;", "valueModifier", "computeEvaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getDebuggerSupportSource", "isInsideJar", "loadScriptsFallback", "Lorg/jetbrains/concurrency/Promise;", "", "setBreakOnException", "catchMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "startCommunication", "vmResult", "write", "content", "Lio/netty/buffer/ByteBuf;", "intellij.javascript.v8.backend"})
public abstract class V8Vm
extends VmBase
implements Vm {
    @NotNull
    private String presentableName;
    @NotNull
    private final V8ScriptManager scriptManager;
    @NotNull
    private final V8CommandProcessor commandProcessor;
    @NotNull
    private final V8SuspendContextManager suspendContextManager;
    @NotNull
    private final V8BreakpointManager breakpointManager;
    @Nullable
    private volatile String vmVersion;
    @Nullable
    private volatile String embeddingHost;
    private boolean valueModificationSupported;
    private volatile boolean hasJbDebuggerSupport;
    private volatile boolean bootstrapped;
    private volatile boolean isAbleToReportSourceMapUrl;
    @NotNull
    private final AsyncPromise<Object> jbDebuggerSupportInstalled;
    @NotNull
    private final AtomicReference<IncomingMessage> initialBreakEvent;

    public V8Vm(@NotNull DebugEventListener debugEventListener) {
        Intrinsics.checkNotNullParameter((Object)debugEventListener, (String)"debugEventListener");
        super(debugEventListener);
        this.presentableName = super.getPresentableName();
        this.scriptManager = new V8ScriptManager(this);
        this.commandProcessor = new V8CommandProcessor((Function1<? super ByteBuf, Boolean>)((Function1)new Function1<ByteBuf, Boolean>(this){
            final /* synthetic */ V8Vm this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ByteBuf it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.write(it);
            }
        }), new EventMap(this));
        this.suspendContextManager = new V8SuspendContextManager(this);
        this.breakpointManager = new V8BreakpointManager(this);
        this.jbDebuggerSupportInstalled = new AsyncPromise();
        this.initialBreakEvent = new AtomicReference();
    }

    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    public void setPresentableName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.presentableName = string;
    }

    @NotNull
    public V8ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public static /* synthetic */ void getScriptManager$annotations() {
    }

    @NotNull
    public final V8CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    public static /* synthetic */ void getCommandProcessor$annotations() {
    }

    @NotNull
    public final V8SuspendContextManager getSuspendContextManager() {
        return this.suspendContextManager;
    }

    public static /* synthetic */ void getSuspendContextManager$annotations() {
    }

    @NotNull
    public final V8BreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public static /* synthetic */ void getBreakpointManager$annotations() {
    }

    @Nullable
    public final String getVmVersion() {
        return this.vmVersion;
    }

    public final void setVmVersion(@Nullable String value) {
        this.vmVersion = value;
        this.valueModificationSupported = StringUtil.compareVersionNumbers((String)this.vmVersion, (String)"3.16") >= 0;
        this.breakpointManager.setRegExpBreakpointSupported(V8VersionFeatures.isRegExpBreakpointSupported(this.vmVersion));
    }

    @Nullable
    public final String getEmbeddingHost() {
        return this.embeddingHost;
    }

    public final void setEmbeddingHost(@Nullable String string) {
        this.embeddingHost = string;
    }

    public final boolean getHasJbDebuggerSupport() {
        return this.hasJbDebuggerSupport;
    }

    public final boolean getBootstrapped() {
        return this.bootstrapped;
    }

    public final void setBootstrapped$intellij_javascript_v8_backend(boolean bl) {
        this.bootstrapped = bl;
    }

    public final boolean isAbleToReportSourceMapUrl() {
        return this.isAbleToReportSourceMapUrl;
    }

    protected abstract boolean write(@NotNull ByteBuf var1);

    @NotNull
    public final Promise<?> setBreakOnException(@NotNull ExceptionCatchMode catchMode) {
        Intrinsics.checkNotNullParameter((Object)catchMode, (String)"catchMode");
        return this.breakpointManager.setBreakOnException(catchMode);
    }

    @NotNull
    public final AtomicReference<IncomingMessage> getInitialBreakEvent$intellij_javascript_v8_backend() {
        return this.initialBreakEvent;
    }

    protected void startCommunication(@NotNull AsyncPromise<? super V8Vm> vmResult) {
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        if (!Intrinsics.areEqual((Object)this.embeddingHost, (Object)"Electron") && Registry.is((String)"nodejs.debugger.use.jb.support", (boolean)true)) {
            String string;
            try {
                string = this.getDebuggerSupportSource();
            }
            catch (Exception e) {
                vmResult.setResult((Object)this);
                String errMsg = "Cannot install our debugger support: cannot read debuggerSupport.js";
                CommandProcessorKt.getLOG().info(errMsg, (Throwable)e);
                this.jbDebuggerSupportInstalled.setError(errMsg);
                string = null;
            }
            String debuggerSupport = string;
            if (debuggerSupport != null) {
                EvaluateContext evaluateContext2 = this.getEvaluateContext();
                Intrinsics.checkNotNull((Object)evaluateContext2);
                EvaluateContext.evaluate$default((EvaluateContext)evaluateContext2, (String)debuggerSupport, null, (boolean)false, null, (int)14, null).onSuccess(arg_0 -> V8Vm.startCommunication$lambda$0((Function1)new Function1<EvaluateResult, Unit>(this, vmResult){
                    final /* synthetic */ V8Vm this$0;
                    final /* synthetic */ AsyncPromise<? super V8Vm> $vmResult;
                    {
                        this.this$0 = $receiver;
                        this.$vmResult = $vmResult;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(EvaluateResult it) {
                        AsyncPromise asyncPromise = V8Vm.access$getJbDebuggerSupportInstalled$p(this.this$0);
                        AsyncPromise<? super V8Vm> asyncPromise2 = this.$vmResult;
                        V8Vm v8Vm = this.this$0;
                        boolean $i$f$catchError = false;
                        try {
                            Object object;
                            boolean bl = false;
                            if (it.getWasThrown()) {
                                String string = it.getValue().getValueString();
                                if (string == null) {
                                    string = it;
                                }
                                String message = "Cannot install our debugger support: " + string;
                                CommandProcessorKt.getLOG().info(message);
                                asyncPromise2.setResult((Object)((Object)v8Vm));
                                object = V8Vm.access$getJbDebuggerSupportInstalled$p(v8Vm).setError(message);
                            } else {
                                V8Vm.access$setHasJbDebuggerSupport$p(v8Vm, true);
                                if (it.getValue().getType() == ValueType.STRING) {
                                    char[] cArray;
                                    Object object2 = it.getValue().getValueString();
                                    if (object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (char[])(cArray = new char[]{'|'}), (boolean)false, (int)0, (int)6, null)) != null) {
                                        Object it2 = object2;
                                        boolean bl2 = false;
                                        V8Vm.access$setAbleToReportSourceMapUrl$p(v8Vm, Intrinsics.areEqual((Object)CollectionsKt.getOrNull((List)it2, (int)0), (Object)"true"));
                                        String string = V8VmKt.computeName((List<String>)it2, 1);
                                        if (string != null) {
                                            String it3 = string;
                                            boolean bl3 = false;
                                            v8Vm.setPresentableName(it3);
                                        }
                                    }
                                }
                                asyncPromise2.setResult((Object)((Object)v8Vm));
                                V8Vm.access$getJbDebuggerSupportInstalled$p(v8Vm).setResult(null);
                                object = Unit.INSTANCE;
                            }
                            Object object3 = object;
                        }
                        catch (Throwable e$iv) {
                            void $this$catchError$iv;
                            $this$catchError$iv.setError(e$iv);
                            Object var13_14 = null;
                        }
                    }
                }, arg_0)).onError(arg_0 -> V8Vm.startCommunication$lambda$1((Function1)new Function1<Throwable, Unit>(vmResult, this){
                    final /* synthetic */ AsyncPromise<? super V8Vm> $vmResult;
                    final /* synthetic */ V8Vm this$0;
                    {
                        this.$vmResult = $vmResult;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(Throwable it) {
                        CommandProcessorKt.getLOG().info("Cannot install our debugger support", it);
                        this.$vmResult.setResult((Object)((Object)this.this$0));
                        AsyncPromise asyncPromise = V8Vm.access$getJbDebuggerSupportInstalled$p(this.this$0);
                        Intrinsics.checkNotNull((Object)it);
                        asyncPromise.setError(it);
                    }
                }, arg_0));
            }
        } else {
            vmResult.setResult((Object)this);
            this.jbDebuggerSupportInstalled.setResult(null);
        }
        this.jbDebuggerSupportInstalled.onProcessed(arg_0 -> V8Vm.startCommunication$lambda$5(this, arg_0));
    }

    private final String getDebuggerSupportSource() {
        if (this.isInsideJar()) {
            String string = V8VmKt.access$getSCRIPT_DEBUGGER_SUPPORT_SOURCE();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getSCRIPT_DEBUGGER_SUPPORT_SOURCE(...)");
            return string;
        }
        File file = PluginPathManager.getPluginHome((String)"JavaScriptDebugger/sdk/v8/backend/src/debuggerSupport.js");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getPluginHome(...)");
        String debuggerSupportText = FilesKt.readText$default((File)file, null, (int)1, null);
        return "try {" + debuggerSupportText + "} catch (e) {throw new Error(e.stack)}";
    }

    private final boolean isInsideJar() {
        URL uRL = V8Vm.class.getResource("debuggerSupport.js");
        if (uRL == null) {
            V8Vm $this$isInsideJar_u24lambda_u246 = this;
            boolean bl = false;
            CommandProcessorKt.getLOG().info("Resource debuggerSupport.js not found");
            return true;
        }
        URL resource = uRL;
        return Intrinsics.areEqual((Object)"jar", (Object)resource.getProtocol());
    }

    private final Promise<Unit> loadScriptsFallback() {
        Promise promise2 = this.commandProcessor.send((Request)ScriptsMessageKt.ScriptsMessage$default(false, 0, 0, null, null, 31, null)).then(arg_0 -> V8Vm.loadScriptsFallback$lambda$7((Function1)new Function1<List<? extends ScriptHandle>, Unit>(this){
            final /* synthetic */ V8Vm this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(List<? extends ScriptHandle> it) {
                List<SomeHandle> refs = ((IncomingMessage)this.this$0.getCommandProcessor().lastSuccessResponse().getBase()).refs();
                for (ScriptHandle scriptHandle : it) {
                    this.this$0.getScriptManager().addScript(scriptHandle, refs);
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @Nullable
    public final ValueModifier checkValueModifier(@NotNull ValueModifier valueModifier) {
        Intrinsics.checkNotNullParameter((Object)valueModifier, (String)"valueModifier");
        return this.valueModificationSupported ? valueModifier : null;
    }

    @NotNull
    protected final EvaluateContext computeEvaluateContext() {
        V8ValueManager v8ValueManager = new V8ValueManager(this);
        return (EvaluateContext)new V8EvaluateContext(v8ValueManager){
            private final int frameIndex;
            {
                this.frameIndex = -1;
            }

            protected int getFrameIndex() {
                return this.frameIndex;
            }
        };
    }

    private static final void startCommunication$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void startCommunication$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void startCommunication$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void startCommunication$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void startCommunication$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void startCommunication$lambda$5(V8Vm this$0, Object it) {
        Promise promise2;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.hasJbDebuggerSupport) {
            void var3_2;
            AsyncPromise result = new AsyncPromise();
            this$0.commandProcessor.send((Request)ProtocolKt.GetScripts$default(null, 1, null)).onSuccess(arg_0 -> V8Vm.startCommunication$lambda$5$lambda$2((Function1)new Function1<GetScriptsResult, Unit>((AsyncPromise<Unit>)result, this$0){
                final /* synthetic */ AsyncPromise<Unit> $result;
                final /* synthetic */ V8Vm this$0;
                {
                    this.$result = $result;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(GetScriptsResult it) {
                    AsyncPromise<Unit> asyncPromise = this.$result;
                    V8Vm v8Vm = this.this$0;
                    boolean $i$f$catchError = false;
                    try {
                        boolean bl = false;
                        Iterable $this$forEach$iv = it.scripts();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            ScriptDescriptor it2 = (ScriptDescriptor)element$iv;
                            boolean bl2 = false;
                            v8Vm.getScriptManager().addScript(it2);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable e$iv) {
                        void $this$catchError$iv;
                        $this$catchError$iv.setError(e$iv);
                        Object var12_13 = null;
                    }
                    this.$result.setResult(null);
                }
            }, arg_0)).onError(arg_0 -> V8Vm.startCommunication$lambda$5$lambda$3((Function1)new Function1<Throwable, Unit>(this$0, (AsyncPromise<Unit>)result){
                final /* synthetic */ V8Vm this$0;
                final /* synthetic */ AsyncPromise<Unit> $result;
                {
                    this.this$0 = $receiver;
                    this.$result = $result;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    V8Vm.access$setHasJbDebuggerSupport$p(this.this$0, false);
                    V8Vm.access$loadScriptsFallback(this.this$0).processed((Promise)this.$result);
                }
            }, arg_0));
            promise2 = (Promise)var3_2;
        } else {
            promise2 = this$0.loadScriptsFallback();
        }
        Promise promise3 = promise2;
        promise3.onSuccess(arg_0 -> V8Vm.startCommunication$lambda$5$lambda$4((Function1)new Function1<Unit, Unit>(this$0){
            final /* synthetic */ V8Vm this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Unit it) {
                IncomingMessage breakEvent = this.this$0.getInitialBreakEvent$intellij_javascript_v8_backend().getAndSet(null);
                this.this$0.setBootstrapped$intellij_javascript_v8_backend(true);
                if (breakEvent != null) {
                    BreakEventHandlerKt.processBreak(breakEvent, this.this$0);
                } else if (V8VersionFeatures.isRunningAccurate(this.this$0.getVmVersion()) && !this.this$0.getCommandProcessor().lastSuccessResponse().running() && this.this$0.getSuspendContextManager().getContext() == null) {
                    if (this.this$0.getHasJbDebuggerSupport()) {
                        this.this$0.getCommandProcessor().send((Request)ProtocolKt.GetFrames(0, 1)).onSuccess(arg_0 -> startCommunication.3.1.invoke$lambda$0((Function1)new Function1<GetFramesResult, Unit>(this.this$0){
                            final /* synthetic */ V8Vm this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(GetFramesResult it) {
                                if (this.this$0.getSuspendContextManager().getContext() == null) {
                                    V8SuspendContextManager v8SuspendContextManager = this.this$0.getSuspendContextManager();
                                    Intrinsics.checkNotNull((Object)it);
                                    v8SuspendContextManager.createAndSetContextIfNotExists(it, false);
                                }
                            }
                        }, arg_0));
                    } else {
                        this.this$0.getCommandProcessor().send((Request)OriginalProtocolKt.FrameMessage()).onSuccess(arg_0 -> startCommunication.3.1.invoke$lambda$1((Function1)new Function1<FrameInfo, Unit>(this.this$0){
                            final /* synthetic */ V8Vm this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(FrameInfo it) {
                                if (this.this$0.getSuspendContextManager().getContext() == null) {
                                    V8SuspendContextManager v8SuspendContextManager = this.this$0.getSuspendContextManager();
                                    Intrinsics.checkNotNull((Object)it);
                                    v8SuspendContextManager.createAndSetContextIfNotExists(it, false);
                                }
                            }
                        }, arg_0));
                    }
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private static final Unit loadScriptsFallback$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ AsyncPromise access$getJbDebuggerSupportInstalled$p(V8Vm $this) {
        return $this.jbDebuggerSupportInstalled;
    }

    public static final /* synthetic */ void access$setAbleToReportSourceMapUrl$p(V8Vm $this, boolean bl) {
        $this.isAbleToReportSourceMapUrl = bl;
    }

    public static final /* synthetic */ void access$setHasJbDebuggerSupport$p(V8Vm $this, boolean bl) {
        $this.hasJbDebuggerSupport = bl;
    }

    public static final /* synthetic */ Promise access$loadScriptsFallback(V8Vm $this) {
        return $this.loadScriptsFallback();
    }
}

