/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Script;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.V8CallFrame;
import org.jetbrains.v8.V8Script;
import org.jetbrains.v8.V8ScriptManager;
import org.jetbrains.v8.V8SuspendContext;
import org.jetbrains.v8.V8SuspendContextCallFramePromiseManager;
import org.jetbrains.v8.V8SuspendContextManagerKt;
import org.jetbrains.v8.protocol.BacktraceCommandBody;
import org.jetbrains.v8.protocol.BacktraceMessage;
import org.jetbrains.v8.protocol.FrameDescriptor;
import org.jetbrains.v8.protocol.FrameInfo;
import org.jetbrains.v8.protocol.GetFramesResult;
import org.jetbrains.v8.protocol.IncomingMessage;
import org.jetbrains.v8.protocol.ProtocolKt;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.value.V8ValueManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001c\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u001e\u0010\u0006\u001a\u0012\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/v8/V8SuspendContextCallFramePromiseManager;", "Lorg/jetbrains/concurrency/PromiseManager;", "Lorg/jetbrains/v8/V8SuspendContext;", "", "Lorg/jetbrains/debugger/CallFrame;", "()V", "nativeScripts", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "", "Lorg/jetbrains/annotations/NotNull;", "load", "Lorg/jetbrains/concurrency/Promise;", "context", "loadJb", "loadV8", "intellij.javascript.v8.backend"})
public final class V8SuspendContextCallFramePromiseManager
extends PromiseManager<V8SuspendContext, CallFrame[]> {
    @NotNull
    private final ConcurrentIntObjectMap<Boolean> nativeScripts;

    public V8SuspendContextCallFramePromiseManager() {
        super(V8SuspendContext.class);
        ConcurrentIntObjectMap concurrentIntObjectMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentIntObjectMap, (String)"createConcurrentIntObjectMap(...)");
        this.nativeScripts = concurrentIntObjectMap;
    }

    @NotNull
    public Promise<CallFrame[]> load(@NotNull V8SuspendContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return context.getValueManager().getVm().getHasJbDebuggerSupport() ? this.loadJb(context) : this.loadV8(context);
    }

    private final Promise<CallFrame[]> loadV8(V8SuspendContext context) {
        Promise promise2 = context.getValueManager().getVm().getCommandProcessor().send((Request)new BacktraceMessage(1, -1)).thenAsync(arg_0 -> V8SuspendContextCallFramePromiseManager.loadV8$lambda$0((Function1)new Function1<BacktraceCommandBody, Promise<CallFrame[]>>(context, this){
            final /* synthetic */ V8SuspendContext $context;
            final /* synthetic */ V8SuspendContextCallFramePromiseManager this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                super(1);
            }

            public final Promise<CallFrame[]> invoke(BacktraceCommandBody result) {
                Promise promise2;
                List list = result.frames();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List frames = list;
                V8ValueManager valueManager = this.$context.getValueManager();
                List<SomeHandle> list2 = ((IncomingMessage)valueManager.getVm().getCommandProcessor().lastSuccessResponse().getBase()).refs();
                Intrinsics.checkNotNull(list2);
                for (SomeHandle handle : list2) {
                    valueManager.addHandleFromRefs(handle);
                }
                V8ScriptManager scriptManager = valueManager.getVm().getScriptManager();
                CallFrame[] callFrames = new CallFrame[frames.size() + 1];
                callFrames[0] = this.$context.getTopFrame();
                IntOpenHashSet unresolvedScriptIds = null;
                for (FrameInfo frameInfo : frames) {
                    int scriptId = V8SuspendContextManagerKt.getScriptId(frameInfo);
                    V8Script script = scriptManager.findScript(scriptId);
                    if (script == null && !V8SuspendContextCallFramePromiseManager.access$getNativeScripts$p(this.this$0).containsKey(scriptId)) {
                        if (unresolvedScriptIds == null) {
                            unresolvedScriptIds = new IntOpenHashSet();
                        }
                        unresolvedScriptIds.add(scriptId);
                        continue;
                    }
                    callFrames[frameInfo.index()] = V8SuspendContextManagerKt.createFrame(frameInfo, this.$context, (Script)script);
                }
                if (unresolvedScriptIds == null) {
                    promise2 = Promises.resolvedPromise((Object)callFrames);
                } else {
                    Promise promise3 = valueManager.getVm().getScriptManager().resolveScripts((IntSet)unresolvedScriptIds).then(arg_0 -> loadV8.1.invoke$lambda$0(callFrames, frames, scriptManager, this.this$0, this.$context, arg_0));
                    Intrinsics.checkNotNull((Object)promise3);
                    promise2 = promise3;
                }
                return promise2;
            }

            private static final CallFrame[] invoke$lambda$0(CallFrame[] $callFrames, List $frames, V8ScriptManager $scriptManager, V8SuspendContextCallFramePromiseManager this$0, V8SuspendContext $context, Object it) {
                Intrinsics.checkNotNullParameter((Object)$callFrames, (String)"$callFrames");
                Intrinsics.checkNotNullParameter((Object)$frames, (String)"$frames");
                Intrinsics.checkNotNullParameter((Object)$scriptManager, (String)"$scriptManager");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)((Object)$context), (String)"$context");
                int n = $callFrames.length;
                for (int i = 1; i < n; ++i) {
                    CallFrame frame = $callFrames[i];
                    if (frame != null) continue;
                    FrameInfo frameInfo = (FrameInfo)$frames.get(i - 1);
                    int scriptId = V8SuspendContextManagerKt.getScriptId(frameInfo);
                    V8Script script = $scriptManager.findScript(scriptId);
                    if (script == null) {
                        V8SuspendContextCallFramePromiseManager.access$getNativeScripts$p(this$0).put(scriptId, (Object)true);
                    }
                    $callFrames[i] = V8SuspendContextManagerKt.createFrame(frameInfo, $context, (Script)script);
                }
                return $callFrames;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
        return promise2;
    }

    private final Promise<CallFrame[]> loadJb(V8SuspendContext context) {
        if (context.getFrameCount() == 1 && context.getTopFrame() != null) {
            CallFrame[] callFrameArray = new CallFrame[1];
            Intrinsics.checkNotNull((Object)context.getTopFrame());
            return Promises.resolvedPromise((Object)callFrameArray);
        }
        Promise promise2 = context.getValueManager().getVm().getCommandProcessor().send((Request)ProtocolKt.GetFrames$default(1, 0, 2, null)).thenAsync(arg_0 -> V8SuspendContextCallFramePromiseManager.loadJb$lambda$1((Function1)new Function1<GetFramesResult, Promise<CallFrame[]>>(context, this){
            final /* synthetic */ V8SuspendContext $context;
            final /* synthetic */ V8SuspendContextCallFramePromiseManager this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                super(1);
            }

            public final Promise<CallFrame[]> invoke(GetFramesResult it) {
                Promise promise2;
                this.$context.getValueManager().store(it.getObjects());
                List<FrameDescriptor> frameDescriptors = it.frames();
                CallFrame[] frames = new CallFrame[frameDescriptors.size() + 1];
                frames[0] = this.$context.getTopFrame();
                IntOpenHashSet unresolvedScriptIds = null;
                for (FrameDescriptor frameDescriptor : frameDescriptors) {
                    int scriptId = frameDescriptor.getScriptId();
                    V8Script script = this.$context.getValueManager().getVm().getScriptManager().findScript(scriptId);
                    if (script == null && !V8SuspendContextCallFramePromiseManager.access$getNativeScripts$p(this.this$0).containsKey(scriptId)) {
                        if (unresolvedScriptIds == null) {
                            unresolvedScriptIds = new IntOpenHashSet();
                        }
                        unresolvedScriptIds.add(scriptId);
                        continue;
                    }
                    frames[frameDescriptor.getIndex()] = new V8CallFrame(frameDescriptor, this.$context, (Script)script);
                }
                if (unresolvedScriptIds == null) {
                    promise2 = Promises.resolvedPromise((Object)frames);
                } else {
                    Promise promise3 = this.$context.getValueManager().getVm().getScriptManager().resolveScripts((IntSet)unresolvedScriptIds).then(arg_0 -> loadJb.1.invoke$lambda$0(frames, frameDescriptors, this.$context, this.this$0, arg_0));
                    Intrinsics.checkNotNull((Object)promise3);
                    promise2 = promise3;
                }
                return promise2;
            }

            private static final CallFrame[] invoke$lambda$0(CallFrame[] $frames, List $frameDescriptors, V8SuspendContext $context, V8SuspendContextCallFramePromiseManager this$0, Object it) {
                Intrinsics.checkNotNullParameter((Object)$frames, (String)"$frames");
                Intrinsics.checkNotNullParameter((Object)$frameDescriptors, (String)"$frameDescriptors");
                Intrinsics.checkNotNullParameter((Object)((Object)$context), (String)"$context");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                int n = $frames.length;
                for (int i = 1; i < n; ++i) {
                    CallFrame frame = $frames[i];
                    if (frame != null) continue;
                    FrameDescriptor frameDescriptor = (FrameDescriptor)$frameDescriptors.get(i - 1);
                    int scriptId = frameDescriptor.getScriptId();
                    V8Script script = $context.getValueManager().getVm().getScriptManager().findScript(scriptId);
                    if (script == null) {
                        V8SuspendContextCallFramePromiseManager.access$getNativeScripts$p(this$0).put(scriptId, (Object)true);
                    }
                    $frames[i] = new V8CallFrame(frameDescriptor, $context, (Script)script);
                }
                return $frames;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
        return promise2;
    }

    private static final Promise loadV8$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise loadJb$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ConcurrentIntObjectMap access$getNativeScripts$p(V8SuspendContextCallFramePromiseManager $this) {
        return $this.nativeScripts;
    }
}

