/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Enumeration;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptBase;
import org.jetbrains.debugger.ScriptManagerBase;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.HotSwapScriptManager;
import org.jetbrains.v8.V8CallFrame;
import org.jetbrains.v8.V8Script;
import org.jetbrains.v8.V8ScriptLiveChangeResult;
import org.jetbrains.v8.V8ScriptManager;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.liveEditProtocol.LiveEditResult;
import org.jetbrains.v8.liveEditProtocol.ScriptLiveChangeResult;
import org.jetbrains.v8.protocol.ChangeLiveBody;
import org.jetbrains.v8.protocol.ChangeLiveMessage;
import org.jetbrains.v8.protocol.EvalLocation;
import org.jetbrains.v8.protocol.GetScriptsResult;
import org.jetbrains.v8.protocol.IncomingMessage;
import org.jetbrains.v8.protocol.ProtocolKt;
import org.jetbrains.v8.protocol.ScriptDescriptor;
import org.jetbrains.v8.protocol.ScriptHandle;
import org.jetbrains.v8.protocol.ScriptsMessageKt;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.protocol.V8ProtocolUtilKt;
import org.jetbrains.v8.value.FunctionReference;
import org.jetbrains.v8.value.V8Function;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J \u0010\u0019\u001a\u0014 \u001a*\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\t0\u0002\u00a2\u0006\u0002\b\t2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u00020\u000b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140$H\u0016J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160&2\u0006\u0010'\u001a\u00020\u001cJ\u0012\u0010(\u001a\u0004\u0018\u00010\u00162\u0006\u0010)\u001a\u00020*H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160&2\u0006\u0010+\u001a\u00020,H\u0016J#\u0010-\u001a\u0015\u0012\f\u0012\n \u001a*\u0004\u0018\u00010!0!0&\u00a2\u0006\u0002\b\t2\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u0006\u0010.\u001a\u00020\u000bJ\u0016\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000&2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u001cJ\u001a\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0002J\u001e\u00106\u001a\b\u0012\u0004\u0012\u0002070&2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00108\u001a\u000209H\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\t0\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/v8/V8ScriptManager;", "Lorg/jetbrains/debugger/ScriptManagerBase;", "Lorg/jetbrains/v8/V8Script;", "Lorg/jetbrains/v8/HotSwapScriptManager;", "vm", "Lorg/jetbrains/v8/V8Vm;", "(Lorg/jetbrains/v8/V8Vm;)V", "idToScript", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lorg/jetbrains/annotations/NotNull;", "addScript", "", "descriptor", "Lorg/jetbrains/v8/protocol/ScriptDescriptor;", "scriptBody", "Lorg/jetbrains/v8/protocol/ScriptHandle;", "refs", "", "Lorg/jetbrains/v8/protocol/SomeHandle;", "containsScript", "", "script", "Lorg/jetbrains/debugger/Script;", "createScript", "rawScriptHandle", "findScript", "kotlin.jvm.PlatformType", "id", "", "findScriptByUrl", "url", "Lcom/intellij/util/Url;", "rawUrl", "", "forEachScript", "scriptProcessor", "Lkotlin/Function1;", "getOrLoadScript", "Lorg/jetbrains/concurrency/Promise;", "scriptId", "getScript", "frame", "Lorg/jetbrains/debugger/CallFrame;", "function", "Lorg/jetbrains/debugger/values/FunctionValue;", "loadScriptSource", "reset", "resolveScripts", "", "unresolvedScriptIds", "Lit/unimi/dsi/fastutil/ints/IntSet;", "scriptCollected", "setSourceCode", "body", "setSourceOnRemote", "Lorg/jetbrains/v8/liveEditProtocol/ScriptLiveChangeResult;", "newSource", "", "intellij.javascript.v8.backend"})
public final class V8ScriptManager
extends ScriptManagerBase<V8Script>
implements HotSwapScriptManager {
    @NotNull
    private final V8Vm vm;
    @NotNull
    private final ConcurrentIntObjectMap<V8Script> idToScript;

    public V8ScriptManager(@NotNull V8Vm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        ConcurrentIntObjectMap concurrentIntObjectMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentIntObjectMap, (String)"createConcurrentIntObjectMap(...)");
        this.idToScript = concurrentIntObjectMap;
    }

    @NotNull
    protected Promise<String> loadScriptSource(@NotNull V8Script script) {
        Intrinsics.checkNotNullParameter((Object)((Object)script), (String)"script");
        Promise promise2 = this.vm.getCommandProcessor().send((Request)ScriptsMessageKt.ScriptsMessage$default(true, 12, script.getId(), null, null, 24, null)).then(arg_0 -> V8ScriptManager.loadScriptSource$lambda$0(loadScriptSource.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @Override
    @NotNull
    public Promise<ScriptLiveChangeResult> setSourceOnRemote(@NotNull Script script, @NotNull CharSequence newSource) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)newSource, (String)"newSource");
        Promise promise2 = this.vm.getCommandProcessor().send((Request)new ChangeLiveMessage(((V8Script)script).getId(), newSource, false)).then(arg_0 -> V8ScriptManager.setSourceOnRemote$lambda$1((Function1)new Function1<ChangeLiveBody, ScriptLiveChangeResult>(this, script){
            final /* synthetic */ V8ScriptManager this$0;
            final /* synthetic */ Script $script;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                super(1);
            }

            public final ScriptLiveChangeResult invoke(ChangeLiveBody it) {
                boolean bl;
                LiveEditResult resultDescription = it.getResultDescription();
                this.this$0.setSource((ScriptBase)this.$script, null);
                V8ScriptManager.access$getVm$p(this.this$0).getDebugListener().scriptContentChanged(this.$script);
                boolean stepInRecommended = it.stepin_recommended();
                boolean bl2 = bl = resultDescription != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                return new V8ScriptLiveChangeResult(resultDescription, stepInRecommended, this.this$0){
                    final /* synthetic */ boolean $stepInRecommended;
                    final /* synthetic */ V8ScriptManager this$0;
                    {
                        this.$stepInRecommended = $stepInRecommended;
                        this.this$0 = $receiver;
                        Intrinsics.checkNotNull((Object)$resultDescription);
                        super($resultDescription);
                    }

                    public void doRecommended() {
                        if (this.$stepInRecommended) {
                            if (V8ScriptManager.access$getVm$p(this.this$0).getSuspendContextManager().getContext() != null) {
                                V8ScriptManager.access$getVm$p(this.this$0).getSuspendContextManager().continueVm(StepAction.IN, 0);
                            }
                        } else if (this.getDescription().stack_modified()) {
                            V8ScriptManager.access$getVm$p(this.this$0).getSuspendContextManager().startRebuildCurrentContext$intellij_javascript_v8_backend();
                        }
                    }
                };
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    public void forEachScript(@NotNull Function1<? super Script, Boolean> scriptProcessor) {
        Intrinsics.checkNotNullParameter(scriptProcessor, (String)"scriptProcessor");
        Enumeration enumeration = this.idToScript.elements();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"elements(...)");
        Enumeration scripts = enumeration;
        while (scripts.hasMoreElements()) {
            Object e = scripts.nextElement();
            Intrinsics.checkNotNullExpressionValue(e, (String)"nextElement(...)");
            if (((Boolean)scriptProcessor.invoke(e)).booleanValue()) continue;
            return;
        }
    }

    @NotNull
    public final Promise<Object> resolveScripts(@NotNull IntSet unresolvedScriptIds) {
        Intrinsics.checkNotNullParameter((Object)unresolvedScriptIds, (String)"unresolvedScriptIds");
        Promise promise2 = this.vm.getCommandProcessor().send((Request)ScriptsMessageKt.ScriptsMessage$default(false, 0, 0, null, unresolvedScriptIds, 15, null)).then(arg_0 -> V8ScriptManager.resolveScripts$lambda$2((Function1)new Function1<List<? extends ScriptHandle>, Object>(this){
            final /* synthetic */ V8ScriptManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Object invoke(List<? extends ScriptHandle> it) {
                for (ScriptHandle scriptHandle : it) {
                    this.this$0.addScript(scriptHandle, ((IncomingMessage)V8ScriptManager.access$getVm$p(this.this$0).getCommandProcessor().lastSuccessResponse().getBase()).refs());
                }
                return null;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @NotNull
    public Promise<Script> getScript(@NotNull FunctionValue function) {
        Promise promise2;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (function instanceof FunctionReference) {
            Promise promise3 = function.resolve().thenAsync(arg_0 -> V8ScriptManager.getScript$lambda$3((Function1)new Function1<FunctionValue, Promise<Script>>(this){
                final /* synthetic */ V8ScriptManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Promise<Script> invoke(FunctionValue it) {
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.v8.value.FunctionReference");
                    return this.this$0.getOrLoadScript(((FunctionReference)it).getScriptId());
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)promise3);
            promise2 = promise3;
        } else {
            promise2 = this.getOrLoadScript(((V8Function)function).getScriptId());
        }
        return promise2;
    }

    @NotNull
    public final Promise<Script> getOrLoadScript(int scriptId) {
        V8Script script = this.findScript(scriptId);
        if (script != null) {
            return Promises.resolvedPromise((Object)((Object)script));
        }
        if (this.vm.getHasJbDebuggerSupport()) {
            int[] nArray = new int[]{scriptId};
            Promise promise2 = this.vm.getCommandProcessor().send((Request)ProtocolKt.GetScripts(nArray)).then(arg_0 -> V8ScriptManager.getOrLoadScript$lambda$4((Function1)new Function1<GetScriptsResult, Script>(this, scriptId){
                final /* synthetic */ V8ScriptManager this$0;
                final /* synthetic */ int $scriptId;
                {
                    this.this$0 = $receiver;
                    this.$scriptId = $scriptId;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Script invoke(GetScriptsResult it) {
                    void $this$forEach$iv;
                    Iterable iterable = it.scripts();
                    V8ScriptManager v8ScriptManager = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ScriptDescriptor it2 = (ScriptDescriptor)element$iv;
                        boolean bl = false;
                        v8ScriptManager.addScript(it2);
                    }
                    return (Script)this.this$0.findScript(this.$scriptId);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
            return promise2;
        }
        Promise promise3 = this.vm.getCommandProcessor().send((Request)ScriptsMessageKt.ScriptsMessage$default(false, 12, scriptId, null, null, 25, null)).then(arg_0 -> V8ScriptManager.getOrLoadScript$lambda$5((Function1)new Function1<List<? extends ScriptHandle>, Script>(this, scriptId){
            final /* synthetic */ V8ScriptManager this$0;
            final /* synthetic */ int $scriptId;
            {
                this.this$0 = $receiver;
                this.$scriptId = $scriptId;
                super(1);
            }

            public final Script invoke(List<? extends ScriptHandle> it) {
                for (ScriptHandle scriptHandle : it) {
                    this.this$0.addScript(scriptHandle, ((IncomingMessage)V8ScriptManager.access$getVm$p(this.this$0).getCommandProcessor().lastSuccessResponse().getBase()).refs());
                }
                return (Script)this.this$0.findScript(this.$scriptId);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"then(...)");
        return promise3;
    }

    @Nullable
    public Script getScript(@NotNull CallFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return ((V8CallFrame)frame).getScript();
    }

    public final void addScript(@NotNull ScriptHandle scriptBody, @Nullable List<? extends SomeHandle> refs) {
        Intrinsics.checkNotNullParameter((Object)scriptBody, (String)"scriptBody");
        V8Script script = (V8Script)((Object)this.idToScript.get(scriptBody.getId()));
        if (script == null) {
            List<? extends SomeHandle> list = refs;
            Intrinsics.checkNotNull(list);
            V8Script v8Script = this.createScript(scriptBody, list);
            if (v8Script == null) {
                return;
            }
            script = v8Script;
            if (this.idToScript.putIfAbsent(script.getId(), (Object)script) != null) {
                return;
            }
        }
        if (scriptBody.getSource() != null) {
            this.setSourceCode(scriptBody, script);
        }
        this.vm.getDebugListener().scriptAdded((Vm)this.vm, (Script)script, null);
    }

    public final void addScript(@Nullable ScriptDescriptor descriptor) {
        if (descriptor == null || descriptor.getId() == -1) {
            return;
        }
        V8Script script = (V8Script)((Object)this.idToScript.get(descriptor.getId()));
        if (script == null) {
            int n = descriptor.getId();
            Script.Type type = V8ProtocolUtilKt.getScriptType(descriptor.getType());
            Intrinsics.checkNotNull((Object)type);
            script = new V8Script(n, type, descriptor.path(), descriptor.getStartLine(), descriptor.getStartColumn(), descriptor.getEndLine(), (Vm)this.vm);
            if (this.idToScript.putIfAbsent(script.getId(), (Object)script) != null) {
                return;
            }
        }
        this.vm.getDebugListener().scriptAdded((Vm)this.vm, (Script)script, descriptor.getSourceMapUrl());
    }

    public final void scriptCollected(int scriptId) {
        V8Script v8Script = (V8Script)((Object)this.idToScript.remove(scriptId));
        if (v8Script == null) {
            return;
        }
        V8Script script = v8Script;
        this.vm.getDebugListener().scriptRemoved((Script)script);
    }

    private final void setSourceCode(ScriptHandle body, V8Script script) {
        String source = body.getSource();
        if (source != null && script != null) {
            this.setSource(script, source);
        }
    }

    public boolean containsScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return script instanceof V8Script && this.idToScript.containsKey(((V8Script)script).getId());
    }

    public final V8Script findScript(int id) {
        return (V8Script)((Object)this.idToScript.get(id));
    }

    public final void reset() {
        this.idToScript.clear();
    }

    private final V8Script createScript(ScriptHandle rawScriptHandle, List<? extends SomeHandle> refs) {
        String name;
        int id;
        Script.Type type;
        ScriptHandle scriptHandle;
        block7: {
            ScriptHandle scriptHandle2 = V8ProtocolUtilKt.validScript(rawScriptHandle, refs);
            if (scriptHandle2 == null) {
                return null;
            }
            scriptHandle = scriptHandle2;
            Script.Type type2 = V8ProtocolUtilKt.getScriptType(scriptHandle.getScriptType());
            if (type2 == null) {
                return null;
            }
            type = type2;
            id = scriptHandle.getId();
            if (id == -1) {
                throw new RuntimeException("Null scriptHandle id");
            }
            name = scriptHandle.getName();
            EvalLocation evalLocation = scriptHandle.getEvalFromLocation();
            if (evalLocation == null) break block7;
            EvalLocation location = evalLocation;
            boolean bl = false;
            if (name == null) {
                Object object = scriptHandle.getEvalFromScript();
                if (object != null && (object = object.asSomeRef()) != null) {
                    int it = object.getRef();
                    boolean bl2 = false;
                    for (SomeHandle someHandle : refs) {
                        if (someHandle.handle() != it) continue;
                        V8Script v8Script = (V8Script)((Object)this.idToScript.get(someHandle.asScriptHandle().getId()));
                        if (v8Script != null) {
                            V8Script script = v8Script;
                            boolean bl3 = false;
                            return new V8Script(id, type, script.getUrl(), location.getLine(), location.getColumn(), location.getLine() + scriptHandle.getLineCount(), (Vm)this.vm);
                        }
                        break;
                    }
                }
            }
        }
        return new V8Script(id, type, name, scriptHandle.getLineOffset(), scriptHandle.getColumnOffset(), scriptHandle.getLineOffset() + scriptHandle.getLineCount(), (Vm)this.vm);
    }

    @Nullable
    public Script findScriptByUrl(@NotNull String rawUrl) {
        Intrinsics.checkNotNullParameter((Object)rawUrl, (String)"rawUrl");
        return this.findScriptByUrl(Urls.newLocalFileUrl((String)rawUrl));
    }

    @Nullable
    public Script findScriptByUrl(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Enumeration enumeration = this.idToScript.elements();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"elements(...)");
        Enumeration scripts = enumeration;
        while (scripts.hasMoreElements()) {
            V8Script script = (V8Script)((Object)scripts.nextElement());
            if (!url.equalsIgnoreParameters(script.getUrl())) continue;
            return (Script)script;
        }
        return null;
    }

    private static final String loadScriptSource$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final ScriptLiveChangeResult setSourceOnRemote$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ScriptLiveChangeResult)$tmp0.invoke(p0);
    }

    private static final Object resolveScripts$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final Promise getScript$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Script getOrLoadScript$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Script)$tmp0.invoke(p0);
    }

    private static final Script getOrLoadScript$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Script)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ V8Vm access$getVm$p(V8ScriptManager $this) {
        return $this.vm;
    }
}

