/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManagerBase;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.V8Breakpoint;
import org.jetbrains.v8.V8BreakpointManager;
import org.jetbrains.v8.V8BreakpointManagerKt;
import org.jetbrains.v8.V8CommandProcessor;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.protocol.FlagsBody;
import org.jetbrains.v8.protocol.FlagsMessage;
import org.jetbrains.v8.protocol.LocationValue;
import org.jetbrains.v8.protocol.ProtocolKt;
import org.jetbrains.v8.protocol.SetBreakpointResult;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J:\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0014H\u0014J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\u0002H\u0014J5\u0010'\u001a\u0015\u0012\f\u0012\n (*\u0004\u0018\u00010\u00020\u00020$\u00a2\u0006\u0002\b)2\u0006\u0010\u001c\u001a\u00020\u00102\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010&\u001a\u00020\u0002H\u0014J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020-0$2\u0006\u0010\"\u001a\u00020\u0014H\u0016J.\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00101\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u00102\u001a\u0004\u0018\u000103J\u000e\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u001eJ\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020-0$2\b\u00107\u001a\u0004\u0018\u000108J$\u00109\u001a\b\u0012\u0004\u0012\u00020-0$2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\f0/2\u0006\u0010;\u001a\u00020-H\u0002R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR/\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/v8/V8BreakpointManager;", "Lorg/jetbrains/debugger/BreakpointManagerBase;", "Lorg/jetbrains/v8/V8Breakpoint;", "vm", "Lorg/jetbrains/v8/V8Vm;", "(Lorg/jetbrains/v8/V8Vm;)V", "commandProcessor", "Lorg/jetbrains/v8/V8CommandProcessor;", "getCommandProcessor", "()Lorg/jetbrains/v8/V8CommandProcessor;", "functionSupport", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "expression", "Lorg/jetbrains/debugger/BreakpointTarget;", "getFunctionSupport", "()Lkotlin/jvm/functions/Function1;", "regExpBreakpointSupported", "", "getRegExpBreakpointSupported", "()Z", "setRegExpBreakpointSupported", "(Z)V", "removedBreakpointIds", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "createBreakpoint", "target", "line", "", "column", "condition", "ignoreCount", "enabled", "doClearBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "", "breakpoint", "doSetBreakpoint", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "url", "Lcom/intellij/util/Url;", "enableBreakpoints", "", "findRelatedBreakpoints", "", "Lorg/jetbrains/debugger/Breakpoint;", "sourceId", "suggestedBreakpointIds", "", "isBreakpointObsolete", "id", "setBreakOnException", "catchMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "setRemoteFlags", "flagNames", "values", "intellij.javascript.v8.backend"})
public final class V8BreakpointManager
extends BreakpointManagerBase<V8Breakpoint> {
    @NotNull
    private final V8Vm vm;
    @NotNull
    private final IntOpenHashSet removedBreakpointIds;
    @NotNull
    private final Function1<String, BreakpointTarget> functionSupport;
    private volatile boolean regExpBreakpointSupported;

    public V8BreakpointManager(@NotNull V8Vm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.removedBreakpointIds = new IntOpenHashSet();
        this.functionSupport = functionSupport.1.INSTANCE;
    }

    @NotNull
    public Function1<String, BreakpointTarget> getFunctionSupport() {
        return this.functionSupport;
    }

    public boolean getRegExpBreakpointSupported() {
        return this.regExpBreakpointSupported;
    }

    public void setRegExpBreakpointSupported(boolean bl) {
        this.regExpBreakpointSupported = bl;
    }

    @NotNull
    public final V8CommandProcessor getCommandProcessor() {
        return this.vm.getCommandProcessor();
    }

    @NotNull
    protected V8Breakpoint createBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new V8Breakpoint(target, line, column, condition, ignoreCount, enabled);
    }

    @NotNull
    protected Promise<V8Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget target, @Nullable Url url, @NotNull V8Breakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)breakpoint), (String)"breakpoint");
        V8CommandProcessor v8CommandProcessor = this.vm.getCommandProcessor();
        Object object = target.accept((BreakpointTarget.Visitor)V8BreakpointManagerKt.access$getGET_TYPE_VISITOR$p());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"accept(...)");
        CharSequence charSequence = (CharSequence)object;
        String string = target.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Promise promise2 = v8CommandProcessor.send((Request)ProtocolKt.SetBreakpoint$default(charSequence, string, breakpoint.getLine(), breakpoint.getColumn(), false, breakpoint.getCondition(), breakpoint.getIgnoreCount(), 16, null)).then(arg_0 -> V8BreakpointManager.doSetBreakpoint$lambda$0((Function1)new Function1<SetBreakpointResult, V8Breakpoint>(breakpoint, this){
            final /* synthetic */ V8Breakpoint $breakpoint;
            final /* synthetic */ V8BreakpointManager this$0;
            {
                this.$breakpoint = $breakpoint;
                this.this$0 = $receiver;
                super(1);
            }

            public final V8Breakpoint invoke(SetBreakpointResult it) {
                this.$breakpoint.setId(it.getBreakpoint());
                this.$breakpoint.setActualLocations(it.getActual_locations());
                V8BreakpointManager.access$notifyBreakpointResolvedListener(this.this$0, this.$breakpoint);
                return this.$breakpoint;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @NotNull
    protected Promise<Unit> doClearBreakpoint(@NotNull V8Breakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)breakpoint), (String)"breakpoint");
        this.removedBreakpointIds.add(breakpoint.getId());
        return this.vm.getCommandProcessor().send((Request)ProtocolKt.ClearBreakpoint(breakpoint.getId()));
    }

    public final boolean isBreakpointObsolete(int id) {
        return this.removedBreakpointIds.contains(id);
    }

    @NotNull
    public Promise<boolean[]> enableBreakpoints(boolean enabled) {
        boolean[] blArray = new boolean[]{enabled};
        return this.setRemoteFlags(CollectionsKt.listOf((Object)"breakPointsActive"), blArray);
    }

    @NotNull
    public final Promise<boolean[]> setBreakOnException(@Nullable ExceptionCatchMode catchMode) {
        boolean[] flagValues = null;
        if (catchMode == null) {
            flagValues = new boolean[]{};
        } else {
            boolean caughtValue = false;
            boolean uncaughtValue = false;
            switch (WhenMappings.$EnumSwitchMapping$0[catchMode.ordinal()]) {
                case 1: {
                    caughtValue = true;
                    uncaughtValue = true;
                    break;
                }
                case 2: {
                    caughtValue = false;
                    uncaughtValue = false;
                    break;
                }
                case 3: {
                    caughtValue = false;
                    uncaughtValue = true;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            boolean[] blArray = new boolean[]{caughtValue, uncaughtValue};
            flagValues = blArray;
        }
        return this.setRemoteFlags(V8BreakpointManagerKt.access$getBREAK_ON_EXCEPTION_FLAG_NAMES$p(), flagValues);
    }

    private final Promise<boolean[]> setRemoteFlags(List<String> flagNames, boolean[] values) {
        HashMap<String, Boolean> flagMap = new HashMap<String, Boolean>(values.length);
        int n = flagNames.size();
        for (int i = 0; i < n; ++i) {
            flagMap.put(flagNames.get(i), values[i]);
        }
        Promise promise2 = this.vm.getCommandProcessor().send((Request)new FlagsMessage((Map<String, Boolean>)flagMap)).then(arg_0 -> V8BreakpointManager.setRemoteFlags$lambda$1((Function1)new Function1<FlagsBody, boolean[]>(flagNames){
            final /* synthetic */ List<String> $flagNames;
            {
                this.$flagNames = $flagNames;
                super(1);
            }

            public final boolean[] invoke(FlagsBody it) {
                List<FlagsBody.FlagInfo> flagList = it.flags();
                boolean[] result = new boolean[this.$flagNames.size()];
                int n = this.$flagNames.size();
                for (int i = 0; i < n; ++i) {
                    FlagsBody.FlagInfo f2;
                    block2: {
                        String name = this.$flagNames.get(i);
                        for (FlagsBody.FlagInfo f2 : flagList) {
                            if (!Intrinsics.areEqual((Object)name, (Object)f2.name())) continue;
                            break block2;
                        }
                        throw new RuntimeException("Failed to find the correct flag in response");
                    }
                    result[i] = f2.value();
                }
                return result;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @NotNull
    public final List<Breakpoint> findRelatedBreakpoints(int sourceId, int line, int column, @Nullable int[] suggestedBreakpointIds) {
        SmartList result = new SmartList();
        block0: for (V8Breakpoint breakpoint : this.getBreakpoints()) {
            if (suggestedBreakpointIds != null && ArrayUtil.indexOf((int[])suggestedBreakpointIds, (int)breakpoint.getId()) != -1) {
                result.add((Object)breakpoint);
                continue;
            }
            for (LocationValue actualLocation : breakpoint.getActualLocations()) {
                if (actualLocation.getScript_id() != sourceId || actualLocation.getLine() != line || actualLocation.getColumn() != column) continue;
                result.add((Object)breakpoint);
                continue block0;
            }
        }
        return (List)result;
    }

    private static final V8Breakpoint doSetBreakpoint$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (V8Breakpoint)((Object)$tmp0.invoke(p0));
    }

    private static final boolean[] setRemoteFlags$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (boolean[])$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$notifyBreakpointResolvedListener(V8BreakpointManager $this, V8Breakpoint breakpoint) {
        $this.notifyBreakpointResolvedListener(breakpoint);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExceptionCatchMode.values().length];
            try {
                nArray[ExceptionCatchMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionCatchMode.NONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionCatchMode.UNCAUGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

