/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.util.Consumer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.debugger.StandaloneVmHelper;
import org.jetbrains.debugger.UtilKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.io.BufferToCharsKt;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.rpc.MessageProcessor;
import org.jetbrains.v8.StandaloneV8VmKt;
import org.jetbrains.v8.V8MessageDecoder;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.protocol.ProtocolKt;
import org.jetbrains.v8.protocol.V8Request;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/v8/StandaloneV8Vm;", "Lorg/jetbrains/v8/V8Vm;", "Lorg/jetbrains/debugger/StandaloneVmHelper$VmEx;", "channel", "Lio/netty/channel/Channel;", "debugEventListener", "Lorg/jetbrains/debugger/DebugEventListener;", "result", "Lorg/jetbrains/concurrency/AsyncPromise;", "debugLogFileSuffix", "", "(Lio/netty/channel/Channel;Lorg/jetbrains/debugger/DebugEventListener;Lorg/jetbrains/concurrency/AsyncPromise;Ljava/lang/String;)V", "attachStateManager", "Lorg/jetbrains/debugger/StandaloneVmHelper;", "getAttachStateManager", "()Lorg/jetbrains/debugger/StandaloneVmHelper;", "debugMessageQueue", "Lorg/jetbrains/debugger/MessagingLogger;", "getDebugMessageQueue$intellij_javascript_v8_backend", "()Lorg/jetbrains/debugger/MessagingLogger;", "vmHelper", "createDisconnectRequest", "Lorg/jetbrains/v8/protocol/V8Request;", "", "write", "", "content", "Lio/netty/buffer/ByteBuf;", "intellij.javascript.v8.backend"})
public final class StandaloneV8Vm
extends V8Vm
implements StandaloneVmHelper.VmEx {
    @NotNull
    private final StandaloneVmHelper vmHelper;
    @Nullable
    private final MessagingLogger debugMessageQueue;
    @NotNull
    private final StandaloneVmHelper attachStateManager;

    public StandaloneV8Vm(@NotNull Channel channel, @NotNull DebugEventListener debugEventListener, final @NotNull AsyncPromise<? super V8Vm> result, @NotNull String debugLogFileSuffix) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)debugEventListener, (String)"debugEventListener");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            Intrinsics.checkNotNullParameter((Object)debugLogFileSuffix, (String)"debugLogFileSuffix");
            super(debugEventListener);
            this.vmHelper = new StandaloneVmHelper((Vm)this, (MessageProcessor)this.getCommandProcessor(), channel);
            this.debugMessageQueue = UtilKt.createDebugLogger((String)"js.debugger.v8.log", (String)debugLogFileSuffix);
            this.attachStateManager = this.vmHelper;
            MessagingLogger messagingLogger = this.debugMessageQueue;
            if (messagingLogger != null) {
                messagingLogger.add((CharSequence)("\"Connected to " + channel.remoteAddress() + "\""), "Channel");
            }
            ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new V8MessageDecoder((Consumer<? super V8MessageDecoder>)((Consumer)arg_0 -> StandaloneV8Vm._init_$lambda$0((Function1)new Function1<V8MessageDecoder, Unit>(){

                public final void invoke(V8MessageDecoder it) {
                    this.setVmVersion(it.v8Version);
                    this.setEmbeddingHost(it.embeddingHost);
                    this.startCommunication(result);
                }
            }, arg_0)), (Consumer<? super CharSequence>)((Consumer)arg_0 -> StandaloneV8Vm._init_$lambda$1((Function1)new Function1<CharSequence, Unit>(){

                public final void invoke(CharSequence it) {
                    MessagingLogger messagingLogger = this.getDebugMessageQueue$intellij_javascript_v8_backend();
                    if (messagingLogger != null) {
                        Intrinsics.checkNotNull((Object)it);
                        MessagingLogger.add$default((MessagingLogger)messagingLogger, (CharSequence)it, null, (int)2, null);
                    }
                    this.getCommandProcessor().processIncomingJson(new JsonReaderEx(it));
                }
            }, arg_0)), this.debugMessageQueue), ChannelExceptionHandler.getInstance()};
            channel.pipeline().addLast(channelHandlerArray);
            MessagingLogger messagingLogger2 = this.debugMessageQueue;
            if (messagingLogger2 == null) break block1;
            messagingLogger2.closeOnChannelClose(channel);
        }
    }

    public /* synthetic */ StandaloneV8Vm(Channel channel, DebugEventListener debugEventListener, AsyncPromise asyncPromise, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = "";
        }
        this(channel, debugEventListener, (AsyncPromise<? super V8Vm>)asyncPromise, string);
    }

    @Nullable
    public final MessagingLogger getDebugMessageQueue$intellij_javascript_v8_backend() {
        return this.debugMessageQueue;
    }

    @NotNull
    public StandaloneVmHelper getAttachStateManager() {
        return this.attachStateManager;
    }

    @Override
    protected boolean write(@NotNull ByteBuf content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        MessagingLogger messagingLogger = this.debugMessageQueue;
        if (messagingLogger != null) {
            MessagingLogger.add$default((MessagingLogger)messagingLogger, (ByteBuf)content, null, (int)2, null);
        }
        Channel channel = this.vmHelper.getChannelIfActive();
        if (channel == null) {
            content.release();
            return false;
        }
        ByteBuf buffer = channel.alloc().ioBuffer(64);
        buffer.writeBytes(StandaloneV8VmKt.access$getCONTENT_LENGTH_BYTES$p());
        int n = content.readableBytes();
        Intrinsics.checkNotNull((Object)buffer);
        BufferToCharsKt.writeIntAsAscii((int)n, (ByteBuf)buffer);
        buffer.writeBytes(StandaloneV8VmKt.access$getHEADER_TERMINATOR_BYTES_X2$p());
        channel.write((Object)buffer);
        return !channel.writeAndFlush((Object)content).isCancelled();
    }

    @NotNull
    public V8Request<Unit> createDisconnectRequest() {
        return ProtocolKt.Disconnect();
    }

    private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

