/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.v8.JSDebuggerV8BackendBundle;
import org.jetbrains.v8.V8SuspendContext;
import org.jetbrains.v8.V8SuspendContextManagerKt;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.protocol.BreakEventBody;
import org.jetbrains.v8.protocol.FrameDescriptor;
import org.jetbrains.v8.protocol.FrameInfo;
import org.jetbrains.v8.protocol.FunctionInfo;
import org.jetbrains.v8.protocol.GetFramesResult;
import org.jetbrains.v8.protocol.IncomingMessage;
import org.jetbrains.v8.protocol.ObjectDescriptor;
import org.jetbrains.v8.protocol.OriginalProtocolKt;
import org.jetbrains.v8.protocol.ProtocolKt;
import org.jetbrains.v8.protocol.ScriptHandle;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.protocol.V8ProtocolReader;
import org.jetbrains.v8.protocol.V8ProtocolUtilKt;
import org.jetbrains.v8.protocol.ValueHandle;
import org.jetbrains.v8.value.V8ExceptionData;
import org.jetbrains.v8.value.V8ValueManager;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f\u001aV\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"createException", "Lorg/jetbrains/debugger/ExceptionData;", "response", "Lorg/jetbrains/v8/protocol/IncomingMessage;", "body", "Lorg/jetbrains/v8/protocol/BreakEventBody;", "valueLoader", "Lorg/jetbrains/v8/value/V8ValueManager;", "processBreak", "", "event", "vm", "Lorg/jetbrains/v8/V8Vm;", "processBreakWithFrameInfo", "breakData", "eventName", "", "frame", "Lorg/jetbrains/v8/protocol/FrameDescriptor;", "hitBreakpoints", "", "objects", "", "Lorg/jetbrains/v8/protocol/ObjectDescriptor;", "frameCount", "", "intellij.javascript.v8.backend"})
public final class BreakEventHandlerKt {
    public static final void processBreak(@NotNull IncomingMessage event, @NotNull V8Vm vm) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        if (vm.getHasJbDebuggerSupport()) {
            V8ProtocolReader v8ProtocolReader = V8ProtocolUtilKt.getPROTOCOL_READER();
            JsonReaderEx jsonReaderEx = event.body();
            Intrinsics.checkNotNull((Object)jsonReaderEx);
            BreakEventBody breakData = v8ProtocolReader.readBreakEvent(jsonReaderEx);
            vm.getCommandProcessor().send((Request)ProtocolKt.GetFrames(0, 1)).onSuccess(arg_0 -> BreakEventHandlerKt.processBreak$lambda$0((Function1)new Function1<GetFramesResult, Unit>(breakData, event, vm){
                final /* synthetic */ BreakEventBody $breakData;
                final /* synthetic */ IncomingMessage $event;
                final /* synthetic */ V8Vm $vm;
                {
                    this.$breakData = $breakData;
                    this.$event = $event;
                    this.$vm = $vm;
                    super(1);
                }

                public final void invoke(GetFramesResult it) {
                    String string = this.$event.event();
                    Intrinsics.checkNotNull((Object)string);
                    BreakEventHandlerKt.processBreakWithFrameInfo(this.$breakData, this.$event, string, (FrameDescriptor)CollectionsKt.first(it.frames()), this.$breakData.breakpoints(), it.getObjects(), this.$vm, it.getTotalCount());
                }
            }, arg_0)).onError(arg_0 -> BreakEventHandlerKt.processBreak$lambda$1((Function1)new Function1<Throwable, Unit>(vm){
                final /* synthetic */ V8Vm $vm;
                {
                    this.$vm = $vm;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    if (!Intrinsics.areEqual((Object)"Connection closed", (Object)it.getMessage())) {
                        CommandProcessorKt.getLOG().error(it);
                        Object[] objectArray = new Object[]{it};
                        this.$vm.getDebugListener().errorOccurred(JSDebuggerV8BackendBundle.message("notification.error.cannot.stop.on.breakpoint", objectArray));
                        this.$vm.getCommandProcessor().send((Request)V8SuspendContextManagerKt.ContinueMessage(StepAction.CONTINUE, 0));
                    }
                }
            }, arg_0));
            return;
        }
        vm.getCommandProcessor().send((Request)OriginalProtocolKt.FrameMessage()).onSuccess(arg_0 -> BreakEventHandlerKt.processBreak$lambda$2((Function1)new Function1<FrameInfo, Unit>(event, vm){
            final /* synthetic */ IncomingMessage $event;
            final /* synthetic */ V8Vm $vm;
            {
                this.$event = $event;
                this.$vm = $vm;
                super(1);
            }

            public final void invoke(FrameInfo topFrame) {
                int n;
                V8ProtocolReader v8ProtocolReader = V8ProtocolUtilKt.getPROTOCOL_READER();
                JsonReaderEx jsonReaderEx = this.$event.body();
                Intrinsics.checkNotNull((Object)jsonReaderEx);
                BreakEventBody breakData = v8ProtocolReader.readBreakEvent(jsonReaderEx);
                V8SuspendContext context = null;
                ScriptHandle scriptHandle = breakData.getScript();
                if (scriptHandle != null) {
                    n = scriptHandle.getId();
                } else {
                    FunctionInfo functionInfo = topFrame.func();
                    n = functionInfo != null ? functionInfo.scriptId() : -1;
                }
                int scriptId = n;
                String string = this.$event.event();
                if (Intrinsics.areEqual((Object)string, (Object)"break")) {
                    List<Breakpoint> breakpoints = this.$vm.getBreakpointManager().findRelatedBreakpoints(scriptId, topFrame.line(), topFrame.column(), breakData.breakpoints());
                    context = new V8SuspendContext(scriptId, this.$vm, breakpoints, 0, 8, null);
                } else if (Intrinsics.areEqual((Object)string, (Object)"exception")) {
                    context = new V8SuspendContext(scriptId, this.$vm, null, 0, 12, null);
                    context.setExceptionData(BreakEventHandlerKt.access$createException(this.$event, breakData, context.getValueManager()));
                } else {
                    throw new IllegalStateException();
                }
                this.$vm.getSuspendContextManager().setContextAndNotify(context, topFrame);
            }
        }, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    public static final void processBreakWithFrameInfo(@Nullable BreakEventBody breakData, @Nullable IncomingMessage event, @NotNull String eventName, @NotNull FrameDescriptor frame, @Nullable int[] hitBreakpoints, @Nullable List<? extends ObjectDescriptor> objects, @NotNull V8Vm vm, int frameCount) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
            context = null;
            scriptId = frame.getScriptId();
            var10_10 = eventName;
            switch (var10_10.hashCode()) {
                case 1481625679: {
                    if (var10_10.equals("exception")) break;
                    ** break;
                }
                case -995321554: {
                    if (!var10_10.equals("paused")) {
                        ** break;
                    }
                    ** GOTO lbl17
                }
                case 94001407: {
                    if (!var10_10.equals("break")) ** break;
lbl17:
                    // 2 sources

                    context = new V8SuspendContext(scriptId, vm, vm.getBreakpointManager().findRelatedBreakpoints(scriptId, frame.getLine(), frame.getColumn(), hitBreakpoints), frameCount);
                    break block6;
                }
            }
            context = new V8SuspendContext(scriptId, vm, null, frameCount, 4, null);
            v0 = event;
            Intrinsics.checkNotNull((Object)v0);
            v1 = breakData;
            Intrinsics.checkNotNull((Object)v1);
            context.setExceptionData(BreakEventHandlerKt.createException(v0, v1, context.getValueManager()));
            break block6;
lbl26:
            // 4 sources

            throw new IllegalStateException();
        }
        context.getValueManager().store(objects);
        vm.getSuspendContextManager().loadScriptIfNeedSetContextAndNotify(context, frame);
    }

    public static /* synthetic */ void processBreakWithFrameInfo$default(BreakEventBody breakEventBody, IncomingMessage incomingMessage, String string, FrameDescriptor frameDescriptor, int[] nArray, List list, V8Vm v8Vm, int n, int n2, Object object) {
        if ((n2 & 0x80) != 0) {
            n = -1;
        }
        BreakEventHandlerKt.processBreakWithFrameInfo(breakEventBody, incomingMessage, string, frameDescriptor, nArray, list, v8Vm, n);
    }

    private static final ExceptionData createException(IncomingMessage response, BreakEventBody body, V8ValueManager valueLoader) {
        ValueHandle valueHandle = body.exception();
        Intrinsics.checkNotNull((Object)valueHandle);
        ValueHandle exception = valueHandle;
        Collection collection = response.refs();
        if (!(collection == null || collection.isEmpty())) {
            List<SomeHandle> list = response.refs();
            Intrinsics.checkNotNull(list);
            for (SomeHandle handle : list) {
                valueLoader.addHandleFromRefs(handle);
            }
        }
        return (ExceptionData)new V8ExceptionData(valueLoader.addHandleFromRefs(exception), body.uncaught(), body.sourceLineText(), exception.text());
    }

    private static final void processBreak$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void processBreak$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void processBreak$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ExceptionData access$createException(IncomingMessage response, BreakEventBody body, V8ValueManager valueLoader) {
        return BreakEventHandlerKt.createException(response, body, valueLoader);
    }
}

