/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.jetbrains.debugger.wip.HttpInetSocketAddress;
import com.jetbrains.debugger.wip.PageConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnectionKt;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.debugger.UtilKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.RemoteVmConnectionKt;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.io.webSocket.WebSocketProtocolHandler;
import org.jetbrains.io.webSocket.WebSocketProtocolHandshakeHandler;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.wip.BrowserWipVm;
import org.jetbrains.wip.NodeWipVm;
import org.jetbrains.wip.StandaloneWipVm;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.inspector.DetachedEventData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00013B\u001d\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J.\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0014J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0014J\u001e\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u001e\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0014J\"\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u001e\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020+2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0004J6\u0010,\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100.2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0014J#\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0010002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b1J&\u00102\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0004R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00064"}, d2={"Lcom/jetbrains/debugger/wip/WipRemoteVmConnection;", "Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "Lorg/jetbrains/wip/WipVm;", "url", "Lcom/intellij/util/Url;", "debugLogSuffix", "", "(Lcom/intellij/util/Url;Ljava/lang/String;)V", "currentPageTitle", "getDebugLogSuffix", "()Ljava/lang/String;", "getUrl", "()Lcom/intellij/util/Url;", "connectDebugger", "", "page", "Lcom/jetbrains/debugger/wip/PageConnection;", "context", "Lio/netty/channel/ChannelHandlerContext;", "result", "Lorg/jetbrains/concurrency/AsyncPromise;", "debugMessageQueue", "Lorg/jetbrains/debugger/MessagingLogger;", "connectToPage", "", "address", "Ljava/net/InetSocketAddress;", "connectionsJson", "Lio/netty/buffer/ByteBuf;", "connectedAddressToPresentation", "vm", "Lorg/jetbrains/debugger/Vm;", "createBootstrap", "Lio/netty/bootstrap/Bootstrap;", "vmResult", "createChannelHandler", "Lio/netty/channel/ChannelHandler;", "createVm", "Lorg/jetbrains/wip/StandaloneWipVm;", "channel", "Lio/netty/channel/Channel;", "handleExceptionOnGettingWebSockets", "e", "", "processPageConnections", "pageConnections", "", "readPageConnections", "Lcom/intellij/util/SmartList;", "readPageConnections$intellij_javascript_chrome_connector", "sendGetJson", "Companion", "intellij.javascript.chrome.connector"})
@SourceDebugExtension(value={"SMAP\nWipRemoteVmConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipRemoteVmConnection.kt\ncom/jetbrains/debugger/wip/WipRemoteVmConnection\n+ 2 netty.kt\ncom/intellij/util/io/NettyKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n39#2,6:278\n66#2,2:284\n66#2,2:287\n1#3:286\n*S KotlinDebug\n*F\n+ 1 WipRemoteVmConnection.kt\ncom/jetbrains/debugger/wip/WipRemoteVmConnection\n*L\n61#1:278,6\n112#1:284,2\n267#1:287,2\n*E\n"})
public class WipRemoteVmConnection
extends RemoteVmConnection<WipVm> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Url url;
    @Nullable
    private final String debugLogSuffix;
    @Nullable
    private String currentPageTitle;
    @NotNull
    private static final Lazy<NioEventLoopGroup> eventGroup$delegate = LazyKt.lazy((Function0)Companion.eventGroup.2.INSTANCE);

    public WipRemoteVmConnection(@Nullable Url url, @Nullable String debugLogSuffix) {
        this.url = url;
        this.debugLogSuffix = debugLogSuffix;
    }

    public /* synthetic */ WipRemoteVmConnection(Url url, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            url = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(url, string);
    }

    @Nullable
    public final Url getUrl() {
        return this.url;
    }

    @Nullable
    public String getDebugLogSuffix() {
        return this.debugLogSuffix;
    }

    @NotNull
    protected Bootstrap createBootstrap() {
        Bootstrap bootstrap2;
        BuiltInServerManager it = BuiltInServerManager.Companion.getInstance();
        boolean bl = false;
        if (it.getServerDisposable() != null) {
            bootstrap2 = it.createClientBootstrap();
        } else {
            Bootstrap bootstrap3 = NettyUtil.nioClientBootstrap((EventLoopGroup)((EventLoopGroup)Companion.getEventGroup()));
            bootstrap2 = bootstrap3;
            Intrinsics.checkNotNullExpressionValue((Object)bootstrap3, (String)"nioClientBootstrap(...)");
        }
        return bootstrap2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bootstrap createBootstrap(@NotNull InetSocketAddress address, @NotNull AsyncPromise<WipVm> vmResult) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        Bootstrap $this$handler$iv = this.createBootstrap();
        boolean $i$f$handler = false;
        $this$handler$iv.handler((ChannelHandler)new ChannelInitializer<Channel>(this, address, vmResult){
            final /* synthetic */ WipRemoteVmConnection this$0;
            final /* synthetic */ InetSocketAddress $address$inlined;
            final /* synthetic */ AsyncPromise $vmResult$inlined;
            {
                this.this$0 = wipRemoteVmConnection;
                this.$address$inlined = inetSocketAddress;
                this.$vmResult$inlined = asyncPromise;
            }

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Channel it = channel;
                boolean bl = false;
                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(0xA00000), this.this$0.createChannelHandler(this.$address$inlined, (AsyncPromise<WipVm>)this.$vmResult$inlined)};
                it.pipeline().addLast(channelHandlerArray);
            }
        });
        return var3_3;
    }

    @NotNull
    protected ChannelHandler createChannelHandler(@NotNull InetSocketAddress address, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        return (ChannelHandler)new SimpleChannelInboundHandlerAdapter<FullHttpResponse>(this, address, vmResult){
            final /* synthetic */ WipRemoteVmConnection this$0;
            final /* synthetic */ InetSocketAddress $address;
            final /* synthetic */ AsyncPromise<WipVm> $vmResult;
            {
                this.this$0 = $receiver;
                this.$address = $address;
                this.$vmResult = $vmResult;
            }

            public void channelActive(@NotNull ChannelHandlerContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                super.channelActive(context);
                this.this$0.sendGetJson(this.$address, context, this.$vmResult);
            }

            protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull FullHttpResponse message) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                try {
                    context.pipeline().remove((ChannelHandler)this);
                    ByteBuf byteBuf = message.content();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"content(...)");
                    this.this$0.connectToPage(context, this.$address, byteBuf, this.$vmResult);
                }
                catch (Throwable e) {
                    this.this$0.handleExceptionOnGettingWebSockets(e, this.$vmResult);
                }
            }

            public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                this.$vmResult.setError(cause);
                context.close();
            }
        };
    }

    protected final void handleExceptionOnGettingWebSockets(@NotNull Throwable e, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        if (e instanceof MalformedJsonException) {
            String host;
            String string = JSDebuggerBundle.message((String)"error.websocket.message", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object message = string;
            InetSocketAddress inetSocketAddress = this.getAddress();
            HttpInetSocketAddress httpInetSocketAddress = inetSocketAddress instanceof HttpInetSocketAddress ? (HttpInetSocketAddress)inetSocketAddress : null;
            String string2 = host = httpInetSocketAddress != null ? httpInetSocketAddress.getOriginalHostName() : null;
            if (!(host == null || NetUtil.isValidIpV4Address((String)host) || NetUtil.isValidIpV6Address((String)host) || Intrinsics.areEqual((Object)host, (Object)"localhost") || Intrinsics.areEqual((Object)host, (Object)"localhost6"))) {
                message = (String)message + "\n\n" + JSDebuggerBundle.message((String)"error.websocket.nodejs.message", (Object[])new Object[0]);
            }
            vmResult.setError((String)message);
        } else {
            vmResult.setError(e);
        }
    }

    protected final void sendGetJson(@NotNull InetSocketAddress address, @NotNull ChannelHandlerContext context, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/json");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)WipRemoteVmConnectionKt.toHttpHeaderHostField(address));
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
        ChannelFuture channelFuture = context.channel().writeAndFlush((Object)request);
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"writeAndFlush(...)");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener(new GenericFutureListener(vmResult){
            final /* synthetic */ AsyncPromise $vmResult$inlined;
            {
                this.$vmResult$inlined = asyncPromise;
            }

            public final void operationComplete(ChannelFuture it) {
                Intrinsics.checkNotNull((Object)it);
                ChannelFuture it2 = it;
                boolean bl = false;
                if (!it2.isSuccess()) {
                    Throwable throwable = it2.cause();
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"cause(...)");
                    this.$vmResult$inlined.setError(throwable);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String connectedAddressToPresentation(@NotNull InetSocketAddress address, @NotNull Vm vm) {
        Object object;
        String string;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)address, (String)"address");
                Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
                string = super.connectedAddressToPresentation(address, vm);
                object = this.currentPageTitle;
                if (object == null) break block2;
                String string2 = object;
                String string3 = string;
                boolean bl = false;
                String string4 = " \u2013 " + (String)it;
                string = string3;
                object = string4;
                if (string4 != null) break block3;
            }
            object = "";
        }
        return string + (String)object;
    }

    protected boolean connectToPage(@NotNull ChannelHandlerContext context, @NotNull InetSocketAddress address, @NotNull ByteBuf connectionsJson, @NotNull AsyncPromise<WipVm> result) {
        MessagingLogger debugMessageQueue;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)connectionsJson, (String)"connectionsJson");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        String string = this.getDebugLogSuffix();
        if (string == null) {
            string = "";
        }
        MessagingLogger messagingLogger = debugMessageQueue = UtilKt.createDebugLogger((String)"js.debugger.wip.log", (String)string);
        if (messagingLogger != null) {
            MessagingLogger logger = messagingLogger;
            boolean bl = false;
            logger.add(connectionsJson, "IN");
            result.onError(arg_0 -> WipRemoteVmConnection.connectToPage$lambda$5$lambda$4((Function1)new Function1<Throwable, Unit>(logger){
                final /* synthetic */ MessagingLogger $logger;
                {
                    this.$logger = $logger;
                    super(1);
                }

                public final void invoke(@NotNull Throwable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$logger.add((CharSequence)("\"" + it + "\""), "Error");
                    this.$logger.close();
                }
            }, arg_0));
        }
        if (!connectionsJson.isReadable()) {
            String string2 = JSDebuggerBundle.message((String)"error.websocket.malformed.message", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            result.setError(string2);
            return true;
        }
        SmartList<PageConnection> pageConnections = this.readPageConnections$intellij_javascript_chrome_connector(connectionsJson, address);
        return !this.processPageConnections(context, debugMessageQueue, (List)pageConnections, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final SmartList<PageConnection> readPageConnections$intellij_javascript_chrome_connector(@NotNull ByteBuf connectionsJson, @NotNull InetSocketAddress address) {
        Intrinsics.checkNotNullParameter((Object)connectionsJson, (String)"connectionsJson");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        pageConnections = new SmartList();
        var4_4 /* !! */  = (InputStream)new ByteBufInputStream(connectionsJson);
        var5_5 = Charsets.UTF_8;
        var4_4 /* !! */  = (Closeable)new JsonReader((Reader)new InputStreamReader(var4_4 /* !! */ , (Charset)var5_5));
        var5_5 = null;
        try {
            reader = (JsonReader)var4_4 /* !! */ ;
            $i$a$-use-WipRemoteVmConnection$readPageConnections$1 = false;
            if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                reader.beginArray();
            }
            while (reader.hasNext() && reader.peek() != JsonToken.END_DOCUMENT) {
                reader.beginObject();
                pageUrl = null;
                webSocketDebuggerUrl = null;
                title = null;
                type = null;
                id = null;
                block13: while (reader.hasNext()) {
                    block19: {
                        block20: {
                            block22: {
                                block21: {
                                    var13_15 = reader.nextName();
                                    if (var13_15 == null) break block19;
                                    switch (var13_15.hashCode()) {
                                        case 3355: {
                                            if (!var13_15.equals("id")) {
                                                ** break;
                                            }
                                            break block20;
                                        }
                                        case 110371416: {
                                            if (var13_15.equals("title")) break;
                                            ** break;
                                        }
                                        case 3575610: {
                                            if (!var13_15.equals("type")) {
                                                ** break;
                                            }
                                            break block21;
                                        }
                                        case -346402009: {
                                            if (!var13_15.equals("webSocketDebuggerUrl")) {
                                                ** break;
                                            }
                                            break block22;
                                        }
                                        case 116079: {
                                            if (!var13_15.equals("url")) ** break;
                                            pageUrl = reader.nextString();
                                            continue block13;
                                        }
                                    }
                                    title = reader.nextString();
                                    continue;
                                }
                                type = reader.nextString();
                                continue;
                            }
                            webSocketDebuggerUrl = reader.nextString();
                            continue;
                        }
                        id = reader.nextString();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                pageConnections.add((Object)new PageConnection(pageUrl, title, type, webSocketDebuggerUrl, id, address));
            }
            var6_6 = Unit.INSTANCE;
        }
        catch (Throwable var6_7) {
            var5_5 = var6_7;
            throw var6_7;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var4_4 /* !! */ , (Throwable)var5_5);
        }
        return pageConnections;
    }

    protected boolean processPageConnections(@NotNull ChannelHandlerContext context, @Nullable MessagingLogger debugMessageQueue, @NotNull List<PageConnection> pageConnections, @NotNull AsyncPromise<WipVm> result) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(pageConnections, (String)"pageConnections");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        SmartList debuggablePages = new SmartList();
        for (PageConnection p : pageConnections) {
            if (this.url == null) {
                debuggablePages.add((Object)p);
                continue;
            }
            String string = p.getUrl();
            Intrinsics.checkNotNull((Object)string);
            if (!Urls.INSTANCE.equals(this.url, Urls.newFromEncoded((String)string), SystemInfo.isFileSystemCaseSensitive, true)) continue;
            this.connectDebugger(p, context, result, debugMessageQueue);
            return true;
        }
        if (this.url == null) {
            RemoteVmConnectionKt.chooseDebuggee((Collection)((Collection)debuggablePages), (int)-1, (Function2)processPageConnections.1.INSTANCE).onSuccess(arg_0 -> WipRemoteVmConnection.processPageConnections$lambda$7((Function1)new Function1<PageConnection, Unit>(result, this, context, debugMessageQueue){
                final /* synthetic */ AsyncPromise<WipVm> $result;
                final /* synthetic */ WipRemoteVmConnection this$0;
                final /* synthetic */ ChannelHandlerContext $context;
                final /* synthetic */ MessagingLogger $debugMessageQueue;
                {
                    this.$result = $result;
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$debugMessageQueue = $debugMessageQueue;
                    super(1);
                }

                public final void invoke(PageConnection it) {
                    String webSocketDebuggerUrl = it.getWebSocketDebuggerUrl();
                    if (webSocketDebuggerUrl == null) {
                        String string = JSDebuggerBundle.message((String)"js.debug.another.debugger.attached", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.$result.setError(string);
                        return;
                    }
                    WipRemoteVmConnection.access$setCurrentPageTitle$p(this.this$0, it.getTitle());
                    Intrinsics.checkNotNull((Object)it);
                    this.this$0.connectDebugger(it, this.$context, this.$result, this.$debugMessageQueue);
                }
            }, arg_0)).onError(arg_0 -> WipRemoteVmConnection.processPageConnections$lambda$8((Function1)new Function1<Throwable, Unit>(result){
                final /* synthetic */ AsyncPromise<WipVm> $result;
                {
                    this.$result = $result;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    Intrinsics.checkNotNull((Object)it);
                    this.$result.setError(it);
                }
            }, arg_0));
        } else {
            Object[] objectArray = new Object[]{this.url};
            String string = JSDebuggerBundle.message((String)"error.connection.no.page", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            result.setError(string);
        }
        return true;
    }

    @NotNull
    protected StandaloneWipVm createVm(@NotNull PageConnection page, @NotNull Channel channel, @Nullable MessagingLogger debugMessageQueue) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        return Intrinsics.areEqual((Object)page.getType(), (Object)"node") ? (StandaloneWipVm)new NodeWipVm(this.getDebugEventListener(), page.getUrl(), channel, debugMessageQueue) : (StandaloneWipVm)new BrowserWipVm(this.getDebugEventListener(), page.getUrl(), channel, debugMessageQueue);
    }

    protected void connectDebugger(@NotNull PageConnection page, @NotNull ChannelHandlerContext context, @NotNull AsyncPromise<WipVm> result, @Nullable MessagingLogger debugMessageQueue) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        String string = page.getWebSocketDebuggerUrl();
        Intrinsics.checkNotNull((Object)string);
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)URI.create(string), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, null, (int)NettyUtil.MAX_CONTENT_LENGTH, (boolean)true, (boolean)false, (long)-1L, (boolean)false, (boolean)false);
        Channel channel = context.channel();
        Intrinsics.checkNotNull((Object)channel);
        StandaloneWipVm vm = this.createVm(page, channel, debugMessageQueue);
        vm.setTitle(page.getTitle());
        vm.getCommandProcessor().getEventMap().add((EventType)DetachedEventData.TYPE, (Function1)new Function1<DetachedEventData, Unit>(this){
            final /* synthetic */ WipRemoteVmConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DetachedEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)it.reason(), (Object)"targetCrashed")) {
                    this.this$0.close(ConnectionStatus.DISCONNECTED.getStatusText() + " (tab crashed)", ConnectionStatus.DISCONNECTED);
                } else {
                    this.this$0.close(ConnectionStatus.DISCONNECTED.getStatusText() + " (tab was closed or Web Inspector was opened)", ConnectionStatus.DETACHED);
                }
            }
        });
        ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new WebSocketProtocolHandshakeHandler(handshaker, vm, result){
            final /* synthetic */ StandaloneWipVm $vm;
            final /* synthetic */ AsyncPromise<WipVm> $result;
            {
                this.$vm = $vm;
                this.$result = $result;
                Intrinsics.checkNotNull((Object)$handshaker);
                super($handshaker);
            }

            protected void completed() {
                this.$vm.initDomains().then(arg_0 -> connectDebugger.2.completed$lambda$0(this.$result, this.$vm, arg_0));
            }

            public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                this.$result.setError(cause);
                context.fireExceptionCaught(cause);
            }

            private static final Promise completed$lambda$0(AsyncPromise $result, StandaloneWipVm $vm, Object it) {
                Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
                Intrinsics.checkNotNullParameter((Object)((Object)$vm), (String)"$vm");
                $result.setResult((Object)((Object)$vm));
                return $vm.ready();
            }
        }, new WebSocketFrameAggregator(NettyUtil.MAX_CONTENT_LENGTH), new WebSocketProtocolHandler(vm){
            final /* synthetic */ StandaloneWipVm $vm;
            {
                this.$vm = $vm;
            }

            protected void textFrameReceived(@NotNull Channel channel, @NotNull TextWebSocketFrame message) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.$vm.textFrameReceived(message);
            }
        }};
        channel.pipeline().addLast(channelHandlerArray);
        ChannelFuture channelFuture = handshaker.handshake(channel);
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"handshake(...)");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener(new GenericFutureListener(context){
            final /* synthetic */ ChannelHandlerContext $context$inlined;
            {
                this.$context$inlined = channelHandlerContext;
            }

            public final void operationComplete(ChannelFuture it) {
                Intrinsics.checkNotNull((Object)it);
                ChannelFuture it2 = it;
                boolean bl = false;
                if (!it2.isSuccess()) {
                    this.$context$inlined.fireExceptionCaught(it2.cause());
                }
            }
        });
    }

    private static final void connectToPage$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void processPageConnections$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void processPageConnections$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public WipRemoteVmConnection() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ void access$setCurrentPageTitle$p(WipRemoteVmConnection $this, String string) {
        $this.currentPageTitle = string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/debugger/wip/WipRemoteVmConnection$Companion;", "", "()V", "eventGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "getEventGroup", "()Lio/netty/channel/nio/NioEventLoopGroup;", "eventGroup$delegate", "Lkotlin/Lazy;", "intellij.javascript.chrome.connector"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NioEventLoopGroup getEventGroup() {
            Lazy lazy = eventGroup$delegate;
            return (NioEventLoopGroup)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

