/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.google.common.collect.BiMap;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.execution.JSLocalFilesMappingPanel;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PortField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.CollapsibleRow;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.HttpInetSocketAddress;
import com.jetbrains.debugger.wip.JSRemoteDebugConfiguration;
import com.jetbrains.debugger.wip.JSRemoteDebugConfigurationKt;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.debugger.wip.WipWithExclusiveWebsocketChannelVmConnection;
import com.jetbrains.nodeJs.NodeJSFileFinder;
import com.jetbrains.nodeJs.NodeJsDebugProcess;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DebuggableRunConfiguration;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.v8.StandaloneV8Vm;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.wip.WipVm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005:\u0001DB\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J*\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020*2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u000205H\u0016J\"\u00106\u001a\u0002072\u0006\u0010/\u001a\u00020*2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0002J\"\u00108\u001a\u0002092\u0006\u0010/\u001a\u00020*2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0002J\u0010\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0;H\u0016J\u001a\u0010<\u001a\u0004\u0018\u00010,2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u000205H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0002H\u0016J\u0010\u0010C\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0002H\u0016R*\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001e\u0010$\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0015\"\u0004\b&\u0010\u0017\u00a8\u0006E"}, d2={"Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lorg/jdom/Element;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "Lcom/intellij/javascript/JSRunProfileWithCompileBeforeLaunchOption;", "Lorg/jetbrains/debugger/DebuggableRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "value", "host", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "isV8Legacy", "", "()Z", "setV8Legacy", "(Z)V", "<set-?>", "", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "mappings", "getMappings", "()Ljava/util/List;", "port", "", "getPort", "()I", "setPort", "(I)V", "restartOnDisconnect", "getRestartOnDisconnect", "setRestartOnDisconnect", "clone", "Lcom/intellij/execution/configurations/RunConfiguration;", "computeDebugAddress", "Ljava/net/InetSocketAddress;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "createDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "socketAddress", "session", "Lcom/intellij/xdebugger/XDebugSession;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "createV8LegacyDebugProcess", "Lcom/jetbrains/nodeJs/NodeJsDebugProcess;", "createWipDebugProcess", "Lcom/jetbrains/debugger/wip/BrowserChromeDebugProcess;", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "getState", "executor", "Lcom/intellij/execution/Executor;", "env", "readExternal", "", "element", "writeExternal", "WipRemoteDebugConfigurationSettingsEditor", "intellij.javascript.chrome.connector"})
public final class JSRemoteDebugConfiguration
extends LocatableConfigurationBase<Element>
implements RunConfigurationWithSuppressedDefaultRunAction,
JSRunProfileWithCompileBeforeLaunchOption,
DebuggableRunConfiguration {
    @Attribute
    @Nullable
    private String host;
    @Attribute
    private int port;
    @Attribute
    private boolean isV8Legacy;
    @Attribute
    private boolean restartOnDisconnect;
    @Property(surroundWithTag=false)
    @XCollection
    @NotNull
    private List<RemoteUrlMappingBean> mappings;

    public JSRemoteDebugConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(project, factory, name);
        this.port = 9229;
        this.mappings = (List)new SmartList();
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@Nullable String value) {
        this.host = StringUtil.isEmpty((String)value) || Intrinsics.areEqual((Object)value, (Object)"localhost") || Intrinsics.areEqual((Object)value, (Object)"127.0.0.1") ? null : value;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    public final boolean isV8Legacy() {
        return this.isV8Legacy;
    }

    public final void setV8Legacy(boolean bl) {
        this.isV8Legacy = bl;
    }

    public final boolean getRestartOnDisconnect() {
        return this.restartOnDisconnect;
    }

    public final void setRestartOnDisconnect(boolean bl) {
        this.restartOnDisconnect = bl;
    }

    @NotNull
    public final List<RemoteUrlMappingBean> getMappings() {
        return this.mappings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new WipRemoteDebugConfigurationSettingsEditor();
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        return EmptyRunProfileState.INSTANCE;
    }

    @NotNull
    public RunConfiguration clone() {
        RunConfiguration runConfiguration = super.clone();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.debugger.wip.JSRemoteDebugConfiguration");
        JSRemoteDebugConfiguration configuration = (JSRemoteDebugConfiguration)runConfiguration;
        configuration.setHost(this.host);
        configuration.port = this.port;
        configuration.isV8Legacy = this.isV8Legacy;
        configuration.restartOnDisconnect = this.restartOnDisconnect;
        configuration.mappings = (List)new SmartList((Collection)this.mappings);
        return (RunConfiguration)configuration;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)((Object)this), (Element)element);
        if (this.port <= 0) {
            this.port = 9229;
        }
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)((Object)this), (Element)element, (SerializationFilter)((SerializationFilter)JSRemoteDebugConfigurationKt.access$getSERIALIZATION_FILTER$p()));
    }

    @NotNull
    public InetSocketAddress computeDebugAddress(@NotNull RunProfileState state) {
        InetSocketAddress inetSocketAddress;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String string = this.host;
        if (string != null) {
            String it = string;
            boolean bl = false;
            inetSocketAddress = new HttpInetSocketAddress(it, this.port);
        } else {
            InetAddress inetAddress = InetAddress.getLoopbackAddress();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getLoopbackAddress(...)");
            inetSocketAddress = new HttpInetSocketAddress(inetAddress, this.port);
        }
        return inetSocketAddress;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        JavaScriptDebugProcess debugProcess;
        Intrinsics.checkNotNullParameter((Object)socketAddress, (String)"socketAddress");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        JavaScriptDebugProcess javaScriptDebugProcess = debugProcess = this.isV8Legacy ? (JavaScriptDebugProcess)this.createV8LegacyDebugProcess(socketAddress, session, executionResult) : (JavaScriptDebugProcess)this.createWipDebugProcess(socketAddress, session, executionResult);
        if (this.restartOnDisconnect) {
            debugProcess.getConnection().stateChanged((Function1)new Function1<ConnectionState, Unit>(session){
                final /* synthetic */ XDebugSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(@NotNull ConnectionState it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (it.getStatus() == ConnectionStatus.DISCONNECTED && !Intrinsics.areEqual((Object)this.$session.getDebugProcess().getProcessHandler().getUserData(ProcessHandler.TERMINATION_REQUESTED), (Object)true)) {
                        AppUIUtil.invokeOnEdt(() -> createDebugProcess.1.invoke$lambda$0(this.$session));
                    }
                }

                private static final void invoke$lambda$0(XDebugSession $session) {
                    Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
                    ExecutionUtil.restart((RunContentDescriptor)$session.getRunContentDescriptor());
                }
            });
        }
        return (XDebugProcess)debugProcess;
    }

    private final BrowserChromeDebugProcess createWipDebugProcess(InetSocketAddress socketAddress, XDebugSession session, ExecutionResult executionResult) {
        WipWithExclusiveWebsocketChannelVmConnection connection2 = new WipWithExclusiveWebsocketChannelVmConnection();
        RemoteDebuggingFileFinder finder = new RemoteDebuggingFileFinder(RemoteDebuggingFileFinderKt.createUrlToLocalMap(this.mappings), (DebuggableFileFinder)new LocalFileSystemFileFinder());
        BrowserChromeDebugProcess process = new BrowserChromeDebugProcess(session, (DebuggableFileFinder)finder, (VmConnection<? extends WipVm>)((VmConnection)connection2), executionResult);
        RemoteVmConnection.open$default((RemoteVmConnection)connection2, (InetSocketAddress)socketAddress, null, (int)2, null);
        return process;
    }

    private final NodeJsDebugProcess createV8LegacyDebugProcess(InetSocketAddress socketAddress, XDebugSession session, ExecutionResult executionResult) {
        RemoteVmConnection<Vm> connection2 = new RemoteVmConnection<Vm>(session){
            final /* synthetic */ XDebugSession $session;
            {
                this.$session = $session;
            }

            @NotNull
            public Bootstrap createBootstrap(@NotNull InetSocketAddress address, @NotNull AsyncPromise<Vm> vmResult) {
                Intrinsics.checkNotNullParameter((Object)address, (String)"address");
                Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
                Bootstrap bootstrap2 = BuiltInServerManager.Companion.getInstance().createClientBootstrap();
                EventDispatcher dispatcher = this.getDispatcher();
                bootstrap2.handler((ChannelHandler)new ChannelInitializer<Channel>(this, address, (EventDispatcher<DebugEventListener>)dispatcher, this.$session, vmResult){
                    final /* synthetic */ createV8LegacyDebugProcess.connection.1 this$0;
                    final /* synthetic */ InetSocketAddress $address;
                    final /* synthetic */ EventDispatcher<DebugEventListener> $dispatcher;
                    final /* synthetic */ XDebugSession $session;
                    final /* synthetic */ AsyncPromise<Vm> $vmResult;
                    {
                        this.this$0 = $receiver;
                        this.$address = $address;
                        this.$dispatcher = $dispatcher;
                        this.$session = $session;
                        this.$vmResult = $vmResult;
                    }

                    protected void initChannel(@NotNull Channel ch) {
                        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                        ScheduledFuture<?> connectToWip2 = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> createV8LegacyDebugProcess.connection.createBootstrap.1.initChannel$lambda$1(this.$address, this.$dispatcher, this.$session, this.$vmResult), 3L, TimeUnit.SECONDS);
                        AsyncPromise v8Attempt = new AsyncPromise();
                        v8Attempt.then(arg_0 -> createV8LegacyDebugProcess.connection.createBootstrap.1.initChannel$lambda$2((Function1)new Function1<Vm, Vm>(this.$vmResult){
                            final /* synthetic */ AsyncPromise<Vm> $vmResult;
                            {
                                this.$vmResult = $vmResult;
                                super(1);
                            }

                            public final Vm invoke(Vm vm) {
                                this.$vmResult.setResult((Object)vm);
                                return vm;
                            }
                        }, arg_0)).onError(arg_0 -> createV8LegacyDebugProcess.connection.createBootstrap.1.initChannel$lambda$3((Function1)new Function1<Throwable, Unit>(this.$vmResult){
                            final /* synthetic */ AsyncPromise<Vm> $vmResult;
                            {
                                this.$vmResult = $vmResult;
                                super(1);
                            }

                            public final void invoke(Throwable e) {
                                Intrinsics.checkNotNull((Object)e);
                                this.$vmResult.setError(e);
                            }
                        }, arg_0)).onProcessed(arg_0 -> createV8LegacyDebugProcess.connection.createBootstrap.1.initChannel$lambda$4((Function1)new Function1<Vm, Unit>(connectToWip2){
                            final /* synthetic */ ScheduledFuture<?> $connectToWip;
                            {
                                this.$connectToWip = $connectToWip;
                                super(1);
                            }

                            public final void invoke(Vm it) {
                                this.$connectToWip.cancel(true);
                            }
                        }, arg_0));
                        new StandaloneV8Vm(ch, createV8LegacyDebugProcess.connection.1.access$getDebugEventListener(this.this$0), (AsyncPromise<? super V8Vm>)v8Attempt, "");
                    }

                    private static final WipVm initChannel$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (WipVm)((Object)$tmp0.invoke(p0));
                    }

                    private static final void initChannel$lambda$1(InetSocketAddress $address, EventDispatcher $dispatcher, XDebugSession $session, AsyncPromise $vmResult) {
                        Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
                        Intrinsics.checkNotNullParameter((Object)$dispatcher, (String)"$dispatcher");
                        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
                        Intrinsics.checkNotNullParameter((Object)$vmResult, (String)"$vmResult");
                        WipRemoteVmConnection wipConnection2 = new WipRemoteVmConnection((EventDispatcher<DebugEventListener>)$dispatcher){
                            final /* synthetic */ EventDispatcher<DebugEventListener> $dispatcher;
                            {
                                this.$dispatcher = $dispatcher;
                                super(null, null, 3, null);
                            }

                            @NotNull
                            public EventDispatcher<DebugEventListener> getDispatcher() {
                                return this.$dispatcher;
                            }
                        };
                        AsyncPromise wipResult = new AsyncPromise();
                        wipResult.then(arg_0 -> createV8LegacyDebugProcess.connection.createBootstrap.1.initChannel$lambda$1$lambda$0((Function1)new Function1<WipVm, WipVm>($session, (AsyncPromise<Vm>)$vmResult){
                            final /* synthetic */ XDebugSession $session;
                            final /* synthetic */ AsyncPromise<Vm> $vmResult;
                            {
                                this.$session = $session;
                                this.$vmResult = $vmResult;
                                super(1);
                            }

                            public final WipVm invoke(WipVm vm) {
                                Object[] objectArray = new Object[]{JSDebuggerBundle.message((String)"js.remote.debug.inspector.protocol", (Object[])new Object[0])};
                                String string = JSDebuggerBundle.message((String)"js.remote.debug.inspector.protocol.detected", (Object[])objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                String message = string;
                                this.$session.reportMessage(message, MessageType.INFO);
                                this.$vmResult.setResult((Object)((Object)vm));
                                return vm;
                            }
                        }, arg_0));
                        Bootstrap wipBootstrap = wipConnection2.createBootstrap($address, (AsyncPromise<WipVm>)wipResult);
                        NettyKt.connectRetrying$default((Bootstrap)wipBootstrap, (InetSocketAddress)$address, (int)2, null, (int)4, null);
                    }

                    private static final Vm initChannel$lambda$2(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (Vm)$tmp0.invoke(p0);
                    }

                    private static final void initChannel$lambda$3(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }

                    private static final void initChannel$lambda$4(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }
                });
                return bootstrap2;
            }

            public static final /* synthetic */ DebugEventListener access$getDebugEventListener(createV8LegacyDebugProcess.connection.1 $this) {
                return $this.getDebugEventListener();
            }
        };
        BiMap biMap = RemoteDebuggingFileFinderKt.createUrlToLocalMap(this.mappings);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RemoteDebuggingFileFinder finder = new RemoteDebuggingFileFinder(biMap, (DebuggableFileFinder)new NodeJSFileFinder(project));
        NodeJsDebugProcess process = new NodeJsDebugProcess(session, (VmConnection<Vm>)((VmConnection)connection2), (DebuggableFileFinder)finder, false, executionResult);
        RemoteVmConnection.open$default((RemoteVmConnection)((RemoteVmConnection)connection2), (InetSocketAddress)socketAddress, null, (int)2, null);
        return process;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration$WipRemoteDebugConfigurationSettingsEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;", "(Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;)V", "filesMappingPanel", "Lcom/intellij/javascript/debugger/execution/JSLocalFilesMappingPanel;", "hostField", "Ljavax/swing/JTextField;", "kotlin.jvm.PlatformType", "portField", "Lcom/intellij/ui/PortField;", "restartOnDisconnectCheckbox", "Lcom/intellij/ui/components/JBCheckBox;", "v8RadioButton", "Lcom/intellij/ui/components/JBRadioButton;", "wipRadioButton", "applyEditorTo", "", "configuration", "createEditor", "Ljavax/swing/JComponent;", "resetEditorFrom", "intellij.javascript.chrome.connector"})
    private final class WipRemoteDebugConfigurationSettingsEditor
    extends SettingsEditor<JSRemoteDebugConfiguration> {
        private final JTextField hostField = GuiUtils.createUndoableTextField();
        @NotNull
        private final PortField portField = new PortField(9229, 1024);
        private JBRadioButton wipRadioButton;
        private JBRadioButton v8RadioButton;
        private JBCheckBox restartOnDisconnectCheckbox;
        @NotNull
        private final JSLocalFilesMappingPanel filesMappingPanel;

        public WipRemoteDebugConfigurationSettingsEditor() {
            Project project = JSRemoteDebugConfiguration.this.getProject();
            BorderLayout borderLayout = new BorderLayout();
            this.filesMappingPanel = new JSLocalFilesMappingPanel(project, borderLayout){
                {
                    Intrinsics.checkNotNull((Object)$super_call_param$1);
                    super($super_call_param$1, (LayoutManager)$super_call_param$2);
                }

                public void initUI() {
                    this.add(this.getMappingTreePanel());
                    super.initUI();
                }

                @NotNull
                public String getBaseUrl() {
                    String string = hostField.getText();
                    if (string == null) {
                        return super.getBaseUrl();
                    }
                    String host = string;
                    int port = portField.getNumber();
                    return "http://" + host + ":" + port + "/";
                }
            };
        }

        protected void resetEditorFrom(@NotNull JSRemoteDebugConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            this.hostField.setText(StringUtil.notNullize((String)configuration.getHost(), (String)"localhost"));
            this.portField.setNumber(configuration.getPort());
            JBRadioButton jBRadioButton = this.wipRadioButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"wipRadioButton");
                jBRadioButton = null;
            }
            jBRadioButton.setSelected(!configuration.isV8Legacy());
            JBRadioButton jBRadioButton2 = this.v8RadioButton;
            if (jBRadioButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"v8RadioButton");
                jBRadioButton2 = null;
            }
            jBRadioButton2.setSelected(configuration.isV8Legacy());
            JBCheckBox jBCheckBox = this.restartOnDisconnectCheckbox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"restartOnDisconnectCheckbox");
                jBCheckBox = null;
            }
            jBCheckBox.setSelected(configuration.getRestartOnDisconnect());
            this.filesMappingPanel.resetEditorFrom(configuration.getMappings(), true);
        }

        protected void applyEditorTo(@NotNull JSRemoteDebugConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            configuration.setHost(this.hostField.getText());
            configuration.setPort(this.portField.getNumber());
            JBRadioButton jBRadioButton = this.v8RadioButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"v8RadioButton");
                jBRadioButton = null;
            }
            configuration.setV8Legacy(jBRadioButton.isSelected());
            JBCheckBox jBCheckBox = this.restartOnDisconnectCheckbox;
            if (jBCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"restartOnDisconnectCheckbox");
                jBCheckBox = null;
            }
            configuration.setRestartOnDisconnect(jBCheckBox.isSelected());
            this.filesMappingPanel.applyEditorTo(JSRemoteDebugConfiguration.this.getMappings(), (RunConfiguration)configuration);
        }

        @NotNull
        protected JComponent createEditor() {
            this.filesMappingPanel.initUI();
            return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
                final /* synthetic */ WipRemoteDebugConfigurationSettingsEditor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Panel $this$panel) {
                    CollapsibleRow collapsibleRow;
                    Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                    String string = JSDebuggerBundle.message((String)"js.remote.debug.host", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ WipRemoteDebugConfigurationSettingsEditor this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            $this$row.cell((JComponent)WipRemoteDebugConfigurationSettingsEditor.access$getHostField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                        }
                    });
                    String string2 = JSDebuggerBundle.message((String)"js.remote.debug.port", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ WipRemoteDebugConfigurationSettingsEditor this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            $this$row.cell((JComponent)WipRemoteDebugConfigurationSettingsEditor.access$getPortField$p(this.this$0));
                        }
                    });
                    Panel.group$default((Panel)$this$panel, (String)JSDebuggerBundle.message((String)"js.remote.debug.attach.to", (Object[])new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                        final /* synthetic */ WipRemoteDebugConfigurationSettingsEditor this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Panel $this$group) {
                            Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                            Panel.buttonsGroup$default((Panel)$this$group, null, (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                                final /* synthetic */ WipRemoteDebugConfigurationSettingsEditor this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull Panel $this$buttonsGroup) {
                                    Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
                                    Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                                        final /* synthetic */ WipRemoteDebugConfigurationSettingsEditor this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull Row $this$row) {
                                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                            String string = JSDebuggerBundle.message((String)"js.remote.debug.inspector.protocol", (Object[])new Object[0]);
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                            WipRemoteDebugConfigurationSettingsEditor.access$setWipRadioButton$p(this.this$0, (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent());
                                        }
                                    }), (int)1, null);
                                    Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                                        final /* synthetic */ WipRemoteDebugConfigurationSettingsEditor this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull Row $this$row) {
                                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                            String string = JSDebuggerBundle.message((String)"js.remote.debug.node.protocol", (Object[])new Object[0]);
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                            WipRemoteDebugConfigurationSettingsEditor.access$setV8RadioButton$p(this.this$0, (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent());
                                        }
                                    }), (int)1, null);
                                }
                            }), (int)3, null);
                        }
                    }), (int)2, null);
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ WipRemoteDebugConfigurationSettingsEditor this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            String string = JSDebuggerBundle.message((String)"js.remote.debug.restart.on.disconnect", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            WipRemoteDebugConfigurationSettingsEditor.access$setRestartOnDisconnectCheckbox$p(this.this$0, (JBCheckBox)$this$row.checkBox(string).getComponent());
                        }
                    }), (int)1, null);
                    String string3 = JSDebuggerBundle.message((String)"label.text.remote.urls.of.local.files", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    CollapsibleRow $this$invoke_u24lambda_u240 = collapsibleRow = Panel.collapsibleGroup$default((Panel)$this$panel, (String)string3, (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                        final /* synthetic */ WipRemoteDebugConfigurationSettingsEditor this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Panel $this$collapsibleGroup) {
                            Intrinsics.checkNotNullParameter((Object)$this$collapsibleGroup, (String)"$this$collapsibleGroup");
                            Panel.row$default((Panel)$this$collapsibleGroup, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                                final /* synthetic */ WipRemoteDebugConfigurationSettingsEditor this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull Row $this$row) {
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                    $this$row.cell((JComponent)WipRemoteDebugConfigurationSettingsEditor.access$getFilesMappingPanel$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                                }
                            }), (int)1, null);
                        }
                    }), (int)2, null);
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.setExpanded(true);
                }
            }));
        }

        public static final /* synthetic */ void access$setWipRadioButton$p(WipRemoteDebugConfigurationSettingsEditor $this, JBRadioButton jBRadioButton) {
            $this.wipRadioButton = jBRadioButton;
        }

        public static final /* synthetic */ void access$setV8RadioButton$p(WipRemoteDebugConfigurationSettingsEditor $this, JBRadioButton jBRadioButton) {
            $this.v8RadioButton = jBRadioButton;
        }

        public static final /* synthetic */ void access$setRestartOnDisconnectCheckbox$p(WipRemoteDebugConfigurationSettingsEditor $this, JBCheckBox jBCheckBox) {
            $this.restartOnDisconnectCheckbox = jBCheckBox;
        }

        public static final /* synthetic */ JSLocalFilesMappingPanel access$getFilesMappingPanel$p(WipRemoteDebugConfigurationSettingsEditor $this) {
            return $this.filesMappingPanel;
        }
    }
}

