/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.debugger.wip.ChromeLocalConnectedTabsService;
import com.jetbrains.debugger.wip.PageConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnectionKt;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0005J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000bR4\u0010\u0003\u001a(\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006 \b*\u0012\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u001d\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\u0006\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\n\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/debugger/wip/ChromeLocalConnectedTabsService;", "Lcom/intellij/openapi/Disposable;", "()V", "registeredTabs", "", "Lcom/jetbrains/debugger/wip/PageConnection;", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "tabsToReuse", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/execution/configurations/RunProfile;", "addTabToReuse", "", "runProfile", "page", "dispose", "getRunProfile", "getTabToReuse", "intellij.javascript.chrome.connector"})
@SourceDebugExtension(value={"SMAP\nChromeLocalConnectedTabsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromeLocalConnectedTabsService.kt\ncom/jetbrains/debugger/wip/ChromeLocalConnectedTabsService\n+ 2 netty.kt\ncom/intellij/util/io/NettyKt\n*L\n1#1,65:1\n39#2,6:66\n*S KotlinDebug\n*F\n+ 1 ChromeLocalConnectedTabsService.kt\ncom/jetbrains/debugger/wip/ChromeLocalConnectedTabsService\n*L\n35#1:66,6\n*E\n"})
public final class ChromeLocalConnectedTabsService
implements Disposable {
    @NotNull
    private final Set<PageConnection> registeredTabs;
    @NotNull
    private final ConcurrentMap<RunProfile, PageConnection> tabsToReuse;

    public ChromeLocalConnectedTabsService() {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.registeredTabs = set;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.tabsToReuse = concurrentMap;
    }

    @Nullable
    public final PageConnection getTabToReuse(@NotNull RunProfile runProfile) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        return (PageConnection)this.tabsToReuse.get(this.getRunProfile(runProfile));
    }

    public final void addTabToReuse(@NotNull RunProfile runProfile, @NotNull PageConnection page) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        if (page.getId() != null) {
            this.registeredTabs.add(page);
            ((Map)this.tabsToReuse).put(this.getRunProfile(runProfile), page);
        }
    }

    public void dispose() {
        if (this.registeredTabs.isEmpty()) {
            return;
        }
        Map<InetSocketAddress, List<Object>> map = this.registeredTabs.stream().collect(Collectors.groupingBy(arg_0 -> ChromeLocalConnectedTabsService.dispose$lambda$0((Function1)dispose.connections.1.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue(map, (String)"collect(...)");
        Map<InetSocketAddress, List<Object>> connections2 = map;
        for (Map.Entry<InetSocketAddress, List<Object>> entry : connections2.entrySet()) {
            InetSocketAddress address = entry.getKey();
            List<Object> tabs = entry.getValue();
            Bootstrap $this$handler$iv = BuiltInServerManager.Companion.getInstance().createClientBootstrap();
            boolean $i$f$handler = false;
            $this$handler$iv.handler((ChannelHandler)new ChannelInitializer<Channel>(tabs){
                final /* synthetic */ List $tabs$inlined;
                {
                    this.$tabs$inlined = list;
                }

                protected void initChannel(@NotNull Channel channel) {
                    Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                    Channel it = channel;
                    boolean bl = false;
                    ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(0xA00000), new SimpleChannelInboundHandlerAdapter<FullHttpResponse>((List<PageConnection>)this.$tabs$inlined){
                        final /* synthetic */ List<PageConnection> $tabs;
                        {
                            this.$tabs = $tabs;
                        }

                        protected void messageReceived(@Nullable ChannelHandlerContext context, @Nullable FullHttpResponse message) {
                        }

                        public void channelActive(@NotNull ChannelHandlerContext context) {
                            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                            super.channelActive(context);
                            for (PageConnection page : this.$tabs) {
                                String string = page.getId();
                                Intrinsics.checkNotNull((Object)string);
                                this.sendCloseTab(context, string, page.getAddress());
                            }
                        }

                        private final void sendCloseTab(ChannelHandlerContext context, String tab, InetSocketAddress address) {
                            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/json/close/" + tab);
                            request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)WipRemoteVmConnectionKt.toHttpHeaderHostField(address));
                            request.headers().set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
                            context.channel().writeAndFlush((Object)request);
                        }
                    }};
                    it.pipeline().addLast(channelHandlerArray);
                }
            });
            $this$handler$iv.connect((SocketAddress)address);
        }
    }

    private final RunProfile getRunProfile(RunProfile runProfile) {
        RunProfile runProfile2 = WrappingRunConfiguration.unwrapRunProfile((RunProfile)runProfile);
        Intrinsics.checkNotNullExpressionValue((Object)runProfile2, (String)"unwrapRunProfile(...)");
        return runProfile2;
    }

    private static final InetSocketAddress dispose$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (InetSocketAddress)$tmp0.invoke(p0);
    }
}

