/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.FunctionStepIntoVariant;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptLineBreakpointManager;
import com.intellij.javascript.debugger.SyntheticSuspendBreakpointInfo;
import com.intellij.javascript.debugger.V8ValueMarkerProvider;
import com.intellij.javascript.debugger.console.ConsoleMessage;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.ConsolePrinterSettings;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PatternUtil;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.ChromeDebugProcessKt;
import com.jetbrains.debugger.wip.WipConsoleAPICalled;
import com.jetbrains.debugger.wip.WipConsoleMessageTask;
import com.jetbrains.debugger.wip.WipExceptionThrown;
import com.jetbrains.debugger.wip.WipLogEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.V8VmKt;
import org.jetbrains.wip.NodeWipVm;
import org.jetbrains.wip.SerializableValue;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipFunction;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.org.jetbrains.wip.WipCssManager;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.console.MessageAddedEventData;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.debugger.ScriptPosition;
import org.jetbrains.wip.protocol.log.EntryAddedEventData;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventData;
import org.jetbrains.wip.protocol.runtime.ExceptionThrownEventData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\b\u0016\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020%H\u0014J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190)2\u0006\u0010\u001a\u001a\u00020\u0003H\u0004J\n\u0010*\u001a\u0004\u0018\u00010\u000eH\u0016J\u001e\u0010+\u001a\u0004\u0018\u00010,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.2\u0006\u0010\"\u001a\u00020#H\u0014J\b\u0010/\u001a\u00020\u000fH\u0014J\u0010\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000eH\u0002J\u0010\u00102\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0014J \u00103\u001a\u00020\u00192\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u000205H\u0016J\u0010\u00108\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u00109\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u000e\u0010:\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u000fJ@\u0010;\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020=2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010>\u001a\u0004\u0018\u00010\u000e2\u0012\u0010?\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0018\u00010@H\u0016R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006A"}, d2={"Lcom/jetbrains/debugger/wip/ChromeDebugProcess;", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/wip/WipVm;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "finder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "connection", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/javascript/debugger/DebuggableFileFinder;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/execution/ExecutionResult;)V", "blackBoxCache", "Ljava/util/WeakHashMap;", "Lcom/intellij/util/Url;", "", "isFilesOnlyInLocalFileSystem", "()Z", "valueMarkerProvider", "Lcom/intellij/javascript/debugger/V8ValueMarkerProvider;", "getValueMarkerProvider", "()Lcom/intellij/javascript/debugger/V8ValueMarkerProvider;", "valueMarkerProvider$delegate", "Lkotlin/Lazy;", "beforeInitBreakpoints", "", "vm", "Lorg/jetbrains/debugger/Vm;", "clearBlackboxing", "compareFunctions", "expectedFunction", "Lcom/intellij/javascript/debugger/FunctionStepIntoVariant;", "topFrame", "Lorg/jetbrains/debugger/CallFrame;", "script", "Lorg/jetbrains/debugger/Script;", "configureConsolePrinter", "Lcom/intellij/javascript/debugger/console/ConsolePrinterSettings;", "enableBlackboxing", "state", "evaluateProcessName", "Lorg/jetbrains/concurrency/Promise;", "getCurrentLocationUrl", "getSyntheticSuspend", "Lcom/intellij/javascript/debugger/SyntheticSuspendBreakpointInfo;", "context", "Lorg/jetbrains/debugger/SuspendContext;", "isFilePathRegexpCreator", "needsBlackboxing", "sourceUrl", "onStart", "registerAdditionalActions", "leftToolbar", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "topToolbar", "settings", "registerVmPrintEvents", "setBlackboxing", "setMuteBreakpoints", "sourceMapFound", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "scriptUrl", "setPromises", "", "intellij.javascript.chrome.connector"})
@SourceDebugExtension(value={"SMAP\nChromeDebugProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromeDebugProcess.kt\ncom/jetbrains/debugger/wip/ChromeDebugProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n1855#2,2:332\n1549#2:334\n1620#2,3:335\n1549#2:338\n1620#2,3:339\n1855#2:342\n1549#2:343\n1620#2,3:344\n1856#2:347\n1747#2,3:348\n1855#2,2:351\n*S KotlinDebug\n*F\n+ 1 ChromeDebugProcess.kt\ncom/jetbrains/debugger/wip/ChromeDebugProcess\n*L\n195#1:332,2\n204#1:334\n204#1:335,3\n206#1:338\n206#1:339,3\n210#1:342\n212#1:343\n212#1:344,3\n210#1:347\n257#1:348,3\n266#1:351,2\n*E\n"})
public class ChromeDebugProcess
extends JavaScriptDebugProcess<VmConnection<? extends WipVm>> {
    @NotNull
    private final WeakHashMap<Url, Boolean> blackBoxCache;
    @NotNull
    private final Lazy valueMarkerProvider$delegate;

    public ChromeDebugProcess(@NotNull XDebugSession session, @NotNull DebuggableFileFinder finder, @NotNull VmConnection<? extends WipVm> connection2, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        Intrinsics.checkNotNullParameter(connection2, (String)"connection");
        super(session, finder, connection2, executionResult);
        this.blackBoxCache = new WeakHashMap();
        connection2.executeOnStart((Function1)new Function1<WipVm, Unit>((Object)this){

            public final void invoke(@NotNull WipVm p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                ((ChromeDebugProcess)((Object)this.receiver)).onStart(p0);
            }
        });
        this.setCssManager(new WipCssManager((JavaScriptDebugProcess)this));
        connection2.addDebugListener(new DebugEventListener(){

            public void navigated(@NotNull String newUrl) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ ChromeDebugProcess this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = ChromeDebugProcess.access$getConsolePrinter(this.this$0).clear((Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                    WipCssManager wipCssManager = this.getCssManager();
                    if (wipCssManager == null) break block0;
                    wipCssManager.clear();
                }
            }
        });
        session.addSessionListener(new XDebugSessionListener(){

            public void breakpointsMuted(boolean muted) {
                this.setMuteBreakpoints(muted);
            }
        });
        this.valueMarkerProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<valueMarkerProvider.1>(this){
            final /* synthetic */ ChromeDebugProcess this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final valueMarkerProvider.1 invoke() {
                return new V8ValueMarkerProvider(this.this$0){

                    @Nullable
                    public String getRefId(@Nullable Value value) {
                        return value instanceof SerializableValue ? ((SerializableValue)value).getRefId() : null;
                    }
                };
            }
        }));
    }

    public /* synthetic */ ChromeDebugProcess(XDebugSession xDebugSession, DebuggableFileFinder debuggableFileFinder, VmConnection vmConnection, ExecutionResult executionResult, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            executionResult = null;
        }
        this(xDebugSession, debuggableFileFinder, (VmConnection<? extends WipVm>)vmConnection, executionResult);
    }

    protected void onStart(@NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.registerVmPrintEvents(vm);
        vm.setRegisterVmPrintEvents((Function1<? super WipVm, Unit>)((Function1)new Function1<WipVm, Unit>((Object)this){

            public final void invoke(@NotNull WipVm p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                ChromeDebugProcess.access$registerVmPrintEvents((ChromeDebugProcess)((Object)this.receiver), p0);
            }
        }));
        int asyncCallStackDepth = Registry.get((String)"js.debugger.async.call.stack.depth").asInteger();
        vm.getCommandProcessor().send((Request)DebuggerKt.SetAsyncCallStackDepth(asyncCallStackDepth));
    }

    @NotNull
    protected ConsolePrinterSettings configureConsolePrinter() {
        return new ConsolePrinterSettings((Function2)configureConsolePrinter.1.INSTANCE);
    }

    private final void registerVmPrintEvents(WipVm vm) {
        ChromeDebugProcess.registerVmPrintEvents$addMessageHandler(vm, this, ConsoleAPICalledEventData.TYPE, (Function1)new Function1<ConsoleAPICalledEventData, ConsoleMessage>(vm){
            final /* synthetic */ WipVm $vm;
            {
                this.$vm = $vm;
                super(1);
            }

            @NotNull
            public final ConsoleMessage invoke(@NotNull ConsoleAPICalledEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new WipConsoleAPICalled(it, this.$vm);
            }
        });
        ChromeDebugProcess.registerVmPrintEvents$addMessageHandler(vm, this, EntryAddedEventData.TYPE, (Function1)new Function1<EntryAddedEventData, ConsoleMessage>(vm){
            final /* synthetic */ WipVm $vm;
            {
                this.$vm = $vm;
                super(1);
            }

            @NotNull
            public final ConsoleMessage invoke(@NotNull EntryAddedEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new WipLogEntry(it.entry(), this.$vm.getNetworkManager().retrieveRequest(it.entry().getNetworkRequestId()));
            }
        });
        ChromeDebugProcess.registerVmPrintEvents$addMessageHandler(vm, this, ExceptionThrownEventData.TYPE, (Function1)new Function1<ExceptionThrownEventData, ConsoleMessage>(vm){
            final /* synthetic */ WipVm $vm;
            {
                this.$vm = $vm;
                super(1);
            }

            @NotNull
            public final ConsoleMessage invoke(@NotNull ExceptionThrownEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new WipExceptionThrown(it, this.$vm);
            }
        });
        ChromeDebugProcess.registerVmPrintEvents$addMessageHandler(vm, this, MessageAddedEventData.TYPE, (Function1)new Function1<MessageAddedEventData, ConsoleMessage>(vm){
            final /* synthetic */ WipVm $vm;
            {
                this.$vm = $vm;
                super(1);
            }

            @NotNull
            public final ConsoleMessage invoke(@NotNull MessageAddedEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new WipConsoleMessageTask(it.message(), this.$vm, this.$vm.getNetworkManager().retrieveRequest(it.message().getNetworkRequestId()));
            }
        });
    }

    @Nullable
    public Url getCurrentLocationUrl() {
        WipVm wipVm = (WipVm)this.getActiveOrMainVm();
        return wipVm != null ? wipVm.getCurrentUrl() : null;
    }

    @NotNull
    public V8ValueMarkerProvider getValueMarkerProvider() {
        Lazy lazy = this.valueMarkerProvider$delegate;
        return (V8ValueMarkerProvider)lazy.getValue();
    }

    @Nullable
    protected SyntheticSuspendBreakpointInfo getSyntheticSuspend(@NotNull SuspendContext<?> context, @NotNull Script script) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Vm vm = context.getVm();
        if (context instanceof WipSuspendContext && ((WipSuspendContext)context).isBreakOnStart()) {
            this.initBreakpoints();
            if (!Intrinsics.areEqual((Object)vm, (Object)this.getMainVm()) && vm instanceof NodeWipVm) {
                this.evaluateProcessName((WipVm)vm).onProcessed(arg_0 -> ChromeDebugProcess.getSyntheticSuspend$lambda$0((Function1)new Function1<Unit, Unit>(this, vm){
                    final /* synthetic */ ChromeDebugProcess this$0;
                    final /* synthetic */ Vm $vm;
                    {
                        this.this$0 = $receiver;
                        this.$vm = $vm;
                        super(1);
                    }

                    public final void invoke(@Nullable Unit it) {
                        this.this$0.resume(this.$vm);
                    }
                }, arg_0));
            } else {
                this.resume(vm);
            }
            return SyntheticSuspendBreakpointInfo.Companion.getSKIP();
        }
        return JavaScriptDebugProcess.processBreakpointsHit$default((JavaScriptDebugProcess)this, context, (Script)script, null, (int)4, null);
    }

    protected boolean compareFunctions(@NotNull FunctionStepIntoVariant expectedFunction, @NotNull CallFrame topFrame, @NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)expectedFunction, (String)"expectedFunction");
        Intrinsics.checkNotNullParameter((Object)topFrame, (String)"topFrame");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        FunctionValue functionValue = expectedFunction.getRuntimeMethodInfo();
        WipFunction expectedRuntimeMethodInfo = functionValue instanceof WipFunction ? (WipFunction)functionValue : null;
        LocationValue currentFunctionLocation = ((WipCallFrame)topFrame).getFunctionLocation();
        if (expectedRuntimeMethodInfo == null || currentFunctionLocation == null) {
            return super.compareFunctions(expectedFunction, topFrame, script);
        }
        return expectedRuntimeMethodInfo.getOpenParenColumn() == currentFunctionLocation.getColumnNumber() && expectedRuntimeMethodInfo.getOpenParenLine() == currentFunctionLocation.getLineNumber() && Intrinsics.areEqual((Object)expectedRuntimeMethodInfo.getScriptId(), (Object)currentFunctionLocation.scriptId());
    }

    @NotNull
    protected final Promise<Unit> evaluateProcessName(@NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        EvaluateContext evaluateContext2 = vm.getEvaluateContext();
        Intrinsics.checkNotNull((Object)evaluateContext2);
        Promise promise2 = EvaluateContext.evaluate$default((EvaluateContext)evaluateContext2, (String)"process.pid + \"|\" + process.argv.join(\",\")", null, (boolean)false, null, (int)14, null).then(arg_0 -> ChromeDebugProcess.evaluateProcessName$lambda$1((Function1)new Function1<EvaluateResult, Unit>(vm){
            final /* synthetic */ WipVm $vm;
            {
                this.$vm = $vm;
                super(1);
            }

            public final void invoke(EvaluateResult evaluateResult) {
                block2: {
                    Object object;
                    if (evaluateResult.getWasThrown()) break block2;
                    Object object2 = evaluateResult.getValue().getValueString();
                    if (object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (char[])(object = new char[]{'|'}), (boolean)false, (int)0, (int)6, null)) != null) {
                        object = object2;
                        WipVm wipVm = this.$vm;
                        Object parts = object;
                        boolean bl = false;
                        String string = V8VmKt.computeName$default((List)parts, 0, 2, null);
                        if (string != null) {
                            String it = string;
                            boolean bl2 = false;
                            wipVm.setPresentableName(it);
                        }
                    }
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    public boolean isFilesOnlyInLocalFileSystem() {
        return this.getVm() instanceof NodeWipVm;
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        Intrinsics.checkNotNullParameter((Object)leftToolbar, (String)"leftToolbar");
        Intrinsics.checkNotNullParameter((Object)topToolbar, (String)"topToolbar");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super.registerAdditionalActions(leftToolbar, topToolbar, settings);
        settings.addAction((AnAction)new JavaScriptDebugProcess.WatchLastMethodReturnValueAction(), Constraints.FIRST);
    }

    public void beforeInitBreakpoints(@NotNull Vm vm) {
        boolean breakOnFirstStatement;
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        ((WipVm)vm).getCommandProcessor().send((Request)DebuggerKt.SetSkipAllPauses(this.getSession().areBreakpointsMuted()));
        if (JavaScriptDebuggerSettings.getInstance().isDoNotStepIntoLibraryCode()) {
            this.setBlackboxing((WipVm)vm);
        }
        super.beforeInitBreakpoints(vm);
        RunProfile runProfile = this.getSession().getRunProfile();
        boolean bl = breakOnFirstStatement = runProfile instanceof JavaScriptDebugConfiguration ? ((JavaScriptDebugConfiguration)runProfile).isUseFirstLineBreakpoints() : Registry.is((String)"js.debugger.break.on.first.statement");
        if (breakOnFirstStatement) {
            if (vm instanceof NodeWipVm) {
                JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default((JavaScriptLineBreakpointManager)this.getLineBreakpointManager(), (Vm)vm, (String)".*", null, (int)4, null);
            } else {
                ((WipVm)vm).getBreakpointManager().setBreakOnFirstStatement();
            }
        }
    }

    protected void enableBlackboxing(boolean state, @NotNull Vm vm) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        if (state != !this.getDisableDoNotStepIntoLibraries() || this.getPatternsUpdateNeeded()) {
            if (state && JavaScriptDebuggerSettings.getInstance().isDoNotStepIntoLibraryCode()) {
                this.setBlackboxing((WipVm)vm);
            } else {
                this.clearBlackboxing((WipVm)vm);
            }
        }
        super.enableBlackboxing(state, vm);
    }

    private final void clearBlackboxing(WipVm vm) {
        vm.getCommandProcessor().send((Request)DebuggerKt.SetBlackboxPatterns(CollectionsKt.emptyList()));
        Iterable $this$forEach$iv = (Iterable)this.getBlackBoxedScripts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JavaScriptDebugProcess.ScriptRanges scriptRange = (JavaScriptDebugProcess.ScriptRanges)element$iv;
            boolean bl = false;
            vm.getCommandProcessor().send((Request)DebuggerKt.SetBlackboxedRanges(scriptRange.getScriptId(), CollectionsKt.listOf((Object)((Object)new ScriptPosition(Integer.MAX_VALUE, Integer.MAX_VALUE)))));
        }
        this.setPatternsUpdateNeeded(false);
    }

    /*
     * WARNING - void declaration
     */
    private final void setBlackboxing(WipVm vm) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2 = this.getLibraryPatterns();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            Regex regex = (Regex)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toString());
        }
        List patterns = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        List list = JavaScriptDebuggerSettings.getInstance().getEnabledSteppingFilters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEnabledSteppingFilters(...)");
        Iterable $i$f$map22 = list;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(PatternUtil.convertToRegex((String)it));
        }
        List customStepFilters = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        patterns.addAll(customStepFilters);
        vm.getCommandProcessor().send((Request)DebuggerKt.SetBlackboxPatterns(patterns));
        Iterable $this$forEach$iv = (Iterable)this.getBlackBoxedScripts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<ScriptPosition> collection2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Object item$iv$iv;
            JavaScriptDebugProcess.ScriptRanges scriptRanges = (JavaScriptDebugProcess.ScriptRanges)element$iv;
            boolean bl = false;
            item$iv$iv = scriptRanges.getRanges();
            CharSequence charSequence = scriptRanges.getScriptId();
            WipCommandProcessor wipCommandProcessor = vm.getCommandProcessor();
            boolean $i$f$map3 = false;
            void var14_24 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                Pair pair = (Pair)item$iv$iv2;
                collection2 = destination$iv$iv3;
                boolean bl3 = false;
                int line = ((Number)pair.component1()).intValue();
                int column = ((Number)pair.component2()).intValue();
                collection2.add(new ScriptPosition(line, column));
            }
            collection2 = (List)destination$iv$iv3;
            wipCommandProcessor.send((Request)DebuggerKt.SetBlackboxedRanges(charSequence, (List<ScriptPosition>)collection2));
        }
        this.setPatternsUpdateNeeded(false);
    }

    public void sourceMapFound(@NotNull Vm vm, @NotNull SourceMap map, @Nullable Script script, @Nullable Url scriptUrl, @Nullable List<Promise<?>> setPromises) {
        boolean startsWithUnmappedRegion;
        MappingEntry currentMapping;
        Script script2;
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        super.sourceMapFound(vm, map, script, scriptUrl, setPromises);
        Script script3 = script;
        if (script3 == null) {
            ScriptManager scriptManager = vm.getScriptManager();
            Url url = scriptUrl;
            Intrinsics.checkNotNull((Object)url);
            script3 = scriptManager.findScriptByUrl(url);
        }
        WipScript wipScript = (script2 = script3) instanceof WipScript ? (WipScript)script2 : null;
        if (wipScript == null) {
            return;
        }
        WipScript wipScript2 = wipScript;
        if (this.needsBlackboxing(wipScript2.getUrl())) {
            return;
        }
        JavaScriptDebugProcess.ScriptRanges scriptRanges = new JavaScriptDebugProcess.ScriptRanges((CharSequence)wipScript2.getId());
        boolean currentRegionBlackboxed = false;
        MappingEntry mappingEntry = currentMapping = map.getGeneratedMappings().getByIndex(0);
        Intrinsics.checkNotNull((Object)mappingEntry);
        boolean bl = startsWithUnmappedRegion = mappingEntry.getGeneratedLine() != 0 || currentMapping.getGeneratedColumn() != 0;
        if (startsWithUnmappedRegion) {
            scriptRanges.getRanges().add(new Pair((Object)0, (Object)0));
            currentRegionBlackboxed = true;
        }
        while (currentMapping != null) {
            boolean bl2;
            int currentSource = currentMapping.getSource();
            if ((currentSource == -1 || this.needsBlackboxing(map.getSources()[currentSource])) != currentRegionBlackboxed) {
                scriptRanges.getRanges().add(new Pair((Object)currentMapping.getGeneratedLine(), (Object)currentMapping.getGeneratedColumn()));
                currentRegionBlackboxed = !currentRegionBlackboxed;
            }
            do {
                MappingEntry mappingEntry2 = currentMapping;
                MappingEntry mappingEntry3 = currentMapping = mappingEntry2 != null ? mappingEntry2.getNextGenerated() : null;
                if (mappingEntry3 != null) {
                    if (mappingEntry3.getSource() == currentSource) {
                        bl2 = true;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                bl2 = false;
            } while (bl2);
        }
        if (!((Collection)scriptRanges.getRanges()).isEmpty()) {
            this.getBlackBoxedScripts().add((Object)scriptRanges);
            this.setPatternsUpdateNeeded(true);
        }
    }

    private final boolean needsBlackboxing(Url sourceUrl) {
        boolean bl;
        block4: {
            if (((Map)this.blackBoxCache).containsKey(sourceUrl)) {
                Boolean bl2 = this.blackBoxCache.get(sourceUrl);
                Intrinsics.checkNotNull((Object)bl2);
                return bl2;
            }
            Iterable $this$any$iv = this.getLibraryPatterns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex pattern = (Regex)element$iv;
                    boolean bl3 = false;
                    String string = sourceUrl.trimParameters().toDecodedForm();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toDecodedForm(...)");
                    if (!pattern.matches((CharSequence)string)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean needBlackboxing = bl || this.matchesCustomStepFilter(sourceUrl);
        Boolean bl4 = needBlackboxing;
        ((Map)this.blackBoxCache).put(sourceUrl, bl4);
        return needBlackboxing;
    }

    public final void setMuteBreakpoints(boolean state) {
        Iterable $this$forEach$iv = this.getCollectVMs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vm vm = (Vm)element$iv;
            boolean bl = false;
            Object object = vm instanceof WipVm ? (WipVm)vm : null;
            if (object == null || (object = object.getCommandProcessor()) == null) continue;
            object.send((Request)DebuggerKt.SetSkipAllPauses(state));
        }
    }

    protected boolean isFilePathRegexpCreator() {
        return this.getMainVm() instanceof NodeWipVm;
    }

    private static final <T> void registerVmPrintEvents$addMessageHandler(WipVm $vm, ChromeDebugProcess this$0, EventType<T, ProtocolResponseReader> type, Function1<? super T, ? extends ConsoleMessage> messageFactory) {
        $vm.getCommandProcessor().getEventMap().add(type, new Function1<T, Unit>($vm, this$0, messageFactory){
            final /* synthetic */ WipVm $vm;
            final /* synthetic */ ChromeDebugProcess this$0;
            final /* synthetic */ Function1<T, ConsoleMessage> $messageFactory;
            {
                this.$vm = $vm;
                this.this$0 = $receiver;
                this.$messageFactory = $messageFactory;
                super(1);
            }

            public final void invoke(T messageData) {
                if (!ChromeDebugProcessKt.access$isWorkerMessage(messageData, (Vm)this.$vm)) {
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$vm, messageData, this.$messageFactory, null){
                        int label;
                        final /* synthetic */ ChromeDebugProcess this$0;
                        final /* synthetic */ WipVm $vm;
                        final /* synthetic */ T $messageData;
                        final /* synthetic */ Function1<T, ConsoleMessage> $messageFactory;
                        {
                            this.this$0 = $receiver;
                            this.$vm = $vm;
                            this.$messageData = $messageData;
                            this.$messageFactory = $messageFactory;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = ConsolePrinter.submitMessage$default((ConsolePrinter)ChromeDebugProcess.access$getConsolePrinter(this.this$0), (Vm)((Vm)this.$vm), (boolean)false, this.$messageData, this.$messageFactory, (Continuation)((Continuation)this), (int)2, null);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                }
            }
        });
    }

    private static final void getSyntheticSuspend$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit evaluateProcessName$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$registerVmPrintEvents(ChromeDebugProcess $this, WipVm vm) {
        $this.registerVmPrintEvents(vm);
    }

    public static final /* synthetic */ ConsolePrinter access$getConsolePrinter(ChromeDebugProcess $this) {
        return $this.getConsolePrinter();
    }
}

