/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.attach;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.ConfigurationSelectionUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkWithHoverInfo;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.IdeEventQueue;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.attach.JSDebuggerUrlFilter;
import com.intellij.javascript.debugger.attach.JSDebuggerUrlFilterKt;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0014R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter;", "Lcom/intellij/execution/filters/UrlFilter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myCurrentLink", "Lkotlin/Pair;", "Ljavax/swing/JComponent;", "Ljava/awt/Rectangle;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "buildHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "url", "JSDebuggerStarterHyperlinkInfo", "intellij.javascript.chrome.connector"})
@SourceDebugExtension(value={"SMAP\nJSDebuggerUrlFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSDebuggerUrlFilter.kt\ncom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,139:1\n12474#2,2:140\n12474#2,2:142\n*S KotlinDebug\n*F\n+ 1 JSDebuggerUrlFilter.kt\ncom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter\n*L\n42#1:140,2\n48#1:142,2\n*E\n"})
public final class JSDebuggerUrlFilter
extends UrlFilter {
    @Nullable
    private Pair<? extends JComponent, ? extends Rectangle> myCurrentLink;

    public JSDebuggerUrlFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        block5: {
            block4: {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                    if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"://", (boolean)false, (int)2, null)) break block4;
                    String[] $this$any$iv = JSDebuggerUrlFilterKt.access$getDEBUGGABLE_URL_PREFIXES$p();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String element$iv;
                        String it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (bl) break block5;
            }
            return null;
        }
        return super.applyFilter(line, entireLength);
    }

    @NotNull
    protected HyperlinkInfo buildHyperlinkInfo(@NotNull String url) {
        boolean bl;
        HyperlinkInfo baseHyperlinkInfo;
        block2: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            HyperlinkInfo hyperlinkInfo = super.buildHyperlinkInfo(url);
            Intrinsics.checkNotNullExpressionValue((Object)hyperlinkInfo, (String)"buildHyperlinkInfo(...)");
            baseHyperlinkInfo = hyperlinkInfo;
            String[] $this$any$iv = JSDebuggerUrlFilterKt.access$getDEBUGGABLE_URL_PREFIXES$p();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)url, (String)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (!bl) {
            return baseHyperlinkInfo;
        }
        return (HyperlinkInfo)new JSDebuggerStarterHyperlinkInfo(url, baseHyperlinkInfo);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter$JSDebuggerStarterHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkWithHoverInfo;", "url", "", "baseHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "(Lcom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter;Ljava/lang/String;Lcom/intellij/execution/filters/HyperlinkInfo;)V", "getUrl", "()Ljava/lang/String;", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "onMouseEntered", "hostComponent", "Ljavax/swing/JComponent;", "linkBounds", "Ljava/awt/Rectangle;", "onMouseExited", "showNotification", "startRunConfiguration", "intellij.javascript.chrome.connector"})
    @SourceDebugExtension(value={"SMAP\nJSDebuggerUrlFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSDebuggerUrlFilter.kt\ncom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter$JSDebuggerStarterHyperlinkInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n766#2:140\n857#2,2:141\n1549#2:143\n1620#2,3:144\n*S KotlinDebug\n*F\n+ 1 JSDebuggerUrlFilter.kt\ncom/intellij/javascript/debugger/attach/JSDebuggerUrlFilter$JSDebuggerStarterHyperlinkInfo\n*L\n68#1:140\n68#1:141,2\n76#1:143\n76#1:144,3\n*E\n"})
    public final class JSDebuggerStarterHyperlinkInfo
    implements HyperlinkWithHoverInfo {
        @NotNull
        private final String url;
        @NotNull
        private final HyperlinkInfo baseHyperlinkInfo;

        public JSDebuggerStarterHyperlinkInfo(@NotNull String url, HyperlinkInfo baseHyperlinkInfo) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)baseHyperlinkInfo, (String)"baseHyperlinkInfo");
            this.url = url;
            this.baseHyperlinkInfo = baseHyperlinkInfo;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public void navigate(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AWTEvent currentEvent = IdeEventQueue.Companion.getInstance().getTrueCurrentEvent();
            if (currentEvent instanceof MouseEvent && UIUtil.isControlKeyDown((MouseEvent)((MouseEvent)currentEvent)) && ((MouseEvent)currentEvent).isShiftDown()) {
                this.startRunConfiguration(project);
            } else {
                this.showNotification(project);
                this.baseHyperlinkInfo.navigate(project);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void startRunConfiguration(Project project) {
            void $this$filterTo$iv$iv;
            JavascriptDebugConfigurationType javascriptDebugConfigurationType = JavascriptDebugConfigurationType.getTypeInstance();
            Intrinsics.checkNotNullExpressionValue((Object)javascriptDebugConfigurationType, (String)"getTypeInstance(...)");
            JavascriptDebugConfigurationType factory = javascriptDebugConfigurationType;
            RunManager runManager = RunManager.Companion.getInstance(project);
            RunManagerImpl runManagerImpl = runManager instanceof RunManagerImpl ? (RunManagerImpl)runManager : null;
            if (runManagerImpl == null) {
                return;
            }
            RunManagerImpl runManager2 = runManagerImpl;
            Iterable $this$filter$iv = runManager2.getConfigurationSettingsList((ConfigurationType)factory);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
                boolean bl = false;
                RunConfiguration runConfiguration = it.getConfiguration();
                JavaScriptDebugConfiguration javaScriptDebugConfiguration = runConfiguration instanceof JavaScriptDebugConfiguration ? (JavaScriptDebugConfiguration)runConfiguration : null;
                if (!Intrinsics.areEqual((Object)(javaScriptDebugConfiguration != null ? javaScriptDebugConfiguration.getUri() : null), (Object)this.url)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List availableConfigurationSettings = (List)destination$iv$iv;
            if (availableConfigurationSettings.size() == 1) {
                ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)((RunnerAndConfigurationSettings)availableConfigurationSettings.get(0)), (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
            } else if (availableConfigurationSettings.size() > 1) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = availableConfigurationSettings;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    RunnerAndConfigurationSettings bl = (RunnerAndConfigurationSettings)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.getConfiguration());
                }
                List configurations = (List)destination$iv$iv2;
                ListPopup popup2 = ConfigurationSelectionUtil.createPopup((Project)project, (RunManagerImpl)runManager2, (List)configurations, (arg_0, arg_1) -> JSDebuggerStarterHyperlinkInfo.startRunConfiguration$lambda$2((Function2)new Function2<List<RunConfiguration>, ExecutionTarget, Unit>(runManager2){
                    final /* synthetic */ RunManagerImpl $runManager;
                    {
                        this.$runManager = $runManager;
                        super(2);
                    }

                    public final void invoke(List<RunConfiguration> selected, ExecutionTarget executionTarget) {
                        for (RunConfiguration configuration : selected) {
                            Intrinsics.checkNotNull((Object)configuration);
                            RunnerAndConfigurationSettings settings = this.$runManager.findSettings(configuration);
                            if (settings == null) continue;
                            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
                        }
                    }
                }, arg_0, arg_1));
                AWTEvent event = IdeEventQueue.Companion.getInstance().getTrueCurrentEvent();
                if (event instanceof MouseEvent) {
                    popup2.show(new RelativePoint((MouseEvent)event));
                } else {
                    popup2.showInFocusCenter();
                }
            } else {
                RunnerAndConfigurationSettings configurationSettings = runManager2.createConfiguration("JavaScript Debug", (ConfigurationFactory)factory);
                configurationSettings.setTemporary(true);
                RunConfiguration runConfiguration = configurationSettings.getConfiguration();
                Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
                JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runConfiguration;
                configuration.setUri(this.url);
                configuration.setGeneratedName();
                runManager2.addConfiguration(configurationSettings);
                runManager2.setSelectedConfiguration(configurationSettings);
                ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configurationSettings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
            }
        }

        private final void showNotification(Project project) {
            Pair pair = JSDebuggerUrlFilter.this.myCurrentLink;
            if (pair == null) {
                return;
            }
            Pair currentLink = pair;
            Disposable disposable = Disposer.newDisposable((Disposable)((Disposable)project), (String)"js.debugger.terminal.start.debugger.from.url");
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable notificationDisposable = disposable;
            Object[] objectArray = new Object[]{SystemInfo.isMac ? "Cmd" : "Ctrl"};
            String string = JSDebuggerBundle.message((String)"js.debugger.terminal.start.debugger.from.url", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            GotItTooltip gotItTooltip = new GotItTooltip("js.debugger.terminal.start.debugger.from.url", message, notificationDisposable).withPosition(Balloon.Position.above);
            String string2 = JSDebuggerBundle.message((String)"js.debugger.terminal.start.debugger.from.url.more", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            GotItTooltip tooltip2 = gotItTooltip.withLink(string2, (Function0)showNotification.tooltip.1.INSTANCE);
            if (!tooltip2.canShow()) {
                Disposer.dispose((Disposable)notificationDisposable);
                return;
            }
            tooltip2.show((JComponent)currentLink.getFirst(), (Function2)new Function2<Component, Balloon, Point>((Pair<? extends JComponent, ? extends Rectangle>)currentLink){
                final /* synthetic */ Pair<JComponent, Rectangle> $currentLink;
                {
                    this.$currentLink = $currentLink;
                    super(2);
                }

                @NotNull
                public final Point invoke(@Nullable Component component, @NotNull Balloon balloon) {
                    Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
                    BalloonImpl balloonImpl = (BalloonImpl)balloon;
                    Rectangle bounds = (Rectangle)this.$currentLink.getSecond();
                    int shiftY = BalloonImpl.getAbstractPositionFor((Balloon.Position)Balloon.Position.below) != balloonImpl.getPosition() ? 0 : bounds.height;
                    return new Point(bounds.x + Math.min(JBUIScale.scale((int)20), bounds.width / 2), bounds.y + shiftY);
                }
            });
        }

        public void onMouseEntered(@NotNull JComponent hostComponent, @NotNull Rectangle linkBounds) {
            Intrinsics.checkNotNullParameter((Object)hostComponent, (String)"hostComponent");
            Intrinsics.checkNotNullParameter((Object)linkBounds, (String)"linkBounds");
            JSDebuggerUrlFilter.this.myCurrentLink = new Pair((Object)hostComponent, (Object)linkBounds);
        }

        public void onMouseExited() {
            JSDebuggerUrlFilter.this.myCurrentLink = null;
        }

        private static final void startRunConfiguration$lambda$2(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }
    }
}

