from common import RegisterStacking
from common.cortex_m import CPUID, ARM_CPUID_PARTNO_MASK, MPU_CTRL, FPU_CPACR, ARM_CP_10_11_MASK, deref_long_from_addr,\
    line_by_part_num, ARM_CM0, ARM_CM0_plus, ARM_CM1, ARM_CM3, ARM_CM4, ARM_CM7, ARM_CM23, ARM_CM33, ARM_CM55

cortex_m0_stack_offsets = {'sp': -1, 'pc': 0x38, 'lr': 0x34, 'r0': 0x20, 'r1': 0x24, 'r2': 0x28,
                           'r3': 0x2c, 'r4': 0x10, 'r5': 0x14, 'r6': 0x18, 'r7': 0x1c, 'r8': 0x00,
                           'r9': 0x04, 'r10': 0x08, 'r11': 0x0c, 'r12': 0x30}
# there is no official port of FreeRTOS to m0+/m1 families.
# consider these equal to m0.

cortex_m3_stack_offsets = {'sp': -1, 'pc': 0x38, 'lr': 0x34, 'r0': 0x20, 'r1': 0x24, 'r2': 0x28,
                           'r3': 0x2c, 'r4': 0x00, 'r5': 0x04, 'r6': 0x08, 'r7': 0x0c, 'r8': 0x10,
                           'r9': 0x14, 'r10': 0x18, 'r11': 0x1c, 'r12': 0x30}

cortex_m3_mpu_stack_offsets = {'sp': -1, 'pc': 0x3c, 'lr': 0x38, 'r0': 0x24, 'r1': 0x28, 'r2': 0x2c,
                               'r3': 0x30, 'r4': 0x04, 'r5': 0x08, 'r6': 0x0c, 'r7': 0x10,
                               'r8': 0x14, 'r9': 0x18, 'r10': 0x1c, 'r11': 0x20, 'r12': 0x34}

cortex_m4_stack_offsets = {'sp': -1, 'pc': 0x3c, 'lr': 0x38, 'r0': 0x24, 'r1': 0x28, 'r2': 0x2c,
                           'r3': 0x30, 'r4': 0x00, 'r5': 0x04, 'r6': 0x08, 'r7': 0x0c, 'r8': 0x10,
                           'r9': 0x14, 'r10': 0x18, 'r11': 0x1c, 'r12': 0x34}

cortex_m4f_fpu_stack_offsets = {'sp': -1, 'pc': 0x7c, 'lr': 0x78, 'r0': 0x64, 'r1': 0x68, 'r2': 0x6c,
                                'r3': 0x70, 'r4': 0x00, 'r5': 0x04, 'r6': 0x08, 'r7': 0x0c, 'r8': 0x10,
                                'r9': 0x14, 'r10': 0x18, 'r11': 0x1c, 'r12': 0x74}

cortex_m4f_mpu_stack_offsets = {'sp': -1, 'pc': 0x40, 'lr': 0x3c, 'r0': 0x28, 'r1': 0x2c, 'r2': 0x30,
                                'r3': 0x34, 'r4': 0x04, 'r5': 0x08, 'r6': 0x0c, 'r7': 0x10,
                                'r8': 0x14, 'r9': 0x18, 'r10': 0x1c, 'r11': 0x20, 'r12': 0x38}

cortex_m4f_mpu_fpu_stack_offsets = {'sp': -1, 'pc': 0x80, 'lr': 0x7c, 'r0': 0x68, 'r1': 0x6c, 'r2': 0x70,
                                    'r3': 0x74, 'r4': 0x04, 'r5': 0x08, 'r6': 0x0c, 'r7': 0x10,
                                    'r8': 0x14, 'r9': 0x18, 'r10': 0x1c, 'r11': 0x20, 'r12': 0x78}

cortex_m0_stacking = RegisterStacking(0x40, cortex_m0_stack_offsets)
cortex_m3_stacking = RegisterStacking(0x40, cortex_m3_stack_offsets)
cortex_m3_mpu_stacking = RegisterStacking(0x44, cortex_m3_mpu_stack_offsets)  # 4 more for control
cortex_m4_stacking = RegisterStacking(0x44, cortex_m4_stack_offsets)  # 4 more for LR
# 4 more for LR + 4 more for control
cortex_m4f_mpu_stacking = RegisterStacking(0x48, cortex_m4f_mpu_stack_offsets)
# 4 more for LR + 34 * 4 more for FPU context
cortex_m4f_fpu_stacking = RegisterStacking(0xcc, cortex_m4f_fpu_stack_offsets)
# 4 more for LR + 4 more for control + 34 * 4 more for FPU context
cortex_m4f_mpu_fpu_stacking = RegisterStacking(0xd0, cortex_m4f_mpu_fpu_stack_offsets)


def get_arm_cm_freertos_stacking(stack_ptr, uint32_type):
    i = deref_long_from_addr(CPUID, uint32_type) & ARM_CPUID_PARTNO_MASK
    line = line_by_part_num[i]
    if line == ARM_CM0 or line == ARM_CM0_plus or line == ARM_CM1:
        print("Detected ARM_CM0/ARM_CM0+/ARM_CM1")
        return cortex_m0_stacking

    if line == ARM_CM3:
        if deref_long_from_addr(MPU_CTRL, uint32_type) & 0x1 == 1:
            print("Detected ARM_CM3 with MPU enabled")
            return cortex_m3_mpu_stacking
        print("Detected ARM_CM3")
        return cortex_m3_stacking

    if line in [ARM_CM4, ARM_CM7, ARM_CM23, ARM_CM33, ARM_CM55]:
        if line in [ARM_CM23, ARM_CM33, ARM_CM55]:
            print("Detected ARM_CM23/ARM_CM33/ARM_CM55. Using ARM_CM4 staking")
        cm4_fpu_enabled = deref_long_from_addr(FPU_CPACR, uint32_type) & ARM_CP_10_11_MASK
        cm4_fpu_used = False
        cm4_mpu_enabled = deref_long_from_addr(MPU_CTRL, uint32_type) & 0x1 == 1

        if cm4_fpu_enabled:
            if cm4_mpu_enabled:
                offset = 0x24
            else:
                offset = 0x20
            cm4_fpu_used = (deref_long_from_addr(stack_ptr + offset, uint32_type) & 0x10) == 0  # fpu is actually used by the task

        if cm4_fpu_enabled and cm4_fpu_used:
            if cm4_mpu_enabled:
                print("Detected ARM_CM4 with MPU and FPU enabled")
                return cortex_m4f_mpu_fpu_stacking
            else:
                print("Detected ARM_CM4 with FPU enabled")
                return cortex_m4f_fpu_stacking
        else:
            if cm4_mpu_enabled:
                print("Detected ARM_CM4 with MPU enabled")
                return cortex_m4f_mpu_stacking
            else:
                print("Detected ARM_CM4")
                return cortex_m4_stacking

    print("Unknown MCU!")
    return cortex_m3_stacking
