import gdb
from common.config import Reg


def safe_gdb_lookup_type(type_name):
    try:
        return gdb.lookup_type(type_name)
    except gdb.error:
        return None


arm_32_commmon_registers = [
    Reg("sp", "", 4),
    Reg("pc", "", 4),
    Reg("lr", "", 4),
    Reg("r0", "", 4),
    Reg("r1", "", 4),
    Reg("r2", "", 4),
    Reg("r3", "", 4),
    Reg("r4", "", 4),
    Reg("r5", "", 4),
    Reg("r6", "", 4),
    Reg("r7", "", 4),
    Reg("r8", "", 4),
    Reg("r9", "", 4),
    Reg("r10", "", 4),
    Reg("r11", "", 4),
    Reg("r12", "", 4)
]
