import gdb

CPUID = 0xE000ED00
ARM_CPUID_PARTNO_MASK = 0xFFF0
MPU_CTRL = 0xE000ED94
ARM_CP_10_11_MASK = 0x00F00000  # CP10, CP11
FPU_CPACR = 0xE000ED88  # Coprocessor Access Control Register


def deref_long_from_addr(addr, uint32_type):
    val = gdb.Value(addr).cast(uint32_type.pointer()).dereference()
    return int(val)


ARM_CM0 = "ARM_CM0"
ARM_CM0_plus = "ARM_CM0+"
ARM_CM1 = "ARM_CM1"
ARM_CM3 = "ARM_CM3"
ARM_CM4 = "ARM_CM4"
ARM_CM7 = "ARM_CM7"
ARM_CM23 = "ARM_CM23"
ARM_CM33 = "ARM_CM33"
ARM_CM55 = "ARM_CM55"
ARM_UNK = "ARM_UNKNOWN"

line_by_part_num = {
    0xC200: ARM_CM0,
    0xC600: ARM_CM0_plus,
    0xC210: ARM_CM1,
    0xC230: ARM_CM3,
    0xC240: ARM_CM4,
    0xC270: ARM_CM7,
    0xD200: ARM_CM23,
    0xD210: ARM_CM33,
    0xD220: ARM_CM55,
}
