from common import Rtos, rtos_class, arm_32_commmon_registers, safe_gdb_lookup_type
from azure.Thread import get_azure_threads, get_curr_thread
from azure.cortex_m import get_arm_cm_azure_stacking
import json
import gdb


@rtos_class
class Azure(Rtos):
    types = None

    def __init__(self):
        self.config = AzureConfig()
        super(Azure, self).__init__(Azure.types.uint32_type)

    @staticmethod
    def detect():
        Azure.types = TypesCache()
        if Azure.types.thread_t is None or Azure.types.uint32_type is None:
            return False
        if gdb.lookup_global_symbol("_tx_thread_current_ptr") is None:
            return False
        return True

    @staticmethod
    def name():
        return "AZURE"

    def get_config(self):
        return json.dumps({})

    def get_threads(self):
        return get_azure_threads(self.config, Azure.types)

    def get_queues(self):
        return json.dumps([])

    def get_timers(self):
        return json.dumps([])

    def get_heap_info(self):
        return json.dumps([])

    def get_current_thread(self):
        return get_curr_thread(self.config, Azure.types)

    def get_thread_registers(self):
        return arm_32_commmon_registers

    def get_thread_stacking(self, stack_ptr):
        return get_arm_cm_azure_stacking(stack_ptr, Azure.types.uint32_type)


class TypesCache:
    def __init__(self):
        self.uint32_type = safe_gdb_lookup_type("uint32_t")
        self.thread_t = safe_gdb_lookup_type("TX_THREAD")


class AzureConfig:
    def __init__(self):
        self.threadMonitor = False
        self.threadName = False
        self.tasks_map = {}
        self.next_task_index = 0

    def get_task_id(self, name):
        try:
            return self.tasks_map[name]
        except KeyError:
            new_id = self.next_task_index
            self.tasks_map[name] = new_id
            self.next_task_index += 1
            return new_id


print("Azure RTOS initialized")
