/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.execution.CidrContextConfigurationTestCase;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public class CidrContextRunConfigurationFixture {
    private final CidrContextConfigurationTestCase myCase;

    public CidrContextRunConfigurationFixture(@NotNull CidrContextConfigurationTestCase ownerCase) {
        if (ownerCase == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(0);
        }
        this.myCase = ownerCase;
    }

    public CidrTestRunConfiguration assertCheckingConfiguration(PsiElement psiElement) throws RuntimeConfigurationException {
        Object config = this.createContextConfigurationInterface(psiElement);
        CidrContextConfigurationTestCase.assertValidity(config, null);
        UsefulTestCase.assertInstanceOf(config, CidrTestRunConfiguration.class);
        ((CidrTestRunConfiguration)config).getTestData().setTestName(null);
        CidrContextConfigurationTestCase.assertValidity(config, null);
        return (CidrTestRunConfiguration)config;
    }

    @NotNull
    public CidrRunConfiguration createConfiguration(PsiElement element) {
        RunnerAndConfigurationSettings settings = this.myCase.createContextConfiguration(element);
        TestCase.assertNotNull((Object)settings);
        RunConfiguration config = settings.getConfiguration();
        UsefulTestCase.assertInstanceOf(config, CidrRunConfiguration.class);
        CidrRunConfiguration cidrRunConfiguration = (CidrRunConfiguration)config;
        if (cidrRunConfiguration == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(1);
        }
        return cidrRunConfiguration;
    }

    public void assertNoConfigurationForElement(PsiElement element) {
        RunnerAndConfigurationSettings settings = this.myCase.createContextConfiguration(element);
        TestCase.assertNull((Object)settings);
    }

    @NotNull
    public <T extends CidrRunConfiguration> T createContextConfigurationInterface(PsiElement element) {
        CidrRunConfiguration config;
        CidrRunConfiguration cidrRunConfiguration = config = this.createConfiguration(element);
        if (cidrRunConfiguration == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(2);
        }
        return (T)cidrRunConfiguration;
    }

    @NotNull
    public <T extends CidrRunConfiguration> T createConfigurationForContext(@NotNull String fileName, @NotNull String label) {
        CidrRunConfiguration config;
        if (fileName == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(3);
        }
        if (label == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(4);
        }
        PsiElement element = this.getFindElement(fileName, label);
        CidrRunConfiguration cidrRunConfiguration = config = this.createConfiguration(element);
        if (cidrRunConfiguration == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(5);
        }
        return (T)cidrRunConfiguration;
    }

    public void assertNoConfigurationForContext(@NotNull String fileName, @NotNull String label) {
        if (fileName == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(6);
        }
        if (label == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(7);
        }
        PsiElement element = this.getFindElement(fileName, label);
        this.assertNoConfigurationForElement(element);
    }

    @NotNull
    public PsiElement getFindElement(@NotNull String fileName, @NotNull String label) {
        String text2;
        if (fileName == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(8);
        }
        if (label == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(9);
        }
        OCFile file2 = ((CidrProjectFixture)this.myCase.getProjectFixture()).findProjectSubOCFile(fileName);
        final String textToFind = "// >>" + label;
        final Ref elementRef = Ref.create();
        file2.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitComment(comment);
                String text2 = comment.getText();
                if (text2 != null && text2.startsWith(textToFind)) {
                    elementRef.set((Object)comment);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/jetbrains/cidr/execution/CidrContextRunConfigurationFixture$1", "visitComment"));
            }
        });
        PsiElement element = (PsiElement)elementRef.get();
        String string = text2 = element == null ? null : element.getText();
        if (text2 != null && text2.contains("next")) {
            if (text2.contains("decl")) {
                element = PsiTreeUtil.getNextSiblingOfType((PsiElement)element, OCDeclarator.class);
            } else if (text2.contains("macroCall")) {
                element = PsiTreeUtil.getNextSiblingOfType((PsiElement)element, OCMacroCall.class);
            }
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    public static String getDefineSubstitution(@NotNull PsiElement context2, @NotNull String macroName) {
        if (context2 == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(11);
        }
        if (macroName == null) {
            CidrContextRunConfigurationFixture.$$$reportNull$$$0(12);
        }
        return (String)ReadAction.compute(() -> {
            OCCodeFragment fragment = OCElementFactory.codeFragment((CharSequence)macroName, (Project)context2.getProject(), (PsiElement)context2, (IFileElementType)OCTokenTypes.OC_FILE, (boolean)false, (boolean)false, (OCLanguageKind)CLanguageKind.C);
            return fragment.getFirstChild() instanceof OCMacroCall ? ((OCMacroCall)fragment.getFirstChild()).getReplacementText() : null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerCase";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrContextRunConfigurationFixture";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrContextRunConfigurationFixture";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createContextConfigurationInterface";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurationForContext";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationForContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertNoConfigurationForContext";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFindElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefineSubstitution";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 10 -> new IllegalStateException(string);
        };
    }
}

