/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestAnnotationInfoList {
    @NotNull
    protected final List<AnnotationInfo> myAnnotationHolder = new ArrayList<AnnotationInfo>();

    private void annotationAdded(@NotNull Annotation annotation) {
        ProblemGroup problemGroup;
        if (annotation == null) {
            TestAnnotationInfoList.$$$reportNull$$$0(0);
        }
        TextRange range = TextRange.create((Segment)annotation);
        HighlightSeverity severity = annotation.getSeverity();
        String message = annotation.getMessage();
        this.annotationAdded(severity, range, message);
        if (annotation.getQuickFixes() != null) {
            for (SuppressIntentionAction[] info : annotation.getQuickFixes()) {
                this.createQuickFix((Segment)range, info.quickFix);
            }
            problemGroup = annotation.getProblemGroup();
            if (problemGroup instanceof OCProblemGroup) {
                for (SuppressIntentionAction action : ((OCProblemGroup)problemGroup).getSuppressActions(null)) {
                    this.createQuickFix((Segment)range, (IntentionAction)action);
                }
            }
        }
        if (annotation.getBatchFixes() != null) {
            for (SuppressIntentionAction[] info : annotation.getBatchFixes()) {
                this.createQuickFix((Segment)range, info.quickFix);
            }
            problemGroup = annotation.getProblemGroup();
            if (problemGroup instanceof OCProblemGroup) {
                for (SuppressIntentionAction action : ((OCProblemGroup)problemGroup).getSuppressActions(null)) {
                    this.createQuickFix((Segment)range, (IntentionAction)action);
                }
            }
        }
    }

    public void annotationAdded(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message) {
        if (severity == null) {
            TestAnnotationInfoList.$$$reportNull$$$0(1);
        }
        if (range == null) {
            TestAnnotationInfoList.$$$reportNull$$$0(2);
        }
        this.myAnnotationHolder.add(new AnnotationInfo(range, severity, message));
    }

    public void annotationsAdded(@NotNull Collection<? extends Annotation> holder) {
        if (holder == null) {
            TestAnnotationInfoList.$$$reportNull$$$0(3);
        }
        for (Annotation annotation : holder) {
            this.annotationAdded(annotation);
        }
    }

    public boolean exists(@NotNull Predicate<? super AnnotationInfo> predicate) {
        if (predicate == null) {
            TestAnnotationInfoList.$$$reportNull$$$0(4);
        }
        return ContainerUtil.exists(this.myAnnotationHolder, it -> predicate.test((AnnotationInfo)it));
    }

    public abstract void createQuickFix(@Nullable Segment var1, @NotNull IntentionAction var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/TestAnnotationInfoList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotationAdded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotationsAdded";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "exists";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AnnotationInfo {
        public final TextRange range;
        public final HighlightSeverity severity;
        public final String message;

        AnnotationInfo(@NotNull TextRange range, @NotNull HighlightSeverity severity, @Nullable String message) {
            if (range == null) {
                AnnotationInfo.$$$reportNull$$$0(0);
            }
            if (severity == null) {
                AnnotationInfo.$$$reportNull$$$0(1);
            }
            this.range = range;
            this.severity = severity;
            this.message = message;
        }

        public String toString() {
            return "AnnotationInfo{range=" + this.range + ", severity=" + this.severity + ", message='" + this.message + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "severity";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/TestAnnotationInfoList$AnnotationInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

