/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.IoTestUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.cidr.CidrPathManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestDataFixture {
    public static final String REAL_PROJECT_DIR_SUFFIX = "-real";
    private final Set<File> myTempFiles = new HashSet<File>();
    protected boolean myCreateSymLinkedProject;
    private final File myTestDataDir;
    public static final Pattern IDEA_DIR_NAME_PATTERN = Pattern.compile("^" + Pattern.quote(".idea") + "$");

    public CidrTestDataFixture(File testDataDir) {
        this(testDataDir, false);
    }

    public CidrTestDataFixture(File testDataDir, boolean createSymlinkedProject) {
        this.myTestDataDir = testDataDir;
        this.myCreateSymLinkedProject = createSymlinkedProject;
    }

    @NotNull
    public static File getRegressionTestData() {
        File file2 = CidrPathManager.getCidrSourcesRoot().resolve("regression-testData").toFile();
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(0);
        }
        return file2;
    }

    @NotNull
    public static File getCommonTestData() {
        File file2 = CidrPathManager.getCidrSourcesRoot().resolve("cidr-common/tests/testData").toFile();
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(1);
        }
        return file2;
    }

    @NotNull
    public static File getLangTestData() {
        File file2 = CidrPathManager.getCidrSourcesRoot().resolve("cidr-lang/testData").toFile();
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(2);
        }
        return file2;
    }

    @NotNull
    public static File getDebuggerTestData() {
        File file2 = CidrPathManager.getCidrSourcesRoot().resolve("cidr-debugger/testData").toFile();
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(3);
        }
        return file2;
    }

    @NotNull
    public static File getCoverageTestData() {
        File file2 = CidrPathManager.getCidrSourcesRoot().resolve("cidr-coverage/testData").toFile();
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(4);
        }
        return file2;
    }

    @NotNull
    public static File getCLionTestData() {
        File file2 = CidrPathManager.getCidrSourcesRoot().resolve("clion/main/testData").toFile();
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(5);
        }
        return file2;
    }

    @NotNull
    public static File getCompDBTestData() {
        File file2 = CidrPathManager.getCidrSourcesRoot().resolve("clion-compdb/testData").toFile();
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(6);
        }
        return file2;
    }

    @NotNull
    public static File getAppCodeTestData() {
        return new File(PathManager.getHomePath(), "CIDR-appcode/appcode/main/testData");
    }

    public static File getCocoaCommonTestData() {
        return new File(PathManager.getHomePath(), "CIDR-appcode/cocoa-common/testData");
    }

    public static File getSwiftTestData() {
        return new File(PathManager.getHomePath(), "CIDR-appcode/swift-tests/testData");
    }

    public static File getMobileTestData() {
        return new File(PathManager.getHomePath(), "mobile-ide/mobile-native/testData");
    }

    @NotNull
    public static File getSwiftPackageManagerTestData() {
        return new File(PathManager.getHomePath(), "CIDR-appcode/swift-package-manager/testData");
    }

    @NotNull
    public static File getMesonTestData() {
        File file2 = CidrPathManager.getCidrSourcesRoot().resolve("clion-meson/testData").toFile();
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(7);
        }
        return file2;
    }

    public void enableSymlinkedProjectCreation() {
        this.myCreateSymLinkedProject = true;
    }

    public boolean isSymlinked() {
        return this.myCreateSymLinkedProject;
    }

    @NotNull
    public File getTestDataDir() {
        if (this.myTestDataDir == null) {
            throw new UnsupportedOperationException("No test data. Please override CidrTestCase.createTestDataFixture");
        }
        File file2 = this.myTestDataDir;
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(8);
        }
        return file2;
    }

    @NotNull
    public Path getTestDataPath() {
        Path path = this.getTestDataDir().toPath();
        if (path == null) {
            CidrTestDataFixture.$$$reportNull$$$0(9);
        }
        return path;
    }

    @NotNull
    public File getTestDataProjectsDir() {
        File file2 = this.getTestDataFile("projects");
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(10);
        }
        return file2;
    }

    @Contract(value="null -> null")
    public File getTestDataProjectsFile(@Nullable String testDataRelativePath) {
        return testDataRelativePath == null ? null : new File(this.getTestDataProjectsDir(), testDataRelativePath);
    }

    @Contract(value="null -> null")
    public File getTestDataFile(@Nullable String testDataRelativePath) {
        return testDataRelativePath == null ? null : new File(this.getTestDataDir(), testDataRelativePath);
    }

    public VirtualFile createTempDir() {
        return CidrTestDataFixture.getVirtualFile(this.createTempIODir());
    }

    public Path createTempPath() {
        return this.createTempIODir().toPath();
    }

    public File createTempIODir() {
        return this.createTempIODir(true);
    }

    public File createTempIODir(boolean deleteOnTearDown) {
        try {
            String randomName = "cidr_test_" + UUID.randomUUID();
            File result = FileUtil.createTempDirectory((String)randomName, null, (boolean)false).getCanonicalFile();
            if (deleteOnTearDown) {
                this.myTempFiles.add(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void tearDown() {
        for (File each : this.myTempFiles) {
            FileUtil.delete((File)each);
        }
    }

    public VirtualFile createTempFile() {
        return this.createTempFile("");
    }

    public VirtualFile createTempFile(@NotNull String content) {
        if (content == null) {
            CidrTestDataFixture.$$$reportNull$$$0(11);
        }
        return CidrTestDataFixture.prepareFile(this.createTempIOFile(), content);
    }

    public VirtualFile createTempFile(@NotNull String content, @NotNull String suffix) {
        if (content == null) {
            CidrTestDataFixture.$$$reportNull$$$0(12);
        }
        if (suffix == null) {
            CidrTestDataFixture.$$$reportNull$$$0(13);
        }
        return CidrTestDataFixture.prepareFile(this.createTempIOFile(suffix), content);
    }

    private static VirtualFile prepareFile(@NotNull File f, @NotNull String content) {
        if (f == null) {
            CidrTestDataFixture.$$$reportNull$$$0(14);
        }
        if (content == null) {
            CidrTestDataFixture.$$$reportNull$$$0(15);
        }
        try {
            FileUtil.writeToFile((File)f, (byte[])content.getBytes(Charset.defaultCharset()));
            return CidrTestDataFixture.getVirtualFile(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static VirtualFile getVirtualFile(@NotNull File f) {
        if (f == null) {
            CidrTestDataFixture.$$$reportNull$$$0(16);
        }
        VirtualFile result = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(f);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{result});
        return result;
    }

    public File createTempIOFile() {
        return this.createTempIOFile("");
    }

    public File createTempIOFile(@NotNull String suffix) {
        if (suffix == null) {
            CidrTestDataFixture.$$$reportNull$$$0(17);
        }
        return this.createTempIOFile("cidr_test_file_", suffix);
    }

    public File createTempIOFile(@NotNull String prefix, @NotNull String suffix) {
        File f;
        if (prefix == null) {
            CidrTestDataFixture.$$$reportNull$$$0(18);
        }
        if (suffix == null) {
            CidrTestDataFixture.$$$reportNull$$$0(19);
        }
        try {
            f = FileUtil.createTempFile((String)prefix, (String)suffix, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((boolean)f.exists());
        this.myTempFiles.add(f);
        return f;
    }

    public VirtualFile createFile(@NotNull VirtualFile dir, @NotNull String name, @NotNull String content) {
        if (dir == null) {
            CidrTestDataFixture.$$$reportNull$$$0(20);
        }
        if (name == null) {
            CidrTestDataFixture.$$$reportNull$$$0(21);
        }
        if (content == null) {
            CidrTestDataFixture.$$$reportNull$$$0(22);
        }
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> {
                VirtualFile file2 = dir.findChild(name);
                if (file2 == null) {
                    file2 = dir.createChildData((Object)this, name);
                }
                file2.setBinaryContent(content.getBytes(Charset.defaultCharset()));
                return file2;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateFileText(@NotNull VirtualFile file2, @NotNull String append) throws IOException {
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(23);
        }
        if (append == null) {
            CidrTestDataFixture.$$$reportNull$$$0(24);
        }
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file2, (String)(VfsUtilCore.loadText((VirtualFile)file2) + append)));
    }

    public void writeFileTextExternally(@NotNull VirtualFile file2, @NotNull String text2) throws IOException {
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(25);
        }
        if (text2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(26);
        }
        this.writeIOFileText(VfsUtilCore.virtualToIoFile((VirtualFile)file2), text2);
        file2.refresh(false, false);
    }

    public void updateFileTextExternally(@NotNull VirtualFile file2, @NotNull String append) throws IOException {
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(27);
        }
        if (append == null) {
            CidrTestDataFixture.$$$reportNull$$$0(28);
        }
        this.updateIOFileText(VfsUtilCore.virtualToIoFile((VirtualFile)file2), append);
        file2.refresh(false, false);
    }

    public void writeIOFileText(@NotNull File file2, @NotNull String text2) throws IOException {
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(29);
        }
        if (text2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(30);
        }
        FileUtil.writeToFile((File)file2, (String)text2);
        this.updateFileTimestamp(file2);
    }

    public void updateIOFileText(@NotNull File file2, @NotNull String append) throws IOException {
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(31);
        }
        if (append == null) {
            CidrTestDataFixture.$$$reportNull$$$0(32);
        }
        this.writeIOFileText(file2, FileUtil.loadFile((File)file2, (Charset)StandardCharsets.UTF_8) + append);
    }

    public void updateFileText(@NotNull VirtualFile file2, @NotNull String replaceString, @NotNull String replaceWith) throws IOException {
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(33);
        }
        if (replaceString == null) {
            CidrTestDataFixture.$$$reportNull$$$0(34);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(35);
        }
        String original = VfsUtilCore.loadText((VirtualFile)file2);
        String replaced = original.replace(replaceString, replaceWith);
        TestCase.assertFalse((String)(replaceString + " not found in \n" + original), (boolean)original.equals(replaced));
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file2, (String)replaced));
    }

    public void updateFileTextExternally(@NotNull VirtualFile file2, @NotNull String replaceString, @NotNull String replaceWith) throws IOException {
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(36);
        }
        if (replaceString == null) {
            CidrTestDataFixture.$$$reportNull$$$0(37);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(38);
        }
        this.updateIOFileText(VfsUtilCore.virtualToIoFile((VirtualFile)file2), replaceString, replaceWith);
        file2.refresh(false, false);
    }

    public void updateIOFileText(@NotNull File file2, @NotNull String replaceString, @NotNull String replaceWith) throws IOException {
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(39);
        }
        if (replaceString == null) {
            CidrTestDataFixture.$$$reportNull$$$0(40);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(41);
        }
        String original = FileUtil.loadFile((File)file2, (String)"UTF-8", (boolean)true);
        String replaced = original.replace(replaceString, replaceWith);
        TestCase.assertFalse((String)(replaceString + " not found in \n" + original), (boolean)original.equals(replaced));
        FileUtil.writeToFile((File)file2, (String)replaced);
        this.updateFileTimestamp(file2);
    }

    public void updateFileTimestamp(File ... files) {
        if (files == null) {
            CidrTestDataFixture.$$$reportNull$$$0(42);
        }
        for (File file2 : files) {
            TestCase.assertTrue((boolean)file2.setLastModified(file2.lastModified() + 3000L));
        }
    }

    public void updateFileRegexpText(@NotNull VirtualFile file2, @NotNull @RegExp String regexp, @NotNull String replaceWith) throws IOException {
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(43);
        }
        if (regexp == null) {
            CidrTestDataFixture.$$$reportNull$$$0(44);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(45);
        }
        this.updateFileRegexpText(file2, regexp, replaceWith, true);
    }

    public void updateFileRegexpText(@NotNull VirtualFile file2, @NotNull @RegExp String regexp, @NotNull String replaceWith, boolean failIfNotFound) throws IOException {
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(46);
        }
        if (regexp == null) {
            CidrTestDataFixture.$$$reportNull$$$0(47);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(48);
        }
        String original = VfsUtilCore.loadText((VirtualFile)file2);
        String replaced = CidrTestDataFixture.replaceFirstDotAll(original, regexp, replaceWith, failIfNotFound);
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file2, (String)replaced));
    }

    public void updateIOFileRegexpText(@NotNull File file2, @NotNull @RegExp String regexp, @NotNull String replaceWith) throws IOException {
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(49);
        }
        if (regexp == null) {
            CidrTestDataFixture.$$$reportNull$$$0(50);
        }
        if (replaceWith == null) {
            CidrTestDataFixture.$$$reportNull$$$0(51);
        }
        String original = FileUtil.loadFile((File)file2, (Charset)StandardCharsets.UTF_8);
        String replaced = CidrTestDataFixture.replaceFirstDotAll(original, regexp, replaceWith, true);
        FileUtil.writeToFile((File)file2, (String)replaced);
        this.updateFileTimestamp(file2);
    }

    private static String replaceFirstDotAll(String original, @RegExp String regexp, String replaceWith, boolean failIfNotFound) {
        Pattern pattern = Pattern.compile(regexp, 32);
        if (failIfNotFound) {
            Assert.assertTrue((String)(regexp + " not found in \n" + original), (boolean)pattern.matcher(original).find());
        }
        return pattern.matcher(original).replaceFirst(replaceWith);
    }

    @NotNull
    public List<File> collectDirectSubDirs(@NotNull File dir) {
        if (dir == null) {
            CidrTestDataFixture.$$$reportNull$$$0(52);
        }
        return CidrTestDataFixture.collectSubDirs(dir, true, new ArrayList<File>());
    }

    @NotNull
    public List<File> collectSubDirs(@NotNull File dir) {
        if (dir == null) {
            CidrTestDataFixture.$$$reportNull$$$0(53);
        }
        return CidrTestDataFixture.collectSubDirs(dir, false, new ArrayList<File>());
    }

    @NotNull
    private static List<File> collectSubDirs(@NotNull File dir, boolean direct, @NotNull List<File> result) {
        File[] subFiles;
        if (dir == null) {
            CidrTestDataFixture.$$$reportNull$$$0(54);
        }
        if (result == null) {
            CidrTestDataFixture.$$$reportNull$$$0(55);
        }
        if ((subFiles = dir.listFiles()) != null) {
            for (File eachSubFile : subFiles) {
                if (!eachSubFile.isDirectory()) continue;
                result.add(eachSubFile);
                if (direct) continue;
                CidrTestDataFixture.collectSubDirs(eachSubFile, false, result);
            }
        }
        List<File> list = result;
        if (list == null) {
            CidrTestDataFixture.$$$reportNull$$$0(56);
        }
        return list;
    }

    public File copyTestData(@NotNull File folderOrZipToCopy, @NotNull File toDir) {
        if (folderOrZipToCopy == null) {
            CidrTestDataFixture.$$$reportNull$$$0(57);
        }
        if (toDir == null) {
            CidrTestDataFixture.$$$reportNull$$$0(58);
        }
        File dir = toDir;
        String action = null;
        try {
            if (folderOrZipToCopy.isFile() && FileUtilRt.extensionEquals((String)folderOrZipToCopy.getName(), (String)"zip")) {
                action = "extract";
                ZipUtil.extract((File)folderOrZipToCopy, (File)toDir, null);
            } else {
                action = "copy";
                dir = new File(toDir, folderOrZipToCopy.getName());
                FileUtil.copyDir((File)folderOrZipToCopy, (File)dir);
            }
            List ideaDirs = FileUtil.findFilesOrDirsByMask((Pattern)IDEA_DIR_NAME_PATTERN, (File)dir);
            for (File ideaDir : ideaDirs) {
                if (!ideaDir.isDirectory()) continue;
                System.out.println("WARN: '.idea' found in test project and will be deleted during copy: " + ideaDir.getPath());
                FileUtil.delete((File)ideaDir);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't " + action + " test data from " + folderOrZipToCopy + " to " + toDir, e);
        }
        File projectDir = new File(toDir, folderOrZipToCopy.getName());
        if (this.myCreateSymLinkedProject) {
            File realDir = this.getRealFolder(projectDir);
            FileUtil.moveDirWithContent((File)projectDir, (File)realDir);
            this.createSymlink(realDir, projectDir.getName());
        }
        return projectDir;
    }

    @NotNull
    protected File getRealFolder(File projectDir) {
        return new File(projectDir.getPath() + REAL_PROJECT_DIR_SUFFIX);
    }

    @NotNull
    public File createSymlink(@NotNull File target) {
        if (target == null) {
            CidrTestDataFixture.$$$reportNull$$$0(59);
        }
        File file2 = this.createSymlink(target, target.getName() + "-symlink");
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(60);
        }
        return file2;
    }

    @NotNull
    public File createSymlink(@NotNull File target, @NotNull String name) {
        if (target == null) {
            CidrTestDataFixture.$$$reportNull$$$0(61);
        }
        if (name == null) {
            CidrTestDataFixture.$$$reportNull$$$0(62);
        }
        File file2 = this.createSymlink(target, new File(target.getParentFile(), name));
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(63);
        }
        return file2;
    }

    @NotNull
    public File createSymlink(@NotNull File target, @NotNull File symlink) {
        if (target == null) {
            CidrTestDataFixture.$$$reportNull$$$0(64);
        }
        if (symlink == null) {
            CidrTestDataFixture.$$$reportNull$$$0(65);
        }
        TestCase.assertFalse((boolean)symlink.exists());
        try {
            IoTestUtil.createSymLink(target.getAbsolutePath(), symlink.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create symlink", e);
        }
        Assert.assertTrue((boolean)symlink.exists());
        File file2 = symlink;
        if (file2 == null) {
            CidrTestDataFixture.$$$reportNull$$$0(66);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 61, 62, 64, 65 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrTestDataFixture";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 20: 
            case 52: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 21: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 43: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "append";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceString";
                break;
            }
            case 35: 
            case 38: 
            case 41: 
            case 45: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceWith";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 44: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderOrZipToCopy";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 59: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegressionTestData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonTestData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLangTestData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerTestData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageTestData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCLionTestData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompDBTestData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMesonTestData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataDir";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataProjectsDir";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrTestDataFixture";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSubDirs";
                break;
            }
            case 60: 
            case 63: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymlink";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createTempIOFile";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 23: 
            case 24: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateFileText";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeFileTextExternally";
                break;
            }
            case 27: 
            case 28: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "updateFileTextExternally";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "writeIOFileText";
                break;
            }
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "updateIOFileText";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateFileTimestamp";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "updateFileRegexpText";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "updateIOFileRegexpText";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "collectDirectSubDirs";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "collectSubDirs";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "copyTestData";
                break;
            }
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createSymlink";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 61, 62, 64, 65 -> new IllegalArgumentException(string);
        };
    }
}

