/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import org.jetbrains.annotations.NotNull;

public class CidrSTLVersionPrinter
implements Function<OCFile, String> {
    @NotNull
    private final String myCompilerPath;

    public CidrSTLVersionPrinter(@NotNull String path) {
        if (path == null) {
            CidrSTLVersionPrinter.$$$reportNull$$$0(0);
        }
        this.myCompilerPath = path;
    }

    public String fun(OCFile file2) {
        return "STL version macro: " + CidrSTLVersionPrinter.getMacroString(file2) + " (compiler path:" + this.myCompilerPath + ")";
    }

    private static String getMacroString(@NotNull OCFile file2) {
        OCSymbol symbol;
        if (file2 == null) {
            CidrSTLVersionPrinter.$$$reportNull$$$0(1);
        }
        if ((symbol = (OCSymbol)ReadAction.compute(() -> CidrSTLVersionPrinter.getSymbol(file2))) != null) {
            return symbol.toString();
        }
        return "UNKNOWN";
    }

    private static OCSymbol getSymbol(@NotNull OCFile file2) {
        if (file2 == null) {
            CidrSTLVersionPrinter.$$$reportNull$$$0(2);
        }
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCMacroSymbol && ("_LIBCPP_VERSION".equals(symbol.getName()) || "_CPPLIB_VER".equals(symbol.getName()));
            }
        };
        file2.getMembersContainer(false).processMembers(null, (Processor)finder);
        OCSymbol symbol = (OCSymbol)finder.getFoundValue();
        if (symbol instanceof OCMacroSymbol) {
            return symbol;
        }
        return OCHeaderContextCache.headerContext((PsiFile)file2).getDefinition("__GNUC__");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/CidrSTLVersionPrinter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMacroString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSymbol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

