/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrProjectDependentFixture;
import com.jetbrains.cidr.CidrProjectDependentFixtureBase;
import com.jetbrains.cidr.CidrProjectFixtureBase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.WaitUtilKt;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.modulemap.AllowedModules;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityExecutionService;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.workspace.OCGeneratedSourcesFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrProjectFixture<BUILD_CONFIGURATION_TYPE>
extends CidrProjectFixtureBase<BUILD_CONFIGURATION_TYPE>
implements CidrProjectDependentFixture {
    private boolean myLoadSymbols;
    private boolean mySaveSymbols;
    private static volatile FileSymbolTablesCache.SymbolsProperties.SymbolsKind ourSymbolsWereBuilt;

    protected CidrProjectFixture(@NotNull CidrTestDataFixture testDataFixture) {
        if (testDataFixture == null) {
            CidrProjectFixture.$$$reportNull$$$0(0);
        }
        super(testDataFixture);
        this.myLoadSymbols = true;
        this.mySaveSymbols = true;
    }

    @Override
    public void setUp(@NotNull String testClassFQN, @NotNull String testName) throws Exception {
        if (testClassFQN == null) {
            CidrProjectFixture.$$$reportNull$$$0(1);
        }
        if (testName == null) {
            CidrProjectFixture.$$$reportNull$$$0(2);
        }
        FileSymbolTablesCache.setShouldBuildTablesInTests(null);
        super.setUp(testClassFQN, testName);
    }

    @Override
    public void tearDown() throws Exception {
        try {
            FileSymbolTablesCache.setShouldBuildTablesInTests(null);
        }
        finally {
            super.tearDown();
        }
    }

    public void setupSerialization(boolean loadSymbols, boolean saveSymbols) {
        this.myLoadSymbols = loadSymbols;
        this.mySaveSymbols = saveSymbols;
    }

    @Override
    @NotNull
    protected CidrProjectFixtureBase.InitSymbolsHook createDefaultSymbolsHook() {
        return new OCSymbolsHook(this.shouldBuildSymbolTablesForFixtures());
    }

    @Override
    protected void waitForSymbols(@NotNull Project project) {
        if (project == null) {
            CidrProjectFixture.$$$reportNull$$$0(3);
        }
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            return;
        }
        OCSymbolTablesBuildingActivity symbolTablesBuildingActivity = OCSymbolTablesBuildingActivity.getInstance((Project)project);
        WaitUtilKt.waitForEvent((Function0<Boolean>)((Function0)() -> !symbolTablesBuildingActivity.isBuilding()), (Function0<String>)((Function0)() -> {
            int cpuCount = Runtime.getRuntime().availableProcessors();
            int symbolBuildingThreadCount = OCBuildingActivityExecutionService.getInstance().getThreadCount();
            return String.format("  Aborting. waiting shouldn't take so much time.\n  cpuCount: %d\n  Thread count in building pool: %d\n", cpuCount, symbolBuildingThreadCount);
        }), TimeUnit.MINUTES.toMillis(10L));
        IndexingTestUtil.waitUntilIndexesAreReady(project);
    }

    @Override
    @Nullable
    public PsiFile findProjectSubPsiFile(@Nullable String relativePath) {
        VirtualFile file2 = this.findProjectSubFile(relativePath);
        return file2 == null ? null : (PsiFile)ReadAction.compute(() -> OCLanguageUtils.tryGetOCFile((PsiFile)PsiManager.getInstance((Project)this.getProject()).findFile(file2)));
    }

    @Nullable
    public OCFile findProjectSubOCFile(@Nullable String relativePath) {
        PsiFile file2 = this.findProjectSubPsiFile(relativePath);
        if (file2 != null) {
            UsefulTestCase.assertInstanceOf(file2, OCPsiFile.class);
            return ((OCPsiFile)file2).getOCFile();
        }
        return null;
    }

    @NotNull
    public OCFile getProjectSubOCFile(@Nullable String relativePath) {
        OCFile result = this.findProjectSubOCFile(relativePath);
        CidrProjectFixture.assertNotNull((String)("File not found: " + relativePath), (Object)result);
        OCFile oCFile = result;
        if (oCFile == null) {
            CidrProjectFixture.$$$reportNull$$$0(4);
        }
        return oCFile;
    }

    @Override
    protected void assertScopeExt(@NotNull StringBuilder m, int mask, @NotNull List<VirtualFile> files) {
        if (m == null) {
            CidrProjectFixture.$$$reportNull$$$0(5);
        }
        if (files == null) {
            CidrProjectFixture.$$$reportNull$$$0(6);
        }
        GlobalSearchScope sourcesScope = OCSearchScope.getProjectSourcesScope((Project)this.getProject());
        OCGeneratedSourcesFilter.GeneratedSourcesScope generatedSourcesScope = new OCGeneratedSourcesFilter.GeneratedSourcesScope(this.getProject(), sourcesScope);
        m.append(CidrProjectFixture.assertScope(sourcesScope, "content sources", (mask & 4) != 0, files));
        m.append(CidrProjectFixture.assertScope((GlobalSearchScope)generatedSourcesScope, "content generated sources", (mask & 0x10) != 0, files));
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(String name, @Nullable Class<T> clazz) {
        return (T)((OCSymbol)ContainerUtil.getFirstItem(this.findSymbols(name, clazz), null));
    }

    @NotNull
    public <T extends OCSymbol> List<T> findSymbols(String name, @Nullable Class<T> clazz) {
        ArrayList result = new ArrayList();
        OCGlobalProjectSymbolsCache.processTopLevelSymbols((Project)this.getProject(), ocSymbol -> {
            if (clazz == null || clazz.isInstance(ocSymbol)) {
                result.add(ocSymbol);
            }
            return true;
        }, (String)name);
        ArrayList arrayList = result;
        if (arrayList == null) {
            CidrProjectFixture.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public List<OCClassSymbol> findClassSymbols(String name, @Nullable String category) {
        List result = this.findSymbols(name, OCClassSymbol.class);
        CidrProjectFixture.assertFalse((boolean)result.isEmpty());
        List list = result = ContainerUtil.findAll(result, symbol -> Objects.equals(symbol.getCategoryName(), category));
        if (list == null) {
            CidrProjectFixture.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void initProject(@NotNull CidrTestProjectDescription projectDescription, @NotNull FileSymbolTablesCache.SymbolsProperties.SymbolsKind buildSymbolTables) throws Exception {
        if (projectDescription == null) {
            CidrProjectFixture.$$$reportNull$$$0(9);
        }
        if (buildSymbolTables == null) {
            CidrProjectFixture.$$$reportNull$$$0(10);
        }
        this.initProject(projectDescription, new OCSymbolsHook(buildSymbolTables), CidrProjectFixtureBase.OpenProjectKind.AS_SPECIFIED_FILE);
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.NO_SYMBOLS;
        if (symbolsKind == null) {
            CidrProjectFixture.$$$reportNull$$$0(11);
        }
        return symbolsKind;
    }

    @NotNull
    private FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTablesForFixtures() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind result = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.NO_SYMBOLS;
        for (CidrProjectDependentFixtureBase each : this.myDependentFixtures.keySet()) {
            CidrProjectDependentFixture ocEach;
            FileSymbolTablesCache.SymbolsProperties.SymbolsKind eachResult;
            if (!(each instanceof CidrProjectDependentFixture) || result.compareTo((Enum)(eachResult = (ocEach = (CidrProjectDependentFixture)each).shouldBuildSymbolTables())) >= 0) continue;
            result = eachResult;
        }
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = result;
        if (symbolsKind == null) {
            CidrProjectFixture.$$$reportNull$$$0(12);
        }
        return symbolsKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassFQN";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrProjectFixture";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescription";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSymbolTables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrProjectFixture";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSubOCFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findSymbols";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassSymbols";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTables";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTablesForFixtures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setUp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "waitForSymbols";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertScopeExt";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 11, 12 -> new IllegalStateException(string);
        };
    }

    private class OCSymbolsHook
    implements CidrProjectFixtureBase.InitSymbolsHook {
        @NotNull
        private final FileSymbolTablesCache.SymbolsProperties.SymbolsKind buildSymbolTables;

        OCSymbolsHook(FileSymbolTablesCache.SymbolsProperties.SymbolsKind buildSymbolTables) {
            if (buildSymbolTables == null) {
                OCSymbolsHook.$$$reportNull$$$0(0);
            }
            this.buildSymbolTables = buildSymbolTables;
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = ", " + this.buildSymbolTables;
            if (string == null) {
                OCSymbolsHook.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void beforeInitializing() {
            ourSymbolsWereBuilt = this.buildSymbolTables;
        }

        @Override
        public boolean shouldReinitialize() {
            return ourSymbolsWereBuilt.compareTo((Enum)this.buildSymbolTables) < 0;
        }

        @Override
        public void setShouldBuildTablesInTests() {
            FileSymbolTablesCache.setShouldBuildTablesInTests((FileSymbolTablesCache.SymbolsProperties)new FileSymbolTablesCache.SymbolsProperties(this.buildSymbolTables, CidrProjectFixture.this.myLoadSymbols, CidrProjectFixture.this.mySaveSymbols));
        }

        @Override
        public void rebuildSymbolsIfNeeded(@NotNull Project project) {
            if (project == null) {
                OCSymbolsHook.$$$reportNull$$$0(2);
            }
            if (AllowedModules.Companion.isRebuildRequired()) {
                OCSymbolTablesBuildingActivity.getInstance((Project)project).rebuildSymbols();
                IndexingTestUtil.waitUntilIndexesAreReady(project);
            }
        }

        @Override
        public void logStats(@NotNull Logger logger) {
            if (logger == null) {
                OCSymbolsHook.$$$reportNull$$$0(3);
            }
            OCBuildingActivityProgressIndicator.logStats((Logger)logger);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildSymbolTables";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/CidrProjectFixture$OCSymbolsHook";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/CidrProjectFixture$OCSymbolsHook";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "rebuildSymbolsIfNeeded";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "logStats";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

