/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays.declarative;

import com.intellij.codeInsight.hints.InlayDumpUtil;
import com.intellij.codeInsight.hints.declarative.InlayActionData;
import com.intellij.codeInsight.hints.declarative.InlayActionPayload;
import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayProviderPassInfo;
import com.intellij.codeInsight.hints.declarative.PsiPointerInlayActionPayload;
import com.intellij.codeInsight.hints.declarative.StringInlayActionPayload;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeHintsPreviewProvider;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayHintsPass;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayHintsPassFactory;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayRenderer;
import com.intellij.codeInsight.hints.declarative.impl.InlayMouseArea;
import com.intellij.codeInsight.hints.declarative.impl.InlayPresentationEntry;
import com.intellij.codeInsight.hints.declarative.impl.TextInlayPresentationEntry;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.platform.testFramework.core.FileComparisonFailedError;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.testFramework.utils.inlays.InlayHintsProviderTestCase;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\rJ(\u0010\u0011\u001a\u00020\u00052\b\b\u0001\u0010\b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002R(\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/intellij/testFramework/utils/inlays/declarative/DeclarativeInlayHintsProviderTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "<init>", "()V", "doTestProvider", "", "fileName", "", "expectedText", "provider", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "enabledOptions", "", "", "expectedFile", "Ljava/io/File;", "verifyHintsPresence", "doTestPreview", "providerId", "language", "Lcom/intellij/lang/Language;", "applyPassAndCheckResult", "pass", "Lcom/intellij/codeInsight/hints/declarative/impl/DeclarativeInlayHintsPass;", "previewText", "customToStringProvider", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "getCustomToStringProvider", "()Lkotlin/jvm/functions/Function1;", "setCustomToStringProvider", "(Lkotlin/jvm/functions/Function1;)V", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nDeclarativeInlayHintsProviderTestCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarativeInlayHintsProviderTestCase.kt\ncom/intellij/testFramework/utils/inlays/declarative/DeclarativeInlayHintsProviderTestCase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public abstract class DeclarativeInlayHintsProviderTestCase
extends BasePlatformTestCase {
    @Nullable
    private Function1<? super PsiElement, String> customToStringProvider;

    public final void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider provider, @NotNull Map<String, Boolean> enabledOptions, @Nullable File expectedFile, boolean verifyHintsPresence) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter(enabledOptions, (String)"enabledOptions");
        if (verifyHintsPresence) {
            InlayHintsProviderTestCase.Companion.verifyHintsPresence(expectedText);
        }
        String sourceText = InlayDumpUtil.INSTANCE.removeHints(expectedText);
        this.myFixture.configureByText(fileName, sourceText);
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file2 = psiFile;
        Editor editor2 = this.myFixture.getEditor();
        InlayProviderPassInfo providerInfo = new InlayProviderPassInfo(provider, "provider.id", enabledOptions);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DeclarativeInlayHintsPass pass = (DeclarativeInlayHintsPass)ActionUtil.underModalProgress((Project)project, (String)"", () -> DeclarativeInlayHintsProviderTestCase.doTestProvider$lambda$0(file2, editor2, providerInfo));
        Intrinsics.checkNotNull((Object)pass);
        this.applyPassAndCheckResult(pass, expectedFile, sourceText, expectedText);
    }

    public static /* synthetic */ void doTestProvider$default(DeclarativeInlayHintsProviderTestCase declarativeInlayHintsProviderTestCase, String string, String string2, InlayHintsProvider inlayHintsProvider, Map map, File file2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTestProvider");
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            file2 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        declarativeInlayHintsProviderTestCase.doTestProvider(string, string2, inlayHintsProvider, map, file2, bl);
    }

    public final void doTestPreview(@org.intellij.lang.annotations.Language(value="JAVA") @NotNull String expectedText, @NotNull String providerId, @NotNull InlayHintsProvider provider, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String string = DeclarativeHintsPreviewProvider.INSTANCE.getPreview(language, providerId, provider);
        if (string == null) {
            throw new IllegalStateException(("Preview not found for provider: " + providerId).toString());
        }
        String previewText = string;
        Object object = language.getAssociatedFileType();
        if (object == null || (object = object.getDefaultExtension()) == null) {
            throw new IllegalStateException("language must have extension".toString());
        }
        String fileName = "preview." + (String)object;
        this.myFixture.configureByText(fileName, InlayDumpUtil.INSTANCE.removeHints(previewText));
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DeclarativeInlayHintsPass pass = (DeclarativeInlayHintsPass)ActionUtil.underModalProgress((Project)project, (String)"", () -> DeclarativeInlayHintsProviderTestCase.doTestPreview$lambda$1(this, provider, providerId));
        Intrinsics.checkNotNull((Object)pass);
        this.applyPassAndCheckResult(pass, null, previewText, expectedText);
    }

    private final void applyPassAndCheckResult(DeclarativeInlayHintsPass pass, File expectedFile, String previewText, String expectedText) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ActionUtil.underModalProgress((Project)project, (String)"", () -> DeclarativeInlayHintsProviderTestCase.applyPassAndCheckResult$lambda$2(pass));
        pass.applyInformationToEditor();
        Function2 function2 = (arg_0, arg_1) -> DeclarativeInlayHintsProviderTestCase.applyPassAndCheckResult$lambda$5(this, arg_0, arg_1);
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        Editor editor2 = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        PsiFile psiFile2 = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Document document = this.myFixture.getDocument(psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        String dump = InlayDumpUtil.dumpHintsInternal$default((InlayDumpUtil)InlayDumpUtil.INSTANCE, (String)previewText, null, (Function2)function2, (PsiFile)psiFile, (Editor)editor2, (Document)document, (int)0, (int)66, null);
        String expectedTrim = ((Object)StringsKt.trim((CharSequence)expectedText)).toString();
        String dumpTrim = ((Object)StringsKt.trim((CharSequence)dump)).toString();
        if (expectedFile != null) {
            if (!Intrinsics.areEqual((Object)expectedTrim, (Object)dumpTrim)) {
                throw new FileComparisonFailedError("Text mismatch in the file " + expectedFile.getAbsolutePath(), expectedTrim, dumpTrim, expectedFile.getAbsolutePath(), null, 16, null);
            }
        } else {
            BasePlatformTestCase.assertEquals((String)expectedTrim, (String)dumpTrim);
        }
    }

    @Nullable
    public final Function1<PsiElement, String> getCustomToStringProvider() {
        return this.customToStringProvider;
    }

    public final void setCustomToStringProvider(@Nullable Function1<? super PsiElement, String> function1) {
        this.customToStringProvider = function1;
    }

    private static final DeclarativeInlayHintsPass doTestProvider$lambda$0(PsiFile $file, Editor $editor, InlayProviderPassInfo $providerInfo) {
        PsiElement psiElement = (PsiElement)$file;
        Intrinsics.checkNotNull((Object)$editor);
        return new DeclarativeInlayHintsPass(psiElement, $editor, CollectionsKt.listOf((Object)$providerInfo), false, false, 16, null);
    }

    private static final DeclarativeInlayHintsPass doTestPreview$lambda$1(DeclarativeInlayHintsProviderTestCase this$0, InlayHintsProvider $provider, String $providerId) {
        PsiFile psiFile = this$0.myFixture.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        Editor editor2 = this$0.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        return DeclarativeInlayHintsPassFactory.Companion.createPassForPreview(psiFile, editor2, $provider, $providerId, MapsKt.emptyMap(), false);
    }

    private static final Unit applyPassAndCheckResult$lambda$2(DeclarativeInlayHintsPass $pass) {
        $pass.doCollectInformation((ProgressIndicator)new EmptyProgressIndicator());
        return Unit.INSTANCE;
    }

    private static final CharSequence applyPassAndCheckResult$lambda$5$lambda$4(DeclarativeInlayHintsProviderTestCase this$0, InlayPresentationEntry entry) {
        CharSequence charSequence;
        block6: {
            InlayActionPayload inlayActionPayload;
            InlayActionPayload payload;
            InlayActionData actionData;
            String text2;
            block3: {
                Object object;
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                        text2 = ((TextInlayPresentationEntry)entry).getText();
                        InlayMouseArea inlayMouseArea = entry.getClickArea();
                        InlayActionData inlayActionData = actionData = inlayMouseArea != null ? inlayMouseArea.getActionData() : null;
                        inlayActionPayload = payload = inlayActionData != null ? inlayActionData.getPayload() : null;
                        if (!(inlayActionPayload instanceof PsiPointerInlayActionPayload)) break block3;
                        object = ((PsiPointerInlayActionPayload)payload).getPointer().getElement();
                        if (object == null) break block4;
                        PsiElement it = object;
                        boolean bl = false;
                        Function1<? super PsiElement, String> function1 = this$0.customToStringProvider;
                        String string = function1 != null ? (String)function1.invoke((Object)it) : null;
                        object = string;
                        if (string != null) break block5;
                    }
                    object = "";
                }
                charSequence = (String)object + text2;
                break block6;
            }
            charSequence = inlayActionPayload instanceof StringInlayActionPayload ? (CharSequence)("[" + ((StringInlayActionPayload)payload).getText() + ":" + actionData.getHandlerId() + "]" + text2) : (CharSequence)text2;
        }
        return charSequence;
    }

    private static final String applyPassAndCheckResult$lambda$5(DeclarativeInlayHintsProviderTestCase this$0, EditorCustomElementRenderer renderer, Inlay inlay) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)inlay, (String)"<unused var>");
        DeclarativeInlayRenderer cfr_ignored_0 = (DeclarativeInlayRenderer)renderer;
        return ArraysKt.joinToString$default((Object[])((DeclarativeInlayRenderer)renderer).getPresentationList().getEntries(), (CharSequence)"|", null, null, (int)0, null, arg_0 -> DeclarativeInlayHintsProviderTestCase.applyPassAndCheckResult$lambda$5$lambda$4(this$0, arg_0), (int)30, null);
    }
}

