/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.lang.Language;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.ref.GCUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J'\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0014\"\u00020\n\u00a2\u0006\u0002\u0010\u0015R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester;", "", "<init>", "()V", "commonRefs", "", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "getCommonRefs", "()Ljava/util/List;", "commonActions", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "getCommonActions", "refActions", "", "refs", "runActions", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "actions", "", "(Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;[Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;)V", "Model", "Action", "RefKind", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nPsiIndexConsistencyTester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiIndexConsistencyTester.kt\ncom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,217:1\n1368#2:218\n1454#2,5:219\n13409#3,2:224\n*S KotlinDebug\n*F\n+ 1 PsiIndexConsistencyTester.kt\ncom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester\n*L\n44#1:218\n44#1:219,5\n49#1:224,2\n*E\n"})
public final class PsiIndexConsistencyTester {
    @NotNull
    public static final PsiIndexConsistencyTester INSTANCE = new PsiIndexConsistencyTester();
    @NotNull
    private static final List<RefKind> commonRefs;
    @NotNull
    private static final List<Action> commonActions;

    private PsiIndexConsistencyTester() {
    }

    @NotNull
    public final List<RefKind> getCommonRefs() {
        return commonRefs;
    }

    @NotNull
    public final List<Action> getCommonActions() {
        return commonActions;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<Action> refActions(@NotNull List<? extends RefKind> refs) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(refs, (String)"refs");
        Iterable $this$flatMap$iv = refs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RefKind it = (RefKind)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new Action[]{new Action.LoadRef(it), new Action.ClearRef(it)};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void runActions(@NotNull Model model, Action ... actions) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        WriteCommandAction.runWriteCommandAction((Project)model.getProject(), () -> PsiIndexConsistencyTester.runActions$lambda$2(actions, model));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void runActions$lambda$2(Action[] $actions, Model $model) {
        try {
            Action[] $this$forEach$iv = $actions;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Action element$iv;
                Action it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.performAction($model);
            }
        }
        finally {
            try {
                Action.Save.INSTANCE.performAction($model);
                $model.getVFile().delete((Object)INSTANCE);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    static {
        Object[] objectArray = new RefKind[]{RefKind.PsiFileRef.INSTANCE, RefKind.DocumentRef.INSTANCE, RefKind.DirRef.INSTANCE, new RefKind.AstRef(null), new RefKind.StubRef(null), new RefKind.GreenStubRef(null)};
        commonRefs = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Action.SimpleAction[]{Action.Commit.INSTANCE, Action.FlushIndexes.INSTANCE, Action.Gc.INSTANCE, Action.ReparseFile.INSTANCE, Action.FilePropertiesChanged.INSTANCE, Action.ReloadFromDisk.INSTANCE, Action.Reformat.INSTANCE, Action.PostponedFormatting.INSTANCE, Action.RenamePsiFile.INSTANCE, Action.RenameVirtualFile.INSTANCE, Action.Save.INSTANCE};
        commonActions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\bf\u0018\u00002\u00020\u0001:\u0010\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "SimpleAction", "FlushIndexes", "Gc", "Commit", "Save", "PostponedFormatting", "ReparseFile", "FilePropertiesChanged", "ReloadFromDisk", "RenameVirtualFile", "RenamePsiFile", "Reformat", "LoadRef", "ClearRef", "SetDocumentText", "SetFileText", "intellij.platform.testFramework"})
    public static interface Action {
        public void performAction(@NotNull Model var1);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$ClearRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "kind", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "<init>", "(Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;)V", "getKind", "()Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.testFramework"})
        public static final class ClearRef
        implements Action {
            @NotNull
            private final RefKind kind;

            public ClearRef(@NotNull RefKind kind) {
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                this.kind = kind;
            }

            @NotNull
            public final RefKind getKind() {
                return this.kind;
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                model.getRefs().remove(this.kind);
            }

            @NotNull
            public final RefKind component1() {
                return this.kind;
            }

            @NotNull
            public final ClearRef copy(@NotNull RefKind kind) {
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                return new ClearRef(kind);
            }

            public static /* synthetic */ ClearRef copy$default(ClearRef clearRef, RefKind refKind, int n, Object object) {
                if ((n & 1) != 0) {
                    refKind = clearRef.kind;
                }
                return clearRef.copy(refKind);
            }

            @NotNull
            public String toString() {
                return "ClearRef(kind=" + this.kind + ")";
            }

            public int hashCode() {
                return this.kind.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ClearRef)) {
                    return false;
                }
                ClearRef clearRef = (ClearRef)other;
                return Intrinsics.areEqual((Object)this.kind, (Object)clearRef.kind);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$Commit;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "<init>", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class Commit
        extends SimpleAction {
            @NotNull
            public static final Commit INSTANCE = new Commit();

            private Commit() {
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                PsiDocumentManager.getInstance((Project)model.getProject()).commitAllDocuments();
                model.onCommit();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$FilePropertiesChanged;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "<init>", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class FilePropertiesChanged
        extends SimpleAction {
            @NotNull
            public static final FilePropertiesChanged INSTANCE = new FilePropertiesChanged();

            private FilePropertiesChanged() {
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                PushedFilePropertiesUpdater.getInstance((Project)model.getProject()).filePropertiesChanged(model.getVFile(), Conditions.alwaysTrue());
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$FlushIndexes;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "<init>", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class FlushIndexes
        extends SimpleAction {
            @NotNull
            public static final FlushIndexes INSTANCE = new FlushIndexes();

            private FlushIndexes() {
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
                ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$Gc;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "<init>", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class Gc
        extends SimpleAction {
            @NotNull
            public static final Gc INSTANCE = new Gc();

            private Gc() {
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                GCUtil.tryGcSoftlyReachableObjects();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$LoadRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "kind", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "<init>", "(Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;)V", "getKind", "()Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.testFramework"})
        public static final class LoadRef
        implements Action {
            @NotNull
            private final RefKind kind;

            public LoadRef(@NotNull RefKind kind) {
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                this.kind = kind;
            }

            @NotNull
            public final RefKind getKind() {
                return this.kind;
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                Object oldValue = model.getRefs().get(this.kind);
                Object newValue = this.kind.loadRef(model);
                if (oldValue != null && newValue != null && oldValue != newValue) {
                    this.kind.checkDuplicates(oldValue, newValue);
                }
                ((Map)model.getRefs()).put(this.kind, newValue);
            }

            @NotNull
            public final RefKind component1() {
                return this.kind;
            }

            @NotNull
            public final LoadRef copy(@NotNull RefKind kind) {
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                return new LoadRef(kind);
            }

            public static /* synthetic */ LoadRef copy$default(LoadRef loadRef, RefKind refKind, int n, Object object) {
                if ((n & 1) != 0) {
                    refKind = loadRef.kind;
                }
                return loadRef.copy(refKind);
            }

            @NotNull
            public String toString() {
                return "LoadRef(kind=" + this.kind + ")";
            }

            public int hashCode() {
                return this.kind.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoadRef)) {
                    return false;
                }
                LoadRef loadRef = (LoadRef)other;
                return Intrinsics.areEqual((Object)this.kind, (Object)loadRef.kind);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$PostponedFormatting;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "<init>", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class PostponedFormatting
        extends SimpleAction {
            @NotNull
            public static final PostponedFormatting INSTANCE = new PostponedFormatting();

            private PostponedFormatting() {
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                PostprocessReformattingAspect.getInstance((Project)model.getProject()).doPostponedFormatting();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$Reformat;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "<init>", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class Reformat
        extends SimpleAction {
            @NotNull
            public static final Reformat INSTANCE = new Reformat();

            private Reformat() {
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                Commit.INSTANCE.performAction(model);
                CodeStyleManager.getInstance((Project)model.getProject()).reformat((PsiElement)Model.findPsiFile$default(model, null, 1, null));
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$ReloadFromDisk;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "<init>", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class ReloadFromDisk
        extends SimpleAction {
            @NotNull
            public static final ReloadFromDisk INSTANCE = new ReloadFromDisk();

            private ReloadFromDisk() {
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                PsiManager.getInstance((Project)model.getProject()).reloadFromDisk(Model.findPsiFile$default(model, null, 1, null));
                model.onReload();
                if (model.isCommitted()) {
                    model.onCommit();
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$RenamePsiFile;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "<init>", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class RenamePsiFile
        extends SimpleAction {
            @NotNull
            public static final RenamePsiFile INSTANCE = new RenamePsiFile();

            private RenamePsiFile() {
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                String newName = model.getVFile().getNameWithoutExtension() + "1." + model.getVFile().getExtension();
                Model.findPsiFile$default(model, null, 1, null).setName(newName);
                boolean bl = Intrinsics.areEqual((Object)Model.findPsiFile$default(model, null, 1, null).getName(), (Object)newName);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                bl = Intrinsics.areEqual((Object)model.getVFile().getName(), (Object)newName);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$RenameVirtualFile;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "<init>", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class RenameVirtualFile
        extends SimpleAction {
            @NotNull
            public static final RenameVirtualFile INSTANCE = new RenameVirtualFile();

            private RenameVirtualFile() {
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                model.getVFile().rename((Object)this, model.getVFile().getNameWithoutExtension() + "1." + model.getVFile().getExtension());
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$ReparseFile;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "<init>", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class ReparseFile
        extends SimpleAction {
            @NotNull
            public static final ReparseFile INSTANCE = new ReparseFile();

            private ReparseFile() {
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                VirtualFile[] virtualFileArray = new VirtualFile[]{model.getVFile()};
                FileContentUtilCore.reparseFiles((VirtualFile[])virtualFileArray);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$Save;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "<init>", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class Save
        extends SimpleAction {
            @NotNull
            public static final Save INSTANCE = new Save();

            private Save() {
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                FileDocumentManager.getInstance().saveAllDocuments();
                model.onSave();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SetDocumentText;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.testFramework"})
        public static final class SetDocumentText
        implements Action {
            @NotNull
            private final String text;

            public SetDocumentText(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.text = text2;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                model.getDocument().setText((CharSequence)this.text);
            }

            @NotNull
            public final String component1() {
                return this.text;
            }

            @NotNull
            public final SetDocumentText copy(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return new SetDocumentText(text2);
            }

            public static /* synthetic */ SetDocumentText copy$default(SetDocumentText setDocumentText, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = setDocumentText.text;
                }
                return setDocumentText.copy(string);
            }

            @NotNull
            public String toString() {
                return "SetDocumentText(text=" + this.text + ")";
            }

            public int hashCode() {
                return this.text.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SetDocumentText)) {
                    return false;
                }
                SetDocumentText setDocumentText = (SetDocumentText)other;
                return Intrinsics.areEqual((Object)this.text, (Object)setDocumentText.text);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SetFileText;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.testFramework"})
        public static final class SetFileText
        implements Action {
            @NotNull
            private final String text;

            public SetFileText(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.text = text2;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                Save.INSTANCE.performAction(model);
                VfsUtil.saveText((VirtualFile)model.getVFile(), (String)this.text);
            }

            @NotNull
            public final String component1() {
                return this.text;
            }

            @NotNull
            public final SetFileText copy(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return new SetFileText(text2);
            }

            public static /* synthetic */ SetFileText copy$default(SetFileText setFileText, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = setFileText.text;
                }
                return setFileText.copy(string);
            }

            @NotNull
            public String toString() {
                return "SetFileText(text=" + this.text + ")";
            }

            public int hashCode() {
                return this.text.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SetFileText)) {
                    return false;
                }
                SetFileText setFileText = (SetFileText)other;
                return Intrinsics.areEqual((Object)this.text, (Object)setFileText.text);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "<init>", "()V", "toString", "", "intellij.platform.testFramework"})
        public static abstract class SimpleAction
        implements Action {
            @NotNull
            public String toString() {
                String string = this.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                return string;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\r\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR1\u0010\f\u001a\"\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00010\rj\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0001`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "getVFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getFixture", "()Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "refs", "Ljava/util/HashMap;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "Lkotlin/collections/HashMap;", "getRefs", "()Ljava/util/HashMap;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "findPsiFile", "Lcom/intellij/psi/PsiFile;", "language", "Lcom/intellij/lang/Language;", "findViewProvider", "Lcom/intellij/psi/FileViewProvider;", "Lorg/jetbrains/annotations/Nullable;", "getDocument", "Lcom/intellij/openapi/editor/Document;", "isCommitted", "", "onCommit", "", "onReload", "onSave", "intellij.platform.testFramework"})
    @SourceDebugExtension(value={"SMAP\nPsiIndexConsistencyTester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiIndexConsistencyTester.kt\ncom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
    public static class Model {
        @NotNull
        private final VirtualFile vFile;
        @NotNull
        private final CodeInsightTestFixture fixture;
        @NotNull
        private final HashMap<RefKind, Object> refs;
        @NotNull
        private final Project project;

        public Model(@NotNull VirtualFile vFile, @NotNull CodeInsightTestFixture fixture) {
            Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
            Intrinsics.checkNotNullParameter((Object)fixture, (String)"fixture");
            this.vFile = vFile;
            this.fixture = fixture;
            this.refs = new HashMap();
            Project project = this.fixture.getProject();
            Intrinsics.checkNotNull((Object)project);
            this.project = project;
        }

        @NotNull
        public final VirtualFile getVFile() {
            return this.vFile;
        }

        @NotNull
        public final CodeInsightTestFixture getFixture() {
            return this.fixture;
        }

        @NotNull
        public final HashMap<RefKind, Object> getRefs() {
            return this.refs;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final PsiFile findPsiFile(@Nullable Language language) {
            FileViewProvider vp = this.findViewProvider();
            boolean bl = false;
            Language language2 = language;
            if (language2 == null) {
                Language language3 = vp.getBaseLanguage();
                language2 = language3;
                Intrinsics.checkNotNullExpressionValue((Object)language3, (String)"getBaseLanguage(...)");
            }
            PsiFile psiFile = vp.getPsi(language2);
            Intrinsics.checkNotNull((Object)psiFile);
            return psiFile;
        }

        public static /* synthetic */ PsiFile findPsiFile$default(Model model, Language language, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPsiFile");
            }
            if ((n & 1) != 0) {
                language = null;
            }
            return model.findPsiFile(language);
        }

        private final FileViewProvider findViewProvider() {
            FileViewProvider fileViewProvider = PsiManager.getInstance((Project)this.project).findViewProvider(this.vFile);
            Intrinsics.checkNotNull((Object)fileViewProvider);
            return fileViewProvider;
        }

        @NotNull
        public final Document getDocument() {
            Document document = FileDocumentManager.getInstance().getDocument(this.vFile);
            Intrinsics.checkNotNull((Object)document);
            return document;
        }

        public final boolean isCommitted() {
            Document document = FileDocumentManager.getInstance().getCachedDocument(this.vFile);
            return document == null || PsiDocumentManager.getInstance((Project)this.project).isCommitted(document);
        }

        public void onCommit() {
        }

        public void onReload() {
        }

        public void onSave() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u0006\u000b\f\r\u000e\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "", "<init>", "()V", "loadRef", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "checkDuplicates", "", "oldValue", "newValue", "PsiFileRef", "DocumentRef", "DirRef", "AstRef", "StubRef", "GreenStubRef", "intellij.platform.testFramework"})
    public static abstract class RefKind {
        @Nullable
        public abstract Object loadRef(@NotNull Model var1);

        public void checkDuplicates(@NotNull Object oldValue, @NotNull Object newValue) {
            Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            if (oldValue instanceof PsiElement && ((PsiElement)oldValue).isValid() && newValue instanceof PsiElement) {
                Assert.fail((String)("Duplicate PSI elements: " + oldValue + " and " + newValue));
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$AstRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "loadRef", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.testFramework"})
        public static final class AstRef
        extends RefKind {
            @Nullable
            private final Language language;

            public AstRef(@Nullable Language language) {
                this.language = language;
            }

            @Nullable
            public final Language getLanguage() {
                return this.language;
            }

            @Override
            @Nullable
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                return model.findPsiFile(this.language).getNode();
            }

            @Nullable
            public final Language component1() {
                return this.language;
            }

            @NotNull
            public final AstRef copy(@Nullable Language language) {
                return new AstRef(language);
            }

            public static /* synthetic */ AstRef copy$default(AstRef astRef, Language language, int n, Object object) {
                if ((n & 1) != 0) {
                    language = astRef.language;
                }
                return astRef.copy(language);
            }

            @NotNull
            public String toString() {
                return "AstRef(language=" + this.language + ")";
            }

            public int hashCode() {
                return this.language == null ? 0 : this.language.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AstRef)) {
                    return false;
                }
                AstRef astRef = (AstRef)other;
                return Intrinsics.areEqual((Object)this.language, (Object)astRef.language);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$DirRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "<init>", "()V", "loadRef", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class DirRef
        extends RefKind {
            @NotNull
            public static final DirRef INSTANCE = new DirRef();

            private DirRef() {
            }

            @Override
            @Nullable
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                return Model.findPsiFile$default(model, null, 1, null).getContainingDirectory();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$DocumentRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "<init>", "()V", "loadRef", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class DocumentRef
        extends RefKind {
            @NotNull
            public static final DocumentRef INSTANCE = new DocumentRef();

            private DocumentRef() {
            }

            @Override
            @NotNull
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                return model.getDocument();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$GreenStubRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "loadRef", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.testFramework"})
        public static final class GreenStubRef
        extends RefKind {
            @Nullable
            private final Language language;

            public GreenStubRef(@Nullable Language language) {
                this.language = language;
            }

            @Nullable
            public final Language getLanguage() {
                return this.language;
            }

            @Override
            @Nullable
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                PsiFile psiFile = model.findPsiFile(this.language);
                Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
                return ((PsiFileImpl)psiFile).getGreenStubTree();
            }

            @Nullable
            public final Language component1() {
                return this.language;
            }

            @NotNull
            public final GreenStubRef copy(@Nullable Language language) {
                return new GreenStubRef(language);
            }

            public static /* synthetic */ GreenStubRef copy$default(GreenStubRef greenStubRef, Language language, int n, Object object) {
                if ((n & 1) != 0) {
                    language = greenStubRef.language;
                }
                return greenStubRef.copy(language);
            }

            @NotNull
            public String toString() {
                return "GreenStubRef(language=" + this.language + ")";
            }

            public int hashCode() {
                return this.language == null ? 0 : this.language.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GreenStubRef)) {
                    return false;
                }
                GreenStubRef greenStubRef = (GreenStubRef)other;
                return Intrinsics.areEqual((Object)this.language, (Object)greenStubRef.language);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$PsiFileRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "<init>", "()V", "loadRef", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class PsiFileRef
        extends RefKind {
            @NotNull
            public static final PsiFileRef INSTANCE = new PsiFileRef();

            private PsiFileRef() {
            }

            @Override
            @NotNull
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                return Model.findPsiFile$default(model, null, 1, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$StubRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "loadRef", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.testFramework"})
        public static final class StubRef
        extends RefKind {
            @Nullable
            private final Language language;

            public StubRef(@Nullable Language language) {
                this.language = language;
            }

            @Nullable
            public final Language getLanguage() {
                return this.language;
            }

            @Override
            @Nullable
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                PsiFile psiFile = model.findPsiFile(this.language);
                Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
                return ((PsiFileImpl)psiFile).getStubTree();
            }

            @Nullable
            public final Language component1() {
                return this.language;
            }

            @NotNull
            public final StubRef copy(@Nullable Language language) {
                return new StubRef(language);
            }

            public static /* synthetic */ StubRef copy$default(StubRef stubRef, Language language, int n, Object object) {
                if ((n & 1) != 0) {
                    language = stubRef.language;
                }
                return stubRef.copy(language);
            }

            @NotNull
            public String toString() {
                return "StubRef(language=" + this.language + ")";
            }

            public int hashCode() {
                return this.language == null ? 0 : this.language.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StubRef)) {
                    return false;
                }
                StubRef stubRef = (StubRef)other;
                return Intrinsics.areEqual((Object)this.language, (Object)stubRef.language);
            }
        }
    }
}

