/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class VfsTestUtil {
    public static final Key<String> TEST_DATA_FILE_PATH = Key.create((String)"TEST_DATA_FILE_PATH");

    private VfsTestUtil() {
    }

    public static void syncRefresh() {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            VirtualFileManager.getInstance().syncRefresh();
            IndexingTestUtil.waitUntilIndexesAreReadyInAllOpenedProjects();
        } else if (ApplicationManager.getApplication().isDispatchThread()) {
            WriteAction.compute(() -> ((VirtualFileManager)VirtualFileManager.getInstance()).syncRefresh());
            IndexingTestUtil.waitUntilIndexesAreReadyInAllOpenedProjects();
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.compute(() -> ((VirtualFileManager)VirtualFileManager.getInstance()).syncRefresh()));
            IndexingTestUtil.waitUntilIndexesAreReadyInAllOpenedProjects();
        }
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath) {
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(1);
        }
        return VfsTestUtil.createFile(root, relativePath, (byte[])null);
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath, @Nullable String text2) {
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(2);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(3);
        }
        try {
            return VfsTestUtil.createFileOrDir(root, relativePath, text2 == null ? null : VfsUtil.toByteArray((VirtualFile)root, (String)text2), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile root, @NotNull String relativePath, byte @Nullable [] data) {
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(4);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(5);
        }
        return VfsTestUtil.createFileOrDir(root, relativePath, data, false);
    }

    @NotNull
    public static VirtualFile createDir(@NotNull VirtualFile root, @NotNull String relativePath) {
        if (root == null) {
            VfsTestUtil.$$$reportNull$$$0(6);
        }
        if (relativePath == null) {
            VfsTestUtil.$$$reportNull$$$0(7);
        }
        return VfsTestUtil.createFileOrDir(root, relativePath, null, true);
    }

    @NotNull
    private static VirtualFile createFileOrDir(VirtualFile root, String relativePath, byte @Nullable [] data, boolean dir) {
        VirtualFile virtualFile;
        try {
            virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> {
                VirtualFile file2;
                VirtualFile parent = root;
                for (String name : StringUtil.tokenize((String)PathUtil.getParentPath((String)relativePath), (String)"/")) {
                    VirtualFile child = parent.findChild(name);
                    if (child == null || !child.isValid()) {
                        child = parent.createChildDirectory(VfsTestUtil.class, name);
                    }
                    parent = child;
                }
                parent.getChildren();
                String name = PathUtil.getFileName((String)relativePath);
                if (dir) {
                    file2 = parent.createChildDirectory(VfsTestUtil.class, name);
                } else {
                    FileDocumentManager manager = FileDocumentManager.getInstance();
                    file2 = parent.findChild(name);
                    if (file2 == null) {
                        file2 = parent.createChildData(VfsTestUtil.class, name);
                    } else {
                        Document document = manager.getCachedDocument(file2);
                        if (document != null) {
                            manager.saveDocument(document);
                        }
                    }
                    if (data != null) {
                        file2.setBinaryContent(data);
                    }
                    manager.reloadFiles(new VirtualFile[]{file2});
                }
                return file2;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            VfsTestUtil.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    public static void deleteFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsTestUtil.$$$reportNull$$$0(9);
        }
        try {
            WriteAction.runAndWait(() -> file2.delete((Object)file2));
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrow((Throwable)throwable);
        }
    }

    public static void clearContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsTestUtil.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                VfsUtil.saveText((VirtualFile)file2, (String)"");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void overwriteTestData(@NotNull String filePath, @NotNull String actual) {
        if (filePath == null) {
            VfsTestUtil.$$$reportNull$$$0(11);
        }
        if (actual == null) {
            VfsTestUtil.$$$reportNull$$$0(12);
        }
        VfsTestUtil.overwriteTestData(filePath, actual, false);
    }

    public static void overwriteTestData(@NotNull String filePath, @NotNull String actual, boolean preserveSpaces) {
        if (filePath == null) {
            VfsTestUtil.$$$reportNull$$$0(13);
        }
        if (actual == null) {
            VfsTestUtil.$$$reportNull$$$0(14);
        }
        try {
            File file2 = new File(filePath);
            if (preserveSpaces) {
                try {
                    actual = VfsTestUtil.preserveSpacesFromFile(file2, actual);
                }
                catch (Throwable e) {
                    System.err.println("Failed to preserve spaces: " + e.getMessage());
                }
            }
            FileUtil.writeToFile((File)file2, (String)actual);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String preserveSpacesFromFile(@NotNull File file2, @NotNull String actual) throws IOException {
        int trail;
        int lead;
        if (file2 == null) {
            VfsTestUtil.$$$reportNull$$$0(15);
        }
        if (actual == null) {
            VfsTestUtil.$$$reportNull$$$0(16);
        }
        if (!file2.exists()) {
            return actual;
        }
        String existing = FileUtil.loadFile((File)file2, (Charset)StandardCharsets.UTF_8);
        int eLen = existing.length();
        for (lead = 0; lead < eLen && Character.isWhitespace(existing.charAt(lead)); ++lead) {
        }
        if (lead != eLen) {
            for (trail = eLen; trail > 0 && Character.isWhitespace(existing.charAt(trail - 1)); --trail) {
            }
        }
        actual = existing.substring(0, lead) + ((String)actual).trim() + existing.substring(trail, eLen);
        return actual;
    }

    @NotNull
    public static VirtualFile findFileByCaseSensitivePath(@NotNull String absolutePath) {
        if (absolutePath == null) {
            VfsTestUtil.$$$reportNull$$$0(17);
        }
        String vfsPath = FileUtil.toSystemIndependentName((String)absolutePath);
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(vfsPath);
        Assert.assertNotNull((String)("file " + absolutePath + " not found"), (Object)vFile);
        String realVfsPath = vFile.getPath();
        if (!vFile.isCaseSensitive() && !vfsPath.equals(realVfsPath) && vfsPath.equalsIgnoreCase(realVfsPath)) {
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + vfsPath + "\nreal path " + realVfsPath));
        }
        VirtualFile virtualFile = vFile;
        if (virtualFile == null) {
            VfsTestUtil.$$$reportNull$$$0(18);
        }
        return virtualFile;
    }

    public static void assertFilePathEndsWithCaseSensitivePath(@NotNull VirtualFile file2, @NotNull String suffixPath) {
        if (file2 == null) {
            VfsTestUtil.$$$reportNull$$$0(19);
        }
        if (suffixPath == null) {
            VfsTestUtil.$$$reportNull$$$0(20);
        }
        String vfsSuffixPath = FileUtil.toSystemIndependentName((String)suffixPath);
        String vfsPath = file2.getPath();
        if (!file2.isCaseSensitive() && !vfsPath.endsWith(vfsSuffixPath) && StringUtil.endsWithIgnoreCase((String)vfsPath, (String)vfsSuffixPath)) {
            String realSuffixPath = vfsPath.substring(vfsPath.length() - vfsSuffixPath.length());
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + suffixPath + "\nreal path " + realSuffixPath));
        }
    }

    @NotNull
    public static List<VFileEvent> getEvents(@NotNull Runnable action) {
        if (action == null) {
            VfsTestUtil.$$$reportNull$$$0(21);
        }
        final List<VFileEvent> allEvents = Collections.synchronizedList(new ArrayList());
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                allEvents.addAll(events);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/testFramework/VfsTestUtil$1", "after"));
            }
        });
        try {
            action.run();
        }
        finally {
            connection.disconnect();
        }
        List<VFileEvent> list = allEvents;
        if (list == null) {
            VfsTestUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public static List<String> print(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            VfsTestUtil.$$$reportNull$$$0(23);
        }
        List list = ContainerUtil.map(events, VfsTestUtil::print);
        if (list == null) {
            VfsTestUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static String print(VFileEvent e) {
        int type = 63;
        if (e instanceof VFileCreateEvent) {
            type = 67;
        } else if (e instanceof VFileDeleteEvent) {
            type = 68;
        } else if (e instanceof VFileContentChangeEvent) {
            type = 85;
        } else if (e instanceof VFilePropertyChangeEvent) {
            type = 80;
        }
        return (char)type + " : " + e.getPath();
    }

    public static void waitForFileWatcher() {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        if (localFileSystem instanceof LocalFileSystemImpl) {
            LocalFileSystemImpl impl = (LocalFileSystemImpl)localFileSystem;
            FileWatcher watcher = impl.getFileWatcher();
            long stopAt = System.nanoTime() + TimeUnit.MINUTES.toNanos(1L);
            while (watcher.isSettingRoots() && System.nanoTime() < stopAt) {
                TimeoutUtil.sleep((long)10L);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 18, 22, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 8: 
            case 18: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/VfsTestUtil";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixPath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/VfsTestUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileOrDir";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileByCaseSensitivePath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "print";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDir";
                break;
            }
            case 8: 
            case 18: 
            case 22: 
            case 24: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clearContent";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "overwriteTestData";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "preserveSpacesFromFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findFileByCaseSensitivePath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "assertFilePathEndsWithCaseSensitivePath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEvents";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 18, 22, 24 -> new IllegalStateException(string);
        };
    }
}

