/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.PsiNamesElementSignatureProvider;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPsiNamesElementSignatureProviderTest
extends BasePlatformTestCase {
    AbstractPsiNamesElementSignatureProviderTest() {
    }

    void doTest(@NotNull String text2, @NotNull String ext) {
        if (text2 == null) {
            AbstractPsiNamesElementSignatureProviderTest.$$$reportNull$$$0(0);
        }
        if (ext == null) {
            AbstractPsiNamesElementSignatureProviderTest.$$$reportNull$$$0(1);
        }
        this.myFixture.configureByText("test." + ext, text2);
        EditorTestUtil.buildInitialFoldingsInBackground(this.myFixture.getEditor());
        FoldRegion[] foldRegions = this.myFixture.getEditor().getFoldingModel().getAllFoldRegions();
        AbstractPsiNamesElementSignatureProviderTest.assertTrue((foldRegions.length > 1 ? 1 : 0) != 0);
        for (FoldRegion region : foldRegions) {
            PsiElement element = AbstractPsiNamesElementSignatureProviderTest.findElement(region, this.myFixture.getFile());
            if (element == null) continue;
            PsiNamesElementSignatureProvider provider = new PsiNamesElementSignatureProvider();
            String signature = provider.getSignature(element);
            AbstractPsiNamesElementSignatureProviderTest.assertNotNull((Object)signature);
            AbstractPsiNamesElementSignatureProviderTest.assertEquals((Object)element, (Object)provider.restoreBySignature(this.myFixture.getFile(), signature, null));
        }
    }

    @Nullable
    private static PsiElement findElement(@NotNull FoldRegion region, @NotNull PsiFile file2) {
        if (region == null) {
            AbstractPsiNamesElementSignatureProviderTest.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            AbstractPsiNamesElementSignatureProviderTest.$$$reportNull$$$0(3);
        }
        return AbstractPsiNamesElementSignatureProviderTest.findElement(region.getStartOffset(), region.getEndOffset(), file2);
    }

    @Nullable
    static PsiElement findElement(int startOffset, int endOffset, @NotNull PsiFile file2) {
        if (file2 == null) {
            AbstractPsiNamesElementSignatureProviderTest.$$$reportNull$$$0(4);
        }
        for (PsiElement element = file2.findElementAt(startOffset); element != null; element = element.getParent()) {
            TextRange range = element.getTextRange();
            if (range.getStartOffset() < startOffset) {
                return null;
            }
            if (range.getStartOffset() != startOffset || range.getEndOffset() != endOffset) continue;
            return element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/AbstractPsiNamesElementSignatureProviderTest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doTest";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

