/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.makefile.MakefileFile;
import com.jetbrains.lang.makefile.psi.MakefileBlock;
import com.jetbrains.lang.makefile.psi.MakefileCondition;
import com.jetbrains.lang.makefile.psi.MakefileConditional;
import com.jetbrains.lang.makefile.psi.MakefileConditionalElse;
import com.jetbrains.lang.makefile.psi.MakefileDefine;
import com.jetbrains.lang.makefile.psi.MakefileRule;
import com.jetbrains.lang.makefile.psi.MakefileTypes;
import com.jetbrains.lang.makefile.psi.MakefileVariable;
import com.jetbrains.lang.makefile.psi.MakefileVariableAssignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0006\u0015\u0016\u0017\u0018\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J+\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/lang/makefile/MakefileFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilderEx;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "getPlaceholderText", "", "Lcom/intellij/openapi/util/NlsSafe;", "node", "Lcom/intellij/lang/ASTNode;", "isCollapsedByDefault", "Companion", "MakefileRuleFoldingDescriptor", "MakefileVariableFoldingDescriptor", "MakefileDefineFoldingDescriptor", "MakefileConditionalFoldingDescriptor", "MakefileConditionalElseFoldingDescriptor", "intellij.makefile"})
@SourceDebugExtension(value={"SMAP\nMakefileFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakefileFoldingBuilder.kt\ncom/jetbrains/lang/makefile/MakefileFoldingBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,223:1\n1611#2,9:224\n1863#2:233\n1864#2:235\n1620#2:236\n1#3:234\n37#4,2:237\n*S KotlinDebug\n*F\n+ 1 MakefileFoldingBuilder.kt\ncom/jetbrains/lang/makefile/MakefileFoldingBuilder\n*L\n30#1:224,9\n30#1:233\n30#1:235\n30#1:236\n30#1:234\n54#1:237,2\n*E\n"})
public final class MakefileFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NlsSafe
    @NotNull
    private static final String DEFAULT_PLACEHOLDER_TEXT = "...";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        void $this$toTypedArray$iv;
        void $this$mapNotNullTo$iv$iv;
        Collection $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!(root instanceof MakefileFile)) {
            Intrinsics.checkNotNullExpressionValue((Object)FoldingDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return FoldingDescriptor.EMPTY_ARRAY;
        }
        Class[] classArray = new Class[]{MakefileRule.class, MakefileVariableAssignment.class, MakefileDefine.class, MakefileConditional.class, MakefileConditionalElse.class};
        Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)root, (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
        Iterable iterable = collection;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FoldingDescriptor foldingDescriptor;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            PsiElement psiElement = it;
            if (psiElement instanceof MakefileRule) {
                foldingDescriptor = new MakefileRuleFoldingDescriptor((MakefileRule)it);
            } else if (psiElement instanceof MakefileVariableAssignment) {
                foldingDescriptor = new MakefileVariableFoldingDescriptor((MakefileVariableAssignment)it);
            } else if (psiElement instanceof MakefileDefine) {
                foldingDescriptor = new MakefileDefineFoldingDescriptor((MakefileDefine)it);
            } else if (psiElement instanceof MakefileConditional) {
                range = Companion.withoutFirstNode(it);
                foldingDescriptor = !range.isEmpty() ? new MakefileConditionalFoldingDescriptor((MakefileConditional)it, range) : null;
            } else if (psiElement instanceof MakefileConditionalElse) {
                IElementType iElementType = MakefileTypes.KEYWORD_ENDIF;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"KEYWORD_ENDIF");
                range = Companion.withoutFirstNodeWithNextSiblingOfType(it, iElementType);
                foldingDescriptor = range.isEmpty() ? null : new MakefileConditionalElseFoldingDescriptor((MakefileConditionalElse)it, range);
            } else {
                foldingDescriptor = null;
            }
            if (foldingDescriptor == null) continue;
            FoldingDescriptor it$iv$iv = foldingDescriptor;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FoldingDescriptor[0]);
    }

    @NotNull
    public String getPlaceholderText(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return DEFAULT_PLACEHOLDER_TEXT;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.getPsi() instanceof MakefileDefine;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u000f\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n*\u00020\u000bJ\n\u0010\f\u001a\u00020\t*\u00020\u000bJ\u0012\u0010\r\u001a\u00020\t*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0082\u0010R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/lang/makefile/MakefileFoldingBuilder$Companion;", "", "<init>", "()V", "DEFAULT_PLACEHOLDER_TEXT", "", "cutValue", "value", "trimmedTextRange", "Lcom/intellij/openapi/util/TextRange;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/psi/PsiElement;", "withoutFirstNode", "withoutFirstNodeWithNextSiblingOfType", "siblingType", "Lcom/intellij/psi/tree/IElementType;", "nextNonWhiteSpaceSibling", "intellij.makefile"})
    @SourceDebugExtension(value={"SMAP\nMakefileFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakefileFoldingBuilder.kt\ncom/jetbrains/lang/makefile/MakefileFoldingBuilder$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,223:1\n170#2,6:224\n*S KotlinDebug\n*F\n+ 1 MakefileFoldingBuilder.kt\ncom/jetbrains/lang/makefile/MakefileFoldingBuilder$Companion\n*L\n77#1:224,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final String cutValue(@Nullable String value) {
            String string;
            Object object;
            if (value == null) return "";
            String it = value;
            boolean bl = false;
            if (it.length() > 60) {
                String string2 = it.substring(0, 42);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                object = string2 + MakefileFoldingBuilder.DEFAULT_PLACEHOLDER_TEXT;
            } else {
                object = it;
            }
            if ((string = object) == null) return "";
            String string3 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (string3 == null) return "";
            String string4 = string3;
            return string4;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TextRange trimmedTextRange(@NotNull PsiElement $this$trimmedTextRange) {
            int n;
            int n2;
            int n3;
            block2: {
                void $this$indexOfLast$iv;
                Intrinsics.checkNotNullParameter((Object)$this$trimmedTextRange, (String)"<this>");
                int n4 = $this$trimmedTextRange.getTextRange().getStartOffset();
                int n5 = $this$trimmedTextRange.getTextRange().getStartOffset();
                String string = $this$trimmedTextRange.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                CharSequence charSequence = string;
                n3 = n5;
                n2 = n4;
                boolean $i$f$indexOfLast = false;
                int n6 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n6) {
                    do {
                        int index$iv = n6--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(!CharsKt.isWhitespace((char)it))) continue;
                        n = index$iv;
                        break block2;
                    } while (0 <= n6);
                }
                n = -1;
            }
            int n7 = n;
            TextRange textRange = TextRange.create((int)n2, (int)(n3 + n7 + 1));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
            return textRange;
        }

        @NotNull
        public final TextRange withoutFirstNode(@NotNull PsiElement $this$withoutFirstNode) {
            Intrinsics.checkNotNullParameter((Object)$this$withoutFirstNode, (String)"<this>");
            PsiElement psiElement = $this$withoutFirstNode.getFirstChild();
            int startOffset = psiElement != null && (psiElement = this.nextNonWhiteSpaceSibling(psiElement)) != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.getStartOffset() : $this$withoutFirstNode.getTextRange().getEndOffset();
            TextRange textRange = TextRange.create((int)startOffset, (int)$this$withoutFirstNode.getTextRange().getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
            return textRange;
        }

        @NotNull
        public final TextRange withoutFirstNodeWithNextSiblingOfType(@NotNull PsiElement $this$withoutFirstNodeWithNextSiblingOfType, @NotNull IElementType siblingType) {
            TextRange textRange;
            Intrinsics.checkNotNullParameter((Object)$this$withoutFirstNodeWithNextSiblingOfType, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)siblingType, (String)"siblingType");
            PsiElement nextSibling = this.nextNonWhiteSpaceSibling($this$withoutFirstNodeWithNextSiblingOfType);
            if (nextSibling == null) {
                textRange = this.withoutFirstNode($this$withoutFirstNodeWithNextSiblingOfType);
            } else if (Intrinsics.areEqual((Object)nextSibling.getNode().getElementType(), (Object)siblingType)) {
                PsiElement psiElement = $this$withoutFirstNodeWithNextSiblingOfType.getFirstChild();
                int startOffset = psiElement != null && (psiElement = this.nextNonWhiteSpaceSibling(psiElement)) != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.getStartOffset() : $this$withoutFirstNodeWithNextSiblingOfType.getTextRange().getEndOffset();
                int endOffset = nextSibling.getTextRange().getEndOffset();
                TextRange textRange2 = TextRange.create((int)startOffset, (int)endOffset);
                Intrinsics.checkNotNull((Object)textRange2);
                textRange = textRange2;
            } else {
                textRange = this.withoutFirstNode($this$withoutFirstNodeWithNextSiblingOfType);
            }
            return textRange;
        }

        private final PsiElement nextNonWhiteSpaceSibling(PsiElement $this$nextNonWhiteSpaceSibling) {
            PsiElement psiElement;
            block2: {
                Companion companion = this;
                while (true) {
                    if (!($this$nextNonWhiteSpaceSibling.getNextSibling() instanceof PsiWhiteSpace)) {
                        psiElement = $this$nextNonWhiteSpaceSibling.getNextSibling();
                        break block2;
                    }
                    PsiElement psiElement2 = $this$nextNonWhiteSpaceSibling.getNextSibling();
                    if (psiElement2 == null) break;
                    $this$nextNonWhiteSpaceSibling = psiElement2;
                }
                psiElement = null;
            }
            return psiElement;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/lang/makefile/MakefileFoldingBuilder$MakefileConditionalElseFoldingDescriptor;", "Lcom/intellij/lang/folding/FoldingDescriptor;", "conditionalElse", "Lcom/jetbrains/lang/makefile/psi/MakefileConditionalElse;", "range", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/jetbrains/lang/makefile/psi/MakefileConditionalElse;Lcom/intellij/openapi/util/TextRange;)V", "getPlaceholderText", "", "intellij.makefile"})
    @SourceDebugExtension(value={"SMAP\nMakefileFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakefileFoldingBuilder.kt\ncom/jetbrains/lang/makefile/MakefileFoldingBuilder$MakefileConditionalElseFoldingDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
    public static final class MakefileConditionalElseFoldingDescriptor
    extends FoldingDescriptor {
        @NotNull
        private final MakefileConditionalElse conditionalElse;

        public MakefileConditionalElseFoldingDescriptor(@NotNull MakefileConditionalElse conditionalElse, @NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)conditionalElse, (String)"conditionalElse");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            super((PsiElement)conditionalElse, range);
            this.conditionalElse = conditionalElse;
        }

        @NotNull
        public String getPlaceholderText() {
            Object object;
            Object[] condition;
            MakefileCondition makefileCondition = this.conditionalElse.getCondition();
            Object object2 = condition = makefileCondition != null ? makefileCondition.getText() : null;
            if (condition == null) {
                MakefileBlock makefileBlock = this.conditionalElse.getBlock();
                String placeholderText = Companion.cutValue(makefileBlock != null ? makefileBlock.getText() : null);
                object = ((CharSequence)placeholderText).length() == 0 ? " ..." : " " + placeholderText;
            } else {
                Object[] objectArray;
                PsiElement psiElement = this.conditionalElse.getFirstChild();
                PsiElement secondChild = psiElement != null ? Companion.nextNonWhiteSpaceSibling(psiElement) : null;
                objectArray = secondChild != null && SetsKt.setOf((Object[])(objectArray = new IElementType[]{MakefileTypes.KEYWORD_IFDEF, MakefileTypes.KEYWORD_IFNDEF, MakefileTypes.KEYWORD_IFEQ, MakefileTypes.KEYWORD_IFNEQ})).contains(secondChild.getNode().getElementType()) ? secondChild.getText() + " " + (String)condition : condition;
                Companion companion = Companion;
                Object[] p0 = objectArray;
                boolean $i$f$getPlaceholderText$stub_for_inlining = false;
                boolean bl = false;
                String placeholderText = companion.cutValue((String)p0);
                object = StringsKt.endsWith$default((CharSequence)placeholderText, (char)' ', (boolean)false, (int)2, null) ? placeholderText : placeholderText + " ";
            }
            return object;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/lang/makefile/MakefileFoldingBuilder$MakefileConditionalFoldingDescriptor;", "Lcom/intellij/lang/folding/FoldingDescriptor;", "conditional", "Lcom/jetbrains/lang/makefile/psi/MakefileConditional;", "range", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/jetbrains/lang/makefile/psi/MakefileConditional;Lcom/intellij/openapi/util/TextRange;)V", "getPlaceholderText", "", "intellij.makefile"})
    public static final class MakefileConditionalFoldingDescriptor
    extends FoldingDescriptor {
        @NotNull
        private final MakefileConditional conditional;

        public MakefileConditionalFoldingDescriptor(@NotNull MakefileConditional conditional, @NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)conditional, (String)"conditional");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            super((PsiElement)conditional, range);
            this.conditional = conditional;
        }

        @NotNull
        public String getPlaceholderText() {
            MakefileCondition makefileCondition = this.conditional.getCondition();
            return Companion.cutValue(makefileCondition != null ? makefileCondition.getText() : null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/lang/makefile/MakefileFoldingBuilder$MakefileDefineFoldingDescriptor;", "Lcom/intellij/lang/folding/FoldingDescriptor;", "define", "Lcom/jetbrains/lang/makefile/psi/MakefileDefine;", "<init>", "(Lcom/jetbrains/lang/makefile/psi/MakefileDefine;)V", "getPlaceholderText", "", "intellij.makefile"})
    public static final class MakefileDefineFoldingDescriptor
    extends FoldingDescriptor {
        @NotNull
        private final MakefileDefine define;

        public MakefileDefineFoldingDescriptor(@NotNull MakefileDefine define) {
            Intrinsics.checkNotNullParameter((Object)define, (String)"define");
            super((PsiElement)define, Companion.trimmedTextRange(define));
            this.define = define;
        }

        @NotNull
        public String getPlaceholderText() {
            MakefileVariable makefileVariable = this.define.getVariable();
            String string = makefileVariable != null ? makefileVariable.getText() : null;
            Object object = this.define.getAssignment();
            if (object == null || (object = object.getText()) == null) {
                object = "=";
            }
            return string + (String)object + Companion.cutValue(this.define.getValue());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/lang/makefile/MakefileFoldingBuilder$MakefileRuleFoldingDescriptor;", "Lcom/intellij/lang/folding/FoldingDescriptor;", "rule", "Lcom/jetbrains/lang/makefile/psi/MakefileRule;", "<init>", "(Lcom/jetbrains/lang/makefile/psi/MakefileRule;)V", "getPlaceholderText", "", "intellij.makefile"})
    public static final class MakefileRuleFoldingDescriptor
    extends FoldingDescriptor {
        @NotNull
        private final MakefileRule rule;

        public MakefileRuleFoldingDescriptor(@NotNull MakefileRule rule) {
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            super((PsiElement)rule, Companion.trimmedTextRange(rule));
            this.rule = rule;
        }

        @NotNull
        public String getPlaceholderText() {
            return this.rule.getTargetLine().getTargets().getText() + ":";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/lang/makefile/MakefileFoldingBuilder$MakefileVariableFoldingDescriptor;", "Lcom/intellij/lang/folding/FoldingDescriptor;", "variable", "Lcom/jetbrains/lang/makefile/psi/MakefileVariableAssignment;", "<init>", "(Lcom/jetbrains/lang/makefile/psi/MakefileVariableAssignment;)V", "getPlaceholderText", "", "intellij.makefile"})
    public static final class MakefileVariableFoldingDescriptor
    extends FoldingDescriptor {
        @NotNull
        private final MakefileVariableAssignment variable;

        public MakefileVariableFoldingDescriptor(@NotNull MakefileVariableAssignment variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            super((PsiElement)variable, Companion.trimmedTextRange(variable));
            this.variable = variable;
        }

        @NotNull
        public String getPlaceholderText() {
            String string = this.variable.getVariable().getText();
            Object object = this.variable.getAssignment();
            if (object == null || (object = object.getText()) == null) {
                object = "=";
            }
            return string + (String)object + Companion.cutValue(this.variable.getValue());
        }
    }
}

