/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.testing.ctest;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.testing.CMakeTestRunConfiguration;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CTestUtil;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectState;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectTestInfo;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestRunConfigurationData;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsActionEx;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrTestCommandLineState<CONFIGURATION> {
    public static final String SEPARATOR = ",";
    public static final Supplier<CidrTestScope> EMPTY_TEST_SCOPE_PRODUCER = () -> CidrTestScope.createEmptyTestScope((String)SEPARATOR);

    public CidrCTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        if (configuration == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(0);
        }
        if (launcher == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(3);
        }
        super(configuration, launcher, env, executor, failedTests, EMPTY_TEST_SCOPE_PRODUCER);
    }

    @NotNull
    public CidrTestScope testScope() {
        if (this.myFailedTests != null) {
            CidrTestScope cidrTestScope = this.myFailedTests;
            if (cidrTestScope == null) {
                CidrCTestCommandLineState.$$$reportNull$$$0(4);
            }
            return cidrTestScope;
        }
        CidrTestRunConfigurationData delegate = this.myConfiguration.getTestData();
        CidrTestScope cidrTestScope = this.createEmptyTestScope().configureForPreRenderedScope(StringUtil.notNullize((String)(delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN ? delegate.getTestPattern() : delegate.getTestName())));
        if (cidrTestScope == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(5);
        }
        return cidrTestScope;
    }

    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView consoleView) {
        if (consoleView == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(6);
        }
        return new CidrRerunFailedTestsActionEx((ComponentContainer)consoleView, testContext -> {
            String url = ((AbstractTestProxy)testContext.first).getLocationUrl();
            if (url != null && url.startsWith("ctest://")) {
                return url.substring("ctest://".length());
            }
            return null;
        }, (CidrTestCommandLineState)this);
    }

    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@NlsSafe @Nullable String suite, @NlsSafe @Nullable String test) {
        CidrTestScopeElement cidrTestScopeElement = CidrTestScopeElementImpl.createTestScopeElementForSuiteAndTest((String)suite, (String)test, CTestUtil.GENERATOR);
        if (cidrTestScopeElement == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(7);
        }
        return cidrTestScopeElement;
    }

    public void prepareTestExecutionEnvironment(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(8);
        }
        CidrTestRunConfiguration configuration = this.getConfiguration();
        CidrTestRunConfigurationData data = configuration.getTestData();
        data.setCommandLineTestPattern(this.testScope().getAsPattern());
        if (data instanceof CidrCTestRunConfigurationData) {
            ((CidrCTestRunConfigurationData)data).prepareTestList(this.getExecutionTarget(), progress);
        }
        super.prepareTestExecutionEnvironment(progress);
    }

    @Contract(pure=true)
    protected boolean needCloseBeforeTestRunTaskResults() {
        return false;
    }

    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        CidrTestRunConfiguration _configuration;
        if (cl == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(9);
        }
        if ((_configuration = this.getConfiguration()) instanceof CMakeTestRunConfiguration) {
            CMakeTestRunConfiguration configuration;
            CMakeAppRunConfiguration.BuildAndRunConfigurations configurations = (configuration = (CMakeTestRunConfiguration)_configuration).getBuildAndRunConfigurations(this.getExecutionTarget());
            cl.addParameters(CidrCTestCommandLineState.getTestListParams(configuration, configurations == null ? null : configurations.buildConfiguration));
        }
        return cl;
    }

    @NotNull
    static List<String> getTestListParams(@Nullable CMakeTestRunConfiguration configuration, @Nullable CMakeConfiguration buildConfiguration) {
        String commandLineTestPattern;
        ArrayList<String> parameters = new ArrayList<String>();
        if (configuration != null && StringUtil.isNotEmpty((String)(commandLineTestPattern = configuration.getTestData().getCommandLineTestPattern()))) {
            CidrTestScope scope = EMPTY_TEST_SCOPE_PRODUCER.get();
            scope.addPattern(commandLineTestPattern);
            parameters.addAll(CidrCTestCommandLineState.getPatternListParameters(scope.getAsPatternList(), configuration.getProject()));
        }
        if (buildConfiguration != null && !CMakeGeneratorType.isSingleConfigurationGenerator((CMakeGeneratorType)buildConfiguration.getGenerator().generatorSpec.getGenerator())) {
            parameters.add("-C");
            parameters.add(buildConfiguration.getBuildType());
        }
        ArrayList<String> arrayList = parameters;
        if (arrayList == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> getPatternListParameters(@NotNull List<String> testNames, @NotNull Project project) {
        if (testNames == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(11);
        }
        if (project == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(12);
        }
        if (testNames.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CidrCTestCommandLineState.$$$reportNull$$$0(13);
            }
            return list;
        }
        CidrCTestProjectState state = (CidrCTestProjectState)project.getService(CidrCTestProjectState.class);
        if (state.hasValidTestDescriptors()) {
            HashSet<Integer> testNumbers = new HashSet<Integer>();
            for (String testName : testNames) {
                CidrCTestProjectTestInfo testInfo = state.geTestInfo(testName);
                if (testInfo == null) continue;
                testNumbers.add(testInfo.getTestNumber());
            }
            if (testNumbers.isEmpty() || testNumbers.size() == state.getTests().size()) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    CidrCTestCommandLineState.$$$reportNull$$$0(14);
                }
                return list;
            }
            Integer firstTestNumber = (Integer)testNumbers.iterator().next();
            List<CallSite> list = List.of("-I", firstTestNumber + SEPARATOR + firstTestNumber + ",," + StringUtil.join(testNumbers, (String)SEPARATOR));
            if (list == null) {
                CidrCTestCommandLineState.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<CallSite> list = List.of("-R", "^(" + StringUtil.join(testNames, (String)"|") + ")$");
        if (list == null) {
            CidrCTestCommandLineState.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 10, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CidrCTestCommandLineState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/CidrCTestCommandLineState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "testScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestScopeElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestListParams";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternListParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRerunFailedTestsAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestExecutionEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPatternListParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 10, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

