/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.packagemanager.commandline;

import com.intellij.openapi.progress.ProgressIndicator;
import com.jetbrains.cidr.packagemanager.commandline.ParserCommandLine;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/packagemanager/commandline/NumericalRatioProgressParser;", "Lcom/jetbrains/cidr/packagemanager/commandline/ParserCommandLine;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "parse", "", "s", "", "Lcom/intellij/openapi/util/NlsSafe;", "Companion", "intellij.clion.packageManager"})
public final class NumericalRatioProgressParser
implements ParserCommandLine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProgressIndicator indicator;
    @NotNull
    private static final Regex numericalRatioRegex = new Regex("\\d+/\\d+");

    public NumericalRatioProgressParser(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.indicator = indicator;
    }

    @Override
    public void parse(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        MatchResult result = Regex.find$default((Regex)numericalRatioRegex, (CharSequence)s, (int)0, (int)2, null);
        if (result != null) {
            String[] stringArray = new String[]{"/"};
            List progress = StringsKt.split$default((CharSequence)result.getValue(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            long current = Long.parseLong((String)progress.get(0)) - 1L;
            long total = Long.parseLong((String)progress.get(1));
            this.indicator.setText(((Object)StringsKt.trim((CharSequence)StringsKt.substring((String)s, (IntRange)new IntRange(result.getRange().getLast() + 2, s.length() - 1)))).toString());
            this.indicator.setFraction((double)current / (double)total);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/packagemanager/commandline/NumericalRatioProgressParser$Companion;", "", "<init>", "()V", "numericalRatioRegex", "Lkotlin/text/Regex;", "getNumericalRatioRegex", "()Lkotlin/text/Regex;", "intellij.clion.packageManager"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getNumericalRatioRegex() {
            return numericalRatioRegex;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

