/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultFuture;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ThrowableFunction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerCustomTasks;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerCustomTasksBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangTidyConfig;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorExecutionConfig;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClazyAnnotatorExecutionConfig;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.ClangdIndexerBatchInspectionsCoordinator;
import com.jetbrains.cidr.lang.inspections.ClangdIndexerExecutionPlan;
import com.jetbrains.cidr.lang.inspections.ClangdInspectionBase;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClangdIndexerBatchInspectionsCoordinatorImpl
implements ClangdIndexerBatchInspectionsCoordinator {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ClangdIndexerBatchInspectionsCoordinatorImpl.class);
    @NotNull
    private final ClangdIndexerService myIndexer;
    @NotNull
    private final GlobalInspectionContext myContext;
    @NotNull
    private final Set<ClangdInspectionBase> myEnabledInspections;
    @NotNull
    private final Set<ClangResultFuture<Void>> myPendingResults;
    private final Cache<VirtualFile, Map<String, PendingAnswers>> myAnswersCache;
    private final Map<String, Integer> myParseCounters;
    @NotNull
    private final ClangdIndexerExecutionPlan myExecutionPlan;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static ClangdIndexerBatchInspectionsCoordinatorImpl getOrCreate(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(0);
        }
        GlobalInspectionContext globalInspectionContext = context;
        synchronized (globalInspectionContext) {
            ClangdIndexerBatchInspectionsCoordinator existingRunner = (ClangdIndexerBatchInspectionsCoordinator)context.getUserData(INDEXER_RUNNER_KEY);
            if (existingRunner == null) {
                ClangLanguageServiceProvider provider2 = Objects.requireNonNull(ClangLanguageServiceProvider.getProvider(context.getProject()));
                ClangdIndexerService indexer = provider2.getOrStartStatelessIndexer();
                if (indexer == null) {
                    return null;
                }
                existingRunner = new ClangdIndexerBatchInspectionsCoordinatorImpl(indexer, context);
                context.putUserData(INDEXER_RUNNER_KEY, (Object)existingRunner);
            }
            return (ClangdIndexerBatchInspectionsCoordinatorImpl)existingRunner;
        }
    }

    public void adviseScope(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(1);
        }
        this.myExecutionPlan.adviseScope(this.myContext.getProject(), this.myIndexer.getClangIdeFacade(), files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ArrayList<ClangResultFuture<Void>> pendingResults;
        Set<ClangResultFuture<Void>> set = this.myPendingResults;
        synchronized (set) {
            pendingResults = new ArrayList<ClangResultFuture<Void>>(this.myPendingResults);
            this.myPendingResults.clear();
        }
        for (ClangResultFuture clangResultFuture : pendingResults) {
            clangResultFuture.release();
        }
    }

    @Override
    public void finish() {
        int uniqueParses = this.myParseCounters.size();
        AtomicInteger totalParses = new AtomicInteger(0);
        this.myParseCounters.forEach((key, counter) -> totalParses.addAndGet((int)counter));
        LOG.info("Unique Parses/Total Parses = " + uniqueParses + " / " + totalParses);
    }

    @Override
    @Nullable
    public List<ClangDiagnostic> getClazyDiagnostics(@NotNull PsiFile file, @NotNull ClazyInspection inspection) {
        if (file == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(2);
        }
        if (inspection == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(3);
        }
        return this.getDiagnosticsImpl(file, inspection, answers -> answers.getClangDiagnostics());
    }

    @Override
    @Nullable
    public List<ClangTidyDiagnostic> getClangTidyDiagnostics(@NotNull PsiFile file, @NotNull ClangTidyInspectionBase inspection) {
        if (file == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(4);
        }
        if (inspection == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(5);
        }
        return this.getDiagnosticsImpl(file, inspection, answers -> inspection.filterRelevant(answers.getClangTidyDiagnostics()));
    }

    @Nullable
    private <T> List<T> getDiagnosticsImpl(@NotNull PsiFile file, @NotNull ClangdInspectionBase inspection, @NotNull ThrowableFunction<PendingAnswers, List<T>, ExecutionException> diagsProducer) {
        if (file == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(6);
        }
        if (inspection == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(7);
        }
        if (diagsProducer == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(8);
        }
        if (!this.myEnabledInspections.contains((Object)inspection)) {
            LOG.warn("Unexpected inspection: " + inspection.getShortName());
            return null;
        }
        try {
            VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
            PendingAnswers concreteAnswer = this.computeAnswers(virtualFile, inspection.getShortName());
            return diagsProducer.apply(concreteAnswer);
        }
        catch (ExecutionException ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }

    @NotNull
    private PendingAnswers computeAnswers(@NotNull VirtualFile virtualFile, @NotNull String inspectionShortName) {
        if (virtualFile == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(9);
        }
        if (inspectionShortName == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(10);
        }
        List<VirtualFile> relatedFiles = this.myExecutionPlan.getRelatedFiles(virtualFile);
        assert (relatedFiles.contains(virtualFile));
        Map cachedAnswers = this.myAnswersCache.getAll(relatedFiles, missingFiles -> {
            ClangdIndexerCustomTasksBuilder tasksBuilder = new ClangdIndexerCustomTasksBuilder(this.myIndexer);
            HashMap<VirtualFile, Map> mappings = new HashMap<VirtualFile, Map>();
            for (VirtualFile missingFile : missingFiles) {
                mappings.put(missingFile, ContainerUtil.map2Map(this.appendIndexerTasks(tasksBuilder, missingFile).entrySet(), entry -> Pair.create((Object)((ClangdInspectionBase)((Object)((Object)((Object)entry.getKey())))).getShortName(), (Object)((PendingAnswers)entry.getValue()))));
            }
            this.scheduleIndexerTasks(tasksBuilder.create());
            return mappings;
        });
        PendingAnswers pendingAnswers = (PendingAnswers)((Map)cachedAnswers.get(virtualFile)).get(inspectionShortName);
        if (pendingAnswers == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(11);
        }
        return pendingAnswers;
    }

    @NotNull
    private Map<ClangdInspectionBase, ExecConfig> collectTasks(@NotNull VirtualFile file) {
        if (file == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(12);
        }
        HashMap<ClangdInspectionBase, ExecConfig> tasks = new HashMap<ClangdInspectionBase, ExecConfig>();
        ExecConfig ourClangTidyExecConfig = null;
        for (ClangdInspectionBase inspection : this.myEnabledInspections) {
            boolean preferClangTidyConfig;
            boolean disableCLionChecks;
            String jsonConfig;
            ClangTidyAnnotatorExecutionConfig inspectionConfig;
            if (inspection instanceof OurClangTidyInspection) {
                OurClangTidyInspection ourClangTidyInspection = (OurClangTidyInspection)inspection;
                if (ourClangTidyExecConfig == null && (inspectionConfig = ourClangTidyInspection.getBatchExecutionConfig(file, this.myContext)) != null) {
                    jsonConfig = (String)ReadAction.computeCancellable(() -> inspectionConfig.getConfig(this.myContext.getProject()));
                    disableCLionChecks = inspectionConfig.isDisableCLionClangTidyChecks(this.myContext.getProject());
                    preferClangTidyConfig = inspectionConfig.isPreferClangTidyFilesOverIDESettings(this.myContext.getProject());
                    ourClangTidyExecConfig = new ExecConfig(new ClangTidyConfig(jsonConfig, disableCLionChecks, preferClangTidyConfig), null);
                }
                if (ourClangTidyExecConfig != null) {
                    tasks.put(inspection, ourClangTidyExecConfig);
                    continue;
                }
                LOG.error("Support running inspection via indexer: " + inspection.getShortName());
                continue;
            }
            if (inspection instanceof ClazyInspection) {
                ClazyInspection clazyInspection = (ClazyInspection)inspection;
                inspectionConfig = clazyInspection.getBatchExecutionConfig(file, this.myContext);
                Objects.requireNonNull(inspectionConfig);
                jsonConfig = (String)ReadAction.computeCancellable(() -> this.lambda$collectTasks$6((ClazyAnnotatorExecutionConfig)inspectionConfig));
                tasks.put(inspection, new ExecConfig(null, new CLionClazyConfigParams(jsonConfig)));
                continue;
            }
            if (inspection instanceof ClangTidyInspectionBase) {
                ClangTidyInspectionBase clangTidyInspection = (ClangTidyInspectionBase)inspection;
                inspectionConfig = clangTidyInspection.getBatchExecutionConfig(file, this.myContext);
                if (inspectionConfig != null) {
                    jsonConfig = (String)ReadAction.computeCancellable(() -> inspectionConfig.getConfig(this.myContext.getProject()));
                    disableCLionChecks = inspectionConfig.isDisableCLionClangTidyChecks(this.myContext.getProject());
                    preferClangTidyConfig = inspectionConfig.isPreferClangTidyFilesOverIDESettings(this.myContext.getProject());
                    tasks.put(inspection, new ExecConfig(new ClangTidyConfig(jsonConfig, preferClangTidyConfig, disableCLionChecks), null));
                    continue;
                }
                LOG.error("Support running inspection via indexer: " + inspection.getShortName());
                continue;
            }
            LOG.error("Unexpected inspection to be run via indexer: " + inspection.getShortName());
        }
        HashMap<ClangdInspectionBase, ExecConfig> hashMap = tasks;
        if (hashMap == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    @NotNull
    private Map<ClangdInspectionBase, PendingAnswers> appendIndexerTasks(@NotNull ClangdIndexerCustomTasksBuilder tasksBuilder, @NotNull VirtualFile file) {
        if (tasksBuilder == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(14);
        }
        if (file == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(15);
        }
        Map<ClangdInspectionBase, ExecConfig> inspection2Config = this.collectTasks(file);
        HashMap<ExecConfig, PendingAnswers> config2Answers = new HashMap<ExecConfig, PendingAnswers>();
        for (ExecConfig config : ClangdIndexerBatchInspectionsCoordinatorImpl.unique(inspection2Config.values())) {
            Map ctAnswers = null;
            if (config.clangTidyConfig != null) {
                ctAnswers = (Map)ReadAction.computeCancellable(() -> tasksBuilder.addClangTidy(config.clangTidyConfig.getConfig(), config.clangTidyConfig.getDisableCLionChecks(), config.clangTidyConfig.getPreferClangTidyFiles(), Collections.singletonList(file)));
            }
            Map clazyAnswers = null;
            if (config.clazyConfig != null) {
                clazyAnswers = (Map)ReadAction.computeCancellable(() -> tasksBuilder.addClazy(config.clazyConfig, Collections.singletonList(file)));
            }
            config2Answers.put(config, new PendingAnswers(ctAnswers != null ? (CompletableFuture)ctAnswers.get(file) : null, clazyAnswers != null ? (CompletableFuture)clazyAnswers.get(file) : null));
        }
        return ClangdIndexerBatchInspectionsCoordinatorImpl.transitivize(inspection2Config, config2Answers);
    }

    private void scheduleIndexerTasks(@NotNull ClangdIndexerCustomTasks tasks) {
        if (tasks == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(16);
        }
        for (String entryFileUri : tasks.getEntryUris()) {
            this.myParseCounters.compute(entryFileUri, (key, existing) -> existing == null ? 1 : existing + 1);
        }
        this.myIndexer.runCustomTasks(tasks, result -> {
            ClangResultFuture pendingResults = result.iWillNotForgetToCancelTheFuture();
            this.myPendingResults.add(pendingResults);
            pendingResults.asFuture().whenComplete((res, ex) -> this.myPendingResults.remove(pendingResults));
        });
    }

    @NotNull
    private static Set<ExecConfig> unique(@NotNull Collection<ExecConfig> configs) {
        if (configs == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(17);
        }
        return configs instanceof Set ? (Set<Object>)configs : new HashSet<ExecConfig>(configs);
    }

    @NotNull
    private static <A, B, C> Map<A, C> transitivize(@NotNull Map<A, B> a2b, @NotNull Map<B, C> b2c) {
        if (a2b == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(18);
        }
        if (b2c == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(19);
        }
        HashMap<A, C> a2c = new HashMap<A, C>();
        for (Map.Entry<A, B> a2bEntry : a2b.entrySet()) {
            C answer = b2c.get(a2bEntry.getValue());
            a2c.put(a2bEntry.getKey(), answer);
        }
        HashMap<A, C> hashMap = a2c;
        if (hashMap == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    private ClangdIndexerBatchInspectionsCoordinatorImpl(@NotNull ClangdIndexerService indexer, @NotNull GlobalInspectionContext context) {
        if (indexer == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(21);
        }
        if (context == null) {
            ClangdIndexerBatchInspectionsCoordinatorImpl.$$$reportNull$$$0(22);
        }
        this.myEnabledInspections = new HashSet<ClangdInspectionBase>();
        this.myPendingResults = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
        this.myAnswersCache = Caffeine.newBuilder().maximumSize(4096L).expireAfterAccess(Duration.ofMinutes(10L)).build();
        this.myParseCounters = new ConcurrentHashMap<String, Integer>();
        this.myExecutionPlan = new ClangdIndexerExecutionPlan();
        this.myIndexer = indexer;
        this.myContext = context;
        if (context instanceof GlobalInspectionContextBase) {
            GlobalInspectionContextBase baseContext = (GlobalInspectionContextBase)context;
            this.myEnabledInspections.addAll(ContainerUtil.mapNotNull(baseContext.getTools().values(), tools -> {
                InspectionProfileEntry tool = tools.getTool().getTool();
                if (tool instanceof ClazyInspection) {
                    return null;
                }
                return tool instanceof ClangdInspectionBase ? (ClangdInspectionBase)tool : null;
            }));
        }
    }

    private /* synthetic */ String lambda$collectTasks$6(ClazyAnnotatorExecutionConfig inspectionConfig) throws RuntimeException {
        return inspectionConfig.getConfig(this.myContext.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 13, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagsProducer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionShortName";
                break;
            }
            case 11: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/ClangdIndexerBatchInspectionsCoordinatorImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksBuilder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2b";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b2c";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/ClangdIndexerBatchInspectionsCoordinatorImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAnswers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTasks";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "transitivize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adviseScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClazyDiagnostics";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClangTidyDiagnostics";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDiagnosticsImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeAnswers";
                break;
            }
            case 11: 
            case 13: 
            case 20: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectTasks";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendIndexerTasks";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "scheduleIndexerTasks";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "transitivize";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 13, 20 -> new IllegalStateException(string);
        };
    }

    private record PendingAnswers(@Nullable CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> clangTidyAnswers, @Nullable CompletableFuture<Supplier<List<ClangDiagnostic>>> clazyAnswers) {
        @NotNull
        List<ClangTidyDiagnostic> getClangTidyDiagnostics() throws ExecutionException {
            Supplier clangTidyDiagsSupplier;
            if (this.clangTidyAnswers != null && (clangTidyDiagsSupplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAware(this.clangTidyAnswers, (String)"clangTidyAnswers")) != null) {
                List list = (List)clangTidyDiagsSupplier.get();
                if (list == null) {
                    PendingAnswers.$$$reportNull$$$0(0);
                }
                return list;
            }
            List<ClangTidyDiagnostic> list = Collections.emptyList();
            if (list == null) {
                PendingAnswers.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        List<ClangDiagnostic> getClangDiagnostics() throws ExecutionException {
            Supplier clangDiagsSupplier;
            if (this.clazyAnswers != null && (clangDiagsSupplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAware(this.clazyAnswers, (String)"clazyAnswers")) != null) {
                List list = (List)clangDiagsSupplier.get();
                if (list == null) {
                    PendingAnswers.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<ClangDiagnostic> list = Collections.emptyList();
            if (list == null) {
                PendingAnswers.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/cidr/lang/inspections/ClangdIndexerBatchInspectionsCoordinatorImpl$PendingAnswers";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClangTidyDiagnostics";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClangDiagnostics";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private record ExecConfig(@Nullable ClangTidyConfig clangTidyConfig, @Nullable CLionClazyConfigParams clazyConfig) {
    }
}

