/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.AddEditRemovePanel;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.InplaceAddEditRemovePanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyCheckOptionsProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyChecksOptionsDialog
extends DialogWrapper {
    @NotNull
    private final Map<String, ClangTidyCheckOption> myUserCheckOptionsMap;
    @NotNull
    private Map<String, ClangTidyCheckOption> myDefaultCheckOptionsMap;
    @NotNull
    private List<ClangTidyCheckOption> myEditableCheckOptions;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    private AddEditRemovePanel<ClangTidyCheckOption> myTablePanel;

    public ClangTidyChecksOptionsDialog(@NotNull Component parent, @NotNull List<ClangTidyCheckOption> checkOptions, @Nullable Project project) {
        if (parent == null) {
            ClangTidyChecksOptionsDialog.$$$reportNull$$$0(0);
        }
        if (checkOptions == null) {
            ClangTidyChecksOptionsDialog.$$$reportNull$$$0(1);
        }
        super(parent, false);
        this.myUserCheckOptionsMap = CommonClangTidyUtil.toCheckOptionsMap(checkOptions);
        this.myDefaultCheckOptionsMap = Collections.emptyMap();
        this.myEditableCheckOptions = ContainerUtil.emptyList();
        this.setTitle(ClangdBundle.message("configurable.clangTidy.checks.options.dialog.title", new Object[0]));
        this.init();
        this.myProgressIndicator = new AbstractProgressIndicatorBase();
        ClangTidyCheckOptionsProvider provider2 = new ClangTidyCheckOptionsProvider(project);
        provider2.getAvailableOptionsAsync(this.myProgressIndicator).whenComplete((options, exception) -> {
            this.myDefaultCheckOptionsMap = CommonClangTidyUtil.toCheckOptionsMap(options);
            this.myEditableCheckOptions = this.buildEditableOptions();
            this.myTablePanel.getTable().setPaintBusy(false);
            if (exception != null) {
                this.myTablePanel.getEmptyText().setText(ClangdBundle.message("configurable.clangTidy.checks.options.load.fail", new Object[0]));
            } else {
                this.myTablePanel.setData(this.myEditableCheckOptions);
            }
        });
    }

    @NotNull
    public List<ClangTidyCheckOption> getResultCheckOptions() {
        this.stopEdit();
        List list = ContainerUtil.filter(this.myEditableCheckOptions, option -> !this.myDefaultCheckOptionsMap.containsKey(option.getOptionName()) || !this.myDefaultCheckOptionsMap.get(option.getOptionName()).getOptionValue().equals(option.getOptionValue()));
        if (list == null) {
            ClangTidyChecksOptionsDialog.$$$reportNull$$$0(2);
        }
        return list;
    }

    private void stopEdit() {
        TableCellEditor editor = this.myTablePanel.getTable().getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    protected void dispose() {
        this.myProgressIndicator.cancel();
        super.dispose();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myTablePanel = this.createTable();
        this.myTablePanel.setPreferredSize((Dimension)JBUI.size((int)800, (int)400));
        return this.myTablePanel;
    }

    @NotNull
    private List<ClangTidyCheckOption> buildEditableOptions() {
        ArrayList<ClangTidyCheckOption> options = new ArrayList<ClangTidyCheckOption>();
        for (Map.Entry<String, ClangTidyCheckOption> entry : this.myDefaultCheckOptionsMap.entrySet()) {
            String optionName = entry.getKey();
            if (this.myUserCheckOptionsMap.containsKey(entry.getKey())) {
                options.add(new ClangTidyCheckOption(optionName, this.myUserCheckOptionsMap.get(optionName).getOptionValue()));
                continue;
            }
            options.add(new ClangTidyCheckOption(optionName, entry.getValue().getOptionValue()));
        }
        for (Map.Entry<String, ClangTidyCheckOption> entry : this.myUserCheckOptionsMap.entrySet()) {
            if (this.myDefaultCheckOptionsMap.containsKey(entry.getKey())) continue;
            options.add(new ClangTidyCheckOption(entry.getKey(), entry.getValue().getOptionValue()));
        }
        ContainerUtil.sort(options, (o1, o2) -> {
            if (this.isDefault((ClangTidyCheckOption)o1) != this.isDefault((ClangTidyCheckOption)o2)) {
                return Boolean.compare(this.isDefault((ClangTidyCheckOption)o1), this.isDefault((ClangTidyCheckOption)o2));
            }
            return o1.getOptionName().compareTo(o2.getOptionName());
        });
        ArrayList<ClangTidyCheckOption> arrayList = options;
        if (arrayList == null) {
            ClangTidyChecksOptionsDialog.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private AddEditRemovePanel<ClangTidyCheckOption> createTable() {
        AddEditRemovePanel.TableModel<ClangTidyCheckOption> model = new AddEditRemovePanel.TableModel<ClangTidyCheckOption>(){

            public int getColumnCount() {
                return 2;
            }

            @NotNull
            public String getColumnName(int columnIndex) {
                String string = columnIndex == 0 ? ClangdBundle.message("configurable.clangTidy.checks.options.option.column", new Object[0]) : ClangdBundle.message("configurable.clangTidy.checks.options.value.column", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Object getField(ClangTidyCheckOption o, int columnIndex) {
                return columnIndex == 0 ? o.getOptionName() : o.getOptionValue();
            }

            public void setValue(Object aValue, ClangTidyCheckOption data, int columnIndex) {
                if (columnIndex == 0) {
                    data.setOptionName(aValue.toString());
                } else {
                    data.setOptionValue(aValue.toString());
                }
            }

            public boolean isEditable(int column) {
                int row = ClangTidyChecksOptionsDialog.this.myTablePanel.getTable().getSelectedRow();
                if (row < 0 || row >= ClangTidyChecksOptionsDialog.this.myEditableCheckOptions.size()) {
                    return false;
                }
                return column != 0 || !ClangTidyChecksOptionsDialog.this.myDefaultCheckOptionsMap.containsKey(ClangTidyChecksOptionsDialog.this.myEditableCheckOptions.get(row).getOptionName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/ClangTidyChecksOptionsDialog$1", "getColumnName"));
            }
        };
        InplaceAddEditRemovePanel<ClangTidyCheckOption> panel = new InplaceAddEditRemovePanel<ClangTidyCheckOption>((AddEditRemovePanel.TableModel)model, this.myEditableCheckOptions){

            @NotNull
            protected ClangTidyCheckOption addItem() {
                return new ClangTidyCheckOption();
            }

            protected void doAdd() {
                super.doAdd();
                int selectedRow = this.getTable().getSelectedRow();
                if (selectedRow != -1) {
                    this.getTable().scrollRectToVisible(new Rectangle(this.getTable().getCellRect(selectedRow, 0, true)));
                }
            }

            @Nullable
            protected ClangTidyCheckOption editItem(ClangTidyCheckOption o) {
                return (ClangTidyCheckOption)super.editItem((Object)o);
            }

            protected ToolbarDecorator createToolbarDecorator() {
                ToolbarDecorator decorator = super.createToolbarDecorator();
                decorator.addExtraAction(new AnAction(IdeBundle.message((String)"button.restore.defaults", (Object[])new Object[0]), null, AllIcons.General.Reset){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ClangTidyChecksOptionsDialog.this.myEditableCheckOptions.clear();
                        ClangTidyChecksOptionsDialog.this.myUserCheckOptionsMap.clear();
                        ClangTidyChecksOptionsDialog.this.myEditableCheckOptions.addAll(ClangTidyChecksOptionsDialog.this.buildEditableOptions());
                        ClangTidyChecksOptionsDialog.this.myTablePanel.setData(ClangTidyChecksOptionsDialog.this.myEditableCheckOptions);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/inspections/ClangTidyChecksOptionsDialog$2$1", "actionPerformed"));
                    }
                });
                decorator.setRemoveActionUpdater(e -> {
                    List options = this.getData();
                    for (int selectedRow : this.getTable().getSelectedRows()) {
                        if (selectedRow < 0 || selectedRow >= options.size()) {
                            return false;
                        }
                        ClangTidyCheckOption option = (ClangTidyCheckOption)options.get(selectedRow);
                        if (!ClangTidyChecksOptionsDialog.this.myDefaultCheckOptionsMap.containsKey(option.getOptionName())) continue;
                        return false;
                    }
                    return true;
                });
                decorator.setEditActionUpdater(e -> {
                    if (this.getTable().getSelectedRows().length != 1 || this.getTable().getSelectedColumns().length != 1) {
                        return false;
                    }
                    return this.getTable().isCellEditable(this.getTable().getSelectedRow(), this.getTable().getSelectedColumn());
                });
                return decorator;
            }

            protected boolean removeItem(ClangTidyCheckOption o) {
                return true;
            }

            public boolean isUpDownSupported() {
                return true;
            }
        };
        panel.getTable().setShowColumns(true);
        TableColumnModel columnModel = panel.getTable().getColumnModel();
        columnModel.getColumn(0).setCellRenderer(this.createChangedCellRenderer());
        columnModel.getColumn(1).setCellRenderer(ClangTidyChecksOptionsDialog.createRenderer(false));
        columnModel.getColumn(0).setHeaderRenderer(ClangTidyChecksOptionsDialog.createRenderer(true));
        columnModel.getColumn(1).setHeaderRenderer(ClangTidyChecksOptionsDialog.createRenderer(true));
        panel.getTable().setPaintBusy(true);
        panel.getEmptyText().setText(ClangdBundle.message("configurable.clangTidy.checks.options.loading.status", new Object[0]));
        TableSpeedSearch speedSearch = TableSpeedSearch.installOn((JTable)panel.getTable());
        speedSearch.setComparator(new SpeedSearchComparator(false));
        InplaceAddEditRemovePanel<ClangTidyCheckOption> inplaceAddEditRemovePanel = panel;
        if (inplaceAddEditRemovePanel == null) {
            ClangTidyChecksOptionsDialog.$$$reportNull$$$0(4);
        }
        return inplaceAddEditRemovePanel;
    }

    private boolean isDefault(@NotNull ClangTidyCheckOption option) {
        if (option == null) {
            ClangTidyChecksOptionsDialog.$$$reportNull$$$0(5);
        }
        String optionName = option.getOptionName();
        String optionValue = option.getOptionValue();
        ClangTidyCheckOption defaultOption = this.myDefaultCheckOptionsMap.get(optionName);
        return defaultOption != null && defaultOption.getOptionValue().equals(optionValue);
    }

    private TableCellRenderer createChangedCellRenderer() {
        return new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                String optionNameText;
                if (table == null) {
                    3.$$$reportNull$$$0(0);
                }
                ClangTidyCheckOption option = ClangTidyChecksOptionsDialog.this.myEditableCheckOptions.get(row);
                String string = optionNameText = value != null ? value.toString() : "";
                if (ClangTidyChecksOptionsDialog.this.isDefault(option)) {
                    this.append(optionNameText);
                } else {
                    this.append(optionNameText, new SimpleTextAttributes(1, (Color)JBColor.blue));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/cidr/lang/inspections/ClangTidyChecksOptionsDialog$3", "customizeCellRenderer"));
            }
        };
    }

    @NotNull
    private static DefaultTableCellRenderer createRenderer(boolean isHeader) {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(isHeader ? 0 : 2);
        DefaultTableCellRenderer defaultTableCellRenderer = renderer;
        if (defaultTableCellRenderer == null) {
            ClangTidyChecksOptionsDialog.$$$reportNull$$$0(6);
        }
        return defaultTableCellRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/ClangTidyChecksOptionsDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/ClangTidyChecksOptionsDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultCheckOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEditableOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDefault";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

