/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.highlighting;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0006\u0010\u0014\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/lang/highlighting/ClangPPHighlightingHandler;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "myCodeInsightSettings", "Lcom/intellij/codeInsight/CodeInsightSettings;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/CodeInsightSettings;)V", "myRanges", "", "Lkotlin/Pair;", "", "collectRanges", "", "doApplyInfoToEditor", "getHighlightersList", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "clearHighlights", "Companion", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nClangPPHighlightingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangPPHighlightingHandler.kt\ncom/jetbrains/cidr/lang/highlighting/ClangPPHighlightingHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1557#2:79\n1628#2,3:80\n*S KotlinDebug\n*F\n+ 1 ClangPPHighlightingHandler.kt\ncom/jetbrains/cidr/lang/highlighting/ClangPPHighlightingHandler\n*L\n40#1:79\n40#1:80,3\n*E\n"})
public final class ClangPPHighlightingHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final CodeInsightSettings myCodeInsightSettings;
    @NotNull
    private List<Pair<Integer, Integer>> myRanges;
    @NotNull
    private static final Key<List<RangeHighlighter>> BRACE_HIGHLIGHTERS_IN_EDITOR_KEY;
    public static final int LAYER = 6001;

    public ClangPPHighlightingHandler(@NotNull Project myProject, @NotNull Editor myEditor, @NotNull CodeInsightSettings myCodeInsightSettings) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
        Intrinsics.checkNotNullParameter((Object)myCodeInsightSettings, (String)"myCodeInsightSettings");
        this.myProject = myProject;
        this.myEditor = myEditor;
        this.myCodeInsightSettings = myCodeInsightSettings;
        this.myRanges = CollectionsKt.emptyList();
    }

    public /* synthetic */ ClangPPHighlightingHandler(Project project, Editor editor, CodeInsightSettings codeInsightSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            codeInsightSettings = CodeInsightSettings.getInstance();
        }
        this(project, editor, codeInsightSettings);
    }

    public final void collectRanges() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(this.myProject);
        VirtualFile virtualFile = this.myEditor.getVirtualFile();
        if (service != null && ClangdBridge.isSupported(this.myProject, virtualFile) && this.myCodeInsightSettings.HIGHLIGHT_BRACES && Registry.Companion.is("com.jetbrains.cidr.lang.highlighting.ClangPPMatchingHighlighter.enable")) {
            Document document = this.myEditor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            service.matchPP(virtualFile, this.myEditor.getCaretModel().getOffset(), arg_0 -> ClangPPHighlightingHandler.collectRanges$lambda$1(this, document2, arg_0));
        }
    }

    public final void doApplyInfoToEditor() {
        ThreadingAssertions.assertEventDispatchThread();
        this.clearHighlights();
        for (Pair<Integer, Integer> range : this.myRanges) {
            RangeHighlighter directiveHighlighter;
            TextAttributesKey attributesKey = CodeInsightColors.MATCHED_BRACE_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)this.myEditor.getMarkupModel().addRangeHighlighter(attributesKey, ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), 6001, HighlighterTargetArea.EXACT_RANGE), (String)"addRangeHighlighter(...)");
            directiveHighlighter.setGreedyToLeft(false);
            directiveHighlighter.setGreedyToRight(false);
            this.getHighlightersList().add(directiveHighlighter);
        }
    }

    private final List<RangeHighlighter> getHighlightersList() {
        List highlighters = (List)this.myEditor.getUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_KEY);
        if (highlighters == null) {
            highlighters = new ArrayList();
            this.myEditor.putUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_KEY, (Object)highlighters);
        }
        return highlighters;
    }

    public final void clearHighlights() {
        List<RangeHighlighter> highlighters = this.getHighlightersList();
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.dispose();
        }
        highlighters.clear();
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectRanges$lambda$1(ClangPPHighlightingHandler this$0, Document $document, ClangResult clangResult) {
        List list;
        Intrinsics.checkNotNullParameter((Object)clangResult, (String)"clangResult");
        ClangPPHighlightingHandler clangPPHighlightingHandler = this$0;
        List list2 = (List)clangResult.waitForResult();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            ClangPPHighlightingHandler clangPPHighlightingHandler2 = clangPPHighlightingHandler;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Range range = (Range)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int lineStart = $document.getLineStartOffset(it.getStart().getLine());
                int lineEnd = $document.getLineStartOffset(it.getEnd().getLine());
                collection.add(new Pair((Object)(lineStart + it.getStart().getCharacter()), (Object)(lineEnd + it.getEnd().getCharacter())));
            }
            list = (List)destination$iv$iv;
            clangPPHighlightingHandler = clangPPHighlightingHandler2;
        } else {
            list = CollectionsKt.emptyList();
        }
        clangPPHighlightingHandler.myRanges = list;
    }

    static {
        Key key = Key.create((String)"ClangPPHighlightingHandler.BRACE_HIGHLIGHTERS_IN_EDITOR_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        BRACE_HIGHLIGHTERS_IN_EDITOR_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R-\u0010\u0004\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/lang/highlighting/ClangPPHighlightingHandler$Companion;", "", "<init>", "()V", "BRACE_HIGHLIGHTERS_IN_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LAYER", "", "intellij.c.clangd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

