/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.DaemonTooltipsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OpenClangTidySettingsAction;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClangTidyAnnotationApplierBase
implements ClangTidyAnnotationApplier {
    @Override
    public void annotateFail(@NotNull PsiFile file, @NotNull String reason, HighlightSeverity severity, @NotNull AnnotationHolder holder) {
        if (file == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(0);
        }
        if (reason == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(2);
        }
        String message = ClangdBundle.message("inspection.clangTidy.failed", reason);
        holder.newAnnotation(severity, message).range((PsiElement)file).fileLevel().withFix((IntentionAction)new OpenClangTidySettingsAction()).create();
    }

    @Override
    public void annotateSuccess(@NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics, final @NotNull AnnotationHolder holder) {
        if (file == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(3);
        }
        if (diagnostics == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(5);
        }
        this.applySuccess(file, diagnostics, holder.isBatchMode(), new DiagnosticProcessor(){

            @Override
            public boolean process(@NotNull @InspectionMessage String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull PsiFile ocFile, @NotNull IntentionAction fixToRegister) {
                if (diagnosticMessage == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (diagnosticName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (rangeToHighlight == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (highlightSeverity == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (sourceInspection == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (ocFile == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (fixToRegister == null) {
                    1.$$$reportNull$$$0(6);
                }
                AnnotationBuilder builder = holder.newAnnotation(highlightSeverity, diagnosticMessage).range(rangeToHighlight).withFix((IntentionAction)new IntentionWrapper(fixToRegister)).problemGroup((ProblemGroup)ClangTidyAnnotationApplierBase.this.createProblemGroup(ocFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection));
                if (sourceInspection.getForcedHighlightType() != null) {
                    builder = builder.highlightType(sourceInspection.getForcedHighlightType());
                }
                if (sourceInspection instanceof ClangTidyInspection) {
                    builder = builder.tooltip(ClangTidyAnnotationApplierBase.getClangTidyDescriptionToolTip(diagnosticMessage, diagnosticName));
                }
                builder.create();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticMessage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rangeToHighlight";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "highlightSeverity";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceInspection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ocFile";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixToRegister";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplierBase$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void annotateSuccess(final @NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics, final @NotNull ProblemsHolder holder) {
        if (file == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(6);
        }
        if (diagnostics == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(8);
        }
        this.applySuccess(file, diagnostics, !holder.isOnTheFly(), new DiagnosticProcessor(){

            @Override
            public boolean process(@NotNull @InspectionMessage String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull PsiFile psiFile, @NotNull IntentionAction fixToRegister) {
                if (diagnosticMessage == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (diagnosticName == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (rangeToHighlight == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (highlightSeverity == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (sourceInspection == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (psiFile == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (fixToRegister == null) {
                    2.$$$reportNull$$$0(6);
                }
                IntentionWrapper localQuickFix = new IntentionWrapper(fixToRegister);
                ProblemHighlightType highlightType = sourceInspection.getForcedHighlightType() == null ? HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)highlightSeverity) : sourceInspection.getForcedHighlightType();
                ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)file.getProject()).createProblemDescriptor((PsiElement)psiFile, rangeToHighlight, diagnosticMessage, highlightType, holder.isOnTheFly(), new LocalQuickFix[]{localQuickFix});
                problemDescriptor.setProblemGroup((ProblemGroup)ClangTidyAnnotationApplierBase.this.createProblemGroup(psiFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection));
                holder.registerProblem(problemDescriptor);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticMessage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rangeToHighlight";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "highlightSeverity";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceInspection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "psiFile";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixToRegister";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplierBase$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void annotateSuccess(final @NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics, final @NotNull HighlightInfoHolder holder, boolean isBatch) {
        if (file == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(9);
        }
        if (diagnostics == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(11);
        }
        this.applySuccess(file, diagnostics, isBatch, new DiagnosticProcessor(){

            @Override
            public boolean process(@NotNull @NlsContexts.DetailedDescription String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull PsiFile ocFile, @NotNull IntentionAction fixToRegister) {
                if (diagnosticMessage == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (diagnosticName == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (rangeToHighlight == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (highlightSeverity == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (sourceInspection == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (ocFile == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (fixToRegister == null) {
                    3.$$$reportNull$$$0(6);
                }
                ProblemHighlightType problemHighlightType = sourceInspection.getForcedHighlightType() == null ? HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)highlightSeverity) : sourceInspection.getForcedHighlightType();
                HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)problemHighlightType, (HighlightSeverity)highlightSeverity, (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)file.getProject()));
                HighlightDisplayKey key = HighlightDisplayKey.find((String)sourceInspection.getShortName());
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(rangeToHighlight).descriptionAndTooltip(diagnosticMessage).severity(highlightSeverity).problemGroup((ProblemGroup)ClangTidyAnnotationApplierBase.this.createProblemGroup(ocFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection)).registerFix(fixToRegister, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key), null, key).create();
                holder.add(info);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticMessage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rangeToHighlight";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "highlightSeverity";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceInspection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ocFile";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixToRegister";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplierBase$3";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    protected abstract SuppressableProblemGroup createProblemGroup(@NotNull PsiFile var1, @NotNull TextRange var2, @NotNull String var3, @NotNull ClangTidyInspectionBase var4);

    @Nullable
    protected abstract TextRange getRangeToHighlight(@NotNull PsiFile var1, @NotNull ClangTidyDiagnostic var2, @NotNull ClangTidyInspectionBase var3);

    protected abstract boolean isSuppressed(@NotNull PsiFile var1, int var2, @NotNull String var3);

    @NotNull
    protected abstract List<IntentionAction> createQuickFixes(@NotNull PsiFile var1, @NotNull @NlsSafe String var2, @NotNull ClangTidyDiagnostic var3, @NotNull ClangTidyInspectionBase var4, @NotNull ClangUrlConverter var5);

    protected abstract boolean shouldIgnoreForFile(@NotNull PsiFile var1);

    @NlsSafe
    @NotNull
    private static String getClangTidyDescriptionToolTip(@NotNull String diagnosticMessage, @NotNull String diagnosticName) {
        if (diagnosticMessage == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(12);
        }
        if (diagnosticName == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(13);
        }
        String string = DaemonTooltipsUtil.getWrappedTooltipWithCustomReference((String)diagnosticMessage, (String)("#clangTidy/" + diagnosticName), (boolean)true);
        if (string == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(14);
        }
        return string;
    }

    private void applySuccess(@NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics, boolean isBatchMode, @NotNull DiagnosticProcessor processor) {
        if (file == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(15);
        }
        if (diagnostics == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            ClangTidyAnnotationApplierBase.$$$reportNull$$$0(17);
        }
        if (this.shouldIgnoreForFile(file)) {
            return;
        }
        ClangLanguageService clangdService = ClangLanguageServiceProvider.getIfStarted(file.getProject());
        @NotNull ClangUrlConverter urlConverter = clangdService != null ? clangdService.getUrlConverter() : new ClangUrlConverter();
        for (ClangTidyDiagnostic diagnostic : diagnostics) {
            TextRange rangeToHighlight;
            ProgressManager.checkCanceled();
            ClangTidyInspectionBase inspection = CommonClangTidyUtil.findInspectionFromClangTidyDiagnostic(diagnostic, file, file.getProject());
            if (inspection == null || (rangeToHighlight = this.getRangeToHighlight(file, diagnostic, inspection)) == null) continue;
            String diagnosticMessage = inspection.getMessage(diagnostic.getMessage(), isBatchMode);
            String diagnosticName = diagnostic.getDiagnosticName();
            HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(((Object)((Object)inspection)).getClass(), null, (PsiElement)file, (HighlightSeverity)HighlightSeverity.WARNING);
            if (highlightSeverity == null || this.isSuppressed(file, diagnostic.getFileOffset(), inspection.getSuppressName(diagnosticName))) continue;
            List<IntentionAction> fixes = this.createQuickFixes(file, diagnosticMessage, diagnostic, inspection, urlConverter);
            for (IntentionAction fix : fixes) {
                if (!processor.process(diagnosticMessage, diagnosticName, rangeToHighlight, highlightSeverity, inspection, file, fix)) break;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticMessage";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplierBase";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplierBase";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyDescriptionToolTip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotateFail";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "annotateSuccess";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClangTidyDescriptionToolTip";
                break;
            }
            case 14: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applySuccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }

    protected static interface DiagnosticProcessor {
        public boolean process(@NotNull String var1, @NotNull String var2, @NotNull TextRange var3, @NotNull HighlightSeverity var4, @NotNull ClangTidyInspectionBase var5, @NotNull PsiFile var6, @NotNull IntentionAction var7);
    }
}

