/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00050\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJF\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00050\u00052\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ,\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J \u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder;", "", "<init>", "()V", "createFor", "", "", "", "errors", "", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionClangTidyError;", "unsavedFilePaths", "", "fileToByteOffset", "Ljava/util/SortedSet;", "createByteToCharMap", "byteOffsets", "contentInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion$ContentInfo;", "getContentInfo", "filePath", "Companion", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nByteToCharOffsetMapBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteToCharOffsetMapBuilder.kt\ncom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n126#2:110\n153#2,3:111\n1755#3,3:114\n*S KotlinDebug\n*F\n+ 1 ByteToCharOffsetMapBuilder.kt\ncom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder\n*L\n41#1:110\n41#1:111,3\n77#1:114,3\n*E\n"})
public final class ByteToCharOffsetMapBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, Map<Integer, Integer>> createFor(@NotNull List<? extends ClionClangTidyError> errors, @NotNull Collection<String> unsavedFilePaths) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        Intrinsics.checkNotNullParameter(unsavedFilePaths, (String)"unsavedFilePaths");
        HashMap fileToByteOffset = new HashMap();
        for (ClionClangTidyError clionClangTidyError : errors) {
            String string = clionClangTidyError.getFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilePath(...)");
            Companion.addOffset(string, clionClangTidyError.getFileOffset(), fileToByteOffset);
            if (clionClangTidyError.getReplacements() != null) {
                for (ClionClangTidyReplacement replacement : clionClangTidyError.getReplacements()) {
                    String string2 = replacement.getFilePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFilePath(...)");
                    Companion.addOffset(string2, replacement.getOffset(), fileToByteOffset);
                    String string3 = replacement.getFilePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFilePath(...)");
                    Companion.addOffset(string3, replacement.getOffset() + replacement.getLength(), fileToByteOffset);
                }
            }
            if (clionClangTidyError.getRanges() == null) continue;
            for (ClangTidyRange range : clionClangTidyError.getRanges()) {
                String string4 = range.getFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getFilePath(...)");
                if (!(((CharSequence)string4).length() > 0)) continue;
                String string5 = range.getFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getFilePath(...)");
                Companion.addOffset(string5, range.getFileOffset(), fileToByteOffset);
                String string6 = range.getFilePath();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getFilePath(...)");
                Companion.addOffset(string6, range.getFileOffset() + range.getLength(), fileToByteOffset);
            }
        }
        return this.createFor(fileToByteOffset, unsavedFilePaths);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Map<Integer, Integer>> createFor(@NotNull Map<String, ? extends SortedSet<Integer>> fileToByteOffset, @NotNull Collection<String> unsavedFilePaths) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fileToByteOffset, (String)"fileToByteOffset");
        Intrinsics.checkNotNullParameter(unsavedFilePaths, (String)"unsavedFilePaths");
        Map<String, ? extends SortedSet<Integer>> $this$map$iv = fileToByteOffset;
        boolean $i$f$map = false;
        Map<String, ? extends SortedSet<Integer>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String filePath = (String)it.getKey();
            SortedSet byteOffsets = (SortedSet)it.getValue();
            Companion.ContentInfo contentInfo = this.getContentInfo(filePath, unsavedFilePaths);
            collection.add(TuplesKt.to((Object)filePath, this.createByteToCharMap(byteOffsets, contentInfo)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final Map<Integer, Integer> createByteToCharMap(SortedSet<Integer> byteOffsets, Companion.ContentInfo contentInfo) {
        Integer byteOffset;
        if (contentInfo == null) {
            return MapsKt.emptyMap();
        }
        HashMap byteToCharMap = new HashMap();
        int lastCharOffset = 0;
        int lastByteOffset = contentInfo.getBomLength();
        Iterator iterator = byteOffsets.iterator();
        while (iterator.hasNext() && (byteOffset = (Integer)iterator.next()) <= contentInfo.getContent().length) {
            String sliceWithUnifiedSeparators;
            Integer n = byteOffset;
            Intrinsics.checkNotNull((Object)n);
            int sliceLength = Math.max(0, n - lastByteOffset);
            String slice = new String(contentInfo.getContent(), lastByteOffset, sliceLength, contentInfo.getEncoding());
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.convertLineSeparators((String)slice), (String)"convertLineSeparators(...)");
            int charOffset = lastCharOffset + sliceWithUnifiedSeparators.length();
            Integer n2 = charOffset;
            ((Map)byteToCharMap).put(byteOffset, n2);
            lastCharOffset = charOffset;
            lastByteOffset = byteOffset;
        }
        return byteToCharMap;
    }

    private final Companion.ContentInfo getContentInfo(String filePath, Collection<String> unsavedFilePaths) {
        Document document;
        VirtualFile virtualFile;
        boolean bl;
        FileDocumentManager manager;
        block6: {
            if (((CharSequence)filePath).length() == 0) {
                return null;
            }
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            manager = fileDocumentManager;
            Iterable $this$any$iv = unsavedFilePaths;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!FileUtil.pathsEqual((String)it, (String)filePath)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl && (virtualFile = VfsUtil.findFile((Path)Paths.get(filePath, new String[0]), (boolean)true)) != null && (document = (Document)ActionsKt.runReadAction(() -> ByteToCharOffsetMapBuilder.getContentInfo$lambda$2(manager, virtualFile))) != null) {
            Charset documentEncoding = Charsets.UTF_8;
            byte[] content = (byte[])ActionsKt.runReadAction(() -> ByteToCharOffsetMapBuilder.getContentInfo$lambda$3(document, documentEncoding));
            return new Companion.ContentInfo(content, documentEncoding, ByteToCharOffsetMapBuilder.Companion.getBomLength(content, documentEncoding));
        }
        virtualFile = VfsUtil.findFile((Path)Paths.get(filePath, new String[0]), (boolean)true);
        if (virtualFile == null) {
            return null;
        }
        byte[] byArray = FileUtil.loadFileBytes((File)new File(filePath));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"loadFileBytes(...)");
        byte[] content = byArray;
        Charset charset = virtualFile.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
        Charset charset2 = virtualFile.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"getCharset(...)");
        return new Companion.ContentInfo(content, charset, ByteToCharOffsetMapBuilder.Companion.getBomLength(content, charset2));
    }

    private static final Document getContentInfo$lambda$2(FileDocumentManager $manager, VirtualFile $virtualFile) {
        return $manager.getDocument($virtualFile);
    }

    private static final byte[] getContentInfo$lambda$3(Document $document, Charset $documentEncoding) {
        String string = $document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        byte[] byArray = string.getBytes($documentEncoding);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @JvmStatic
    public static final void addOffset(@NotNull String filePath, int offset, @NotNull Map<String, SortedSet<Integer>> result) {
        Companion.addOffset(filePath, offset, result);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J2\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00110\u0010H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion;", "", "<init>", "()V", "getBomLength", "", "content", "", "encoding", "Ljava/nio/charset/Charset;", "addOffset", "", "filePath", "", "offset", "result", "", "Ljava/util/SortedSet;", "ContentInfo", "intellij.c.clangd"})
    public static final class Companion {
        private Companion() {
        }

        private final int getBomLength(byte[] content, Charset encoding) {
            return CharsetToolkit.getBOMLength((byte[])content, (Charset)encoding);
        }

        @JvmStatic
        public final void addOffset(@NotNull String filePath, int offset, @NotNull Map<String, SortedSet<Integer>> result) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            if (!result.containsKey(filePath)) {
                result.put(filePath, new TreeSet());
            }
            SortedSet<Integer> sortedSet = result.get(filePath);
            Intrinsics.checkNotNull(sortedSet);
            sortedSet.add(offset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ByteToCharOffsetMapBuilder$Companion$ContentInfo;", "", "content", "", "encoding", "Ljava/nio/charset/Charset;", "bomLength", "", "<init>", "([BLjava/nio/charset/Charset;I)V", "getContent", "()[B", "getEncoding", "()Ljava/nio/charset/Charset;", "getBomLength", "()I", "intellij.c.clangd"})
        private static final class ContentInfo {
            @NotNull
            private final byte[] content;
            @NotNull
            private final Charset encoding;
            private final int bomLength;

            public ContentInfo(@NotNull byte[] content, @NotNull Charset encoding, int bomLength) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
                this.content = content;
                this.encoding = encoding;
                this.bomLength = bomLength;
            }

            @NotNull
            public final byte[] getContent() {
                return this.content;
            }

            @NotNull
            public final Charset getEncoding() {
                return this.encoding;
            }

            public final int getBomLength() {
                return this.bomLength;
            }
        }
    }
}

