/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TabbedPaneImpl;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdIndexingTaskId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangIndexerCustomCommandDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdDumpIndexerState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdIndexerPanel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdIndexerPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.IndexAppState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.IndexOptsState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.IndexViewerState;
import com.jetbrains.cidr.lang.daemon.clang.usages.ClangFoundUsage;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002JI\u0010\u001a\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032)\u0010\u001e\u001a%\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u001b\u0018\u00010$0\u001fH\u0002J\"\u0010%\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0015H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010 2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdIndexerPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "isStateful", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "()Z", "indexViewerState", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexViewerState;", "indexAppState", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexAppState;", "indexOptsState", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/IndexOptsState;", "tabbedPane", "Lcom/intellij/ui/components/JBTabbedPane;", "queryRunning", "selectIndexerOpts", "", "createLspLog", "Lcom/intellij/execution/ui/ConsoleView;", "createAppLog", "Lkotlin/Pair;", "Lcom/intellij/openapi/ui/DialogPanel;", "createIndexViewer", "runQuery", "T", "textArea", "Lcom/intellij/ui/components/JBTextArea;", "query", "Lkotlin/Function1;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "Lkotlin/ParameterName;", "name", "service", "", "connectToService", "lspView", "appView", "getIfStartedIndexer", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nClangdIndexerPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdIndexerPanel.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdIndexerPanel\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,652:1\n37#2,2:653\n1#3:655\n2669#4,7:656\n*S KotlinDebug\n*F\n+ 1 ClangdIndexerPanel.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdIndexerPanel\n*L\n165#1:653,2\n390#1:656,7\n*E\n"})
public final class ClangdIndexerPanel
extends ClangdPanelBase {
    private final boolean isStateful;
    @NotNull
    private final IndexViewerState indexViewerState;
    @NotNull
    private final IndexAppState indexAppState;
    @NotNull
    private final IndexOptsState indexOptsState;
    @NotNull
    private final JBTabbedPane tabbedPane;
    private volatile boolean queryRunning;

    public ClangdIndexerPanel(final @NotNull Project project, boolean isStateful) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.isStateful = isStateful;
        this.indexViewerState = new IndexViewerState(null, false, null, 7, null);
        this.indexAppState = new IndexAppState(null, null, null, 0, 15, null);
        this.indexOptsState = new IndexOptsState(null, 1, null);
        this.indexAppState.setIndexerModulesCacheMb(ClangdSettings.getInstance(project).getIndexerModulesCacheMb());
        this.tabbedPane = (JBTabbedPane)new TabbedPaneImpl(1);
        this.add((Component)this.tabbedPane);
        final ConsoleView lspConsoleView = this.createLspLog(project);
        this.tabbedPane.add("LSP Log", (Component)lspConsoleView.getComponent());
        Pair<DialogPanel, ConsoleView> pair = this.createAppLog(project);
        DialogPanel appPanel = (DialogPanel)pair.component1();
        final ConsoleView appConsoleView = (ConsoleView)pair.component2();
        this.tabbedPane.add("App Log", (Component)appPanel);
        this.indexAppState.setAppPanel(appPanel);
        this.indexAppState.setAppConsoleView(appConsoleView);
        this.indexViewerState.setIndexViewer(this.createIndexViewer(project));
        this.tabbedPane.add("Index Viewer", (Component)this.indexViewerState.getIndexViewer());
        this.indexOptsState.setIndexOptsPanel(ClangdIndexerPanelKt.access$createIndexOptionsPanel(project));
        this.tabbedPane.add("Index Opts", (Component)this.indexOptsState.getIndexOptsPanel());
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic<ClangLanguageServiceProviderListener> topic = ClangLanguageServiceProviderListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ClangLanguageServiceProviderListener(){

            @Override
            public void onServiceStarted(ClangLanguageService service) {
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                if (Intrinsics.areEqual((Object)service.getDescriptor(), (Object)"indexer")) {
                    this.connectToService(service, lspConsoleView, appConsoleView);
                }
            }
        });
        MessageBusConnection messageBusConnection2 = project.getMessageBus().connect();
        Topic<ClangdSettingsListener> topic2 = ClangdSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection2.subscribe(topic2, (Object)new ClangdSettingsListener(){

            @Override
            public void onIndexerOptimizeIncludeGraphChanged(boolean value) {
                ClangdIndexerPanelKt.access$runIndexerCommand(project, appConsoleView, this.isStateful(), ClangIndexerCommand.Companion.OPTIMIZE_INCLUDE_GRAPH(value));
            }
        });
        this.connectToService(this.getIfStartedIndexer(project), lspConsoleView, appConsoleView);
        AnAction[] anActionArray = new AnAction[]{new ClangdDumpIndexerState(this.isStateful)};
        this.createToolbarWithActions(anActionArray);
    }

    public final boolean isStateful() {
        return this.isStateful;
    }

    public final void selectIndexerOpts() {
        this.tabbedPane.setSelectedComponent((Component)this.indexOptsState.getIndexOptsPanel());
    }

    private final ConsoleView createLspLog(Project project) {
        ConsoleView consoleView = new TextConsoleBuilderImpl(project).getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        ConsoleView lspConsoleView = consoleView;
        Disposer.register((Disposable)this, (Disposable)((Disposable)lspConsoleView));
        ConsoleViewImpl consoleViewImpl = lspConsoleView instanceof ConsoleViewImpl ? (ConsoleViewImpl)lspConsoleView : null;
        if (consoleViewImpl != null && (consoleViewImpl = consoleViewImpl.getEditor()) != null && (consoleViewImpl = consoleViewImpl.getSettings()) != null) {
            consoleViewImpl.setUseSoftWraps(false);
        }
        TextAttributes methodHighlightAttrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        Pattern methodPattern = Pattern.compile("\"method\": \"(.*?)\"");
        lspConsoleView.addMessageFilter((arg_0, arg_1) -> ClangdIndexerPanel.createLspLog$lambda$0(methodPattern, methodHighlightAttrs, arg_0, arg_1));
        return lspConsoleView;
    }

    private final Pair<DialogPanel, ConsoleView> createAppLog(Project project) {
        ConsoleView consoleView = new TextConsoleBuilderImpl(project).getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        ConsoleView appConsoleView = consoleView;
        Disposer.register((Disposable)this, (Disposable)((Disposable)appConsoleView));
        ConsoleViewImpl consoleViewImpl = appConsoleView instanceof ConsoleViewImpl ? (ConsoleViewImpl)appConsoleView : null;
        if (consoleViewImpl != null && (consoleViewImpl = consoleViewImpl.getEditor()) != null && (consoleViewImpl = consoleViewImpl.getSettings()) != null) {
            consoleViewImpl.setUseSoftWraps(false);
        }
        int coresNumber = Runtime.getRuntime().availableProcessors();
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)((Iterable)new IntRange(0, coresNumber)));
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DefaultComboBoxModel<Integer> indexingThreadsModel = new DefaultComboBoxModel<Integer>(thisCollection$iv.toArray(new Integer[0]));
        indexingThreadsModel.setSelectedItem(ClangdSettings.getInstance(project).getIndexingThreadsNum());
        indexingThreadsModel.addListDataListener(new ListDataListener(indexingThreadsModel, this, project, appConsoleView){
            final /* synthetic */ DefaultComboBoxModel<Integer> $indexingThreadsModel;
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ConsoleView $appConsoleView;
            {
                this.$indexingThreadsModel = $indexingThreadsModel;
                this.this$0 = $receiver;
                this.$project = $project;
                this.$appConsoleView = $appConsoleView;
            }

            public void intervalAdded(ListDataEvent e) {
            }

            public void intervalRemoved(ListDataEvent e) {
            }

            public void contentsChanged(ListDataEvent e) {
                Object object = this.$indexingThreadsModel.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int newThreadsNum = (Integer)object;
                if (this.this$0.isStateful()) {
                    ClangdSettings.getInstance(this.$project).setIndexingThreadsNum(newThreadsNum);
                }
                ClangdIndexerPanelKt.access$runIndexerCommand(this.$project, this.$appConsoleView, this.this$0.isStateful(), ClangIndexerCommand.Companion.SET_PP_THREADS(newThreadsNum));
                ClangdIndexerPanelKt.access$runIndexerCommand(this.$project, this.$appConsoleView, this.this$0.isStateful(), ClangIndexerCommand.Companion.SET_INDEXING_THREADS(newThreadsNum));
            }
        });
        int[] $i$f$toTypedArray22 = new int[]{0, 500, 1000, 1500, 2000, 2500, 3000, 3500, 4000, 4500, 5000, 5500, 6000, 6500, 7000};
        DefaultComboBoxModel<Integer> modulesCacheModel = new DefaultComboBoxModel<Integer>(ArraysKt.toTypedArray((int[])$i$f$toTypedArray22));
        modulesCacheModel.setSelectedItem(ClangdSettings.getInstance(project).getIndexerModulesCacheMb());
        modulesCacheModel.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent e) {
            }

            public void intervalRemoved(ListDataEvent e) {
            }

            public void contentsChanged(ListDataEvent e) {
            }
        });
        DialogPanel appPanel = BuilderKt.panel(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30(project, indexingThreadsModel, modulesCacheModel, this, appConsoleView, arg_0));
        return new Pair((Object)appPanel, (Object)appConsoleView);
    }

    private final DialogPanel createIndexViewer(Project project) {
        JBTextArea textArea = new JBTextArea((Document)new DefaultStyledDocument());
        textArea.setEditable(false);
        return BuilderKt.panel(arg_0 -> ClangdIndexerPanel.createIndexViewer$lambda$37(this, textArea, project, arg_0));
    }

    private final <T> void runQuery(JBTextArea textArea, Project project, Function1<? super ClangLanguageService, ? extends List<? extends T>> query) {
        if (this.queryRunning) {
            textArea.setText("Query is already in progress...");
            return;
        }
        DialogPanel dialogPanel = this.indexViewerState.getIndexViewer();
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project);
        if (service == null) {
            textArea.setText("Service is not started yet!");
            return;
        }
        this.queryRunning = true;
        ReadAction.nonBlocking(() -> ClangdIndexerPanel.runQuery$lambda$38(query, service)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> ClangdIndexerPanel.runQuery$lambda$40(arg_0 -> ClangdIndexerPanel.runQuery$lambda$39(this, textArea, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    /*
     * WARNING - void declaration
     */
    private final void connectToService(ClangLanguageService service, ConsoleView lspView, ConsoleView appView) {
        if (service == null) {
            return;
        }
        if (service instanceof ClangdIndexerService) {
            List<String> list;
            Object object = ((ClangdIndexerService)service).getCopyOfAppLog();
            Iterable<String> it = object;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            List<String> list2 = list = !((Collection)it).isEmpty() ? object : null;
            if (list != null) {
                void $this$reduce$iv;
                it = list;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void right;
                    String string = (String)iterator$iv.next();
                    String left = (String)accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = left + "\n" + (String)right;
                }
                object = (String)accumulator$iv;
                if (object != null) {
                    Object object2;
                    Object object3;
                    Object it2 = object3 = object;
                    boolean bl3 = false;
                    Object object4 = object2 = ((CharSequence)it2).length() > 0 ? object3 : null;
                    if (object2 != null) {
                        it2 = object3 = object2;
                        boolean bl4 = false;
                        ClangdIndexerPanelKt.access$printConsole(appView, (String)it2);
                    }
                }
            }
            ((ClangdIndexerService)service).addPausedListener(arg_0 -> ClangdIndexerPanel.connectToService$lambda$47(this, arg_0));
        }
        MessageBusConnection messageBusConnection = service.getMessageBus().connect((Disposable)this);
        Topic<ClangServerListener> topic = ClangServerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ClangServerListener(service, this, lspView, appView){
            private boolean indexStartedCame;
            private int lastReportedPercent;
            final /* synthetic */ ClangLanguageService $service;
            final /* synthetic */ ClangdIndexerPanel this$0;
            final /* synthetic */ ConsoleView $lspView;
            final /* synthetic */ ConsoleView $appView;
            {
                this.$service = $service;
                this.this$0 = $receiver;
                this.$lspView = $lspView;
                this.$appView = $appView;
                this.lastReportedPercent = -1;
            }

            public final boolean getIndexStartedCame() {
                return this.indexStartedCame;
            }

            public final void setIndexStartedCame(boolean bl) {
                this.indexStartedCame = bl;
            }

            public final int getLastReportedPercent() {
                return this.lastReportedPercent;
            }

            public final void setLastReportedPercent(int n) {
                this.lastReportedPercent = n;
            }

            public void onMessage(Message message, boolean incoming) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                String contents = message.toString();
                ClangMessagesFilter clangMessagesFilter = this.$service.getContext().getMessagesFilter();
                String string = contents;
                Intrinsics.checkNotNull((Object)string);
                if (clangMessagesFilter.matchesBlockedCommunication(string)) {
                    return;
                }
                String truncated = this.this$0.truncateIfNecessary(contents);
                contents = null;
                Function0 edt = () -> connectToService.6.onMessage$lambda$1(incoming, this.$lspView, truncated);
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> connectToService.6.onMessage$lambda$2(edt));
            }

            public void onIndexingStarted(ClangdIndexingTaskId taskId) {
                Intrinsics.checkNotNullParameter((Object)((Object)taskId), (String)"taskId");
                this.indexStartedCame = true;
                this.lastReportedPercent = -1;
            }

            public void onIndexingProgress(int percentage, String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (this.indexStartedCame) {
                    ClangdIndexerPanelKt.access$printConsole(this.$appView, "Indexing started: " + message);
                    this.indexStartedCame = false;
                }
                if (percentage != this.lastReportedPercent) {
                    this.lastReportedPercent = percentage;
                    ClangdIndexerPanelKt.access$printConsole(this.$appView, "Progress: " + percentage + "%");
                }
            }

            public void onIndexingFinished(List<String> deletedSymbolsPaths, String path) {
                Intrinsics.checkNotNullParameter(deletedSymbolsPaths, (String)"deletedSymbolsPaths");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                ClangdIndexerPanelKt.access$printConsole(this.$appView, "Indexing finished! " + deletedSymbolsPaths.size() + " deleted (" + path + ")");
            }

            public void onIndexingMessage(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                ClangdIndexerPanelKt.access$printConsole(this.$appView, message);
            }

            private static final void onMessage$lambda$1$lambda$0(String $truncated, String $linkText, Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ClangdIndexerPanelKt.access$showJsonInEditor(it, $truncated, $linkText);
            }

            private static final Unit onMessage$lambda$1(boolean $incoming, ConsoleView $lspView, String $truncated) {
                String string = ClangdIndexerPanelKt.access$getDATE_FORMAT$p().format(System.currentTimeMillis());
                Intrinsics.checkNotNull((Object)string);
                String linkText = string + " " + ($incoming ? "-->" : "<--");
                $lspView.printHyperlink(linkText, arg_0 -> connectToService.6.onMessage$lambda$1$lambda$0($truncated, linkText, arg_0));
                $lspView.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
                $lspView.print(ClangdIndexerPanelKt.access$toOneLine($truncated), ConsoleViewContentType.NORMAL_OUTPUT);
                $lspView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                return Unit.INSTANCE;
            }

            private static final void onMessage$lambda$2(Function0 $tmp0) {
                $tmp0.invoke();
            }
        });
    }

    private final ClangLanguageService getIfStartedIndexer(Project project) {
        return ClangdIndexerPanelKt.getIfStartedIndexer(project, this.isStateful);
    }

    private static final Filter.Result createLspLog$lambda$0(Pattern $methodPattern, TextAttributes $methodHighlightAttrs, String line, int length) {
        Filter.Result result;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Matcher matcher = $methodPattern.matcher(line);
        int lineStartOffset = length - line.length();
        if (matcher.find()) {
            int groupStart = lineStartOffset + matcher.start(1);
            int groupEnd = lineStartOffset + matcher.end(1);
            result = new Filter.Result(groupStart, groupEnd, null, $methodHighlightAttrs);
        } else {
            result = null;
        }
        return result;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$1(ClangdIndexerPanel this$0, Project $project, ConsoleView $appConsoleView, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DialogPanel dialogPanel = this$0.indexAppState.getAppPanel();
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        ClangdIndexerPanelKt.access$runIndexerCommand($project, $appConsoleView, this$0.isStateful, ClangIndexerCommand.Companion.getCLEAR_CACHES());
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$2(ClangdIndexerPanel this$0, Project $project, ConsoleView $appConsoleView, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DialogPanel dialogPanel = this$0.indexAppState.getAppPanel();
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        ClangdIndexerPanelKt.access$runIndexerCommand($project, $appConsoleView, this$0.isStateful, ClangIndexerCommand.Companion.getREBUILD());
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$3(ClangdIndexerPanel this$0, Project $project, ConsoleView $appConsoleView, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DialogPanel dialogPanel = this$0.indexAppState.getAppPanel();
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        ClangdIndexerPanelKt.access$runIndexerCommand($project, $appConsoleView, this$0.isStateful, ClangIndexerCommand.Companion.getREINDEX());
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$4(ClangdIndexerPanel this$0, Project $project, ConsoleView $appConsoleView, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DialogPanel dialogPanel = this$0.indexAppState.getAppPanel();
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        ClangdIndexerPanelKt.access$runIndexerCommand($project, $appConsoleView, this$0.isStateful, ClangIndexerCommand.Companion.getCANCEL());
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$5(ClangdIndexerPanel this$0, Project $project, ConsoleView $appConsoleView, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DialogPanel dialogPanel = this$0.indexAppState.getAppPanel();
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        ClangLanguageService clangLanguageService = this$0.getIfStartedIndexer($project);
        ClangdIndexerService clangdIndexerService = clangLanguageService instanceof ClangdIndexerService ? (ClangdIndexerService)clangLanguageService : null;
        boolean isUnpause = clangdIndexerService != null ? clangdIndexerService.isPaused() : false;
        ClangdIndexerPanelKt.access$runIndexerCommand($project, $appConsoleView, this$0.isStateful, isUnpause ? ClangIndexerCommand.Companion.getRESUME() : ClangIndexerCommand.Companion.getPAUSE());
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$7(Project $project, ClangdIndexerPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        new ClangIndexerCustomCommandDialog($project, this$0.indexAppState, this$0.isStateful).show();
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$11$lambda$10$lambda$8(ClangdIndexerPanel this$0, Project $project, boolean $newSkipBodies, JBCheckBox $cb, Boolean it) {
        if (!it.booleanValue()) {
            if (this$0.isStateful) {
                ClangdSettings.getInstance($project).setIndexerSkipBodies(!$newSkipBodies);
            }
            $cb.getModel().setSelected(!$newSkipBodies);
        }
        return Unit.INSTANCE;
    }

    private static final void createAppLog$lambda$30$lambda$28$lambda$11$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$11(Row $this_row, ClangdIndexerPanel this$0, Project $project, ConsoleView $appConsoleView, JBCheckBox cb) {
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        Row $this$createAppLog_u24lambda_u2430_u24lambda_u2428_u24lambda_u2411_u24lambda_u2410 = $this_row;
        boolean bl = false;
        DialogPanel dialogPanel = this$0.indexAppState.getAppPanel();
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        boolean newSkipBodies = cb.getModel().isSelected();
        if (this$0.isStateful) {
            ClangdSettings.getInstance($project).setIndexerSkipBodies(newSkipBodies);
        }
        ClangdIndexerPanelKt.access$runIndexerCommand($project, $appConsoleView, this$0.isStateful, ClangIndexerCommand.Companion.SET_SKIP_BODIES(newSkipBodies)).thenAccept(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$11$lambda$10$lambda$9(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$11$lambda$10$lambda$8(this$0, $project, newSkipBodies, cb, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$15$lambda$14$lambda$12(ClangdIndexerPanel this$0, Project $project, boolean $newSkipII, JBCheckBox $cb, Boolean it) {
        if (!it.booleanValue()) {
            if (this$0.isStateful) {
                ClangdSettings.getInstance($project).setIndexerSkipImplicitInstantiations(!$newSkipII);
            }
            $cb.getModel().setSelected(!$newSkipII);
        }
        return Unit.INSTANCE;
    }

    private static final void createAppLog$lambda$30$lambda$28$lambda$15$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$15(Row $this_row, ClangdIndexerPanel this$0, Project $project, ConsoleView $appConsoleView, JBCheckBox cb) {
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        Row $this$createAppLog_u24lambda_u2430_u24lambda_u2428_u24lambda_u2415_u24lambda_u2414 = $this_row;
        boolean bl = false;
        DialogPanel dialogPanel = this$0.indexAppState.getAppPanel();
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        boolean newSkipII = cb.getModel().isSelected();
        if (this$0.isStateful) {
            ClangdSettings.getInstance($project).setIndexerSkipImplicitInstantiations(newSkipII);
        }
        ClangdIndexerPanelKt.access$runIndexerCommand($project, $appConsoleView, this$0.isStateful, ClangIndexerCommand.Companion.SET_SKIP_IMPLICIT_INSTANTIATIONS(newSkipII)).thenAccept(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$15$lambda$14$lambda$13(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$15$lambda$14$lambda$12(this$0, $project, newSkipII, cb, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$19$lambda$18$lambda$16(ClangdIndexerPanel this$0, Project $project, boolean $newRUT, JBCheckBox $cb, Boolean it) {
        if (!it.booleanValue()) {
            if (this$0.isStateful) {
                ClangdSettings.getInstance($project).setIndexerRestrictUpdatingThreads(!$newRUT);
            }
            $cb.getModel().setSelected(!$newRUT);
        }
        return Unit.INSTANCE;
    }

    private static final void createAppLog$lambda$30$lambda$28$lambda$19$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$19(Row $this_row, ClangdIndexerPanel this$0, Project $project, ConsoleView $appConsoleView, JBCheckBox cb) {
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        Row $this$createAppLog_u24lambda_u2430_u24lambda_u2428_u24lambda_u2419_u24lambda_u2418 = $this_row;
        boolean bl = false;
        DialogPanel dialogPanel = this$0.indexAppState.getAppPanel();
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        boolean newRUT = cb.getModel().isSelected();
        if (this$0.isStateful) {
            ClangdSettings.getInstance($project).setIndexerRestrictUpdatingThreads(newRUT);
        }
        ClangdIndexerPanelKt.access$runIndexerCommand($project, $appConsoleView, this$0.isStateful, ClangIndexerCommand.Companion.SET_RESTRICT_UPDATING_THREADS(newRUT)).thenAccept(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$19$lambda$18$lambda$17(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$19$lambda$18$lambda$16(this$0, $project, newRUT, cb, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$23$lambda$22$lambda$20(ClangdIndexerPanel this$0, Project $project, boolean $newShowDebugMessages, JBCheckBox $cb, Boolean it) {
        if (!it.booleanValue()) {
            if (this$0.isStateful) {
                ClangdSettings.getInstance($project).setIndexerShowDebugMessages(!$newShowDebugMessages);
            }
            $cb.getModel().setSelected(!$newShowDebugMessages);
        }
        return Unit.INSTANCE;
    }

    private static final void createAppLog$lambda$30$lambda$28$lambda$23$lambda$22$lambda$21(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$23(Row $this_row, ClangdIndexerPanel this$0, Project $project, ConsoleView $appConsoleView, JBCheckBox cb) {
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        Row $this$createAppLog_u24lambda_u2430_u24lambda_u2428_u24lambda_u2423_u24lambda_u2422 = $this_row;
        boolean bl = false;
        DialogPanel dialogPanel = this$0.indexAppState.getAppPanel();
        if (dialogPanel != null) {
            dialogPanel.apply();
        }
        boolean newShowDebugMessages = cb.getModel().isSelected();
        if (this$0.isStateful) {
            ClangdSettings.getInstance($project).setIndexerShowDebugMessages(newShowDebugMessages);
        }
        ClangdIndexerPanelKt.access$runIndexerCommand($project, $appConsoleView, this$0.isStateful, ClangIndexerCommand.Companion.SET_VERBOSE_LOG(newShowDebugMessages)).thenAccept(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$23$lambda$22$lambda$21(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$23$lambda$22$lambda$20(this$0, $project, newShowDebugMessages, cb, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final Integer createAppLog$lambda$30$lambda$28$lambda$24(DefaultComboBoxModel $indexingThreadsModel) {
        Object object = $indexingThreadsModel.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        return (Integer)object;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$25(DefaultComboBoxModel $indexingThreadsModel, Integer it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Int");
        $indexingThreadsModel.setSelectedItem(it);
        return Unit.INSTANCE;
    }

    private static final Integer createAppLog$lambda$30$lambda$28$lambda$26(DefaultComboBoxModel $modulesCacheModel) {
        Object object = $modulesCacheModel.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        return (Integer)object;
    }

    private static final Unit createAppLog$lambda$30$lambda$28$lambda$27(DefaultComboBoxModel $modulesCacheModel, Integer it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Int");
        $modulesCacheModel.setSelectedItem(it);
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30$lambda$28(Project $project, DefaultComboBoxModel $indexingThreadsModel, DefaultComboBoxModel $modulesCacheModel, ClangdIndexerPanel this$0, ConsoleView $appConsoleView, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button("Clear Caches", arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$1(this$0, $project, $appConsoleView, arg_0)).gap(RightGap.SMALL);
        $this$row.button("Rebuild", arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$2(this$0, $project, $appConsoleView, arg_0)).gap(RightGap.SMALL);
        $this$row.button("Reindex", arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$3(this$0, $project, $appConsoleView, arg_0)).gap(RightGap.SMALL);
        $this$row.button("Cancel", arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$4(this$0, $project, $appConsoleView, arg_0)).gap(RightGap.SMALL);
        Cell it = cell = $this$row.button("Pause", arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$5(this$0, $project, $appConsoleView, arg_0)).gap(RightGap.SMALL);
        boolean bl = false;
        this$0.indexAppState.setPauseButton((JButton)it.getComponent());
        $this$row.button("Custom", arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$7($project, this$0, arg_0));
        ButtonKt.selected((Cell)$this$row.checkBox("Skip function bodies"), (boolean)ClangdSettings.getInstance($project).getIndexerSkipBodies()).gap(RightGap.SMALL).onChanged(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$11($this$row, this$0, $project, $appConsoleView, arg_0));
        ButtonKt.selected((Cell)$this$row.checkBox("Skip implicit instantiations"), (boolean)ClangdSettings.getInstance($project).getIndexerSkipImplicitInstantiations()).gap(RightGap.SMALL).onChanged(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$15($this$row, this$0, $project, $appConsoleView, arg_0));
        ButtonKt.selected((Cell)$this$row.checkBox("Deprioritize update"), (boolean)ClangdSettings.getInstance($project).getIndexerRestrictUpdatingThreads()).gap(RightGap.SMALL).onChanged(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$19($this$row, this$0, $project, $appConsoleView, arg_0));
        ButtonKt.selected((Cell)$this$row.checkBox("Show debug messages"), (boolean)ClangdSettings.getInstance($project).getIndexerShowDebugMessages()).onChanged(arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$23($this$row, this$0, $project, $appConsoleView, arg_0));
        Cell.label$default((Cell)ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (ComboBoxModel)$indexingThreadsModel, null, (int)2, null), () -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$24($indexingThreadsModel), arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$25($indexingThreadsModel, arg_0)), (String)"Indexing threads:", null, (int)2, null);
        Cell.label$default((Cell)ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (ComboBoxModel)$modulesCacheModel, null, (int)2, null), () -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$26($modulesCacheModel), arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28$lambda$27($modulesCacheModel, arg_0)), (String)"Modules cache:", null, (int)2, null).enabled(false);
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30$lambda$29(ConsoleView $appConsoleView, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = $appConsoleView.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createAppLog$lambda$30(Project $project, DefaultComboBoxModel $indexingThreadsModel, DefaultComboBoxModel $modulesCacheModel, ClangdIndexerPanel this$0, ConsoleView $appConsoleView, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$28($project, $indexingThreadsModel, $modulesCacheModel, this$0, $appConsoleView, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangdIndexerPanel.createAppLog$lambda$30$lambda$29($appConsoleView, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final List createIndexViewer$lambda$37$lambda$35$lambda$32$lambda$31(ClangdIndexerPanel this$0, ClangLanguageService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        CompletableFuture<List<CLionSymbolInformation>> completableFuture = service.getSymbols(this$0.indexViewerState.getQuery(), this$0.indexViewerState.getOnlyCLionIndex());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getSymbols(...)");
        CompletableFuture<List<CLionSymbolInformation>> symbolsFuture = completableFuture;
        return (List)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)symbolsFuture, (String)"workspace/symbols");
    }

    private static final Unit createIndexViewer$lambda$37$lambda$35$lambda$32(ClangdIndexerPanel this$0, JBTextArea $textArea, Project $project, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.runQuery($textArea, $project, arg_0 -> ClangdIndexerPanel.createIndexViewer$lambda$37$lambda$35$lambda$32$lambda$31(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final List createIndexViewer$lambda$37$lambda$35$lambda$34$lambda$33(ClangdIndexerPanel this$0, ClangLanguageService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        CompletableFuture<List<ClangFoundUsage>> completableFuture = service.getReferences(this$0.indexViewerState.getQuery(), this$0.indexViewerState.getOnlyCLionIndex());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getReferences(...)");
        CompletableFuture<List<ClangFoundUsage>> refsFuture = completableFuture;
        return (List)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)refsFuture, (String)"clionReferences");
    }

    private static final Unit createIndexViewer$lambda$37$lambda$35$lambda$34(ClangdIndexerPanel this$0, JBTextArea $textArea, Project $project, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.runQuery($textArea, $project, arg_0 -> ClangdIndexerPanel.createIndexViewer$lambda$37$lambda$35$lambda$34$lambda$33(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createIndexViewer$lambda$37$lambda$35(ClangdIndexerPanel this$0, JBTextArea $textArea, Project $project, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.indexViewerState){

            public Object get() {
                return ((IndexViewerState)this.receiver).getQuery();
            }

            public void set(Object value) {
                ((IndexViewerState)this.receiver).setQuery((String)value);
            }
        })).align((Align)AlignX.FILL.INSTANCE).resizableColumn().focused();
        ButtonKt.bindSelected((Cell)$this$row.checkBox("Only CLion Index"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.indexViewerState){

            public Object get() {
                return ((IndexViewerState)this.receiver).getOnlyCLionIndex();
            }

            public void set(Object value) {
                ((IndexViewerState)this.receiver).setOnlyCLionIndex((Boolean)value);
            }
        }));
        $this$row.button("QueryS", arg_0 -> ClangdIndexerPanel.createIndexViewer$lambda$37$lambda$35$lambda$32(this$0, $textArea, $project, arg_0)).gap(RightGap.SMALL);
        $this$row.button("QueryR", arg_0 -> ClangdIndexerPanel.createIndexViewer$lambda$37$lambda$35$lambda$34(this$0, $textArea, $project, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createIndexViewer$lambda$37$lambda$36(JBTextArea $textArea, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.scrollCell((JComponent)$textArea).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createIndexViewer$lambda$37(ClangdIndexerPanel this$0, JBTextArea $textArea, Project $project, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangdIndexerPanel.createIndexViewer$lambda$37$lambda$35(this$0, $textArea, $project, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangdIndexerPanel.createIndexViewer$lambda$37$lambda$36($textArea, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final List runQuery$lambda$38(Function1 $query, ClangLanguageService $service) {
        return (List)$query.invoke((Object)$service);
    }

    private static final Unit runQuery$lambda$39(ClangdIndexerPanel this$0, JBTextArea $textArea, List it) {
        this$0.queryRunning = false;
        Collection collection = it;
        if (collection == null || collection.isEmpty()) {
            $textArea.setText("Empty result");
            return Unit.INSTANCE;
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = ((Iterable)it).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int counter = n++;
            Object item = iterator.next();
            sb.append(counter + 1 + ". " + item + "\n");
        }
        $textArea.setText(sb.toString());
        return Unit.INSTANCE;
    }

    private static final void runQuery$lambda$40(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit connectToService$lambda$47$lambda$45(ClangdIndexerPanel this$0, Boolean $paused) {
        block0: {
            JButton jButton = this$0.indexAppState.getPauseButton();
            if (jButton == null) break block0;
            jButton.setText($paused != false ? "Unpause" : "Pause");
        }
        return Unit.INSTANCE;
    }

    private static final void connectToService$lambda$47$lambda$46(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void connectToService$lambda$47(ClangdIndexerPanel this$0, Boolean paused) {
        Function0 edt = () -> ClangdIndexerPanel.connectToService$lambda$47$lambda$45(this$0, paused);
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> ClangdIndexerPanel.connectToService$lambda$47$lambda$46(edt));
    }
}

