/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup.listeners;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/startup/listeners/ClangdEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "provider", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageServiceProvider;", "<init>", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageServiceProvider;)V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "intellij.c.clangd"})
public final class ClangdEditorFactoryListener
implements EditorFactoryListener {
    @NotNull
    private final ClangLanguageServiceProvider provider;

    public ClangdEditorFactoryListener(@NotNull ClangLanguageServiceProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        this.provider = provider2;
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        block2: {
            ClangdIndexerService indexer;
            ClangLanguageService service;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor2.getDocument());
            if (virtualFile == null) {
                return;
            }
            VirtualFile file = virtualFile;
            ClangLanguageService clangLanguageService = service = this.provider.getIfStarted();
            if (clangLanguageService != null) {
                clangLanguageService.notifyDocumentOpened(file, new EditorOpenRequestId(editor2));
            }
            ClangdIndexerService clangdIndexerService = indexer = this.provider.getIfStartedIndexer();
            if (clangdIndexerService == null) break block2;
            clangdIndexerService.notifyDocumentOpened(file, new EditorOpenRequestId(editor2));
        }
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        block2: {
            ClangdIndexerService indexer;
            ClangLanguageService service;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor2.getDocument());
            if (virtualFile == null) {
                return;
            }
            VirtualFile file = virtualFile;
            ClangLanguageService clangLanguageService = service = this.provider.getIfStarted();
            if (clangLanguageService != null) {
                clangLanguageService.notifyDocumentClosed(file, new EditorOpenRequestId(editor2));
            }
            ClangdIndexerService clangdIndexerService = indexer = this.provider.getIfStartedIndexer();
            if (clangdIndexerService == null) break block2;
            clangdIndexerService.notifyDocumentClosed(file, new EditorOpenRequestId(editor2));
        }
    }
}

